/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.console.auth.model;

import com.iplanet.am.console.auth.model.ACDataModel;
import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.console.service.model.SMDataModelImpl;
import com.iplanet.am.sdk.AMException;
import com.iplanet.sso.SSOException;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class ACDataModelImpl
extends SMDataModelImpl
implements ACDataModel {
    public static final String CONFIGURATION_SCHEMA = "Configurations";
    public static final String NAMED_CONFIGURATION_SCHEMA = "NamedConfiguration";
    protected ServiceSchema confSchema = null;
    protected ServiceSchema namedSchema = null;

    public ACDataModelImpl(HttpServletRequest httpServletRequest, String string, Map map, String string2) {
        super(httpServletRequest, string, map, string2, false);
    }

    protected void getOrgSchema() {
        block4: {
            try {
                ServiceSchemaManager serviceSchemaManager = this.getServiceSchemaManager(this.svcName);
                this.orgSvcSchema = serviceSchemaManager.getSchema(SchemaType.ORGANIZATION);
                if (this.orgSvcSchema == null) break block4;
                this.confSchema = this.orgSvcSchema.getSubSchema(CONFIGURATION_SCHEMA);
                if (this.confSchema == null) break block4;
                this.namedSchema = this.confSchema.getSubSchema(NAMED_CONFIGURATION_SCHEMA);
                if (this.namedSchema != null) {
                    this.orgAttrSchemaList = this.getAttributeSchemas(this.namedSchema);
                    this.orgSize = this.orgAttrSchemaList.size();
                    this.orgAttrs = this.getAttributes(this.namedSchema);
                }
            }
            catch (SSOException sSOException) {
                this.orgAttrSchemaList = Collections.EMPTY_LIST;
                this.orgSize = 0;
                AMModelBase.debug.warning("ACDataModelImpl.getOrgSchema", (Throwable)sSOException);
            }
            catch (SMSException sMSException) {
                this.orgAttrSchemaList = Collections.EMPTY_LIST;
                this.orgSize = 0;
                AMModelBase.debug.error("ACDataModelImpl.getOrgSchema", (Throwable)sMSException);
            }
        }
    }

    public void store(int n, Map map) throws AMConsoleException {
        if (map != null && !map.isEmpty()) {
            if (!this.processed) {
                this.process();
            }
            try {
                switch (n) {
                    case 1: {
                        this.setAttributeDefaults(this.namedSchema, map, this.orgAttrs);
                        break;
                    }
                    case 2: {
                        this.setAttributeDefaults(this.dynSvcSchema, map, this.dynAttrs);
                        break;
                    }
                    default: {
                        this.errorTitle = this.getLocalizedString("errorMessage.title");
                        String string = this.getLocalizedString("invalidServiceType.message");
                        AMModelBase.debug.error("SMDataModelImpl.store" + string);
                        throw new AMConsoleException(string);
                    }
                }
            }
            catch (AMException aMException) {
                throw new AMConsoleException(this.getErrorString((Exception)((Object)aMException)));
            }
        }
    }
}

