/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.util;

import java.util.LinkedList;

public class ReaderWriterLock {
    private int currentReaders;
    private int queuedReaders;
    private int currentWriters;
    private final LinkedList writerLocks = new LinkedList();

    public synchronized void readRequest() {
        if (this.currentWriters == 0 && this.writerLocks.size() == 0) {
            ++this.currentReaders;
        } else {
            ++this.queuedReaders;
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized boolean readRequestImmediate() {
        if (this.currentWriters == 0 && this.writerLocks.size() == 0) {
            ++this.currentReaders;
            return true;
        }
        return false;
    }

    public synchronized void readDone() {
        if (--this.currentReaders == 0) {
            this.notify_writers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRequest() {
        Object object;
        Object object2 = object = new Object();
        synchronized (object2) {
            ReaderWriterLock readerWriterLock = this;
            synchronized (readerWriterLock) {
                boolean bl;
                boolean bl2 = bl = this.writerLocks.size() == 0 && this.currentReaders == 0 && this.currentWriters == 0;
                if (bl) {
                    ++this.currentWriters;
                    return;
                }
                this.writerLocks.addLast(object);
            }
            try {
                object.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public synchronized boolean writeRequestImmediate() {
        if (this.writerLocks.size() == 0 && this.currentReaders == 0 && this.currentWriters == 0) {
            ++this.currentWriters;
            return true;
        }
        return false;
    }

    public synchronized void writeDone() {
        --this.currentWriters;
        if (this.queuedReaders > 0) {
            this.notify_readers();
        } else {
            this.notify_writers();
        }
    }

    private void notify_readers() {
        this.currentReaders += this.queuedReaders;
        this.queuedReaders = 0;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notify_writers() {
        if (this.writerLocks.size() > 0) {
            Object e = this.writerLocks.removeFirst();
            ++this.currentWriters;
            Object e2 = e;
            synchronized (e2) {
                e.notify();
            }
        }
    }

    public static class Test {
        Resource resource = new Resource();

        public Test() {
            if (!this.resource.read_if_possible()) {
                System.out.println("Immediate read request didn't work");
            }
            if (!this.resource.write_if_possible()) {
                System.out.println("Immediate write request didn't work");
            }
            new Writer("w/0").start();
            new Reader("r/1").start();
            new Writer("w/1").start();
            new Writer("w/2").start();
            new Reader("r/2").start();
            new Reader("r/3").start();
        }

        public static void main(String[] stringArray) {
            Test test = new Test();
        }

        class Writer
        extends Thread {
            private String name;

            Writer(String string) {
                this.name = string;
            }

            public void run() {
                System.out.println("Starting " + this.name);
                Test.this.resource.write(this.name);
                System.out.println("Stopping " + this.name);
            }
        }

        class Reader
        extends Thread {
            private String name;

            Reader(String string) {
                this.name = string;
            }

            public void run() {
                System.out.println("Starting " + this.name);
                Test.this.resource.read(this.name);
                System.out.println("Stopping " + this.name);
            }
        }

        static class Resource {
            ReaderWriterLock lock = new ReaderWriterLock();

            Resource() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void read(String string) {
                try {
                    this.lock.readRequest();
                    System.out.println("\t\t" + string + " reading");
                    try {
                        Thread.currentThread();
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    System.out.println("\t\t" + string + " done");
                    Object var4_3 = null;
                    this.lock.readDone();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    this.lock.readDone();
                    throw throwable;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void write(String string) {
                try {
                    this.lock.writeRequest();
                    System.out.println("\t\t" + string + " writing");
                    try {
                        Thread.currentThread();
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    System.out.println("\t\t" + string + " done");
                    Object var4_3 = null;
                    this.lock.writeDone();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    this.lock.writeDone();
                    throw throwable;
                }
            }

            public boolean read_if_possible() {
                if (this.lock.readRequestImmediate()) {
                    this.lock.readDone();
                    return true;
                }
                return false;
            }

            public boolean write_if_possible() {
                if (this.lock.writeRequestImmediate()) {
                    this.lock.writeDone();
                    return true;
                }
                return false;
            }
        }
    }
}

