/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.handlers;

import com.sun.identity.log.LogManager;
import com.sun.identity.log.LogManagerUtil;
import com.sun.identity.log.LogRecord;
import com.sun.identity.log.spi.Debug;
import com.sun.identity.log.spi.ITimestampGenerator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Formatter;
import java.util.logging.Handler;

public class DBFormatter
extends Formatter {
    private java.util.logging.LogManager lmanager = (LogManager)LogManagerUtil.getLogManager();
    private String[] allFields;
    private ITimestampGenerator secureTimestampGenerator;

    public DBFormatter() {
        String string = this.lmanager.getProperty("iplanet-am-logging-secure-timestamp-generator");
        try {
            Class<?> clazz = Class.forName(string);
            this.secureTimestampGenerator = (ITimestampGenerator)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            Debug.error("DBFormatter: TimeStamp Generator Class not found", classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            Debug.error("DBFormatter: Timestamp Generator Couldnot be Instantiated", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Debug.error("DBFormatter: Timestamp Generator Couldnot be Instantiated", illegalAccessException);
        }
    }

    public String getHead(Handler handler) {
        String string = this.lmanager.getProperty("iplanet-am-logging-allfields");
        if (Debug.messageEnabled()) {
            Debug.message("DBFormatter: Returned String from getHead is " + string);
        }
        return string;
    }

    public String getTail(Handler handler) {
        return "";
    }

    public String format(java.util.logging.LogRecord logRecord) {
        this.getAllFields();
        StringBuffer stringBuffer = new StringBuffer();
        Map map = ((LogRecord)logRecord).getLogInfoMap();
        Set set = this.getSelectedFieldSet();
        String string = "";
        if (this.secureTimestampGenerator != null) {
            string = this.secureTimestampGenerator.getTimestamp();
        }
        stringBuffer.append("'").append(string).append("', ");
        String string2 = this.formatMessage(logRecord);
        if (string2.length() > 0 && string2.indexOf("'") != -1) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "'");
            StringBuffer stringBuffer2 = new StringBuffer();
            if (Debug.messageEnabled()) {
                Debug.message("DBFormatter:found single-quote in data: " + string2);
            }
            if (string2.indexOf("'") == 0) {
                stringBuffer2.append("''");
                if (stringTokenizer.hasMoreTokens()) {
                    stringBuffer2.append(stringTokenizer.nextToken());
                }
                if (Debug.messageEnabled()) {
                    Debug.message("DBFormatter:thisfield1 = #" + stringBuffer2.toString() + "#");
                }
            } else if (stringTokenizer.hasMoreTokens()) {
                stringBuffer2.append(stringTokenizer.nextToken());
            }
            while (stringTokenizer.hasMoreTokens()) {
                stringBuffer2.append("''").append(stringTokenizer.nextToken());
                if (!Debug.messageEnabled()) continue;
                Debug.message("DBFormatter:thisfield2 = #" + stringBuffer2.toString() + "#");
            }
            if (string2.indexOf("'", string2.length() - 1) != -1) {
                stringBuffer2.append("''");
            }
            string2 = stringBuffer2.toString();
        }
        stringBuffer.append("'").append(string2).append("', ");
        if (Debug.messageEnabled()) {
            Debug.message("DBFormatter:thisfield3 = #" + stringBuffer.toString() + "#");
        }
        int n = this.allFields.length;
        int n2 = 2;
        while (n2 < n - 1) {
            if (map != null && set != null && set.contains(this.allFields[n2])) {
                String string3 = (String)map.get(this.allFields[n2]);
                if (string3 != null && string3.length() > 0 && string3.indexOf("'") != -1) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string3, "'");
                    StringBuffer stringBuffer3 = new StringBuffer();
                    if (Debug.messageEnabled()) {
                        Debug.message("DBFormatter:found single-quote in: " + string3);
                    }
                    if (string3.indexOf("'") == 0) {
                        stringBuffer3.append("''");
                        if (stringTokenizer.hasMoreTokens()) {
                            stringBuffer3.append(stringTokenizer.nextToken());
                        }
                    } else if (stringTokenizer.hasMoreTokens()) {
                        stringBuffer3.append(stringTokenizer.nextToken());
                    }
                    while (stringTokenizer.hasMoreTokens()) {
                        stringBuffer3.append("''").append(stringTokenizer.nextToken());
                    }
                    if (string3.indexOf("'", string3.length() - 1) != -1) {
                        stringBuffer3.append("''");
                    }
                    string3 = stringBuffer3.toString();
                }
                stringBuffer.append("'").append(string3).append("', ");
            } else {
                stringBuffer.append("'NULL'").append(", ");
            }
            ++n2;
        }
        if (Debug.messageEnabled()) {
            Debug.message("DBFormatter:format1: sbuffer = " + stringBuffer.toString());
        }
        if (set.contains(this.allFields[n - 1])) {
            stringBuffer.append("'").append(map.get(this.allFields[n - 1])).append("'");
        } else {
            stringBuffer.append("'Null'");
        }
        if (Debug.messageEnabled()) {
            Debug.message("DBFormatter:format2: sbuffer = " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    private void getAllFields() {
        String string = this.lmanager.getProperty("iplanet-am-logging-allfields");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        int n = stringTokenizer.countTokens();
        this.allFields = new String[n];
        n = 0;
        while (stringTokenizer.hasMoreElements()) {
            this.allFields[n++] = stringTokenizer.nextToken().trim();
        }
        String string2 = "";
        int n2 = 0;
        while (n2 < n) {
            string2 = string2 + this.allFields[n2] + "\t";
            ++n2;
        }
    }

    private Set getSelectedFieldSet() {
        HashSet<String> hashSet = new HashSet<String>();
        String string = this.lmanager.getProperty("iplanet-am-logging-logfields");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        String string2 = "";
        String string3 = "";
        while (stringTokenizer.hasMoreElements()) {
            string3 = stringTokenizer.nextToken();
            if (Debug.messageEnabled()) {
                Debug.message("DBFormatter:getSelectedFieldSet: temp1 = " + string3);
            }
            hashSet.add(string3);
            string2 = string2 + string3 + "\t";
        }
        return hashSet;
    }
}

