/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log;

import com.sun.identity.log.LogManagerUtil;
import com.sun.identity.log.LogQuery;
import com.sun.identity.log.Logger;
import com.sun.identity.log.handlers.LogReadHandler;
import com.sun.identity.log.spi.Authorizer;
import com.sun.identity.log.spi.Debug;
import java.io.File;
import java.io.IOException;
import java.util.logging.LogManager;

public class LogReader {
    private static int maxReordToReturn = 1;
    private static final String FILE_SOURCE = "File";
    private static final String DB_SOURCE = "DB";
    private static LogManager manager;
    private static String[][] queryResult;
    private static String logFileName;
    private static String logPathName;
    private static String[] archivedFiles;
    private static String fileHandlerClass;
    private static String maxRecStr;
    private static String dbHandlerClass;
    private static String logStorageType;
    private static String securityPrefix;
    private static String loggerName;
    private static LogReadHandler currentHandler;

    private LogReader() {
        manager = LogManagerUtil.getLogManager();
    }

    public static synchronized String[][] read(String string, Object object) throws IOException, NoSuchFieldException, IllegalArgumentException, RuntimeException, Exception {
        LogReader logReader = new LogReader();
        logReader.readConfiguration();
        if (string == null) {
            throw new IllegalArgumentException("filename can't be null");
        }
        LogReader.setLoggerName(string);
        if (!logReader.isAllowed(object)) {
            throw new RuntimeException("Authorization failed");
        }
        String string2 = logPathName + string;
        LogQuery logQuery = new LogQuery(-2);
        queryResult = currentHandler.logRecRead(string2, logQuery, false);
        return queryResult;
    }

    public static synchronized String[][] read(String string, String string2, Object object) throws IOException, NoSuchFieldException, IllegalArgumentException, RuntimeException, Exception {
        queryResult = LogReader.read(string, string2, null, null, object);
        return queryResult;
    }

    public static synchronized String[][] read(String string, String string2, String string3, Object object) throws IOException, NoSuchFieldException, IllegalArgumentException, RuntimeException, Exception {
        queryResult = LogReader.read(string, string2, string3, null, object);
        return queryResult;
    }

    public static synchronized String[][] read(String string, String string2, LogQuery logQuery, Object object) throws IOException, NoSuchFieldException, IllegalArgumentException, RuntimeException, Exception {
        queryResult = LogReader.read(string, string2, null, logQuery, object);
        return queryResult;
    }

    public static String[][] read(String string, String string2, String string3, LogQuery logQuery, Object object) throws IOException, NoSuchFieldException, IllegalArgumentException, RuntimeException, Exception {
        String string4 = new String();
        LogReader.setLoggerName(string, string2);
        string4 = loggerName;
        if (string3 != null) {
            if (string4.length() == 0) {
                return null;
            }
            string4 = string4 + "." + string3;
        } else {
            String string5 = new String();
            string4 = LogReader.getCurrentFile(string, string2, object);
        }
        queryResult = LogReader.read(string4, logQuery, object);
        return queryResult;
    }

    public static String[][] read(String string, LogQuery logQuery, Object object) throws IOException, NoSuchFieldException, IllegalArgumentException, RuntimeException, Exception {
        LogReader logReader = new LogReader();
        logReader.readConfiguration();
        if (string == null) {
            throw new IllegalArgumentException("filename can't be null");
        }
        if (maxReordToReturn <= 0) {
            maxReordToReturn = 1;
        }
        if (logQuery != null) {
            if (logQuery.getNumRecordsWanted() < -2) {
                logQuery.setMaxRecord(maxReordToReturn);
            } else if (logQuery.getNumRecordsWanted() == -1) {
                logQuery.setMaxRecord(maxReordToReturn);
            }
        } else {
            logQuery = new LogQuery(maxReordToReturn);
        }
        LogReader.setLoggerName(string);
        if (!logReader.isAllowed(object)) {
            throw new RuntimeException("Authorization failed");
        }
        String string2 = logPathName + string;
        queryResult = currentHandler.logRecRead(string2, logQuery, true);
        return queryResult;
    }

    private static String getCurrentFile(String string, String string2, Object object) throws IOException, NoSuchFieldException, IllegalArgumentException, RuntimeException, Exception {
        LogReader.setLoggerName(string, string2);
        Logger logger = (Logger)Logger.getLogger(loggerName);
        try {
            logFileName = logger.getCurrentFile();
        }
        catch (RuntimeException runtimeException) {
            Debug.error("LogReader.getCurrentFile(): RuntimeException: ", runtimeException);
            logFileName = null;
            throw runtimeException;
        }
        return logFileName;
    }

    private boolean isAllowed(Object object) throws Exception {
        boolean bl = false;
        try {
            bl = Authorizer.isAuthorized(loggerName, "READ", object);
        }
        catch (Exception exception) {
            Debug.error("LogReader.isAllowed(): Exception: ", exception);
            throw exception;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readConfiguration() throws Exception {
        this.cleanup();
        try {
            logStorageType = manager.getProperty("iplanet-am-logging-type");
            fileHandlerClass = manager.getProperty("iplanet-am-logging-file-read-handler");
            dbHandlerClass = null;
            logPathName = manager.getProperty("iplanet-am-logging-location");
            if (logPathName == null) {
                Debug.error("LogReader readConfiguration():unable to get log location");
                return;
            }
            if (!logPathName.endsWith(File.separator)) {
                logPathName = logPathName + File.separator;
            }
            maxRecStr = manager.getProperty("iplanet-am-logging-max-records");
        }
        catch (Exception exception) {
            Debug.error("LogReader.readConfiguration(): Exception: ", exception);
            throw exception;
        }
        try {
            if (logStorageType.compareToIgnoreCase(FILE_SOURCE) == 0) {
                Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(fileHandlerClass);
                currentHandler = (LogReadHandler)clazz.newInstance();
            } else if (logStorageType.compareToIgnoreCase(DB_SOURCE) != 0) {
                // empty if block
            }
        }
        catch (Exception exception) {
            Debug.error("LogReader.readConfiguration(): Exception: ", exception);
            throw exception;
        }
        try {
            if (maxRecStr == null) return;
            maxRecStr = maxRecStr.trim();
            maxReordToReturn = Integer.parseInt(maxRecStr);
            return;
        }
        catch (Exception exception) {
            Debug.error("LogReader.readConfiguration(): Exception: ", exception);
            throw exception;
        }
    }

    private static void setLoggerName(String string) {
        if (string.startsWith(securityPrefix)) {
            string = string.substring(securityPrefix.length() + 1, string.length());
        }
        int n = string.lastIndexOf(".");
        int n2 = string.length();
        String string2 = string.substring(++n + 1, n2);
        try {
            Long l = new Long(string2);
            long l2 = l;
            if (l2 >= 1L) {
                string = string.substring(0, n - 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        loggerName = string;
    }

    private static void setLoggerName(String string, String string2) {
        if (string != null) {
            loggerName = string;
        }
        if (string2 != null) {
            if (string != null) {
                loggerName = loggerName + ".";
            }
            loggerName = loggerName + string2;
        }
    }

    private void cleanup() {
        maxReordToReturn = -1;
        queryResult = null;
        currentHandler = null;
    }

    static {
        queryResult = null;
        logFileName = null;
        logPathName = null;
        archivedFiles = null;
        fileHandlerClass = null;
        maxRecStr = null;
        dbHandlerClass = null;
        logStorageType = null;
        securityPrefix = "_secure";
        currentHandler = null;
    }
}

