/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log;

import com.sun.identity.log.QueryElement;
import java.util.ArrayList;

public class LogQuery {
    public static final int MATCH_ALL_CONDITIONS = 1;
    public static final int MATCH_ANY_CONDITION = 2;
    public static final int MOST_RECENT_MAX_RECORDS = -1;
    public static final int ALL_RECORDS = -2;
    private int maxRecord;
    private int globalOperand;
    private ArrayList queries;
    private String sortBy;

    public LogQuery() {
        this.maxRecord = -1;
        this.globalOperand = 2;
        this.queries = null;
        this.sortBy = null;
    }

    public LogQuery(int n) {
        this.maxRecord = n;
        this.globalOperand = 2;
        this.queries = null;
        this.sortBy = null;
    }

    public LogQuery(int n, int n2, String string) throws IllegalArgumentException {
        if (n < -2) {
            throw new IllegalArgumentException("max_Record should be greater than LogQuery.ALL_RECORDS");
        }
        this.maxRecord = n;
        if (n2 > 2 || n2 < 1) {
            throw new IllegalArgumentException("matchCriteria should be LogQuery.MATCH_ANY_CONDITION or LogQuery.MATCH_ALL_CONDITIONS");
        }
        this.globalOperand = n2;
        if (string != null) {
            this.sortBy = string;
        }
        this.queries = null;
    }

    public void setGlobalOperand(int n) throws IllegalArgumentException {
        if (n > 2) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("parameter should be LogQuery.MATCH_ANY_CONDITION or LogQuery.MATCH_ALL_CONDITIONS");
            throw illegalArgumentException;
        }
        if (n < 1) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("parameter should be LogQuery.MATCH_ANY_CONDITION or LogQuery.MATCH_ALL_CONDITIONS");
            throw illegalArgumentException;
        }
        this.globalOperand = n;
    }

    public void setMaxRecord(int n) {
        if (n < -2) {
            return;
        }
        this.maxRecord = n;
    }

    public void addQuery(QueryElement queryElement) {
        if (queryElement == null) {
            return;
        }
        if (this.queries == null) {
            this.queries = new ArrayList();
        }
        this.queries.add(queryElement);
    }

    public ArrayList getQueries() {
        return this.queries;
    }

    public int getNumRecordsWanted() {
        return this.maxRecord;
    }

    public int getGlobalOperand() {
        return this.globalOperand;
    }

    public void setSortingField(String string) {
        if (string == null) {
            return;
        }
        this.sortBy = string;
    }

    public String getSortingField() {
        return this.sortBy;
    }
}

