#
# This sample shell script is to provide a basic set of compile commands for
# the different COBOL compilers supported and if necessary, certain platforms.
#
# Currently, MBM supports the following COBOL language products:
# Micro Focus Server Express(tm) and Acucorop ACUCOBOL-GT(r).
#
# If the current environment was set from an ACUCOBOL subsystem
# (as indicated by the internal environment variable MBM_COBOL=ACUCOBOL)
# the ACUCOBOL compile line will be invoked.
#
# For any other internal language setting, the Micro Focus COBOL compile
# line will be invoked.
#
if [ "$MBM_COBOL" = "ACUCOBOL" ]
then
  ccbl -Cav -Dz -Fm "--fileAssign=external" $1.cbl
else
  #
  # For Micro Focus Server Express COBOL the recommended 
  # production compile directives are:
  #
  # APOST ARITHMETIC"OSVS" CHECKDIV"OSVS" COPYLIST DEFAULTBYTE"0" IBMCOMP
  # LIBRARIAN NOALTER NOANIM NOBOUND NOCICS NOEARLY-RELEASE NOMFCOMMENT
  # NORESEQ NOTRUNC OPT"3" PANVALET PARAMCOUNTCHECK PERFORM-TYPE"OSVS"
  # RECMODE"OSVS" REMOVE"PRINTER" RTNCODE-SIZE"2" SEQUENTIAL"RECORD" SETTINGS
  # STICKY-LINKAGE"2" VSC2 CALLFH"ebmlsfile" ASSIGN"EXTERNAL"
  #
  # the following directives are intended for a test environment example only
  #
  cob -uaP -C "osvs callfh=ebmlsfile ibmcomp nobound noalter notrunc vsc2 defaultbyte=0 assign=external" $1.cbl
fi
