/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mbm.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;

public class JdLock {
    private String _jdLockFileName = null;
    private File _jdLockFile = null;
    private boolean _jdLocked = false;
    private static JdLock _jdSessionLock = null;
    private static File _jdSessionFile = null;
    private static String _jdSessionFileName = "JEdit_Session.lck";

    private JdLock() {
        _jdSessionFile = new File(_jdSessionFileName);
    }

    public JdLock(String inFile) throws FileNotFoundException {
        File exFile = new File(inFile);
        if (!exFile.exists()) {
            throw new FileNotFoundException("File " + inFile + " Not Found");
        }
        this._jdLockFileName = inFile + "_JEdit.lck";
    }

    public boolean jdLock() {
        this._jdLockFile = new File(this._jdLockFileName);
        try {
            this._jdLocked = this._jdLockFile.createNewFile();
            if (this._jdLocked) {
                this._jdLockFile.deleteOnExit();
            } else {
                this._jdLockFile = null;
            }
        }
        catch (IOException e) {
            this._jdLockFile = null;
            System.err.println(e.toString());
        }
        return this._jdLocked;
    }

    public void jdUnlock() {
        if (this._jdLockFile != null) {
            this._jdLockFile.delete();
        }
        this._jdLockFile = null;
    }

    public static void jdSetSessionFilename(String inFile) {
        if (inFile != null) {
            _jdSessionFileName = inFile + "_JEdit.lck";
        }
    }

    public static boolean jdLockSession(String pid) {
        if (_jdSessionLock == null) {
            _jdSessionLock = new JdLock();
        }
        try {
            if (_jdSessionFile.createNewFile()) {
                if (pid != null) {
                    FileWriter fw = new FileWriter(_jdSessionFile);
                    fw.write(pid + "\n");
                    fw.close();
                }
                _jdSessionFile.deleteOnExit();
                return true;
            }
            _jdSessionLock = null;
            return false;
        }
        catch (IOException e) {
            System.err.println(e.toString());
            return false;
        }
    }

    public static boolean jdUnLockSession() {
        if (_jdSessionLock == null) {
            return true;
        }
        if (_jdSessionFile.delete()) {
            _jdSessionLock = null;
            return true;
        }
        return false;
    }

    public boolean isLocked() {
        return this._jdLocked;
    }

    public String getLockInfo() {
        return this._jdLockFileName;
    }

    public static String getSessionLockInfo() {
        return _jdSessionFileName;
    }

    public static void main(String[] av) {
        try {
            JdLock jl;
            System.out.println("First attempt to lock session\n");
            if (JdLock.jdLockSession("1")) {
                System.out.println("Session is locked!, Filename ='" + JdLock.getSessionLockInfo() + "'\n");
                System.out.println("Second attempt to lock session\n");
                if (JdLock.jdLockSession("2")) {
                    System.out.println("Second attempt: Session is locked!");
                } else {
                    System.out.println("Session already locked - Good :-)\n");
                }
                if (JdLock.jdUnLockSession()) {
                    System.out.println("Session Unlocked\n");
                    if (JdLock.jdLockSession("3")) {
                        System.out.println("Third attempt: Session is locked ;-)!");
                    } else {
                        System.out.println("Session already locked - Bad :-{\n");
                    }
                    JdLock.jdUnLockSession();
                } else {
                    System.out.println("Session did not Unlock - we have a problem!\n");
                }
            }
            if ((jl = new JdLock("d:/temp/tpl")).jdLock()) {
                System.out.println("File tpl locked!\n");
                JdLock jl1 = new JdLock("d:/temp/tpl");
                if (jl1.jdLock()) {
                    System.out.println("File tpl locked!\n");
                } else {
                    System.out.println("File tpl not locked, could already be locked!\n");
                }
            } else {
                System.out.println("File tpl was not locked!\n");
            }
        }
        catch (FileNotFoundException e) {
            System.err.println(e.toString());
        }
    }
}

