/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mbm.jedit.view;

import com.sun.emp.mbm.jedit.controller.JdMediator;
import com.sun.emp.mbm.jedit.interfaces.JdIElement;
import com.sun.emp.mbm.jedit.interfaces.JdIFormUI;
import com.sun.emp.mbm.jedit.interfaces.JdIPgmDirectories;
import com.sun.emp.mbm.jedit.model.JdJobElement;
import com.sun.emp.mbm.util.JdDirectory;
import com.sun.emp.mbm.util.JdFormLayout;
import com.sun.emp.mbm.util.JdInvalidComponent;
import com.sun.emp.mbm.util.JdListChooser;
import com.sun.emp.mbm.util.Log;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JdProgramsUI
extends JPanel
implements JdIFormUI,
ListSelectionListener {
    JPanel parent;
    private JdIPgmDirectories jdElement;
    private JList jdwindowl;
    private JButton jdlistbtn;
    private JButton jdbrowsebtn;
    private JButton jddeletebtn;
    private JButton jdaddbtn;
    private JLabel jdpathnamelbl;
    private JTextField jdpathnametxt;
    private DefaultListModel listmodel;
    private File lastSelectedFile;

    public JdProgramsUI() {
        Log.entry((Level)Level.INFO, (Object)this, (String)"JdProgramsUI");
        this.parent = this;
        JdFormLayout jdfl = new JdFormLayout(20, 5);
        this.setLayout((LayoutManager)jdfl);
        this.listmodel = new DefaultListModel();
        this.jdwindowl = new JList(this.listmodel);
        JScrollPane listScrollPane = new JScrollPane(this.jdwindowl);
        this.jdwindowl.setSelectionMode(0);
        this.jdwindowl.clearSelection();
        this.jdwindowl.addListSelectionListener(this);
        this.jdlistbtn = new JButton("List");
        this.jddeletebtn = new JButton("Delete");
        this.jdbrowsebtn = new JButton("Browse");
        this.jdaddbtn = new JButton("Add");
        this.jdpathnamelbl = new JLabel("Path Name");
        this.jdpathnametxt = new JTextField(15);
        this.jdaddbtn.addActionListener(new AddListener());
        this.jddeletebtn.addActionListener(new DeleteListener());
        this.jdpathnametxt.addActionListener(new AddListener());
        this.jdbrowsebtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JFileChooser chooser = new JFileChooser(JdProgramsUI.this.lastSelectedFile);
                chooser.setFileSelectionMode(1);
                int option = chooser.showDialog(JdProgramsUI.this.parent, "Select");
                if (option == 0) {
                    JdProgramsUI.this.lastSelectedFile = chooser.getSelectedFile();
                    JdProgramsUI.this.jdpathnametxt.setText(JdProgramsUI.this.lastSelectedFile.getAbsolutePath());
                }
            }
        });
        this.jdlistbtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JdListChooser listChooser = new JdListChooser("Program Directory Chooser", "Select a Program Directory", JdMediator.getProgramDirectoryList().toArray(), JdProgramsUI.this.jdlistbtn);
                listChooser.setVisible(true);
                if (listChooser.getSelectedValue() != null) {
                    JdProgramsUI.this.jdpathnametxt.setText((String)listChooser.getSelectedValue());
                }
                listChooser.dispose();
            }
        });
        this.add(listScrollPane);
        this.add(this.jdbrowsebtn);
        this.add(this.jdlistbtn);
        this.add(this.jddeletebtn);
        this.add(this.jdpathnamelbl);
        this.add(this.jdpathnametxt);
        this.add(this.jdaddbtn);
        Log.exit((Level)Level.INFO, (Object)this, (String)"JdProgramsUI");
    }

    public void valueChanged(ListSelectionEvent e) {
        Log.entry((Level)Level.INFO, (Object)this, (String)"valueChanged");
        if (!e.getValueIsAdjusting()) {
            Log.trace((Level)Level.INFO, (Object)this, (String)"valueChanged", (String)("jdwindowl.getSelectedIndex() == " + this.jdwindowl.getSelectedIndex()));
            if (this.jdwindowl.getSelectedIndex() == -1) {
                this.jddeletebtn.setEnabled(false);
                this.jdpathnametxt.setText("");
            } else {
                this.jddeletebtn.setEnabled(true);
                String name = this.jdwindowl.getSelectedValue().toString();
                this.jdpathnametxt.setText(name);
            }
        }
        Log.exit((Level)Level.INFO, (Object)this, (String)"valueChanged");
    }

    public void show(JdIElement jdIElement) {
        Log.entry((Level)Level.INFO, (Object)this, (String)"show");
        this.jdElement = (JdIPgmDirectories)((Object)jdIElement);
        this.listmodel.clear();
        ArrayList al = new ArrayList();
        al = this.jdElement.getListPgmDirs();
        if (al != null && al.size() != 0) {
            Object[] arr1 = al.toArray();
            int i = 0;
            while (i < arr1.length) {
                JdDirectory jdi = (JdDirectory)arr1[i];
                this.listmodel.addElement(jdi.getPathname());
                Log.trace((Level)Level.INFO, (Object)this, (String)"show", (String)("Adding path '" + jdi.getPathname() + "' to list."));
                ++i;
            }
        }
        this.jdpathnametxt.setText("");
        this.setReadOnly();
        Log.exit((Level)Level.INFO, (Object)this, (String)"show");
    }

    public void update() {
        Log.entry((Level)Level.INFO, (Object)this, (String)"update");
        ArrayList<JdDirectory> arr = new ArrayList<JdDirectory>();
        Object[] arr1 = new Object[]{""};
        arr1 = this.listmodel.toArray();
        int i = 0;
        while (i < arr1.length) {
            arr.add(new JdDirectory((String)arr1[i]));
            ++i;
        }
        this.jdElement.setListPgmDirs(arr);
        Log.exit((Level)Level.INFO, (Object)this, (String)"update");
    }

    public void reset() {
        Log.entry((Level)Level.INFO, (Object)this, (String)"reset");
        this.listmodel.clear();
        ArrayList al = this.jdElement.getListPgmDirs();
        if (al != null && al.size() != 0) {
            Object[] arr1 = al.toArray();
            int i = 0;
            while (i < arr1.length) {
                JdDirectory jdi = (JdDirectory)arr1[i];
                this.listmodel.addElement(jdi.getPathname());
                Log.trace((Level)Level.INFO, (Object)this, (String)"reset", (String)("adding path '" + jdi.getPathname() + "' to list."));
                ++i;
            }
        }
        Log.exit((Level)Level.INFO, (Object)this, (String)"reset");
    }

    public void setUpdate() {
        Log.entry((Level)Level.INFO, (Object)this, (String)"setUpdate");
        this.jdwindowl.setEnabled(true);
        this.jdpathnametxt.setEnabled(true);
        this.jdlistbtn.setEnabled(true);
        this.jdbrowsebtn.setEnabled(true);
        this.jddeletebtn.setEnabled(true);
        this.jdaddbtn.setEnabled(true);
        Log.exit((Level)Level.INFO, (Object)this, (String)"setUpdate");
    }

    public void setReadOnly() {
        Log.entry((Level)Level.INFO, (Object)this, (String)"setReadOnly");
        this.jdwindowl.setEnabled(false);
        this.jdpathnametxt.setEnabled(false);
        this.jdlistbtn.setEnabled(false);
        this.jdbrowsebtn.setEnabled(false);
        this.jddeletebtn.setEnabled(false);
        this.jdaddbtn.setEnabled(false);
        Log.exit((Level)Level.INFO, (Object)this, (String)"setReadOnly");
    }

    public boolean isInputValid(JdInvalidComponent component) {
        return true;
    }

    public static void main(String[] av) {
        JFrame jf = new JFrame();
        JdProgramsUI jdpui = new JdProgramsUI();
        JdJobElement jdp = new JdJobElement();
        jdpui.show(jdp);
        jf.getContentPane().add(jdpui);
        jf.setSize(300, 300);
        jf.setVisible(true);
        jdpui.update();
    }

    class AddListener
    implements ActionListener {
        AddListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Log.entry((Level)Level.INFO, (Object)this, (String)"AddListener.actionPerformed");
            if (JdProgramsUI.this.jdpathnametxt.getText().length() == 0) {
                JOptionPane.showMessageDialog(null, "The path name cannot be empty.", "Invalid Input", 1, null);
                return;
            }
            if (JdProgramsUI.this.jdpathnametxt.getText().indexOf(" ") != -1) {
                JOptionPane.showMessageDialog(null, "The path name cannot contain space.", "Invalid Input", 1, null);
                return;
            }
            int index = JdProgramsUI.this.jdwindowl.getSelectedIndex();
            int size = JdProgramsUI.this.listmodel.getSize();
            if (index == -1 || index + 1 == size) {
                JdProgramsUI.this.listmodel.addElement(JdProgramsUI.this.jdpathnametxt.getText());
                JdProgramsUI.this.jdwindowl.setSelectedIndex(size);
            } else {
                JdProgramsUI.this.listmodel.insertElementAt(JdProgramsUI.this.jdpathnametxt.getText(), index);
                JdProgramsUI.this.jdwindowl.setSelectedIndex(index);
            }
            Log.exit((Level)Level.INFO, (Object)this, (String)"AddListener.actionPerformed");
        }
    }

    class DeleteListener
    implements ActionListener {
        DeleteListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Log.entry((Level)Level.INFO, (Object)this, (String)"DeleteListener.actionPerformed");
            int index = JdProgramsUI.this.jdwindowl.getSelectedIndex();
            JdProgramsUI.this.listmodel.remove(index);
            int size = JdProgramsUI.this.listmodel.getSize();
            if (size == 0) {
                JdProgramsUI.this.jddeletebtn.setEnabled(false);
                JdProgramsUI.this.listmodel.clear();
                JdProgramsUI.this.jdwindowl.clearSelection();
            } else {
                if (index == JdProgramsUI.this.listmodel.getSize()) {
                    --index;
                }
                if (index != 0) {
                    JdProgramsUI.this.jdwindowl.setSelectedIndex(index);
                } else {
                    JdProgramsUI.this.jdwindowl.clearSelection();
                }
            }
            Log.exit((Level)Level.INFO, (Object)this, (String)"DeleteListener.actionPerformed");
        }
    }
}

