/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mbm.jedit.view;

import com.sun.emp.mbm.jedit.controller.JdMediator;
import com.sun.emp.mbm.jedit.interfaces.JdIElement;
import com.sun.emp.mbm.jedit.interfaces.JdIFormUI;
import com.sun.emp.mbm.jedit.interfaces.JdIProcDirectories;
import com.sun.emp.mbm.jedit.model.JdJobElement;
import com.sun.emp.mbm.util.JdDirectory;
import com.sun.emp.mbm.util.JdFormLayout;
import com.sun.emp.mbm.util.JdInvalidComponent;
import com.sun.emp.mbm.util.JdListChooser;
import com.sun.emp.mbm.util.Log;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JdProceduresUI
extends JPanel
implements JdIFormUI,
ListSelectionListener {
    JPanel parent = this;
    private JdIProcDirectories jdElement;
    private JList jdwindowl;
    private JButton jdlistbtn;
    private JButton jdbrowsebtn;
    private JButton jddeletebtn;
    private JButton jdaddbtn;
    private JLabel jdpathnamelbl;
    private JTextField jdpathnametxt;
    private DefaultListModel listmodel;
    private File lastSelectedFile = null;

    public JdProceduresUI() {
        JdFormLayout jdfl = new JdFormLayout(20, 5);
        this.setLayout((LayoutManager)jdfl);
        JPanel jp = new JPanel();
        this.listmodel = new DefaultListModel();
        this.jdwindowl = new JList(this.listmodel);
        JScrollPane listScrollPane = new JScrollPane(this.jdwindowl);
        this.jdwindowl.setSelectionMode(0);
        this.jdwindowl.setSelectedIndex(0);
        this.jdwindowl.addListSelectionListener(this);
        this.jdlistbtn = new JButton("List");
        this.jddeletebtn = new JButton("Delete");
        this.jdbrowsebtn = new JButton("Browse");
        this.jdaddbtn = new JButton("Add");
        this.jdaddbtn.addActionListener(new AddListener());
        this.jddeletebtn.addActionListener(new DeleteListener());
        this.jdpathnamelbl = new JLabel("Path Name");
        this.jdpathnametxt = new JTextField(15);
        this.jdpathnametxt.addActionListener(new AddListener());
        this.jdbrowsebtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JFileChooser chooser = new JFileChooser(JdProceduresUI.this.lastSelectedFile);
                chooser.setFileSelectionMode(1);
                int option = chooser.showDialog(JdProceduresUI.this.parent, "Select");
                if (option == 0) {
                    JdProceduresUI.this.lastSelectedFile = chooser.getSelectedFile();
                    JdProceduresUI.this.jdpathnametxt.setText(JdProceduresUI.this.lastSelectedFile.getAbsolutePath());
                }
            }
        });
        this.jdlistbtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JdListChooser listChooser = new JdListChooser("Procedure Directory Chooser", "Select a Procedure Directory", JdMediator.getProcedureDirectoryList().toArray(), JdProceduresUI.this.jdlistbtn);
                listChooser.setVisible(true);
                if (listChooser.getSelectedValue() != null) {
                    JdProceduresUI.this.jdpathnametxt.setText((String)listChooser.getSelectedValue());
                }
                listChooser.dispose();
            }
        });
        this.add(listScrollPane);
        this.add(this.jdbrowsebtn);
        this.add(this.jdlistbtn);
        this.add(this.jddeletebtn);
        this.add(this.jdpathnamelbl);
        this.add(this.jdpathnametxt);
        this.add(this.jdaddbtn);
    }

    public void valueChanged(ListSelectionEvent e) {
        Log.entry((Level)Level.INFO, (Object)this, (String)"valueChanged");
        if (!e.getValueIsAdjusting()) {
            if (this.jdwindowl.getSelectedIndex() == -1) {
                this.jddeletebtn.setEnabled(false);
                this.jdpathnametxt.setText("");
            } else {
                this.jddeletebtn.setEnabled(true);
                String name = this.jdwindowl.getSelectedValue().toString();
                this.jdpathnametxt.setText(name);
            }
        }
        Log.exit((Level)Level.INFO, (Object)this, (String)"valueChanged");
    }

    public void show(JdIElement jdIElement) {
        Log.entry((Level)Level.INFO, (Object)this, (String)"show");
        this.jdElement = (JdIProcDirectories)((Object)jdIElement);
        this.listmodel.removeAllElements();
        ArrayList al = this.jdElement.getListProcDirs();
        if (al != null && al.size() != 0) {
            Object[] arr1 = al.toArray();
            int i = 0;
            while (i < arr1.length) {
                JdDirectory jdi = (JdDirectory)arr1[i];
                this.listmodel.addElement(jdi.getPathname());
                ++i;
            }
        }
        this.jdpathnametxt.setText("");
        this.setReadOnly();
        Log.exit((Level)Level.INFO, (Object)this, (String)"show");
    }

    public void update() {
        Log.entry((Level)Level.INFO, (Object)this, (String)"update");
        ArrayList<JdDirectory> arr = new ArrayList<JdDirectory>();
        Object[] arr1 = new Object[]{""};
        arr1 = this.listmodel.toArray();
        int i = 0;
        while (i < arr1.length) {
            arr.add(new JdDirectory((String)arr1[i]));
            ++i;
        }
        this.jdElement.setListProcDirs(arr);
        Log.exit((Level)Level.INFO, (Object)this, (String)"update");
    }

    public void reset() {
        Log.entry((Level)Level.INFO, (Object)this, (String)"reset");
        this.listmodel.removeAllElements();
        ArrayList al = this.jdElement.getListProcDirs();
        if (al != null && al.size() != 0) {
            Object[] arr1 = al.toArray();
            int i = 0;
            while (i < arr1.length) {
                JdDirectory jdi = (JdDirectory)arr1[i];
                this.listmodel.addElement(jdi.getPathname());
                ++i;
            }
        }
        Log.exit((Level)Level.INFO, (Object)this, (String)"reset");
    }

    public void setUpdate() {
        this.jdwindowl.setEnabled(true);
        this.jdpathnametxt.setEnabled(true);
        this.jddeletebtn.setEnabled(true);
        this.jdaddbtn.setEnabled(true);
        this.jdbrowsebtn.setEnabled(true);
        this.jdlistbtn.setEnabled(true);
    }

    public void setReadOnly() {
        this.jdwindowl.setEnabled(false);
        this.jdpathnametxt.setEnabled(false);
        this.jddeletebtn.setEnabled(false);
        this.jdaddbtn.setEnabled(false);
        this.jdbrowsebtn.setEnabled(false);
        this.jdlistbtn.setEnabled(false);
    }

    public boolean isInputValid(JdInvalidComponent component) {
        return true;
    }

    public static void main(String[] av) {
        JFrame jf = new JFrame();
        JdProceduresUI jdpui = new JdProceduresUI();
        JdJobElement jdp = new JdJobElement();
        jdpui.show(jdp);
        jf.getContentPane().add(jdpui);
        jf.setSize(300, 300);
        jf.setVisible(true);
        jdpui.update();
    }

    class AddListener
    implements ActionListener {
        AddListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Log.entry((Level)Level.INFO, (Object)this, (String)"actionPerformed");
            if (JdProceduresUI.this.jdpathnametxt.getText().length() == 0) {
                JOptionPane.showMessageDialog(null, "The path name cannot be empty.", "Invalid Input", 1, null);
                return;
            }
            if (JdProceduresUI.this.jdpathnametxt.getText().indexOf(" ") != -1) {
                JOptionPane.showMessageDialog(null, "The path name cannot contain space.", "Invalid Input", 1, null);
                return;
            }
            int index = JdProceduresUI.this.jdwindowl.getSelectedIndex();
            int size = JdProceduresUI.this.listmodel.getSize();
            if (index == -1 || index + 1 == size) {
                JdProceduresUI.this.listmodel.addElement(JdProceduresUI.this.jdpathnametxt.getText());
                JdProceduresUI.this.jdwindowl.setSelectedIndex(size);
            } else {
                JdProceduresUI.this.listmodel.insertElementAt(JdProceduresUI.this.jdpathnametxt.getText(), index);
                JdProceduresUI.this.jdwindowl.setSelectedIndex(index);
            }
            Log.exit((Level)Level.INFO, (Object)this, (String)"actionPerformed");
        }
    }

    class DeleteListener
    implements ActionListener {
        DeleteListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Log.entry((Level)Level.INFO, (Object)this, (String)"DeleteListener.actionPerformed");
            int index = JdProceduresUI.this.jdwindowl.getSelectedIndex();
            JdProceduresUI.this.listmodel.remove(index);
            int size = JdProceduresUI.this.listmodel.getSize();
            if (size == 0) {
                JdProceduresUI.this.jddeletebtn.setEnabled(false);
            } else {
                if (index == JdProceduresUI.this.listmodel.getSize()) {
                    --index;
                }
                JdProceduresUI.this.jdwindowl.setSelectedIndex(index);
            }
            Log.exit((Level)Level.INFO, (Object)this, (String)"DeleteListener.actionPerformed");
        }
    }
}

