/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mbm.jedit.model;

import com.sun.emp.mbm.jedit.interfaces.JdIElement;
import com.sun.emp.mbm.jedit.interfaces.JdIMutableTreeNode;
import com.sun.emp.mbm.jedit.interfaces.JdIProjectElement;
import com.sun.emp.mbm.jedit.interfaces.JdIVisitor;
import com.sun.emp.mbm.jedit.model.JdJobFolderElement;
import com.sun.emp.mbm.jedit.model.JdProcStepElement;
import com.sun.emp.mbm.util.JdDirectory;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;

public class JdProjectElement
implements JdIProjectElement {
    static final long serialVersionUID = 838587791445004024L;
    private static final ObjectStreamField[] serialPersistentFields;
    private JdDirectory jdDirectory = new JdDirectory("");
    private String jdProjectName = "New Project";
    private String jdDescription = "Enter Description";
    static /* synthetic */ Class class$com$sun$emp$mbm$util$JdDirectory;
    static /* synthetic */ Class class$java$lang$String;

    public JdProjectElement() {
    }

    public JdProjectElement(String project_name) {
        this.jdProjectName = project_name;
    }

    public void setDirectoryPathname(JdDirectory directoryName) {
        if (directoryName != null) {
            this.jdDirectory = directoryName;
        }
    }

    public void setName(String elementName) {
        this.jdProjectName = elementName;
    }

    public void setDescription(String text) {
        this.jdDescription = text;
    }

    public void restoreFrom(JdIElement jdElement) {
        JdProjectElement jdProjectElement = (JdProjectElement)jdElement;
        try {
            this.jdDirectory = (JdDirectory)jdProjectElement.jdDirectory.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        this.jdProjectName = jdProjectElement.jdProjectName;
        this.jdDescription = jdProjectElement.jdDescription;
    }

    public void acceptVisitor(JdIVisitor visitor, JdIMutableTreeNode treeNodeOwner) {
        visitor.visitProject(this, treeNodeOwner);
    }

    public JdDirectory getDirectoryPathname() {
        return this.jdDirectory;
    }

    public String getToolTipText() {
        return "Project directory = " + this.jdDirectory.getPathname();
    }

    public String getDescription() {
        return this.jdDescription;
    }

    public String getName() {
        return this.jdProjectName;
    }

    public boolean canContain(JdIElement jdElement, JdIElement parentElement) {
        switch (jdElement.getElementType()) {
            case 1: {
                return true;
            }
        }
        return false;
    }

    public boolean canInsert(int jType, int parentType) {
        switch (jType) {
            case 0: 
            case 1: {
                return true;
            }
        }
        return false;
    }

    public boolean canExport() {
        return false;
    }

    public boolean canImport() {
        return false;
    }

    public boolean canDelete() {
        return true;
    }

    public boolean canModify() {
        return true;
    }

    public int getElementType() {
        return 0;
    }

    public Object clone() throws CloneNotSupportedException {
        JdProjectElement jdprojectcopy = (JdProjectElement)super.clone();
        jdprojectcopy.jdDirectory = (JdDirectory)this.jdDirectory.clone();
        return jdprojectcopy;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        try {
            ObjectOutputStream.PutField fields = stream.putFields();
            fields.put("f_jdDirectory", this.jdDirectory);
            fields.put("f_jdProjectName", this.jdProjectName);
            fields.put("f_jdDescription", this.jdDescription);
            stream.writeFields();
        }
        catch (IOException e) {
            System.out.println("JdProjectElement::writeObject - " + e);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException {
        try {
            ObjectInputStream.GetField fields = stream.readFields();
            this.jdDirectory = (JdDirectory)fields.get("f_jdDirectory", "");
            this.jdProjectName = (String)fields.get("f_jdProjectName", "New Project");
            this.jdDescription = (String)fields.get("f_jdDescription", "Enter Description");
        }
        catch (ClassNotFoundException e) {
            System.out.println("JdProjectElement::readObject - " + e);
        }
    }

    public static void main(String[] av) {
        System.out.println("-------------------------------------------------");
        System.out.println("Test Constructors: ");
        System.out.println("-------------------------------------------------");
        JdProjectElement jpe1 = new JdProjectElement();
        System.out.println("getName without arg returned: " + jpe1.getName());
        JdProjectElement jpe2 = new JdProjectElement("PROD");
        System.out.println("getName with arg returned: " + jpe2.getName());
        System.out.println(" ");
        System.out.println("-------------------------------------------------");
        System.out.println("Test setName ");
        System.out.println("-------------------------------------------------");
        System.out.println("Invoking setName with project name: PROD");
        jpe2.setName("PROD");
        System.out.println("getName returned Project name: " + jpe2.getName());
        System.out.println(" ");
        System.out.println("-------------------------------------------------");
        System.out.println("Test setDirectoryPathname ");
        System.out.println("-------------------------------------------------");
        System.out.println("Invoking setDirectoryPathname with directory name: /prod");
        JdDirectory jddir = new JdDirectory("/prod");
        jpe2.setDirectoryPathname(jddir);
        System.out.println("getDirectoryPathname returned directory name: " + jpe2.getDirectoryPathname().getPathname());
        System.out.println(" ");
        System.out.println("-------------------------------------------------");
        System.out.println("Test getToolTipText ");
        System.out.println("-------------------------------------------------");
        System.out.println("getToolTipText returns the Directory Path shown above preceded by 'Project Directory = '");
        System.out.println("getToolTipText returned: " + jpe2.getToolTipText());
        System.out.println(" ");
        System.out.println("-------------------------------------------------");
        System.out.println("Test setDescription ");
        System.out.println("-------------------------------------------------");
        System.out.println("Invoking setDescription with description : This project folder contains the production batch");
        jpe2.setDescription("This project folder contains the production batch");
        System.out.println("getDescription returned description: " + jpe2.getDescription());
        System.out.println(" ");
        System.out.println("-------------------------------------------------");
        System.out.println("Test canContain ");
        System.out.println("-------------------------------------------------");
        System.out.println("Invoked canContain with VALID JdIElement JdJobFolderElement, it returned: " + jpe2.canContain(new JdJobFolderElement(), null));
        System.out.println("Invoked canContain with INVALID JdIElement JdProcStepElement, it returned:" + jpe2.canContain(new JdProcStepElement(), null));
        System.out.println(" ");
        System.out.println("-------------------------------------------------");
        System.out.println("Test canInsert ");
        System.out.println("-------------------------------------------------");
        System.out.println("Invoked canInsert with VALID type JD_FOLDER, it returned:  " + jpe2.canInsert(1, 0));
        System.out.println("Invoked canInsert with INVALID type JD_JVSAM, it returned:  " + jpe2.canInsert(8, 0));
        System.out.println(" ");
        System.out.println("-------------------------------------------------");
        System.out.println("Test clone and restoreFrom ");
        System.out.println("-------------------------------------------------");
        System.out.println(" ");
        System.out.println("Creating jpe3");
        System.out.println("with ProjectName = \tJpe3 Project Name");
        System.out.println("with Description =\t\tJpe3 Description");
        System.out.println("with Directory =\t\t/Jpe3/testdir0");
        System.out.println("        -- end of Jpe3 -- ");
        JdProjectElement jpe3 = new JdProjectElement();
        jpe3.setName("Jpe3 Project Name");
        jpe3.setDescription("Jpe3 Description");
        JdDirectory j3dir0 = new JdDirectory();
        j3dir0.setPathname("/Jpe3/testdir0");
        jpe3.setDirectoryPathname(j3dir0);
        System.out.println(" ");
        System.out.println(" ");
        System.out.println("Printing original jpe3 as created");
        System.out.println(" ");
        System.out.println("      -- jpe3 original --");
        System.out.println("ProjectName = " + jpe3.getName());
        System.out.println("Description = " + jpe3.getDescription());
        System.out.println("Directory   = " + jpe3.getDirectoryPathname().getPathname());
        System.out.println(" ");
        System.out.println(" ");
        System.out.println("Clone jpe3 and call the clone jpe4");
        System.out.println(" ");
        try {
            JdProjectElement jpe4 = (JdProjectElement)jpe3.clone();
            System.out.println("Print jpe4 -- it should look identical to jpe3");
            System.out.println(" ");
            System.out.println("      -- jpe4 clone --");
            System.out.println("ProjectName = " + jpe4.getName());
            System.out.println("Description = " + jpe4.getDescription());
            System.out.println("Directory   = " + jpe4.getDirectoryPathname().getPathname());
            System.out.println(" ");
            System.out.println(" ");
            System.out.println("Modify the values of jpe4");
            System.out.println("with ProjectName = Jpe4 Project Name");
            System.out.println("with Description = Jpe4 Description");
            System.out.println("with Directory   = /Jpe4/testdir0");
            System.out.println("        -- end of Jpe4 -- ");
            System.out.println(" ");
            jpe4.setName("Jpe4 Project Name");
            jpe4.setDescription("Jpe4 Description");
            JdDirectory j4dir0 = new JdDirectory();
            j4dir0.setPathname("/Jpe4/testdir0");
            jpe4.setDirectoryPathname(j4dir0);
            System.out.println(" ");
            System.out.println("Print jpe4 with its new values");
            System.out.println(" ");
            System.out.println("      -- jpe4 original --");
            System.out.println("ProjectName = " + jpe4.getName());
            System.out.println("Description = " + jpe4.getDescription());
            System.out.println("Directory   = " + jpe4.getDirectoryPathname().getPathname());
            System.out.println(" ");
            System.out.println(" ");
            System.out.println("Print original jpe3 to show it hasn't changed");
            System.out.println(" ");
            System.out.println("      -- jpe3 --");
            System.out.println("ProjectName = " + jpe3.getName());
            System.out.println("Description = " + jpe3.getDescription());
            System.out.println("Directory   = " + jpe3.getDirectoryPathname().getPathname());
            System.out.println(" ");
            System.out.println(" ");
            System.out.println("Now restore jpe4 to the same values as jpe3");
            System.out.println(" ");
            jpe4.restoreFrom(jpe3);
            System.out.println("Print jpe4 -- should be identical to jpe3 again");
            System.out.println(" ");
            System.out.println("      -- jpe4 restored to jpe3--");
            System.out.println("ProjectName = " + jpe4.getName());
            System.out.println("Description = " + jpe4.getDescription());
            System.out.println("Directory   = " + jpe4.getDirectoryPathname().getPathname());
            System.out.println(" ");
            System.out.println(" ");
            System.out.println("Now modify jpe4 again");
            System.out.println("with ProjectName = Jpe4 - Project Name");
            System.out.println("with Description = Jpe4 - Description");
            System.out.println("with Directory   = /Jpe4/testdir2");
            System.out.println("        -- end of Jpe4 -- ");
            System.out.println(" ");
            System.out.println(" ");
            jpe4.setName("Jpe4 - Project Name");
            jpe4.setDescription("Jpe4 - Description");
            JdDirectory j4dir2 = new JdDirectory();
            j4dir2.setPathname("/Jpe4/testdir2");
            jpe4.setDirectoryPathname(j4dir2);
            System.out.println(" ");
            System.out.println("Print jpe4 with its new values");
            System.out.println(" ");
            System.out.println(" ");
            System.out.println("      -- jpe4 modified again --");
            System.out.println("ProjectName = " + jpe4.getName());
            System.out.println("Description = " + jpe4.getDescription());
            System.out.println("Directory   = " + jpe4.getDirectoryPathname().getPathname());
            System.out.println(" ");
            System.out.println(" ");
            System.out.println("Print jpe3 to show it hasn't changed");
            System.out.println(" ");
            System.out.println("      -- jpe3 --");
            System.out.println("ProjectName = " + jpe3.getName());
            System.out.println("Description = " + jpe3.getDescription());
            System.out.println("Directory   = " + jpe3.getDirectoryPathname().getPathname());
            System.out.println(" ");
            System.out.println(" ");
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Error: " + e.toString());
        }
        System.out.println(" ");
        System.out.println("-------------------------------------------------");
        System.out.println("Test readObject and writeObject ");
        System.out.println("-------------------------------------------------");
        JdProjectElement jpe5 = new JdProjectElement();
        jpe5.setName("Jpe5 Project Name");
        jpe5.setDescription("Jpe5 Description");
        JdDirectory j5dir0 = new JdDirectory();
        j5dir0.setPathname("/Jpe5/testdir1");
        jpe5.setDirectoryPathname(j5dir0);
        System.out.println(" ");
        System.out.println(" ");
        System.out.println("Printing jpe 3 and jpe5 for reference");
        System.out.println(" ");
        System.out.println("      -- jpe3 original --");
        System.out.println("ProjectName = " + jpe3.getName());
        System.out.println("Description = " + jpe3.getDescription());
        System.out.println("Directory   = " + jpe3.getDirectoryPathname().getPathname());
        System.out.println(" ");
        System.out.println("      -- jpe5 original --");
        System.out.println("ProjectName = " + jpe5.getName());
        System.out.println("Description = " + jpe5.getDescription());
        System.out.println("Directory   = " + jpe5.getDirectoryPathname().getPathname());
        System.out.println(" ");
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream("JdProjectElement.ser"));
            System.out.println("Write jpe3 and jpe5");
            oos.writeObject(jpe3);
            oos.writeObject(jpe5);
            System.out.println("Read  jpe3 and jpe5");
            System.out.println(" ");
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream("JdProjectElement.ser"));
            try {
                JdProjectElement jpeIn0 = (JdProjectElement)ois.readObject();
                System.out.println("Print jpe3 as it was read back in");
                System.out.println("      -- jpe3 --");
                System.out.println("ProjectName = " + jpeIn0.getName());
                System.out.println("Description = " + jpeIn0.getDescription());
                System.out.println("Directory   = " + jpeIn0.getDirectoryPathname().getPathname());
                System.out.println(" ");
                JdProjectElement jpeIn1 = (JdProjectElement)ois.readObject();
                System.out.println("Print jpe5 as it was read back in");
                System.out.println("      -- jpe5 --");
                System.out.println("ProjectName = " + jpeIn1.getName());
                System.out.println("Description = " + jpeIn1.getDescription());
                System.out.println("Directory   = " + jpeIn1.getDirectoryPathname().getPathname());
                System.out.println(" ");
            }
            catch (ClassNotFoundException cnfe) {
                System.err.println("Error: " + cnfe.toString());
            }
        }
        catch (IOException ioe) {
            System.err.println("Error: " + ioe.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        serialVersionUID = 838587791445004024L;
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("f_jdDirectory", class$com$sun$emp$mbm$util$JdDirectory == null ? (class$com$sun$emp$mbm$util$JdDirectory = JdProjectElement.class$("com.sun.emp.mbm.util.JdDirectory")) : class$com$sun$emp$mbm$util$JdDirectory), new ObjectStreamField("f_jdProjectName", class$java$lang$String == null ? (class$java$lang$String = JdProjectElement.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("f_jdDescription", class$java$lang$String == null ? (class$java$lang$String = JdProjectElement.class$("java.lang.String")) : class$java$lang$String)};
    }
}

