/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mbm.jedit.model;

import com.sun.emp.mbm.jedit.interfaces.JdIElement;
import com.sun.emp.mbm.jedit.interfaces.JdIMutableTreeNode;
import com.sun.emp.mbm.jedit.interfaces.JdINodeElement;
import com.sun.emp.mbm.jedit.model.JdJobElement;
import com.sun.emp.mbm.jedit.model.JdMutableTreeNode;
import com.sun.emp.mbm.jedit.model.JdNode;
import com.sun.emp.mbm.jedit.model.JdProjectElement;
import com.sun.emp.mbm.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.logging.Level;

public class JdFileNode
implements JdINodeElement {
    private JdIElement mJdIElement;
    private boolean _nodeAdded = false;

    public void expandNode(JdIMutableTreeNode jdIMutableTreeNode) {
        Log.entry((Level)Level.INFO, (Object)this, (String)"expandNode");
        if (!this._nodeAdded) {
            JdIMutableTreeNode grandParentNode;
            String projectPath = null;
            ((JdMutableTreeNode)jdIMutableTreeNode).removeAllChildren();
            JdIMutableTreeNode parentNode = jdIMutableTreeNode.getJdParent();
            if (null != parentNode && null != (grandParentNode = parentNode.getJdParent())) {
                JdProjectElement jdpe = (JdProjectElement)grandParentNode.getJdIElement();
                projectPath = jdpe.getDirectoryPathname().getPathname() + File.separator + jdpe.getName() + File.separator + parentNode.toString();
            }
            String fullPath = projectPath + File.separator + jdIMutableTreeNode.getJdIElement().getName() + ".ser";
            try {
                FileInputStream fstream = new FileInputStream(fullPath);
                ObjectInputStream istream = new ObjectInputStream(fstream);
                JdNode fileNode = (JdNode)istream.readObject();
                istream.close();
                jdIMutableTreeNode.getJdIElement().restoreFrom(fileNode.getJdIElement());
                this.buildNodes(jdIMutableTreeNode, fileNode);
            }
            catch (IOException e) {
                System.err.println(e.toString());
                Log.exit((Level)Level.INFO, (Object)this, (String)"expandNode");
                return;
            }
            catch (ClassNotFoundException e) {
                System.err.println(e.toString());
                Log.exit((Level)Level.INFO, (Object)this, (String)"expandNode");
                return;
            }
            this._nodeAdded = true;
            Log.exit((Level)Level.INFO, (Object)this, (String)"expandNode");
        }
    }

    private void buildNodes(JdIMutableTreeNode treeNode, JdNode fileNode) {
        Log.entry((Level)Level.INFO, (Object)this, (String)"buildNodes");
        int count = 0;
        Enumeration eNodes = fileNode.getAllChildren();
        while (eNodes.hasMoreElements()) {
            JdNode l_fileNode = (JdNode)eNodes.nextElement();
            JdMutableTreeNode l_treeNode = new JdMutableTreeNode(l_fileNode.getJdIElement());
            treeNode.insertJdNode(l_treeNode, count++);
            this.buildNodes(l_treeNode, l_fileNode);
        }
        Log.exit((Level)Level.INFO, (Object)this, (String)"buildNodes");
    }

    public void setJdIElement(JdIElement jdIElement) {
        this.mJdIElement = jdIElement;
    }

    public void setNodeAdded(boolean added) {
        this._nodeAdded = added;
    }

    public JdIElement getJdIElement() {
        return this.mJdIElement;
    }

    public boolean isNodeAdded() {
        return this._nodeAdded;
    }

    public static void main(String[] av) {
        JdFileNode ljdFileNode = new JdFileNode();
        JdJobElement lJdJobElement = new JdJobElement();
        ljdFileNode.setJdIElement(lJdJobElement);
        System.out.println("Called method a ");
        JdIElement lJdIElement = ljdFileNode.getJdIElement();
        if (lJdIElement.equals(lJdJobElement)) {
            System.out.println("Correct ");
        } else {
            System.out.println("incorrect ");
        }
        System.out.println("Instantiated a " + ljdFileNode.toString());
    }
}

