/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mbm.jedit.controller;

import com.sun.emp.mbm.jedit.interfaces.JdIElement;
import com.sun.emp.mbm.jedit.interfaces.JdIMutableTreeNode;
import com.sun.emp.mbm.jedit.model.JdConcatenatedFile;
import com.sun.emp.mbm.jedit.model.JdConfiguration;
import com.sun.emp.mbm.jedit.model.JdGdgFile;
import com.sun.emp.mbm.jedit.model.JdInputFile;
import com.sun.emp.mbm.jedit.model.JdJobElement;
import com.sun.emp.mbm.jedit.model.JdMutableTreeNode;
import com.sun.emp.mbm.jedit.model.JdNode;
import com.sun.emp.mbm.jedit.model.JdPgmStepElement;
import com.sun.emp.mbm.jedit.model.JdPrintFile;
import com.sun.emp.mbm.jedit.model.JdProcElement;
import com.sun.emp.mbm.jedit.model.JdProjectElement;
import com.sun.emp.mbm.jedit.model.JdStandardFile;
import com.sun.emp.mbm.jedit.model.JdUtilStepElement;
import com.sun.emp.mbm.jedit.model.JdVsamFile;
import com.sun.emp.mbm.util.JdDirectory;
import com.sun.emp.mbm.util.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.logging.Level;

public class JdWriterVisitor {
    JdWriterVisitor() {
    }

    public void doWriteConfiguration() {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream("JdConfig.ser"));
            JdConfiguration configuration = JdConfiguration.getConfiguration();
            oos.writeObject(configuration);
            oos.close();
        }
        catch (Exception e) {
            Log.displayMessage((Object)"JdWriterVisitor", (String)"doWriteConfiguration", (String)e.toString(), (String)"E00003", (Object)e.toString());
        }
    }

    public static void doCreateDir(JdIMutableTreeNode jdTreeNode) {
        String dirname = jdTreeNode.getJdIElement().getName();
        if (dirname.startsWith("New ")) {
            return;
        }
        String path = ((JdProjectElement)jdTreeNode.getJdIElement()).getDirectoryPathname().getPathname() + File.separator + dirname;
        try {
            File project_folder = new File(path);
            File jobs_folder = new File(path + File.separator + "jobs");
            File procs_folder = new File(path + File.separator + "procs");
            File ish_folder = new File(path + File.separator + "ish");
            File ishp_folder = new File(path + File.separator + "ishp");
            if (project_folder.exists()) {
                jobs_folder.mkdir();
                procs_folder.mkdir();
                ish_folder.mkdir();
                ishp_folder.mkdir();
            } else if (project_folder.mkdirs()) {
                jobs_folder.mkdir();
                procs_folder.mkdir();
                ish_folder.mkdir();
                ishp_folder.mkdir();
            } else {
                Log.displayMessage((Object)"JdWriterVisitor", (String)"doCreateDir", (String)("Could not create project directory '" + path + "'"), (String)"E00004", (Object)path);
            }
        }
        catch (NullPointerException npe) {
            Log.displayMessage((Object)"JdWriterVisitor", (String)"doCreateDir", (String)npe.toString(), (String)"E00003", (Object)npe.toString());
        }
    }

    public void doWriteFile(JdIMutableTreeNode jdTreeNode, String path) {
        JdNode node = new JdNode(jdTreeNode);
        try {
            File file = new File(path + File.separator + jdTreeNode.getJdIElement().getName() + ".ser");
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(file));
            oos.writeObject(node);
            oos.close();
        }
        catch (FileNotFoundException fnfe) {
            Log.displayMessage((Object)this, (String)"doWriteFile", (String)fnfe.toString(), (String)"E00003", (Object)fnfe.toString());
        }
        catch (IOException ioe) {
            Log.displayMessage((Object)this, (String)"doWriteFile ", (String)ioe.toString(), (String)"E00003", (Object)ioe.toString());
        }
    }

    public void doDeleteFile(JdIMutableTreeNode jdTreeNode, JdIMutableTreeNode parentNode) {
        String fullPath = JdWriterVisitor.getFullPath(parentNode) + File.separator + jdTreeNode.getJdIElement().getName() + ".ser";
        File dFile = new File(fullPath);
        dFile.delete();
    }

    public static void renameNode(JdIElement oldElement, JdIElement newElement, JdIMutableTreeNode jdTreeNode) {
        Log.trace((Level)Level.INFO, (Object)"JdWriterVisitor", (String)"renameNode", (String)"entering");
        if (jdTreeNode == null) {
            Log.trace((Level)Level.INFO, (Object)"JdWriterVisitor", (String)"renameNode - jdTreeNode == null", (String)"exit");
            return;
        }
        if (oldElement == null) {
            Log.trace((Level)Level.INFO, (Object)"JdWriterVisitor", (String)"renameNode - oldElement == null", (String)"exit");
            return;
        }
        if (newElement == null) {
            Log.trace((Level)Level.INFO, (Object)"JdWriterVisitor", (String)"renameNode - newElement == null", (String)"exit");
            return;
        }
        if (!(oldElement instanceof JdProjectElement || oldElement instanceof JdJobElement || oldElement instanceof JdProcElement)) {
            Log.trace((Level)Level.INFO, (Object)"JdWriterVisitor", (String)"renameNode - not job/proc/proj", (String)"exit");
            return;
        }
        if (oldElement.getName().startsWith("New ")) {
            Log.trace((Level)Level.INFO, (Object)"JdWriterVisitor", (String)"renameNode - is 'New ' element", (String)"exit");
            return;
        }
        if (oldElement.getName().equals("Pasted Node")) {
            Log.trace((Level)Level.INFO, (Object)"JdWriterVisitor", (String)"renameNode - is Pasted element", (String)"exit");
            return;
        }
        if (newElement.getName().startsWith("New ") || newElement.getName().equals("Pasted Node")) {
            try {
                String projPath = null;
                projPath = !(oldElement instanceof JdProjectElement) ? ((JdProjectElement)jdTreeNode.getJdParent().getJdParent().getJdIElement()).getDirectoryPathname().getPathname() : ((JdProjectElement)oldElement).getDirectoryPathname().getPathname();
                String oldPath = projPath + File.separator + oldElement.getName();
                File rmFile = new File(oldPath);
                if (rmFile.exists()) {
                    rmFile.delete();
                }
            }
            catch (SecurityException e) {
                Log.displayMessage((Object)"JdWriterVisitor", (String)"renameNode 1", (String)e.toString(), (String)"E00003", (Object)e.toString());
            }
            Log.trace((Level)Level.INFO, (Object)"JdWriterVisitor", (String)"renameNode - is new/pasted node", (String)"exit");
            return;
        }
        switch (oldElement.getElementType()) {
            case 0: {
                try {
                    String newPath = ((JdProjectElement)newElement).getDirectoryPathname().getPathname() + File.separator + newElement.getName();
                    String oldPath = ((JdProjectElement)oldElement).getDirectoryPathname().getPathname() + File.separator + oldElement.getName();
                    File projFile = new File(oldPath);
                    File newProjFile = new File(newPath);
                    if (!projFile.exists() || projFile.renameTo(newProjFile)) break;
                    Log.displayMessage((Object)"JdWriterVisitor", (String)"renameNode", (String)("Could not rename '" + oldPath + "' to '" + newPath + "'"), (String)"E00005", (Object)oldPath, (Object)newPath);
                }
                catch (SecurityException e) {
                    Log.displayMessage((Object)"JdWriterVisitor", (String)"renameNode 3", (String)e.toString(), (String)"E00003", (Object)e.toString());
                }
                catch (NullPointerException e) {
                    Log.displayMessage((Object)"JdWriterVisitor", (String)"renameNode 4", (String)e.toString(), (String)"E00003", (Object)e.toString());
                }
                break;
            }
            case 2: 
            case 3: {
                try {
                    String path = JdWriterVisitor.getFullPath(jdTreeNode.getJdParent());
                    String oldPath = path + File.separator + oldElement.getName() + ".ser";
                    String newPath = path + File.separator + newElement.getName() + ".ser";
                    File oldFile = new File(oldPath);
                    File newFile = new File(newPath);
                    if (!oldFile.exists() || oldFile.renameTo(newFile)) break;
                    Log.displayMessage((Object)"JdWriterVisitor", (String)"renameNode", (String)("Could not rename '" + oldPath + "' to '" + newPath + "'"), (String)"E00005", (Object)oldPath, (Object)newPath);
                }
                catch (SecurityException e) {
                    Log.displayMessage((Object)"JdWriterVisitor", (String)"renameNode 6", (String)e.toString(), (String)"E00003", (Object)e.toString());
                }
                catch (NullPointerException e) {
                    Log.displayMessage((Object)"JdWriterVisitor", (String)"renameNode 7", (String)e.toString(), (String)"E00003", (Object)e.toString());
                }
                break;
            }
        }
        Log.trace((Level)Level.INFO, (Object)"JdWriterVisitor", (String)"renameNode", (String)"exit");
    }

    public static void moveProject(JdProjectElement oldElement, JdProjectElement newElement, JdIMutableTreeNode jdTreeNode) {
        Log.trace((Level)Level.INFO, (Object)"JdWriterVisitor", (String)"moveProject", (String)"entering");
        if (jdTreeNode == null) {
            Log.trace((Level)Level.INFO, (Object)"JdWriterVisitor", (String)"moveProject - jdTreeNode == null", (String)"exit");
            return;
        }
        if (oldElement == null) {
            Log.trace((Level)Level.INFO, (Object)"JdWriterVisitor", (String)"moveProject - oldElement == null", (String)"exit");
            return;
        }
        if (newElement == null) {
            Log.trace((Level)Level.INFO, (Object)"JdWriterVisitor", (String)"moveProject - newElement == null", (String)"exit");
            return;
        }
        if (oldElement.getName().startsWith("New ")) {
            Log.trace((Level)Level.INFO, (Object)"JdWriterVisitor", (String)"moveProject - is 'New ' element", (String)"exit");
            return;
        }
        if (oldElement.getName().equals("Pasted Node")) {
            Log.trace((Level)Level.INFO, (Object)"JdWriterVisitor", (String)"moveProject - is Pasted element", (String)"exit");
            return;
        }
        if (newElement.getName().startsWith("New ") || newElement.getName().equals("Pasted Node")) {
            Log.trace((Level)Level.INFO, (Object)"JdWriterVisitor", (String)"moveProject - is new/pasted node", (String)"exit");
            return;
        }
        JdWriterVisitor.doCreateDir(jdTreeNode);
        Log.trace((Level)Level.INFO, (Object)"JdWriterVisitor", (String)"moveProject", (String)"exit");
    }

    private static String getFullPath(JdIMutableTreeNode targetNode) {
        String fullPath = null;
        Object projectPath = null;
        String parentPath = null;
        if (null != targetNode) {
            JdIMutableTreeNode parentNode = targetNode;
            while (parentNode != null && !(((JdMutableTreeNode)parentNode).getJdIElement() instanceof JdProjectElement)) {
                parentPath = parentPath == null ? File.separator + parentNode.toString() : parentPath + File.separator + parentNode.toString();
                parentNode = ((JdMutableTreeNode)parentNode).getJdParent();
            }
            if (parentNode != null) {
                JdIElement jdie = parentNode.getJdIElement();
                JdProjectElement jdpe = (JdProjectElement)jdie;
                JdDirectory jdDirectory = jdpe.getDirectoryPathname();
                fullPath = jdDirectory.getPathname() + File.separator + jdpe.getName() + parentPath;
            } else {
                Log.displayMessage((Object)"JdWriterVisitor", (String)"getFullPath", (String)"parentNode is Null", (String)"E00002", (Object)"parentNode");
            }
        } else {
            Log.displayMessage((Object)"JdWriterVisitor", (String)"getFullPath", (String)"targetNode is Null", (String)"E00002", (Object)"targetNode");
        }
        return fullPath;
    }

    protected static JdIMutableTreeNode testjob() {
        JdMutableTreeNode treeJob1 = new JdMutableTreeNode(new JdJobElement("Job1"));
        JdMutableTreeNode treeStep1 = new JdMutableTreeNode(new JdPgmStepElement("Step1"));
        treeJob1.insertJdNode(treeStep1, 0);
        treeStep1.insertJdNode(new JdMutableTreeNode(new JdStandardFile("StdFile1")), 0);
        treeStep1.insertJdNode(new JdMutableTreeNode(new JdInputFile("InputFile1")), 1);
        treeStep1.insertJdNode(new JdMutableTreeNode(new JdVsamFile("VSAMFile1")), 2);
        treeStep1.insertJdNode(new JdMutableTreeNode(new JdGdgFile("GDGFile1")), 3);
        treeStep1.insertJdNode(new JdMutableTreeNode(new JdPrintFile("PrintFile1")), 4);
        JdMutableTreeNode treeConc1 = new JdMutableTreeNode(new JdConcatenatedFile("Concat1"));
        treeStep1.insertJdNode(treeConc1, 5);
        treeConc1.insertJdNode(new JdMutableTreeNode(new JdStandardFile("StdFile1")), 0);
        treeConc1.insertJdNode(new JdMutableTreeNode(new JdInputFile("Inputfile1")), 1);
        treeConc1.insertJdNode(new JdMutableTreeNode(new JdStandardFile("StdFile2")), 2);
        treeConc1.insertJdNode(new JdMutableTreeNode(new JdGdgFile("GDGFile1")), 3);
        treeJob1.insertJdNode(new JdMutableTreeNode(new JdUtilStepElement("StepUtil1")), 0);
        return treeJob1;
    }

    public static void main(String[] av) {
        JdWriterVisitor writer = new JdWriterVisitor();
        writer.doWriteFile(JdWriterVisitor.testjob(), "mtnode.ser");
        System.exit(0);
    }
}

