/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mbm.jedit.controller;

import com.sun.emp.mbm.jedit.controller.JdMediator;
import com.sun.emp.mbm.jedit.interfaces.JdIMutableTreeNode;
import com.sun.emp.mbm.util.Log;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.TreePath;

public class JdTreeExpansionListener
implements TreeExpansionListener {
    public static JdMediator m_jdMediator = null;

    public JdTreeExpansionListener(JdMediator jdMediator) {
        m_jdMediator = jdMediator;
    }

    public void treeExpanded(TreeExpansionEvent tee) {
        Log.entry((Level)Level.INFO, (Object)this, (String)"treeExpanded");
        if (tee == null) {
            System.out.println("ERROR:treeExpanded() NULL input param!");
            return;
        }
        JdIMutableTreeNode jdiMutableTreeNode = null;
        TreePath treePath = tee.getPath();
        if (null == treePath) {
            System.out.println("treePath NULL!");
            return;
        }
        try {
            jdiMutableTreeNode = (JdIMutableTreeNode)treePath.getLastPathComponent();
        }
        catch (Exception ex) {
            System.out.println("Exception in JdTreeExpansionListener::treeExpand(): Error in call to getLastPathComponent=" + ex.toString());
            return;
        }
        if (null != m_jdMediator) {
            m_jdMediator.treeExpanded(jdiMutableTreeNode);
        } else {
            System.out.println("m_jdMediator is NULL");
        }
        Log.exit((Level)Level.INFO, (Object)this, (String)"treeExpanded");
    }

    public void treeCollapsed(TreeExpansionEvent tee) {
        Log.entry((Level)Level.INFO, (Object)this, (String)"treeCollapsed");
        if (null == tee) {
            System.out.println("ERROR:treeCollapsed():NULL input param!");
            return;
        }
        Log.exit((Level)Level.INFO, (Object)this, (String)"treeCollapsed");
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("JdTreeExpansionListener Test");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        JLabel helloLabel = new JLabel("Hello!");
        helloLabel.setPreferredSize(new Dimension(175, 100));
        frame.getContentPane().add((Component)helloLabel, "Center");
        JTree jTree = new JTree();
        frame.getContentPane().add(jTree);
        frame.pack();
        frame.setVisible(true);
        jTree.addTreeExpansionListener(new JdTreeExpansionListener(null));
        JdMediator jdMediator = null;
        JdTreeExpansionListener jdTreeExpansionListener = new JdTreeExpansionListener(jdMediator);
        jdTreeExpansionListener.treeExpanded(null);
        jdTreeExpansionListener.treeCollapsed(null);
    }
}

