/*
 * Decompiled with CFR 0.152.
 */
package com.sun.emp.mbm.jedit.command;

import com.sun.emp.mbm.jedit.command.JdCommand;
import com.sun.emp.mbm.jedit.controller.JdElementFactory;
import com.sun.emp.mbm.jedit.interfaces.JdIElement;
import com.sun.emp.mbm.jedit.interfaces.JdIMutableTreeNode;
import com.sun.emp.mbm.jedit.model.JdJobFolderElement;
import com.sun.emp.mbm.jedit.model.JdMutableTreeNode;
import com.sun.emp.mbm.util.Log;
import java.util.logging.Level;

public class JdNewCommand
extends JdCommand {
    private static final String _commandName = "new";
    private static final JdElementFactory _jdElementFactory;
    private int m_jdElementType;
    private int m_position;
    private JdIMutableTreeNode m_newNode;
    private JdIMutableTreeNode m_parentNode;

    public JdNewCommand(int elementType) {
        this.m_jdElementType = elementType;
    }

    public void doIt() {
        Log.entry((Level)Level.INFO, (Object)this, (String)"doIt");
        if (null == _jdElementFactory) {
            Log.displayMessage((Object)this, (String)"doIt", (String)"_jdElementFactory is Null", (String)"E00002", (Object)"_jdElementFactory");
            return;
        }
        JdIElement jdiElement = _jdElementFactory.getJdIElement(this.m_jdElementType);
        if (null == jdiElement) {
            Log.displayMessage((Object)this, (String)"doIt", (String)"jdiElement is Null", (String)"E00002", (Object)"jdiElement");
            return;
        }
        this.m_newNode = new JdMutableTreeNode(jdiElement);
        JdIMutableTreeNode selectedNode = JdCommand._jdMediator.getSelectedNode();
        if (!selectedNode.getJdINodeElement().isNodeAdded()) {
            selectedNode.getJdINodeElement().expandNode(selectedNode);
        }
        if (null != JdCommand._jdMediator && null != this.m_newNode) {
            if (this.m_jdElementType == 0) {
                this.m_newNode.insertJdNode(new JdMutableTreeNode(new JdJobFolderElement("Loading...")), 0);
            }
            JdCommand._jdMediator.addTreeNode(this.m_newNode);
        } else {
            Log.displayMessage((Object)this, (String)"doIt", (String)"_jdMediator is Null", (String)"E00002", (Object)"_jdMediator");
        }
        Log.exit((Level)Level.INFO, (Object)this, (String)"doIt");
    }

    public void undoIt() {
        Log.entry((Level)Level.INFO, (Object)this, (String)"undoIt");
        if (null == this.m_newNode) {
            Log.displayMessage((Object)this, (String)"undoIt", (String)"selectedNode is Null", (String)"E00002", (Object)"selectedNode");
            return;
        }
        this.m_parentNode = this.m_newNode.getJdParent();
        this.m_position = this.m_newNode.getPosition();
        if (null != this.m_parentNode) {
            JdCommand._jdMediator.setEndNew();
            JdCommand._jdMediator.removeNodeFrom(this.m_parentNode, this.m_newNode);
        } else {
            Log.displayMessage((Object)this, (String)"undoIt", (String)"parentNode is Null", (String)"E00002", (Object)"parentNode");
        }
        Log.exit((Level)Level.INFO, (Object)this, (String)"undoIt");
    }

    public void redoIt() {
        Log.entry((Level)Level.INFO, (Object)this, (String)"redoIt");
        if (null != JdCommand._jdMediator) {
            JdCommand._jdMediator.insertNodeInto(this.m_newNode, this.m_parentNode, this.m_position);
        } else {
            Log.displayMessage((Object)this, (String)"redoIt", (String)"_jdMediator is Null", (String)"E00002", (Object)"_jdMediator");
        }
        JdCommand._jdMediator.setNew();
        Log.exit((Level)Level.INFO, (Object)this, (String)"redoIt");
    }

    public String canUndo() {
        return _commandName;
    }

    public String canRedo() {
        return _commandName;
    }

    public String getCommandName() {
        return new String("new ...");
    }

    public static void main(String[] args) {
    }

    static {
        _commandName = _commandName;
        _jdElementFactory = JdElementFactory.getJdElementFactory();
    }
}

