/*
 * Decompiled with CFR 0.152.
 */
package sun.comm.client;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import sun.comm.client.CLIInteractive;
import sun.comm.client.CLIValidOptions;
import sun.comm.client.Debug;

public class CLIUsage {
    static final String sccs_id = "%W% %G% SMI";
    private String objectName = null;
    private ResourceBundle res = ResourceBundle.getBundle("sun.comm.client.CLIResourceBundle", Locale.getDefault());
    private String taskName = null;
    private CLIValidOptions validOptions = null;
    public static final String VALID_OBJECT_LIST = "\"admin|domain|group|resource|user\"";
    public static final String[] VALID_COMMAND_LIST = new String[]{"admin add|remove|search", "domain create|delete|modify|search|purge", "group create|delete|modify|search", "resource create|delete|modify|search", "user create|delete|modify|search"};
    public static final String COMMAND_SPECIFIC_HELP_CMD = "commadmin <object> <task> -D <adminLogin> -w <adminPasswd> -h";

    public String getClassVersion() {
        return sccs_id;
    }

    public CLIUsage(String taskName, String objectName, CLIValidOptions validOptions) {
        this.taskName = taskName;
        this.objectName = objectName;
        this.validOptions = validOptions;
    }

    public CLIUsage(String taskName, String objectName) {
        this(taskName, objectName, null);
    }

    public CLIUsage(String taskName) {
        this(taskName, "", null);
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public CLIValidOptions getValidOptions() {
        return this.validOptions;
    }

    public void setValidOptions(CLIValidOptions validOptions) {
        this.validOptions = validOptions;
    }

    public void printGeneralUsage() {
        String msg = this.res.getString("UsageMessage") + " " + this.res.getString("Object") + " " + this.res.getString("Task") + " " + this.res.getString("UsageOptions") + "\n";
        msg = msg + this.res.getString("ValidObjectIs") + " " + VALID_OBJECT_LIST + " " + this.res.getString("AndWord") + "\n";
        msg = msg + this.res.getString("ObjectTaskCombo") + "\n";
        CLIInteractive.printResult(msg);
        for (int i = 0; i < VALID_COMMAND_LIST.length; ++i) {
            CLIInteractive.printResult(VALID_COMMAND_LIST[i]);
        }
        CLIInteractive.printResult("\n" + this.res.getString("FurtherHelp"));
        CLIInteractive.printResult(this.res.getString("RunWord") + " \"" + COMMAND_SPECIFIC_HELP_CMD + "\"");
    }

    public void printUsage(boolean std) {
        HashMap secOptMap;
        boolean oldindex = false;
        String msg = null;
        msg = this.res.getString("UsageMessage") + " " + this.objectName + " " + this.taskName + " " + this.res.getString("UsageOptions");
        if (std) {
            CLIInteractive.printResult(msg);
        } else {
            CLIInteractive.printError(msg);
        }
        this.printOptions(std, true);
        this.printOptions(std, false);
        int sOptind = this.validOptions.indexOf("S");
        if (sOptind != -1 && (secOptMap = this.validOptions.getSecOption(sOptind)) != null) {
            Iterator keys = secOptMap.keySet().iterator();
            while (keys.hasNext()) {
                String servName = (String)keys.next();
                CLIValidOptions secValidOpts = (CLIValidOptions)secOptMap.get(servName);
                Debug.println("Going to set sec valid option for " + servName);
                this.validOptions = secValidOpts;
                this.printIt(this.res.getString("UsageServiceOptions") + " " + servName, std);
                this.printOptions(std, true);
                this.printOptions(std, false);
            }
        }
    }

    private void printOptions(boolean std, boolean required) {
        String msg = null;
        msg = required ? this.res.getString("UsageWhereRequired") : this.res.getString("UsageWhereOptional");
        this.printIt(msg, std);
        String[] optionNames = this.validOptions.getNames();
        Boolean[] takesArgs = this.validOptions.getTakesArgs();
        Boolean[] requireds = this.validOptions.getRequireds();
        String[] descriptions = this.validOptions.getDescriptions();
        int longestName = 0;
        for (int i = 0; i < optionNames.length; ++i) {
            if (optionNames[i].length() <= longestName) continue;
            longestName = optionNames[i].length();
        }
        boolean atLeastOneLinePrinted = false;
        for (int i = 0; i < optionNames.length; ++i) {
            if (requireds[i] != required) continue;
            String descriptionString = null;
            String valueString = this.res.getString("UsageValue");
            try {
                descriptionString = this.res.getString(descriptions[i]);
            }
            catch (MissingResourceException e) {
                descriptionString = descriptions[i];
            }
            StringBuffer pad = new StringBuffer(" ");
            for (int j = 0; j < longestName - optionNames[i].length(); ++j) {
                pad.append(" ");
            }
            if (!takesArgs[i].booleanValue()) {
                int valueLength = this.res.getString("UsageValue").length();
                for (int j = 0; j < valueLength; ++j) {
                    pad.append(" ");
                }
                valueString = "";
            }
            msg = "  -" + optionNames[i] + " " + valueString + pad + descriptionString;
            this.printIt(msg, std);
            atLeastOneLinePrinted = true;
        }
        if (!atLeastOneLinePrinted) {
            this.printIt(this.res.getString("UsageNoneMessage"), std);
        }
    }

    private void printIt(String msg, boolean which) {
        if (which) {
            CLIInteractive.printResult(msg);
        } else {
            CLIInteractive.printError(msg);
        }
    }
}

