/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.LDAPAsynchronousConnection;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPBind;
import netscape.ldap.LDAPCache;
import netscape.ldap.LDAPCheckComm;
import netscape.ldap.LDAPConnSetupMgr;
import netscape.ldap.LDAPConnThread;
import netscape.ldap.LDAPConstraints;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPExtendedOperation;
import netscape.ldap.LDAPMessage;
import netscape.ldap.LDAPMessageQueue;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPRebind;
import netscape.ldap.LDAPRebindAuth;
import netscape.ldap.LDAPReferralException;
import netscape.ldap.LDAPResponse;
import netscape.ldap.LDAPResponseControl;
import netscape.ldap.LDAPResponseListener;
import netscape.ldap.LDAPSSLSocketFactoryExt;
import netscape.ldap.LDAPSaslBind;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchListener;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPSocketFactory;
import netscape.ldap.LDAPTraceWriter;
import netscape.ldap.LDAPUrl;
import netscape.ldap.LDAPv3;
import netscape.ldap.client.JDAPAVA;
import netscape.ldap.client.opers.JDAPAbandonRequest;
import netscape.ldap.client.opers.JDAPAddRequest;
import netscape.ldap.client.opers.JDAPBindRequest;
import netscape.ldap.client.opers.JDAPCompareRequest;
import netscape.ldap.client.opers.JDAPDeleteRequest;
import netscape.ldap.client.opers.JDAPExtendedRequest;
import netscape.ldap.client.opers.JDAPExtendedResponse;
import netscape.ldap.client.opers.JDAPModifyRDNRequest;
import netscape.ldap.client.opers.JDAPModifyRequest;
import netscape.ldap.client.opers.JDAPProtocolOp;
import netscape.ldap.client.opers.JDAPResult;
import netscape.ldap.client.opers.JDAPSearchRequest;
import netscape.ldap.client.opers.JDAPSearchResultReference;
import netscape.ldap.controls.LDAPPersistSearchControl;

public class LDAPConnection
implements LDAPv3,
LDAPAsynchronousConnection,
Cloneable,
Serializable {
    static final long serialVersionUID = -8698420087475771144L;
    public static final int LDAP_VERSION = 2;
    public static final String LDAP_PROPERTY_SDK = "version.sdk";
    public static final String LDAP_PROPERTY_PROTOCOL = "version.protocol";
    public static final String LDAP_PROPERTY_SECURITY = "version.security";
    public static final String TRACE_PROPERTY = "com.netscape.ldap.trace";
    public static final int NODELAY_SERIAL = -1;
    public static final int NODELAY_PARALLEL = 0;
    private static final String defaultFilter = "(objectClass=*)";
    private static final LDAPConstraints readConstraints = new LDAPSearchConstraints();
    private LDAPSearchConstraints m_defaultConstraints = new LDAPSearchConstraints();
    private LDAPConstraints m_rebindConstraints;
    private Vector m_responseListeners;
    private Vector m_searchListeners;
    private boolean m_bound;
    private String m_prevBoundDN;
    private String m_prevBoundPasswd;
    private String m_boundDN;
    private String m_boundPasswd;
    private int m_protocolVersion = 2;
    private LDAPConnSetupMgr m_connMgr;
    private int m_connSetupDelay = -1;
    private int m_connectTimeout = 0;
    private LDAPSocketFactory m_factory = null;
    private transient LDAPConnThread m_thread = null;
    private Vector m_attachedList = new Vector();
    private Hashtable m_responseControlTable = new Hashtable();
    private LDAPCache m_cache = null;
    static Hashtable m_threadConnTable = new Hashtable();
    private boolean m_anonymousBound = false;
    private Object m_security = null;
    private LDAPSaslBind m_saslBinder = null;
    private Properties m_securityProperties;
    private Hashtable m_properties = new Hashtable();
    private LDAPConnection m_referralConnection;
    private String m_authMethod = "none";
    private static final Float SdkVersion = new Float(4.15f);
    private static final Float ProtocolVersion = new Float(3.0f);
    private static final String SecurityVersion = new String("none,simple,sasl");
    private static final Float MajorVersion = new Float(4.0f);
    private static final Float MinorVersion = new Float(0.15f);
    private static final String DELIM = "#";
    private static final String PersistSearchPackageName = "netscape.ldap.controls.LDAPPersistSearchControl";
    static final String EXTERNAL_MECHANISM = "external";
    private static final String EXTERNAL_MECHANISM_PACKAGE = "com.netscape.sasl";
    static final String DEFAULT_SASL_PACKAGE = "com.netscape.sasl";
    static final String SCHEMA_BUG_PROPERTY = "com.netscape.ldap.schema.quoting";
    static final String SASL_PACKAGE_PROPERTY = "com.netscape.ldap.saslpackage";
    public static final int MAXBACKLOG = 30;
    private static boolean isCommunicator = LDAPConnection.checkCommunicator();
    private static boolean debug = false;

    public LDAPConnection() {
        this.m_properties.put(LDAP_PROPERTY_SDK, SdkVersion);
        this.m_properties.put(LDAP_PROPERTY_PROTOCOL, ProtocolVersion);
        this.m_properties.put(LDAP_PROPERTY_SECURITY, SecurityVersion);
        this.m_properties.put("version.major", MajorVersion);
        this.m_properties.put("version.minor", MinorVersion);
    }

    public LDAPConnection(LDAPSocketFactory lDAPSocketFactory) {
        this();
        this.m_factory = lDAPSocketFactory;
    }

    public void abandon(int n) throws LDAPException {
        if (!this.isConnected()) {
            return;
        }
        int n2 = 0;
        while (n2 < 3) {
            try {
                this.m_thread.abandon(n);
                this.m_thread.sendRequest(null, new JDAPAbandonRequest(n), null, this.m_defaultConstraints);
                break;
            }
            catch (NullPointerException nullPointerException) {
                ++n2;
            }
        }
        if (this.m_thread == null) {
            throw new LDAPException("Failed to send abandon request to the server.", 80);
        }
    }

    public void abandon(LDAPSearchListener lDAPSearchListener) throws LDAPException {
        int[] nArray = lDAPSearchListener.getMessageIDs();
        int n = 0;
        while (n < nArray.length) {
            lDAPSearchListener.removeRequest(nArray[n]);
            this.abandon(nArray[n]);
            ++n;
        }
    }

    public void abandon(LDAPSearchResults lDAPSearchResults) throws LDAPException {
        if (!this.isConnected() || lDAPSearchResults == null) {
            return;
        }
        int n = lDAPSearchResults.getMessageID();
        if (n != -1) {
            this.abandon(n);
        }
    }

    public void add(LDAPEntry lDAPEntry) throws LDAPException {
        this.add(lDAPEntry, this.m_defaultConstraints);
    }

    public void add(LDAPEntry lDAPEntry, LDAPConstraints lDAPConstraints) throws LDAPException {
        this.internalBind(lDAPConstraints);
        LDAPResponseListener lDAPResponseListener = this.getResponseListener();
        LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
        LDAPAttribute[] lDAPAttributeArray = new LDAPAttribute[lDAPAttributeSet.size()];
        int n = 0;
        while (n < lDAPAttributeSet.size()) {
            lDAPAttributeArray[n] = lDAPAttributeSet.elementAt(n);
            ++n;
        }
        boolean bl = false;
        try {
            try {
                this.sendRequest(new JDAPAddRequest(lDAPEntry.getDN(), lDAPAttributeArray), lDAPResponseListener, lDAPConstraints);
                LDAPResponse lDAPResponse = lDAPResponseListener.getResponse();
                this.checkMsg(lDAPResponse);
            }
            catch (LDAPReferralException lDAPReferralException) {
                this.performReferrals(lDAPReferralException, lDAPConstraints, 8, null, 0, null, null, false, null, lDAPEntry, null, null);
            }
            Object var10_10 = null;
            this.releaseResponseListener(lDAPResponseListener);
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.releaseResponseListener(lDAPResponseListener);
            throw throwable;
        }
    }

    public LDAPResponseListener add(LDAPEntry lDAPEntry, LDAPResponseListener lDAPResponseListener) throws LDAPException {
        return this.add(lDAPEntry, lDAPResponseListener, this.m_defaultConstraints);
    }

    public LDAPResponseListener add(LDAPEntry lDAPEntry, LDAPResponseListener lDAPResponseListener, LDAPConstraints lDAPConstraints) throws LDAPException {
        if (lDAPConstraints == null) {
            lDAPConstraints = this.m_defaultConstraints;
        }
        this.internalBind(lDAPConstraints);
        if (lDAPResponseListener == null) {
            lDAPResponseListener = new LDAPResponseListener(true);
        }
        LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
        LDAPAttribute[] lDAPAttributeArray = new LDAPAttribute[lDAPAttributeSet.size()];
        int n = 0;
        while (n < lDAPAttributeSet.size()) {
            lDAPAttributeArray[n] = lDAPAttributeSet.elementAt(n);
            ++n;
        }
        boolean bl = false;
        this.sendRequest(new JDAPAddRequest(lDAPEntry.getDN(), lDAPAttributeArray), lDAPResponseListener, lDAPConstraints);
        return lDAPResponseListener;
    }

    public void add(LDAPEntry lDAPEntry, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        this.add(lDAPEntry, (LDAPConstraints)lDAPSearchConstraints);
    }

    public void authenticate(int n, String string, String string2) throws LDAPException {
        this.authenticate(n, string, string2, this.m_defaultConstraints);
    }

    public void authenticate(int n, String string, String string2, LDAPConstraints lDAPConstraints) throws LDAPException {
        this.m_prevBoundDN = this.m_boundDN;
        this.m_prevBoundPasswd = this.m_boundPasswd;
        this.m_boundDN = string;
        this.m_boundPasswd = string2;
        this.m_anonymousBound = this.m_prevBoundDN == null || this.m_prevBoundPasswd == null;
        this.internalBind(n, true, lDAPConstraints);
    }

    public LDAPResponseListener authenticate(int n, String string, String string2, LDAPResponseListener lDAPResponseListener) throws LDAPException {
        return this.authenticate(n, string, string2, lDAPResponseListener, this.m_defaultConstraints);
    }

    public LDAPResponseListener authenticate(int n, String string, String string2, LDAPResponseListener lDAPResponseListener, LDAPConstraints lDAPConstraints) throws LDAPException {
        if (lDAPConstraints == null) {
            lDAPConstraints = this.m_defaultConstraints;
        }
        this.m_prevBoundDN = this.m_boundDN;
        this.m_prevBoundPasswd = this.m_boundPasswd;
        this.m_boundDN = string;
        this.m_boundPasswd = string2;
        this.m_protocolVersion = n;
        if (this.m_thread == null) {
            this.connect();
        } else if (this.m_thread.getClientCount() > 1) {
            this.disconnect();
            this.connect();
        }
        if (lDAPResponseListener == null) {
            lDAPResponseListener = new LDAPResponseListener(true);
        }
        this.sendRequest(new JDAPBindRequest(n, this.m_boundDN, this.m_boundPasswd), lDAPResponseListener, lDAPConstraints);
        return lDAPResponseListener;
    }

    public void authenticate(int n, String string, String string2, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        this.authenticate(n, string, string2, (LDAPConstraints)lDAPSearchConstraints);
    }

    public void authenticate(String string, String string2) throws LDAPException {
        this.authenticate(this.m_protocolVersion, string, string2, this.m_defaultConstraints);
    }

    public void authenticate(String string, String string2, String string3, Hashtable hashtable, Object object) throws LDAPException {
        this.authenticate(string, new String[]{string2}, string3, hashtable, object);
    }

    public void authenticate(String string, String string2, LDAPConstraints lDAPConstraints) throws LDAPException {
        this.authenticate(this.m_protocolVersion, string, string2, lDAPConstraints);
    }

    public void authenticate(String string, String string2, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        this.authenticate(string, string2, (LDAPConstraints)lDAPSearchConstraints);
    }

    public void authenticate(String string, Hashtable hashtable, Object object) throws LDAPException {
        String[] stringArray;
        LDAPEntry lDAPEntry;
        LDAPAttribute lDAPAttribute;
        if (!this.isConnected()) {
            this.connect();
        }
        if ((lDAPAttribute = (lDAPEntry = this.read("", stringArray = new String[]{"supportedSaslMechanisms"})).getAttribute(stringArray[0])) == null) {
            throw new LDAPException("Not found in root DSE: " + stringArray[0], 16);
        }
        this.authenticate(string, lDAPAttribute.getStringValueArray(), hashtable, object);
    }

    public void authenticate(String string, String[] stringArray, String string2, Hashtable hashtable, Object object) throws LDAPException {
        if (!this.isConnected()) {
            this.connect();
        } else if (this.m_thread.getClientCount() > 1) {
            this.disconnect();
            this.connect();
        }
        this.m_boundDN = null;
        this.m_protocolVersion = 3;
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        this.m_saslBinder = new LDAPSaslBind(string, stringArray, string2, hashtable, object);
        this.m_saslBinder.bind(this);
        this.m_authMethod = "sasl";
        this.m_boundDN = string;
    }

    public void authenticate(String string, String[] stringArray, Hashtable hashtable, Object object) throws LDAPException {
        this.authenticate(string, stringArray, "com.netscape.sasl", hashtable, object);
    }

    private void authenticateSSLConnection() throws LDAPException {
        if (this.m_factory != null && this.m_factory instanceof LDAPSSLSocketFactoryExt && ((LDAPSSLSocketFactoryExt)this.m_factory).isClientAuth()) {
            this.authenticate(null, EXTERNAL_MECHANISM, "com.netscape.sasl", null, null);
        }
    }

    public void bind(int n, String string, String string2) throws LDAPException {
        this.authenticate(n, string, string2, this.m_defaultConstraints);
    }

    public void bind(int n, String string, String string2, LDAPConstraints lDAPConstraints) throws LDAPException {
        this.authenticate(n, string, string2, lDAPConstraints);
    }

    public LDAPResponseListener bind(int n, String string, String string2, LDAPResponseListener lDAPResponseListener) throws LDAPException {
        return this.bind(n, string, string2, lDAPResponseListener, this.m_defaultConstraints);
    }

    public LDAPResponseListener bind(int n, String string, String string2, LDAPResponseListener lDAPResponseListener, LDAPConstraints lDAPConstraints) throws LDAPException {
        return this.authenticate(n, string, string2, lDAPResponseListener, lDAPConstraints);
    }

    public void bind(String string, String string2) throws LDAPException {
        this.authenticate(this.m_protocolVersion, string, string2, this.m_defaultConstraints);
    }

    public void bind(String string, String string2, LDAPConstraints lDAPConstraints) throws LDAPException {
        this.authenticate(this.m_protocolVersion, string, string2, lDAPConstraints);
    }

    public LDAPResponseListener bind(String string, String string2, LDAPResponseListener lDAPResponseListener) throws LDAPException {
        return this.bind(this.m_protocolVersion, string, string2, lDAPResponseListener, this.m_defaultConstraints);
    }

    public LDAPResponseListener bind(String string, String string2, LDAPResponseListener lDAPResponseListener, LDAPConstraints lDAPConstraints) throws LDAPException {
        return this.bind(this.m_protocolVersion, string, string2, lDAPResponseListener, lDAPConstraints);
    }

    public void bind(String string, Hashtable hashtable, Object object) throws LDAPException {
        this.authenticate(string, hashtable, object);
    }

    public void bind(String string, String[] stringArray, Hashtable hashtable, Object object) throws LDAPException {
        this.authenticate(string, stringArray, hashtable, object);
    }

    private static boolean checkCommunicator() {
        try {
            Method method = LDAPCheckComm.getMethod("netscape.security.PrivilegeManager", "enablePrivilege");
            if (method == null) {
                LDAPConnection.printDebug("Method is null");
                return false;
            }
            Object[] objectArray = new Object[]{new String("UniversalConnect")};
            method.invoke(null, objectArray);
            LDAPConnection.printDebug("UniversalConnect enabled");
            objectArray[0] = new String("UniversalPropertyRead");
            method.invoke(null, objectArray);
            LDAPConnection.printDebug("UniversalPropertyRead enabled");
            return true;
        }
        catch (LDAPException lDAPException) {
            LDAPConnection.printDebug("Exception: " + lDAPException.toString());
        }
        catch (Exception exception) {
            LDAPConnection.printDebug("Exception on invoking enablePrivilege: " + exception.toString());
        }
        return false;
    }

    void checkMsg(LDAPMessage lDAPMessage) throws LDAPException {
        if (lDAPMessage.getProtocolOp() instanceof JDAPResult) {
            JDAPResult jDAPResult = (JDAPResult)((Object)lDAPMessage.getProtocolOp());
            int n = jDAPResult.getResultCode();
            if (n == 0) {
                return;
            }
            if (n == 10) {
                throw new LDAPReferralException("referral", n, jDAPResult.getReferrals());
            }
            if (n == 9) {
                throw new LDAPReferralException("referral", n, jDAPResult.getErrorMessage());
            }
            throw new LDAPException("error result", n, jDAPResult.getErrorMessage(), jDAPResult.getMatchedDN());
        }
        if (lDAPMessage.getProtocolOp() instanceof JDAPSearchResultReference) {
            String[] stringArray = ((JDAPSearchResultReference)lDAPMessage.getProtocolOp()).getUrls();
            throw new LDAPReferralException("referral", 0, stringArray);
        }
    }

    /*
     * Unable to fully structure code
     */
    void checkSearchMsg(LDAPSearchResults var1_1, LDAPMessage var2_2, LDAPSearchConstraints var3_3, String var4_4, int var5_5, String var6_6, String[] var7_7, boolean var8_8) throws LDAPException {
        block9: {
            var1_1.setMsgID(var2_2.getMessageID());
            try {
                this.checkMsg(var2_2);
                if (var2_2.getProtocolOp().getType() != 5) {
                    var1_1.add(var2_2);
                }
            }
            catch (LDAPReferralException var9_9) {
                var10_11 = new Vector<E>();
                try {
                    this.performReferrals(var9_9, (LDAPConstraints)var3_3, 3, var4_4, var5_5, var6_6, var7_7, var8_8, null, null, null, var10_11);
                }
                catch (LDAPException var11_12) {
                    if (var2_2.getProtocolOp() instanceof JDAPSearchResultReference) {
                        return;
                    }
                    throw var11_12;
                }
                var11_13 = 0;
                ** while (var11_13 < var10_11.size())
            }
lbl-1000:
            // 1 sources

            {
                var1_1.addReferralEntries((LDAPSearchResults)var10_11.elementAt(var11_13));
                ++var11_13;
                continue;
            }
lbl21:
            // 1 sources

            var10_11 = null;
            break block9;
            catch (LDAPException var9_10) {
                if (var9_10.getLDAPResultCode() == 11 || var9_10.getLDAPResultCode() == 3 || var9_10.getLDAPResultCode() == 4) {
                    var1_1.add(var9_10);
                }
                throw var9_10;
            }
        }
    }

    public synchronized Object clone() {
        try {
            LDAPConnection lDAPConnection = (LDAPConnection)super.clone();
            if (!this.isConnected()) {
                this.internalBind(this.m_defaultConstraints);
            }
            lDAPConnection.m_defaultConstraints = (LDAPSearchConstraints)this.m_defaultConstraints.clone();
            lDAPConnection.m_responseListeners = null;
            lDAPConnection.m_searchListeners = null;
            lDAPConnection.m_bound = this.m_bound;
            lDAPConnection.m_connMgr = this.m_connMgr;
            lDAPConnection.m_connSetupDelay = this.m_connSetupDelay;
            lDAPConnection.m_boundDN = this.m_boundDN;
            lDAPConnection.m_boundPasswd = this.m_boundPasswd;
            lDAPConnection.m_prevBoundDN = this.m_prevBoundDN;
            lDAPConnection.m_prevBoundPasswd = this.m_prevBoundPasswd;
            lDAPConnection.m_anonymousBound = this.m_anonymousBound;
            lDAPConnection.setCache(this.m_cache);
            lDAPConnection.m_factory = this.m_factory;
            lDAPConnection.m_thread = this.m_thread;
            Hashtable hashtable = m_threadConnTable;
            synchronized (hashtable) {
                Vector vector = (Vector)m_threadConnTable.get(this.m_thread);
                if (vector == null) {
                    LDAPConnection.printDebug("Failed to clone");
                    Object var2_4 = null;
                    Object var4_5 = null;
                    return var2_4;
                }
                vector.addElement(lDAPConnection);
            }
            lDAPConnection.m_thread.register(lDAPConnection);
            return lDAPConnection;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean compare(String string, LDAPAttribute lDAPAttribute) throws LDAPException {
        return this.compare(string, lDAPAttribute, this.m_defaultConstraints);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean compare(String string, LDAPAttribute lDAPAttribute, LDAPConstraints lDAPConstraints) throws LDAPException {
        LDAPResponseListener lDAPResponseListener;
        block8: {
            boolean bl;
            block7: {
                this.internalBind(lDAPConstraints);
                lDAPResponseListener = this.getResponseListener();
                Enumeration enumeration = lDAPAttribute.getStringValues();
                String string2 = (String)enumeration.nextElement();
                JDAPAVA jDAPAVA = new JDAPAVA(lDAPAttribute.getName(), string2);
                try {
                    try {
                        this.sendRequest(new JDAPCompareRequest(string, jDAPAVA), lDAPResponseListener, lDAPConstraints);
                        LDAPResponse lDAPResponse = lDAPResponseListener.getResponse();
                        int n = ((JDAPResult)((Object)lDAPResponse.getProtocolOp())).getResultCode();
                        if (n == 5) {
                            boolean bl2 = false;
                            Object var11_14 = null;
                            this.releaseResponseListener(lDAPResponseListener);
                            return bl2;
                        }
                        if (n == 6) {
                            bl = true;
                            break block7;
                        }
                        this.checkMsg(lDAPResponse);
                        break block8;
                    }
                    catch (LDAPReferralException lDAPReferralException) {
                        Vector vector = new Vector();
                        this.performReferrals(lDAPReferralException, lDAPConstraints, 14, string, 0, null, null, false, null, null, lDAPAttribute, vector);
                        boolean bl3 = false;
                        if (vector.size() > 0) {
                            bl3 = (Boolean)vector.elementAt(0);
                        }
                        boolean bl4 = bl3;
                        Object var11_16 = null;
                        this.releaseResponseListener(lDAPResponseListener);
                        return bl4;
                    }
                }
                catch (Throwable throwable) {
                    Object var11_18 = null;
                    this.releaseResponseListener(lDAPResponseListener);
                    throw throwable;
                }
            }
            Object var11_15 = null;
            this.releaseResponseListener(lDAPResponseListener);
            return bl;
        }
        Object var11_17 = null;
        this.releaseResponseListener(lDAPResponseListener);
        return false;
    }

    public LDAPResponseListener compare(String string, LDAPAttribute lDAPAttribute, LDAPResponseListener lDAPResponseListener) throws LDAPException {
        return this.compare(string, lDAPAttribute, lDAPResponseListener, this.m_defaultConstraints);
    }

    public LDAPResponseListener compare(String string, LDAPAttribute lDAPAttribute, LDAPResponseListener lDAPResponseListener, LDAPConstraints lDAPConstraints) throws LDAPException {
        if (lDAPConstraints == null) {
            lDAPConstraints = this.m_defaultConstraints;
        }
        this.internalBind(lDAPConstraints);
        if (lDAPResponseListener == null) {
            lDAPResponseListener = new LDAPResponseListener(true);
        }
        Enumeration enumeration = lDAPAttribute.getStringValues();
        String string2 = (String)enumeration.nextElement();
        JDAPAVA jDAPAVA = new JDAPAVA(lDAPAttribute.getName(), string2);
        this.sendRequest(new JDAPCompareRequest(string, jDAPAVA), lDAPResponseListener, lDAPConstraints);
        return lDAPResponseListener;
    }

    public boolean compare(String string, LDAPAttribute lDAPAttribute, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        return this.compare(string, lDAPAttribute, (LDAPConstraints)lDAPSearchConstraints);
    }

    private synchronized void connect() throws LDAPException {
        if (this.isConnected()) {
            return;
        }
        if (this.m_connMgr == null) {
            throw new LDAPException("no connection parameters", 89);
        }
        this.m_connMgr.openConnection();
        this.m_thread = this.getNewThread(this.m_connMgr, this.m_cache);
        this.authenticateSSLConnection();
    }

    public void connect(int n, String string, int n2, String string2, String string3) throws LDAPException {
        this.connect(n, string, n2, string2, string3, this.m_defaultConstraints);
    }

    public void connect(int n, String string, int n2, String string2, String string3, LDAPConstraints lDAPConstraints) throws LDAPException {
        this.setProtocolVersion(n);
        this.connect(string, n2, string2, string3, lDAPConstraints);
    }

    public void connect(int n, String string, int n2, String string2, String string3, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        this.connect(n, string, n2, string2, string3, (LDAPConstraints)lDAPSearchConstraints);
    }

    public void connect(String string, int n) throws LDAPException {
        this.connect(string, n, null, null, this.m_defaultConstraints, false);
    }

    public void connect(String string, int n, String string2, String string3) throws LDAPException {
        this.connect(string, n, string2, string3, this.m_defaultConstraints, true);
    }

    public void connect(String string, int n, String string2, String string3, LDAPConstraints lDAPConstraints) throws LDAPException {
        this.connect(string, n, string2, string3, lDAPConstraints, true);
    }

    private void connect(String string, int n, String string2, String string3, LDAPConstraints lDAPConstraints, boolean bl) throws LDAPException {
        if (this.isConnected()) {
            this.disconnect();
        }
        if (string == null || string.equals("")) {
            throw new LDAPException("no host for connection", 89);
        }
        int n2 = n;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int[] nArray = new int[stringTokenizer.countTokens()];
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            int n4 = string4.indexOf(58);
            if (n4 > 0) {
                stringArray[n3] = string4.substring(0, n4);
                nArray[n3] = Integer.parseInt(string4.substring(n4 + 1));
            } else {
                stringArray[n3] = string4;
                nArray[n3] = n2;
            }
            ++n3;
        }
        this.m_connMgr = new LDAPConnSetupMgr(stringArray, nArray, this.m_factory);
        this.m_connMgr.setConnSetupDelay(this.m_connSetupDelay);
        this.m_connMgr.setConnectTimeout(this.m_connectTimeout);
        this.connect();
        if (bl) {
            this.authenticate(string2, string3, lDAPConstraints);
        }
    }

    public void connect(String string, int n, String string2, String string3, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        this.connect(string, n, string2, string3, (LDAPConstraints)lDAPSearchConstraints);
    }

    private String createReferralConnectList(LDAPUrl[] lDAPUrlArray) {
        String string = "";
        String string2 = null;
        int n = 0;
        int n2 = 0;
        while (lDAPUrlArray != null && n2 < lDAPUrlArray.length) {
            string2 = lDAPUrlArray[n2].getHost();
            n = lDAPUrlArray[n2].getPort();
            if (string2 == null || string2.length() < 1) {
                string2 = this.getHost();
                n = this.getPort();
            }
            string = String.valueOf(string) + (n2 == 0 ? "" : " ") + string2 + ":" + n;
            ++n2;
        }
        return string.length() == 0 ? null : string;
    }

    LDAPConnection createReferralConnection(LDAPReferralException lDAPReferralException, LDAPConstraints lDAPConstraints) throws LDAPException {
        if (lDAPConstraints.getHopLimit() <= 0) {
            throw new LDAPException("exceed hop limit", lDAPReferralException.getLDAPResultCode(), lDAPReferralException.getLDAPErrorMessage());
        }
        if (!lDAPConstraints.getReferrals()) {
            throw lDAPReferralException;
        }
        String string = this.createReferralConnectList(lDAPReferralException.getURLs());
        if (string == null) {
            throw new LDAPException("No target URL in referral", 94);
        }
        LDAPConnection lDAPConnection = null;
        lDAPConnection = this.prepareReferral(string, lDAPConstraints);
        try {
            lDAPConnection.authenticate(this.m_protocolVersion, this.m_boundDN, this.m_boundPasswd);
        }
        catch (LDAPException lDAPException) {
            try {
                lDAPConnection.disconnect();
            }
            catch (LDAPException lDAPException2) {}
            throw lDAPException;
        }
        return lDAPConnection;
    }

    Object createTraceOutput(Object object) throws LDAPException {
        if (object instanceof String) {
            FilterOutputStream filterOutputStream = null;
            String string = (String)object;
            if (string.length() == 0) {
                filterOutputStream = System.err;
            } else {
                try {
                    boolean bl;
                    boolean bl2 = bl = string.charAt(0) == '+';
                    if (bl) {
                        string = string.substring(1);
                    }
                    FileOutputStream fileOutputStream = new FileOutputStream(string, bl);
                    filterOutputStream = new BufferedOutputStream(fileOutputStream);
                }
                catch (IOException iOException) {
                    throw new LDAPException("Can not open output trace file " + string + " " + iOException);
                }
            }
            return filterOutputStream;
        }
        if (object instanceof OutputStream) {
            return object;
        }
        if (object instanceof LDAPTraceWriter) {
            return object;
        }
        throw new LDAPException("com.netscape.ldap.trace must be an OutputStream, a file name or an instance of LDAPTraceWriter");
    }

    public void delete(String string) throws LDAPException {
        this.delete(string, this.m_defaultConstraints);
    }

    public void delete(String string, LDAPConstraints lDAPConstraints) throws LDAPException {
        this.internalBind(lDAPConstraints);
        LDAPResponseListener lDAPResponseListener = this.getResponseListener();
        try {
            try {
                this.sendRequest(new JDAPDeleteRequest(string), lDAPResponseListener, lDAPConstraints);
                LDAPResponse lDAPResponse = lDAPResponseListener.getResponse();
                this.checkMsg(lDAPResponse);
            }
            catch (LDAPReferralException lDAPReferralException) {
                this.performReferrals(lDAPReferralException, lDAPConstraints, 10, string, 0, null, null, false, null, null, null, null);
            }
            Object var6_6 = null;
            this.releaseResponseListener(lDAPResponseListener);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.releaseResponseListener(lDAPResponseListener);
            throw throwable;
        }
    }

    public LDAPResponseListener delete(String string, LDAPResponseListener lDAPResponseListener) throws LDAPException {
        return this.delete(string, lDAPResponseListener, this.m_defaultConstraints);
    }

    public LDAPResponseListener delete(String string, LDAPResponseListener lDAPResponseListener, LDAPConstraints lDAPConstraints) throws LDAPException {
        if (lDAPConstraints == null) {
            lDAPConstraints = this.m_defaultConstraints;
        }
        this.internalBind(lDAPConstraints);
        if (lDAPResponseListener == null) {
            lDAPResponseListener = new LDAPResponseListener(true);
        }
        this.sendRequest(new JDAPDeleteRequest(string), lDAPResponseListener, lDAPConstraints);
        return lDAPResponseListener;
    }

    public void delete(String string, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        this.delete(string, (LDAPConstraints)lDAPSearchConstraints);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deleteThreadConnEntry() {
        Hashtable hashtable = m_threadConnTable;
        synchronized (hashtable) {
            LDAPConnection lDAPConnection;
            Vector vector = (Vector)m_threadConnTable.get(this.m_thread);
            if (vector == null) {
                LDAPConnection.printDebug("Thread table does not contain the thread of this object");
                return;
            }
            Enumeration enumeration = vector.elements();
            do {
                if (enumeration.hasMoreElements()) continue;
                return;
            } while (!(lDAPConnection = (LDAPConnection)enumeration.nextElement()).equals(this));
            vector.removeElement(lDAPConnection);
            if (vector.size() != 0) return;
            m_threadConnTable.remove(this.m_thread);
            return;
        }
    }

    synchronized void deregisterConnection() {
        if (this.m_thread != null) {
            this.deleteThreadConnEntry();
            if (this.m_thread.isRunning()) {
                this.m_thread.deregister(this);
            }
        }
        this.m_thread = null;
        this.m_bound = false;
    }

    public synchronized void disconnect() throws LDAPException {
        if (!this.isConnected()) {
            return;
        }
        if (this.m_thread.isRunning() && this.m_thread.getClientCount() > 1) {
            this.m_connMgr = (LDAPConnSetupMgr)this.m_connMgr.clone();
            this.m_connMgr.disconnect();
        }
        if (this.m_referralConnection != null && this.m_referralConnection.isConnected()) {
            this.m_referralConnection.disconnect();
        }
        this.m_referralConnection = null;
        if (this.m_cache != null) {
            this.m_cache.removeReference();
            this.m_cache = null;
        }
        this.deregisterConnection();
    }

    public LDAPExtendedOperation extendedOperation(LDAPExtendedOperation lDAPExtendedOperation) throws LDAPException {
        return this.extendedOperation(lDAPExtendedOperation, this.m_defaultConstraints);
    }

    public LDAPExtendedOperation extendedOperation(LDAPExtendedOperation lDAPExtendedOperation, LDAPConstraints lDAPConstraints) throws LDAPException {
        String string;
        this.internalBind(lDAPConstraints);
        LDAPResponseListener lDAPResponseListener = this.getResponseListener();
        LDAPResponse lDAPResponse = null;
        byte[] byArray = null;
        try {
            try {
                this.sendRequest(new JDAPExtendedRequest(lDAPExtendedOperation.getID(), lDAPExtendedOperation.getValue()), lDAPResponseListener, lDAPConstraints);
                lDAPResponse = lDAPResponseListener.getResponse();
                this.checkMsg(lDAPResponse);
                JDAPExtendedResponse jDAPExtendedResponse = (JDAPExtendedResponse)lDAPResponse.getProtocolOp();
                byArray = jDAPExtendedResponse.getValue();
                string = jDAPExtendedResponse.getID();
            }
            catch (LDAPReferralException lDAPReferralException) {
                LDAPExtendedOperation lDAPExtendedOperation2 = this.performExtendedReferrals(lDAPReferralException, lDAPConstraints, lDAPExtendedOperation);
                Object var9_10 = null;
                this.releaseResponseListener(lDAPResponseListener);
                return lDAPExtendedOperation2;
            }
            Object var9_11 = null;
            this.releaseResponseListener(lDAPResponseListener);
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            this.releaseResponseListener(lDAPResponseListener);
            throw throwable;
        }
        return new LDAPExtendedOperation(string, byArray);
    }

    public LDAPExtendedOperation extendedOperation(LDAPExtendedOperation lDAPExtendedOperation, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        return this.extendedOperation(lDAPExtendedOperation, (LDAPConstraints)lDAPSearchConstraints);
    }

    public void finalize() throws LDAPException {
        if (this.isConnected()) {
            this.disconnect();
        }
    }

    private LDAPUrl findReferralURL(LDAPConnection lDAPConnection, LDAPUrl[] lDAPUrlArray) {
        String string = lDAPConnection.getHost();
        int n = lDAPConnection.getPort();
        int n2 = 0;
        while (n2 < lDAPUrlArray.length) {
            if (lDAPUrlArray[n2].getHost() == null || lDAPUrlArray[n2].getHost().length() < 1 ? string.equals(this.getHost()) && n == this.getPort() : string.equals(lDAPUrlArray[n2].getHost()) && n == lDAPUrlArray[n2].getPort()) {
                return lDAPUrlArray[n2];
            }
            ++n2;
        }
        return null;
    }

    public String getAuthenticationDN() {
        return this.m_boundDN;
    }

    public String getAuthenticationMethod() {
        return this.isConnected() ? this.m_authMethod : "none";
    }

    public String getAuthenticationPassword() {
        return this.m_boundPasswd;
    }

    public LDAPCache getCache() {
        return this.m_cache;
    }

    public int getConnSetupDelay() {
        return this.m_connSetupDelay;
    }

    public int getConnectTimeout() {
        return this.m_connectTimeout;
    }

    public LDAPConstraints getConstraints() {
        return this.getSearchConstraints();
    }

    public String getHost() {
        if (this.m_connMgr != null) {
            return this.m_connMgr.getHost();
        }
        return null;
    }

    public InputStream getInputStream() {
        return this.m_thread != null ? this.m_thread.getInputStream() : null;
    }

    private synchronized LDAPConnThread getNewThread(LDAPConnSetupMgr lDAPConnSetupMgr, LDAPCache lDAPCache) throws LDAPException {
        LDAPConnThread lDAPConnThread = null;
        Vector vector = null;
        Hashtable hashtable = m_threadConnTable;
        synchronized (hashtable) {
            Object object;
            Enumeration enumeration = m_threadConnTable.keys();
            boolean bl = false;
            while (enumeration.hasMoreElements()) {
                LDAPConnThread lDAPConnThread2 = (LDAPConnThread)enumeration.nextElement();
                Vector vector2 = (Vector)m_threadConnTable.get(lDAPConnThread2);
                object = vector2.elements();
                while (object.hasMoreElements()) {
                    LDAPConnection lDAPConnection = (LDAPConnection)object.nextElement();
                    if (!lDAPConnection.equals(this)) continue;
                    bl = true;
                    if (lDAPConnThread2.isRunning()) break;
                    try {
                        lDAPConnThread = new LDAPConnThread(lDAPConnSetupMgr, lDAPCache, this.getTraceOutput());
                        vector = (Vector)m_threadConnTable.remove(lDAPConnThread2);
                        break;
                    }
                    catch (Exception exception) {
                        throw new LDAPException("unable to establish connection", 52);
                    }
                }
                if (bl) break;
            }
            if (!bl) {
                try {
                    lDAPConnThread = new LDAPConnThread(lDAPConnSetupMgr, lDAPCache, this.getTraceOutput());
                    vector = new Vector();
                    vector.addElement(this);
                }
                catch (Exception exception) {
                    throw new LDAPException("unable to establish connection", 52);
                }
            }
            if (lDAPConnThread != null) {
                m_threadConnTable.put(lDAPConnThread, vector);
                int n = 0;
                int n2 = vector.size();
                while (n < n2) {
                    object = (LDAPConnection)vector.elementAt(n);
                    lDAPConnThread.register((LDAPConnection)object);
                    ((LDAPConnection)object).m_thread = lDAPConnThread;
                    ++n;
                }
            }
        }
        return lDAPConnThread;
    }

    public Object getOption(int n) throws LDAPException {
        if (n == 17) {
            return new Integer(this.m_protocolVersion);
        }
        return LDAPConnection.getOption(n, this.m_defaultConstraints);
    }

    private static Object getOption(int n, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        switch (n) {
            case 2: {
                return new Integer(lDAPSearchConstraints.getDereference());
            }
            case 3: {
                return new Integer(lDAPSearchConstraints.getMaxResults());
            }
            case 4: {
                return new Integer(lDAPSearchConstraints.getServerTimeLimit());
            }
            case 8: {
                return new Boolean(lDAPSearchConstraints.getReferrals());
            }
            case 9: {
                return lDAPSearchConstraints.getRebindProc();
            }
            case 13: {
                return lDAPSearchConstraints.getBindProc();
            }
            case 10: {
                return new Integer(lDAPSearchConstraints.getHopLimit());
            }
            case 20: {
                return new Integer(lDAPSearchConstraints.getBatchSize());
            }
            case 11: {
                return lDAPSearchConstraints.getClientControls();
            }
            case 12: {
                return lDAPSearchConstraints.getServerControls();
            }
            case 30: {
                return new Integer(lDAPSearchConstraints.getMaxBacklog());
            }
        }
        throw new LDAPException("invalid option", 89);
    }

    public OutputStream getOutputStream() {
        return this.m_thread != null ? this.m_thread.getOutputStream() : null;
    }

    public int getPort() {
        if (this.m_connMgr != null) {
            return this.m_connMgr.getPort();
        }
        return -1;
    }

    public Object getProperty(String string) throws LDAPException {
        return this.m_properties.get(string);
    }

    public LDAPControl[] getResponseControls() {
        LDAPControl[] lDAPControlArray = null;
        Hashtable hashtable = this.m_responseControlTable;
        synchronized (hashtable) {
            Vector vector = (Vector)this.m_responseControlTable.get(this.m_thread);
            if (vector != null) {
                int n = 0;
                int n2 = vector.size();
                while (n < n2) {
                    LDAPResponseControl lDAPResponseControl = (LDAPResponseControl)vector.elementAt(n);
                    if (lDAPResponseControl.getConnection().equals(this)) {
                        lDAPControlArray = lDAPResponseControl.getControls();
                        vector.removeElementAt(n);
                        break;
                    }
                    ++n;
                }
            }
        }
        return lDAPControlArray;
    }

    LDAPControl[] getResponseControls(int n) {
        LDAPControl[] lDAPControlArray = null;
        Hashtable hashtable = this.m_responseControlTable;
        synchronized (hashtable) {
            Vector vector = (Vector)this.m_responseControlTable.get(this.m_thread);
            if (vector != null) {
                int n2 = 0;
                int n3 = vector.size();
                while (n2 < n3) {
                    LDAPResponseControl lDAPResponseControl = (LDAPResponseControl)vector.elementAt(n2);
                    if (lDAPResponseControl.getMsgID() == n) {
                        lDAPControlArray = lDAPResponseControl.getControls();
                        vector.removeElementAt(n2);
                        break;
                    }
                    ++n2;
                }
            }
        }
        return lDAPControlArray;
    }

    synchronized LDAPResponseListener getResponseListener() {
        LDAPResponseListener lDAPResponseListener;
        if (this.m_responseListeners == null) {
            this.m_responseListeners = new Vector(5);
        }
        if (this.m_responseListeners.size() < 1) {
            lDAPResponseListener = new LDAPResponseListener(false);
        } else {
            lDAPResponseListener = (LDAPResponseListener)this.m_responseListeners.elementAt(0);
            this.m_responseListeners.removeElementAt(0);
        }
        return lDAPResponseListener;
    }

    public LDAPSearchConstraints getSearchConstraints() {
        return (LDAPSearchConstraints)this.m_defaultConstraints.clone();
    }

    private synchronized LDAPSearchListener getSearchListener(LDAPSearchConstraints lDAPSearchConstraints) {
        LDAPSearchListener lDAPSearchListener;
        if (this.m_searchListeners == null) {
            this.m_searchListeners = new Vector(5);
        }
        if (this.m_searchListeners.size() < 1) {
            lDAPSearchListener = new LDAPSearchListener(false, lDAPSearchConstraints);
        } else {
            lDAPSearchListener = (LDAPSearchListener)this.m_searchListeners.elementAt(0);
            this.m_searchListeners.removeElementAt(0);
            lDAPSearchListener.setSearchConstraints(lDAPSearchConstraints);
        }
        return lDAPSearchListener;
    }

    public LDAPSocketFactory getSocketFactory() {
        return this.m_factory;
    }

    Object getTraceOutput() throws LDAPException {
        Object object = this.m_properties.get(TRACE_PROPERTY);
        if (object != null) {
            return this.createTraceOutput(object);
        }
        try {
            object = System.getProperty(TRACE_PROPERTY);
            if (object != null) {
                return this.createTraceOutput(object);
            }
        }
        catch (Exception exception) {}
        return null;
    }

    private void internalBind(int n, boolean bl, LDAPConstraints lDAPConstraints) throws LDAPException {
        this.m_saslBinder = null;
        if (!this.isConnected()) {
            this.m_bound = false;
            this.m_authMethod = "none";
            this.connect();
        } else if (!this.m_bound && bl && this.m_thread.getClientCount() > 1) {
            this.disconnect();
            this.connect();
        }
        if (this.m_bound && !bl) {
            return;
        }
        if (!(this.m_anonymousBound || this.m_boundDN != null && this.m_boundPasswd != null || bl)) {
            return;
        }
        if (this.m_bound && bl) {
            if (this.m_protocolVersion == n) {
                if (this.m_anonymousBound && (this.m_boundDN == null || this.m_boundPasswd == null)) {
                    return;
                }
                if (!this.m_anonymousBound && this.m_boundDN != null && this.m_boundPasswd != null && this.m_boundDN.equals(this.m_prevBoundDN) && this.m_boundPasswd.equals(this.m_prevBoundPasswd)) {
                    return;
                }
            }
            if (this.m_thread.getClientCount() > 1) {
                this.disconnect();
                this.connect();
            }
        }
        this.m_protocolVersion = n;
        LDAPResponseListener lDAPResponseListener = this.getResponseListener();
        try {
            try {
                if (this.m_referralConnection != null && this.m_referralConnection.isConnected()) {
                    this.m_referralConnection.disconnect();
                }
                this.m_referralConnection = null;
                this.m_bound = false;
                this.sendRequest(new JDAPBindRequest(this.m_protocolVersion, this.m_boundDN, this.m_boundPasswd), lDAPResponseListener, lDAPConstraints);
                this.checkMsg(lDAPResponseListener.getResponse());
                this.markConnAsBound();
                this.m_rebindConstraints = (LDAPConstraints)lDAPConstraints.clone();
                this.m_authMethod = "simple";
            }
            catch (LDAPReferralException lDAPReferralException) {
                this.m_referralConnection = this.createReferralConnection(lDAPReferralException, lDAPConstraints);
            }
            Object var6_6 = null;
            this.releaseResponseListener(lDAPResponseListener);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.releaseResponseListener(lDAPResponseListener);
            throw throwable;
        }
    }

    private void internalBind(LDAPConstraints lDAPConstraints) throws LDAPException {
        if (this.m_connMgr != null && this.m_connMgr.isUserDisconnected()) {
            throw new LDAPException("not connected", 80);
        }
        if (this.m_saslBinder != null) {
            if (!this.isConnected()) {
                this.connect();
            }
            this.m_saslBinder.bind(this, false);
            this.m_authMethod = "sasl";
        } else {
            if (this.m_rebindConstraints == null) {
                this.m_rebindConstraints = this.m_defaultConstraints;
            }
            this.internalBind(this.m_protocolVersion, false, this.m_rebindConstraints);
        }
    }

    public boolean isAuthenticated() {
        if (this.m_bound && (this.m_boundDN == null || this.m_boundDN.equals("") || this.m_boundPasswd == null || this.m_boundPasswd.equals(""))) {
            return false;
        }
        return this.m_bound;
    }

    public boolean isConnected() {
        LDAPConnection lDAPConnection = this;
        synchronized (lDAPConnection) {
            if (this.m_thread != null && this.m_thread.isRunning()) {
                boolean bl = true;
                Object var3_3 = null;
                return bl;
            }
        }
        if (this.m_thread != null) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
            Thread.yield();
        }
        return false;
    }

    public static boolean isNetscape() {
        return isCommunicator;
    }

    public static void main(String[] stringArray) {
        System.out.println("LDAP SDK Version is " + SdkVersion);
        System.out.println("LDAP Protocol Version is " + ProtocolVersion);
    }

    void markConnAsBound() {
        Hashtable hashtable = m_threadConnTable;
        synchronized (hashtable) {
            if (m_threadConnTable.containsKey(this.m_thread)) {
                Vector vector = (Vector)m_threadConnTable.get(this.m_thread);
                int n = 0;
                int n2 = vector.size();
                while (n < n2) {
                    LDAPConnection lDAPConnection = (LDAPConnection)vector.elementAt(n);
                    lDAPConnection.m_bound = true;
                    ++n;
                }
            } else {
                LDAPConnection.printDebug("Thread table does not contain the thread of this object");
            }
        }
    }

    public void modify(String string, LDAPModification lDAPModification) throws LDAPException {
        this.modify(string, lDAPModification, this.m_defaultConstraints);
    }

    public void modify(String string, LDAPModification lDAPModification, LDAPConstraints lDAPConstraints) throws LDAPException {
        LDAPModification[] lDAPModificationArray = new LDAPModification[]{lDAPModification};
        this.modify(string, lDAPModificationArray, lDAPConstraints);
    }

    public LDAPResponseListener modify(String string, LDAPModification lDAPModification, LDAPResponseListener lDAPResponseListener) throws LDAPException {
        return this.modify(string, lDAPModification, lDAPResponseListener, (LDAPConstraints)this.m_defaultConstraints);
    }

    public LDAPResponseListener modify(String string, LDAPModification lDAPModification, LDAPResponseListener lDAPResponseListener, LDAPConstraints lDAPConstraints) throws LDAPException {
        if (lDAPConstraints == null) {
            lDAPConstraints = this.m_defaultConstraints;
        }
        this.internalBind(lDAPConstraints);
        if (lDAPResponseListener == null) {
            lDAPResponseListener = new LDAPResponseListener(true);
        }
        LDAPModification[] lDAPModificationArray = new LDAPModification[]{lDAPModification};
        this.sendRequest(new JDAPModifyRequest(string, lDAPModificationArray), lDAPResponseListener, lDAPConstraints);
        return lDAPResponseListener;
    }

    public void modify(String string, LDAPModification lDAPModification, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        this.modify(string, lDAPModification, (LDAPConstraints)lDAPSearchConstraints);
    }

    public void modify(String string, LDAPModificationSet lDAPModificationSet) throws LDAPException {
        this.modify(string, lDAPModificationSet, this.m_defaultConstraints);
    }

    public void modify(String string, LDAPModificationSet lDAPModificationSet, LDAPConstraints lDAPConstraints) throws LDAPException {
        LDAPModification[] lDAPModificationArray = new LDAPModification[lDAPModificationSet.size()];
        int n = 0;
        while (n < lDAPModificationSet.size()) {
            lDAPModificationArray[n] = lDAPModificationSet.elementAt(n);
            ++n;
        }
        this.modify(string, lDAPModificationArray, lDAPConstraints);
    }

    public LDAPResponseListener modify(String string, LDAPModificationSet lDAPModificationSet, LDAPResponseListener lDAPResponseListener) throws LDAPException {
        return this.modify(string, lDAPModificationSet, lDAPResponseListener, (LDAPConstraints)this.m_defaultConstraints);
    }

    public LDAPResponseListener modify(String string, LDAPModificationSet lDAPModificationSet, LDAPResponseListener lDAPResponseListener, LDAPConstraints lDAPConstraints) throws LDAPException {
        if (lDAPConstraints == null) {
            lDAPConstraints = this.m_defaultConstraints;
        }
        this.internalBind(lDAPConstraints);
        if (lDAPResponseListener == null) {
            lDAPResponseListener = new LDAPResponseListener(true);
        }
        LDAPModification[] lDAPModificationArray = new LDAPModification[lDAPModificationSet.size()];
        int n = 0;
        while (n < lDAPModificationSet.size()) {
            lDAPModificationArray[n] = lDAPModificationSet.elementAt(n);
            ++n;
        }
        this.sendRequest(new JDAPModifyRequest(string, lDAPModificationArray), lDAPResponseListener, lDAPConstraints);
        return lDAPResponseListener;
    }

    public void modify(String string, LDAPModificationSet lDAPModificationSet, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        this.modify(string, lDAPModificationSet, (LDAPConstraints)lDAPSearchConstraints);
    }

    public void modify(String string, LDAPModification[] lDAPModificationArray) throws LDAPException {
        this.modify(string, lDAPModificationArray, this.m_defaultConstraints);
    }

    public void modify(String string, LDAPModification[] lDAPModificationArray, LDAPConstraints lDAPConstraints) throws LDAPException {
        this.internalBind(lDAPConstraints);
        LDAPResponseListener lDAPResponseListener = this.getResponseListener();
        LDAPResponse lDAPResponse = null;
        try {
            try {
                this.sendRequest(new JDAPModifyRequest(string, lDAPModificationArray), lDAPResponseListener, lDAPConstraints);
                lDAPResponse = lDAPResponseListener.getResponse();
                this.checkMsg(lDAPResponse);
            }
            catch (LDAPReferralException lDAPReferralException) {
                this.performReferrals(lDAPReferralException, lDAPConstraints, 6, string, 0, null, null, false, lDAPModificationArray, null, null, null);
            }
            Object var7_7 = null;
            this.releaseResponseListener(lDAPResponseListener);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.releaseResponseListener(lDAPResponseListener);
            throw throwable;
        }
    }

    public void modify(String string, LDAPModification[] lDAPModificationArray, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        this.modify(string, lDAPModificationArray, (LDAPConstraints)lDAPSearchConstraints);
    }

    private LDAPExtendedOperation performExtendedReferrals(LDAPReferralException lDAPReferralException, LDAPConstraints lDAPConstraints, LDAPExtendedOperation lDAPExtendedOperation) throws LDAPException {
        if (lDAPConstraints.getHopLimit() <= 0) {
            throw new LDAPException("exceed hop limit", lDAPReferralException.getLDAPResultCode(), lDAPReferralException.getLDAPErrorMessage());
        }
        if (!lDAPConstraints.getReferrals()) {
            throw lDAPReferralException;
        }
        LDAPUrl[] lDAPUrlArray = lDAPReferralException.getURLs();
        if (lDAPUrlArray == null || lDAPUrlArray.length == 0) {
            return null;
        }
        String string = this.createReferralConnectList(lDAPUrlArray);
        LDAPConnection lDAPConnection = this.prepareReferral(string, lDAPConstraints);
        this.referralRebind(lDAPConnection, lDAPConstraints);
        LDAPExtendedOperation lDAPExtendedOperation2 = lDAPConnection.extendedOperation(lDAPExtendedOperation);
        lDAPConnection.disconnect();
        return lDAPExtendedOperation2;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void performReferrals(LDAPConnection lDAPConnection, LDAPConstraints lDAPConstraints, int n, String string, int n2, String string2, String[] stringArray, boolean bl, LDAPModification[] lDAPModificationArray, LDAPEntry lDAPEntry, LDAPAttribute lDAPAttribute, Vector vector) throws LDAPException {
        LDAPSearchResults lDAPSearchResults = null;
        try {
            switch (n) {
                case 3: {
                    lDAPSearchResults = lDAPConnection.search(string, n2, string2, stringArray, bl, (LDAPSearchConstraints)lDAPConstraints);
                    if (lDAPSearchResults != null) {
                        lDAPSearchResults.closeOnCompletion(lDAPConnection);
                        vector.addElement(lDAPSearchResults);
                        return;
                    }
                    if (this.m_referralConnection != null) {
                        if (lDAPConnection.equals(this.m_referralConnection)) return;
                    }
                    lDAPConnection.disconnect();
                    return;
                }
                case 6: {
                    lDAPConnection.modify(string, lDAPModificationArray, lDAPConstraints);
                    return;
                }
                case 8: {
                    if (string != null && !string.equals("")) {
                        lDAPEntry.setDN(string);
                    }
                    lDAPConnection.add(lDAPEntry, lDAPConstraints);
                    return;
                }
                case 10: {
                    lDAPConnection.delete(string, lDAPConstraints);
                    return;
                }
                case 12: {
                    lDAPConnection.rename(string, string2, bl, lDAPConstraints);
                    return;
                }
                case 14: {
                    boolean bl2 = lDAPConnection.compare(string, lDAPAttribute, lDAPConstraints);
                    vector.addElement(new Boolean(bl2));
                    return;
                }
                default: {
                    return;
                }
            }
        }
        finally {
            Object var15_16 = null;
            if (!(lDAPConnection == null || n == 3 && lDAPSearchResults != null || this.m_referralConnection != null && lDAPConnection.equals(this.m_referralConnection))) {
                lDAPConnection.disconnect();
            }
        }
    }

    void performReferrals(LDAPReferralException lDAPReferralException, LDAPConstraints lDAPConstraints, int n, String string, int n2, String string2, String[] stringArray, boolean bl, LDAPModification[] lDAPModificationArray, LDAPEntry lDAPEntry, LDAPAttribute lDAPAttribute, Vector vector) throws LDAPException {
        String string3;
        if (lDAPConstraints.getHopLimit() <= 0) {
            throw new LDAPException("exceed hop limit", lDAPReferralException.getLDAPResultCode(), lDAPReferralException.getLDAPErrorMessage());
        }
        if (!lDAPConstraints.getReferrals()) {
            if (n == 3) {
                LDAPSearchResults lDAPSearchResults = new LDAPSearchResults();
                lDAPSearchResults.add(lDAPReferralException);
                vector.addElement(lDAPSearchResults);
                return;
            }
            throw lDAPReferralException;
        }
        LDAPUrl[] lDAPUrlArray = lDAPReferralException.getURLs();
        if (lDAPUrlArray == null || lDAPUrlArray.length == 0) {
            return;
        }
        LDAPUrl lDAPUrl = null;
        LDAPConnection lDAPConnection = null;
        if (this.m_referralConnection != null && this.m_referralConnection.isConnected()) {
            lDAPUrl = this.findReferralURL(this.m_referralConnection, lDAPUrlArray);
        }
        if (lDAPUrl != null) {
            lDAPConnection = this.m_referralConnection;
        } else {
            string3 = this.createReferralConnectList(lDAPUrlArray);
            lDAPConnection = this.prepareReferral(string3, lDAPConstraints);
            lDAPUrl = this.findReferralURL(lDAPConnection, lDAPUrlArray);
            this.referralRebind(lDAPConnection, lDAPConstraints);
        }
        string3 = lDAPUrl.getDN();
        String string4 = null;
        string4 = string3 == null || string3.equals("") ? string : string3;
        if (lDAPUrl.getUrl().indexOf("?base") > -1) {
            n2 = 0;
        }
        LDAPSearchConstraints lDAPSearchConstraints = (LDAPSearchConstraints)lDAPConstraints.clone();
        lDAPSearchConstraints.setHopLimit(lDAPConstraints.getHopLimit() - 1);
        this.performReferrals(lDAPConnection, (LDAPConstraints)lDAPSearchConstraints, n, string4, n2, string2, stringArray, bl, lDAPModificationArray, lDAPEntry, lDAPAttribute, vector);
    }

    private LDAPConnection prepareReferral(String string, LDAPConstraints lDAPConstraints) throws LDAPException {
        LDAPConnection lDAPConnection = new LDAPConnection(this.getSocketFactory());
        lDAPConnection.setConnSetupDelay(this.getConnSetupDelay());
        lDAPConnection.setOption(8, new Boolean(true));
        lDAPConnection.setOption(9, lDAPConstraints.getRebindProc());
        lDAPConnection.setOption(13, lDAPConstraints.getBindProc());
        lDAPConnection.setOption(17, new Integer(this.m_protocolVersion));
        lDAPConnection.setOption(10, new Integer(lDAPConstraints.getHopLimit() - 1));
        try {
            lDAPConnection.connect(string, 389);
        }
        catch (LDAPException lDAPException) {
            throw new LDAPException("Referral connect failed: " + lDAPException.getMessage(), lDAPException.getLDAPResultCode());
        }
        return lDAPConnection;
    }

    static void printDebug(String string) {
        if (debug) {
            System.out.println(string);
        }
    }

    public LDAPEntry read(String string) throws LDAPException {
        return this.read(string, null, this.m_defaultConstraints);
    }

    public LDAPEntry read(String string, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        return this.read(string, null, lDAPSearchConstraints);
    }

    public LDAPEntry read(String string, String[] stringArray) throws LDAPException {
        return this.read(string, stringArray, this.m_defaultConstraints);
    }

    public LDAPEntry read(String string, String[] stringArray, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        LDAPSearchResults lDAPSearchResults = this.search(string, 0, "(|(objectclass=*)(objectclass=ldapsubentry))", stringArray, false, lDAPSearchConstraints);
        if (lDAPSearchResults == null) {
            return null;
        }
        LDAPEntry lDAPEntry = lDAPSearchResults.next();
        while (lDAPSearchResults.hasMoreElements()) {
            lDAPSearchResults.nextElement();
        }
        return lDAPEntry;
    }

    public static LDAPEntry read(LDAPUrl lDAPUrl) throws LDAPException {
        String string = lDAPUrl.getHost();
        int n = lDAPUrl.getPort();
        if (string == null) {
            throw new LDAPException("no host for connection", 89);
        }
        String[] stringArray = lDAPUrl.getAttributeArray();
        String string2 = lDAPUrl.getDN();
        LDAPConnection lDAPConnection = new LDAPConnection();
        if (lDAPUrl.isSecure()) {
            LDAPSocketFactory lDAPSocketFactory = LDAPUrl.getSocketFactory();
            if (lDAPSocketFactory == null) {
                throw new LDAPException("No socket factory for LDAPUrl", 80);
            }
            lDAPConnection.setSocketFactory(lDAPSocketFactory);
        }
        lDAPConnection.connect(string, n);
        LDAPEntry lDAPEntry = lDAPConnection.read(string2, stringArray);
        lDAPConnection.disconnect();
        return lDAPEntry;
    }

    public void reconnect() throws LDAPException {
        this.disconnect();
        this.connect();
        if (this.m_saslBinder != null) {
            this.m_saslBinder.bind(this, true);
            this.m_authMethod = "sasl";
        } else {
            this.internalBind(this.m_protocolVersion, true, this.m_defaultConstraints);
        }
    }

    private void referralRebind(LDAPConnection lDAPConnection, LDAPConstraints lDAPConstraints) throws LDAPException {
        try {
            if (lDAPConstraints.getRebindProc() == null && lDAPConstraints.getBindProc() == null) {
                lDAPConnection.authenticate(this.m_protocolVersion, null, null);
            } else if (lDAPConstraints.getBindProc() == null) {
                LDAPRebindAuth lDAPRebindAuth = lDAPConstraints.getRebindProc().getRebindAuthentication(lDAPConnection.getHost(), lDAPConnection.getPort());
                lDAPConnection.authenticate(this.m_protocolVersion, lDAPRebindAuth.getDN(), lDAPRebindAuth.getPassword());
            } else {
                lDAPConstraints.getBindProc().bind(lDAPConnection);
            }
        }
        catch (LDAPException lDAPException) {
            throw new LDAPException("Referral bind failed: " + lDAPException.getMessage(), lDAPException.getLDAPResultCode());
        }
    }

    synchronized void releaseResponseListener(LDAPResponseListener lDAPResponseListener) {
        if (this.m_responseListeners == null) {
            this.m_responseListeners = new Vector(5);
        }
        lDAPResponseListener.reset();
        this.m_responseListeners.addElement(lDAPResponseListener);
    }

    synchronized void releaseSearchListener(LDAPSearchListener lDAPSearchListener) {
        if (this.m_searchListeners == null) {
            this.m_searchListeners = new Vector(5);
        }
        lDAPSearchListener.reset();
        this.m_searchListeners.addElement(lDAPSearchListener);
    }

    public void rename(String string, String string2, String string3, boolean bl) throws LDAPException {
        this.rename(string, string2, string3, bl, this.m_defaultConstraints);
    }

    public void rename(String string, String string2, String string3, boolean bl, LDAPConstraints lDAPConstraints) throws LDAPException {
        this.internalBind(lDAPConstraints);
        LDAPResponseListener lDAPResponseListener = this.getResponseListener();
        try {
            try {
                JDAPModifyRDNRequest jDAPModifyRDNRequest = null;
                jDAPModifyRDNRequest = string3 != null ? new JDAPModifyRDNRequest(string, string2, bl, string3) : new JDAPModifyRDNRequest(string, string2, bl);
                this.sendRequest(jDAPModifyRDNRequest, lDAPResponseListener, lDAPConstraints);
                LDAPResponse lDAPResponse = lDAPResponseListener.getResponse();
                this.checkMsg(lDAPResponse);
            }
            catch (LDAPReferralException lDAPReferralException) {
                this.performReferrals(lDAPReferralException, lDAPConstraints, 12, string, 0, string2, null, bl, null, null, null, null);
            }
            Object var8_10 = null;
            this.releaseResponseListener(lDAPResponseListener);
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            this.releaseResponseListener(lDAPResponseListener);
            throw throwable;
        }
    }

    public void rename(String string, String string2, String string3, boolean bl, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        this.rename(string, string2, string3, bl, (LDAPConstraints)lDAPSearchConstraints);
    }

    public void rename(String string, String string2, boolean bl) throws LDAPException {
        this.rename(string, string2, null, bl);
    }

    public void rename(String string, String string2, boolean bl, LDAPConstraints lDAPConstraints) throws LDAPException {
        this.rename(string, string2, null, bl, lDAPConstraints);
    }

    public LDAPResponseListener rename(String string, String string2, boolean bl, LDAPResponseListener lDAPResponseListener) throws LDAPException {
        return this.rename(string, string2, bl, lDAPResponseListener, (LDAPConstraints)this.m_defaultConstraints);
    }

    public LDAPResponseListener rename(String string, String string2, boolean bl, LDAPResponseListener lDAPResponseListener, LDAPConstraints lDAPConstraints) throws LDAPException {
        if (lDAPConstraints == null) {
            lDAPConstraints = this.m_defaultConstraints;
        }
        this.internalBind(lDAPConstraints);
        if (lDAPResponseListener == null) {
            lDAPResponseListener = new LDAPResponseListener(true);
        }
        this.sendRequest(new JDAPModifyRDNRequest(string, string2, bl), lDAPResponseListener, lDAPConstraints);
        return lDAPResponseListener;
    }

    public void rename(String string, String string2, boolean bl, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        this.rename(string, string2, bl, (LDAPConstraints)lDAPSearchConstraints);
    }

    public LDAPSearchResults search(String string, int n, String string2, String[] stringArray, boolean bl) throws LDAPException {
        return this.search(string, n, string2, stringArray, bl, this.m_defaultConstraints);
    }

    public LDAPSearchResults search(String string, int n, String string2, String[] stringArray, boolean bl, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        if (lDAPSearchConstraints == null) {
            lDAPSearchConstraints = this.m_defaultConstraints;
        }
        LDAPSearchResults lDAPSearchResults = new LDAPSearchResults(this, lDAPSearchConstraints, string, n, string2, stringArray, bl);
        Vector vector = null;
        Long l = null;
        boolean bl2 = true;
        try {
            if (this.m_cache != null && (vector = (Vector)this.m_cache.getEntry(l = this.m_cache.createKey(this.getHost(), this.getPort(), string, string2, n, stringArray, this.m_boundDN, lDAPSearchConstraints))) != null) {
                return new LDAPSearchResults(vector, this, lDAPSearchConstraints, string, n, string2, stringArray, bl);
            }
        }
        catch (LDAPException lDAPException) {
            bl2 = false;
            LDAPConnection.printDebug("Exception: " + lDAPException);
        }
        this.internalBind(lDAPSearchConstraints);
        LDAPSearchListener lDAPSearchListener = this.getSearchListener(lDAPSearchConstraints);
        int n2 = lDAPSearchConstraints.getDereference();
        JDAPSearchRequest jDAPSearchRequest = null;
        try {
            jDAPSearchRequest = new JDAPSearchRequest(string, n, n2, lDAPSearchConstraints.getMaxResults(), lDAPSearchConstraints.getServerTimeLimit(), bl, string2, stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new LDAPException(illegalArgumentException.getMessage(), 89);
        }
        if (this.m_cache != null && bl2) {
            lDAPSearchListener.setKey(l);
        }
        try {
            this.sendRequest(jDAPSearchRequest, lDAPSearchListener, lDAPSearchConstraints);
        }
        catch (LDAPException lDAPException) {
            this.releaseSearchListener(lDAPSearchListener);
            throw lDAPException;
        }
        boolean bl3 = false;
        LDAPControl[] lDAPControlArray = (LDAPControl[])LDAPConnection.getOption(12, lDAPSearchConstraints);
        int n3 = 0;
        while (lDAPControlArray != null && n3 < lDAPControlArray.length) {
            if (lDAPControlArray[n3] instanceof LDAPPersistSearchControl) {
                bl3 = true;
                break;
            }
            ++n3;
        }
        if (bl3) {
            lDAPSearchResults.associatePersistentSearch(lDAPSearchListener);
        } else {
            if (lDAPSearchConstraints.getBatchSize() == 0) {
                try {
                    LDAPResponse lDAPResponse = lDAPSearchListener.completeSearchOperation();
                    Enumeration enumeration = lDAPSearchListener.getAllMessages().elements();
                    this.checkSearchMsg(lDAPSearchResults, lDAPResponse, lDAPSearchConstraints, string, n, string2, stringArray, bl);
                    while (enumeration.hasMoreElements()) {
                        LDAPMessage lDAPMessage = (LDAPMessage)enumeration.nextElement();
                        this.checkSearchMsg(lDAPSearchResults, lDAPMessage, lDAPSearchConstraints, string, n, string2, stringArray, bl);
                    }
                }
                finally {
                    Object var18_25 = null;
                    this.releaseSearchListener(lDAPSearchListener);
                }
            }
            LDAPMessage lDAPMessage = lDAPSearchListener.nextMessage();
            if (lDAPMessage instanceof LDAPResponse) {
                try {
                    this.checkSearchMsg(lDAPSearchResults, lDAPMessage, lDAPSearchConstraints, string, n, string2, stringArray, bl);
                }
                finally {
                    Object var19_21 = null;
                    this.releaseSearchListener(lDAPSearchListener);
                }
            }
            try {
                this.checkSearchMsg(lDAPSearchResults, lDAPMessage, lDAPSearchConstraints, string, n, string2, stringArray, bl);
            }
            catch (LDAPException lDAPException) {
                this.releaseSearchListener(lDAPSearchListener);
                throw lDAPException;
            }
            lDAPSearchResults.associate(lDAPSearchListener);
        }
        return lDAPSearchResults;
    }

    public LDAPSearchListener search(String string, int n, String string2, String[] stringArray, boolean bl, LDAPSearchListener lDAPSearchListener) throws LDAPException {
        return this.search(string, n, string2, stringArray, bl, lDAPSearchListener, this.m_defaultConstraints);
    }

    public LDAPSearchListener search(String string, int n, String string2, String[] stringArray, boolean bl, LDAPSearchListener lDAPSearchListener, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        if (lDAPSearchConstraints == null) {
            lDAPSearchConstraints = this.m_defaultConstraints;
        }
        this.internalBind(lDAPSearchConstraints);
        if (lDAPSearchListener == null) {
            lDAPSearchListener = new LDAPSearchListener(true, lDAPSearchConstraints);
        }
        JDAPSearchRequest jDAPSearchRequest = null;
        try {
            jDAPSearchRequest = new JDAPSearchRequest(string, n, lDAPSearchConstraints.getDereference(), lDAPSearchConstraints.getMaxResults(), lDAPSearchConstraints.getServerTimeLimit(), bl, string2, stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new LDAPException(illegalArgumentException.getMessage(), 89);
        }
        this.sendRequest(jDAPSearchRequest, lDAPSearchListener, lDAPSearchConstraints);
        return lDAPSearchListener;
    }

    public static LDAPSearchResults search(LDAPUrl lDAPUrl) throws LDAPException {
        return LDAPConnection.search(lDAPUrl, null);
    }

    public static LDAPSearchResults search(LDAPUrl lDAPUrl, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        Object object;
        String string = lDAPUrl.getHost();
        int n = lDAPUrl.getPort();
        if (string == null) {
            throw new LDAPException("no host for connection", 89);
        }
        String[] stringArray = lDAPUrl.getAttributeArray();
        String string2 = lDAPUrl.getDN();
        String string3 = lDAPUrl.getFilter();
        if (string3 == null) {
            string3 = defaultFilter;
        }
        int n2 = lDAPUrl.getScope();
        LDAPConnection lDAPConnection = new LDAPConnection();
        if (lDAPUrl.isSecure()) {
            object = LDAPUrl.getSocketFactory();
            if (object == null) {
                throw new LDAPException("No socket factory for LDAPUrl", 80);
            }
            lDAPConnection.setSocketFactory((LDAPSocketFactory)object);
        }
        lDAPConnection.connect(string, n);
        object = lDAPSearchConstraints != null ? lDAPConnection.search(string2, n2, string3, stringArray, false, lDAPSearchConstraints) : lDAPConnection.search(string2, n2, string3, stringArray, false);
        ((LDAPSearchResults)object).closeOnCompletion(lDAPConnection);
        return object;
    }

    void sendRequest(JDAPProtocolOp jDAPProtocolOp, LDAPMessageQueue lDAPMessageQueue, LDAPConstraints lDAPConstraints) throws LDAPException {
        boolean bl = false;
        int n = 0;
        while (!bl && n < 3) {
            try {
                this.m_thread.sendRequest(this, jDAPProtocolOp, lDAPMessageQueue, lDAPConstraints);
                bl = true;
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new LDAPException(illegalArgumentException.getMessage(), 89);
            }
            ++n;
        }
        if (!this.isConnected()) {
            throw new LDAPException("The connection is not available", 80);
        }
        if (!bl) {
            throw new LDAPException("Failed to send request", 80);
        }
    }

    public void setCache(LDAPCache lDAPCache) {
        if (this.m_cache != null) {
            this.m_cache.removeReference();
        }
        if (lDAPCache != null) {
            lDAPCache.addReference();
        }
        this.m_cache = lDAPCache;
        if (this.m_thread != null) {
            this.m_thread.setCache(lDAPCache);
        }
    }

    public void setConnSetupDelay(int n) {
        this.m_connSetupDelay = n;
        if (this.m_connMgr != null) {
            this.m_connMgr.setConnSetupDelay(n);
        }
    }

    public void setConnectTimeout(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Timeout value can not be negative");
        }
        this.m_connectTimeout = n;
        if (this.m_connMgr != null) {
            this.m_connMgr.setConnectTimeout(this.m_connectTimeout);
        }
    }

    public void setConstraints(LDAPConstraints lDAPConstraints) {
        this.m_defaultConstraints.setHopLimit(lDAPConstraints.getHopLimit());
        this.m_defaultConstraints.setReferrals(lDAPConstraints.getReferrals());
        this.m_defaultConstraints.setTimeLimit(lDAPConstraints.getTimeLimit());
        this.m_defaultConstraints.setBindProc(lDAPConstraints.getBindProc());
        this.m_defaultConstraints.setRebindProc(lDAPConstraints.getRebindProc());
        LDAPControl[] lDAPControlArray = lDAPConstraints.getClientControls();
        LDAPControl[] lDAPControlArray2 = null;
        if (lDAPControlArray != null && lDAPControlArray.length > 0) {
            lDAPControlArray2 = new LDAPControl[lDAPControlArray.length];
            int n = 0;
            while (n < lDAPControlArray.length) {
                lDAPControlArray2[n] = (LDAPControl)lDAPControlArray[n].clone();
                ++n;
            }
        }
        this.m_defaultConstraints.setClientControls(lDAPControlArray2);
        LDAPControl[] lDAPControlArray3 = lDAPConstraints.getServerControls();
        LDAPControl[] lDAPControlArray4 = null;
        if (lDAPControlArray3 != null && lDAPControlArray3.length > 0) {
            lDAPControlArray4 = new LDAPControl[lDAPControlArray3.length];
            int n = 0;
            while (n < lDAPControlArray3.length) {
                lDAPControlArray4[n] = (LDAPControl)lDAPControlArray3[n].clone();
                ++n;
            }
        }
        this.m_defaultConstraints.setServerControls(lDAPControlArray4);
    }

    public void setInputStream(InputStream inputStream) {
        if (this.m_thread != null) {
            this.m_thread.setInputStream(inputStream);
        }
    }

    public void setOption(int n, Object object) throws LDAPException {
        if (n == 17) {
            this.setProtocolVersion((Integer)object);
            return;
        }
        LDAPConnection.setOption(n, object, this.m_defaultConstraints);
    }

    private static void setOption(int n, Object object, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        try {
            switch (n) {
                case 2: {
                    lDAPSearchConstraints.setDereference((Integer)object);
                    return;
                }
                case 3: {
                    lDAPSearchConstraints.setMaxResults((Integer)object);
                    return;
                }
                case 4: {
                    lDAPSearchConstraints.setTimeLimit((Integer)object);
                    return;
                }
                case 5: {
                    lDAPSearchConstraints.setServerTimeLimit((Integer)object);
                    return;
                }
                case 8: {
                    lDAPSearchConstraints.setReferrals((Boolean)object);
                    return;
                }
                case 13: {
                    lDAPSearchConstraints.setBindProc((LDAPBind)object);
                    return;
                }
                case 9: {
                    lDAPSearchConstraints.setRebindProc((LDAPRebind)object);
                    return;
                }
                case 10: {
                    lDAPSearchConstraints.setHopLimit((Integer)object);
                    return;
                }
                case 20: {
                    lDAPSearchConstraints.setBatchSize((Integer)object);
                    return;
                }
                case 11: {
                    if (object == null) {
                        lDAPSearchConstraints.setClientControls((LDAPControl[])null);
                    } else if (object instanceof LDAPControl) {
                        lDAPSearchConstraints.setClientControls((LDAPControl)object);
                    } else if (object instanceof LDAPControl[]) {
                        lDAPSearchConstraints.setClientControls((LDAPControl[])object);
                    } else {
                        throw new LDAPException("invalid LDAPControl", 89);
                    }
                    return;
                }
                case 12: {
                    if (object == null) {
                        lDAPSearchConstraints.setServerControls((LDAPControl[])null);
                    } else if (object instanceof LDAPControl) {
                        lDAPSearchConstraints.setServerControls((LDAPControl)object);
                    } else if (object instanceof LDAPControl[]) {
                        lDAPSearchConstraints.setServerControls((LDAPControl[])object);
                    } else {
                        throw new LDAPException("invalid LDAPControl", 89);
                    }
                    return;
                }
                case 30: {
                    lDAPSearchConstraints.setMaxBacklog((Integer)object);
                    return;
                }
            }
            throw new LDAPException("invalid option", 89);
        }
        catch (ClassCastException classCastException) {
            throw new LDAPException("invalid option value", 89);
        }
    }

    public void setOutputStream(OutputStream outputStream) {
        if (this.m_thread != null) {
            this.m_thread.setOutputStream(outputStream);
        }
    }

    public void setProperty(String string, Object object) throws LDAPException {
        if (string.equalsIgnoreCase(SCHEMA_BUG_PROPERTY)) {
            this.m_properties.put(SCHEMA_BUG_PROPERTY, object);
        } else if (string.equalsIgnoreCase(SASL_PACKAGE_PROPERTY)) {
            this.m_properties.put(SASL_PACKAGE_PROPERTY, object);
        } else if (string.equalsIgnoreCase("debug")) {
            debug = ((String)object).equalsIgnoreCase("true");
        } else if (string.equalsIgnoreCase(TRACE_PROPERTY)) {
            Object object2 = null;
            if (object == null) {
                this.m_properties.remove(TRACE_PROPERTY);
            } else {
                if (this.m_thread != null) {
                    object2 = this.createTraceOutput(object);
                }
                this.m_properties.put(TRACE_PROPERTY, object);
            }
            if (this.m_thread != null) {
                this.m_thread.setTraceOutput(object2);
            }
        } else if (string.equalsIgnoreCase("breakConnection")) {
            this.m_connMgr.breakConnection();
        } else {
            throw new LDAPException("Unknown property: " + string);
        }
    }

    private void setProtocolVersion(int n) {
        this.m_protocolVersion = n;
    }

    void setResponseControls(LDAPConnThread lDAPConnThread, LDAPResponseControl lDAPResponseControl) {
        Hashtable hashtable = this.m_responseControlTable;
        synchronized (hashtable) {
            Object object;
            Vector<LDAPResponseControl> vector = (Vector<LDAPResponseControl>)this.m_responseControlTable.get(lDAPConnThread);
            if (vector != null && vector.size() > 0) {
                int n = vector.size() - 1;
                while (n >= 0) {
                    object = (LDAPResponseControl)vector.elementAt(n);
                    if (((LDAPResponseControl)object).getConnection().equals(this) && (lDAPResponseControl == null || lDAPResponseControl.getMsgID() != ((LDAPResponseControl)object).getMsgID())) {
                        vector.removeElement(object);
                    }
                    --n;
                }
            } else if (lDAPResponseControl != null) {
                vector = new Vector<LDAPResponseControl>();
            }
            if (lDAPResponseControl != null) {
                vector.addElement(lDAPResponseControl);
                this.m_responseControlTable.put(lDAPConnThread, vector);
            }
            Enumeration enumeration = this.m_attachedList.elements();
            while (enumeration.hasMoreElements()) {
                object = (LDAPConnThread)enumeration.nextElement();
                if (((LDAPConnThread)object).isRunning()) continue;
                this.m_responseControlTable.remove(object);
                this.m_attachedList.removeElement(object);
            }
        }
        if (this.m_attachedList.indexOf(lDAPConnThread) < 0) {
            this.m_attachedList.addElement(lDAPConnThread);
        }
    }

    public void setSearchConstraints(LDAPSearchConstraints lDAPSearchConstraints) {
        this.m_defaultConstraints = (LDAPSearchConstraints)lDAPSearchConstraints.clone();
    }

    public void setSocketFactory(LDAPSocketFactory lDAPSocketFactory) {
        this.m_factory = lDAPSocketFactory;
    }

    public String toString() {
        int n = this.m_thread == null ? 0 : this.m_thread.getClientCount();
        StringBuffer stringBuffer = new StringBuffer("LDAPConnection {");
        stringBuffer.append(this.m_factory == null ? "ldap" : "ldaps");
        stringBuffer.append("://");
        stringBuffer.append(this.getHost());
        stringBuffer.append(":");
        stringBuffer.append(this.getPort());
        if (n > 1) {
            stringBuffer.append(" (");
            stringBuffer.append(n);
            stringBuffer.append(")");
        }
        stringBuffer.append(" ldapVersion:");
        stringBuffer.append(this.m_protocolVersion);
        stringBuffer.append(" bindDN:\"");
        if (this.getAuthenticationDN() != null) {
            stringBuffer.append(this.getAuthenticationDN());
        }
        stringBuffer.append("\"}");
        return stringBuffer.toString();
    }
}

