/*
 * Decompiled with CFR 0.152.
 */
package sun.comm.dirmig;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPModificationSet;
import sun.comm.dirmig.commAttribute;
import sun.comm.dirmig.commConfig;
import sun.comm.dirmig.commConfigEntry;
import sun.comm.dirmig.commConstants;
import sun.comm.dirmig.commDomainEntry;

public class commEntry {
    protected LDAPEntry myLDAPEntry;
    protected LDAPModificationSet myModSet;
    protected String objectType = null;

    public commEntry(LDAPEntry myLDAPEntry) {
        this.myLDAPEntry = myLDAPEntry;
    }

    public commEntry() {
        this.myLDAPEntry = null;
        this.myModSet = null;
    }

    public commEntry(LDAPAttributeSet theAttributeSet, String theDn) {
        this.myLDAPEntry = new LDAPEntry(theDn, theAttributeSet);
    }

    public commEntry(commConfigEntry theConfigEntry, commDomainEntry theDomain, Map theValueMap) throws Exception {
        this.setNewEntry(theConfigEntry, theDomain, theValueMap);
    }

    public commEntry(commConfigEntry theConfigEntry, commDomainEntry theDomain) throws Exception {
        this.setNewEntry(theConfigEntry, theDomain, null);
    }

    public void prepareForMigration(Vector servicesToAdd, Vector migAttrSet, commDomainEntry theDomainEntry) {
        try {
            this.removeExistingAttributes(migAttrSet, theDomainEntry);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public LDAPModificationSet getModificationSet() {
        return this.myModSet;
    }

    public Map getValueMap() {
        return null;
    }

    public String getModLdif() throws Exception {
        return commEntry.LdapModificationSetToLdif(this.myModSet, this.myLDAPEntry.getDN());
    }

    public String getAddLdif() throws Exception {
        return null;
    }

    public Vector getCurrentServices() {
        LDAPAttribute objAttr = this.myLDAPEntry.getAttribute("objectclass");
        String[] values = objAttr.getStringValueArray();
        Vector<String> servicesToAdd = new Vector<String>();
        String mailMarkerClass = commConfig.getMarkerClass(this.objectType, "Mail", "S1");
        String calMarkerClass = commConfig.getMarkerClass(this.objectType, "Calendar", "S1");
        for (int i = 0; i < values.length; ++i) {
            if (values[i].equalsIgnoreCase(mailMarkerClass)) {
                servicesToAdd.add("Mail");
            }
            if (!values[i].equalsIgnoreCase(calMarkerClass)) continue;
            servicesToAdd.add("Calendar");
        }
        return servicesToAdd;
    }

    private boolean checkPresence(LDAPAttribute attr) {
        LDAPAttributeSet myAttrSet = this.myLDAPEntry.getAttributeSet();
        Enumeration myAttrs = myAttrSet.getAttributes();
        while (myAttrs.hasMoreElements()) {
            LDAPAttribute myAttr = (LDAPAttribute)myAttrs.nextElement();
            String name = myAttr.getName();
            if (!name.equalsIgnoreCase(attr.getName())) continue;
            return true;
        }
        return false;
    }

    protected void removeExistingAttributes(Vector migAttrSet, commDomainEntry domEntry) throws Exception {
        if (this.myLDAPEntry == null) {
            return;
        }
        Iterator itr = migAttrSet.iterator();
        LDAPAttributeSet myAttrSet = this.myLDAPEntry.getAttributeSet();
        LDAPModificationSet newModSet = new LDAPModificationSet();
        while (itr.hasNext()) {
            commAttribute attr = (commAttribute)((Object)itr.next());
            String name = attr.getName();
            String[] values = attr.getStringValueArray();
            if (attr.getClassType() == 4 || attr.getClassType() == 5) {
                String[] newvals = attr.getSubstitutedValues(domEntry, this.myLDAPEntry, this.getValueMap());
                values = newvals;
            }
            if (values == null) continue;
            LDAPAttribute newAttr = new LDAPAttribute(name, values);
            if (attr.getType() == 1) {
                if (this.checkPresence(attr)) continue;
                newModSet.add(attr.getOperation(), newAttr);
                continue;
            }
            Enumeration myAttrs = myAttrSet.getAttributes();
            boolean addIt = true;
            while (myAttrs.hasMoreElements()) {
                LDAPAttribute myAttr = (LDAPAttribute)myAttrs.nextElement();
                if (!name.equalsIgnoreCase(myAttr.getName())) continue;
                String[] myValues = myAttr.getStringValueArray();
                HashSet<String> uniqValues = new HashSet<String>();
                boolean isValUniq = true;
                for (int i = 0; i < values.length; ++i) {
                    String cval = values[i];
                    isValUniq = true;
                    for (int j = 0; j < myValues.length; ++j) {
                        if (!cval.equalsIgnoreCase(myValues[j])) continue;
                        isValUniq = false;
                        break;
                    }
                    if (!isValUniq) continue;
                    uniqValues.add(cval);
                }
                if (uniqValues.size() > 0) {
                    String[] uvals = new String[uniqValues.size()];
                    newAttr = new LDAPAttribute(name, uniqValues.toArray(uvals));
                    break;
                }
                addIt = false;
                break;
            }
            if (!addIt) continue;
            newModSet.add(attr.getOperation(), newAttr);
        }
        this.myModSet = newModSet;
    }

    public void setNewEntry(commConfigEntry theConfigEntry, commDomainEntry theDomain, Map theValueMap) throws Exception {
        Object aIterator = null;
        LDAPAttributeSet aLdapAttributeSet = null;
        String aDnValue = null;
        if (theConfigEntry == null) {
            throw new Exception("00001 - No new entry to prepare");
        }
        aLdapAttributeSet = theConfigEntry.getAttributeSetWithSubstitution(theDomain, null, theValueMap);
        aDnValue = theConfigEntry.getDnValue();
        aDnValue = commConstants.substitute(aDnValue, theDomain, null, null);
        this.myLDAPEntry = new LDAPEntry(aDnValue, aLdapAttributeSet);
        this.myModSet = null;
    }

    public static String LdapEntryToLdif(LDAPEntry theLdapEntry, boolean theDnSwitch) {
        StringBuffer aReturnBuffer = new StringBuffer(500);
        String aAttributeValue = null;
        String aFormattedString = null;
        String aAttributeName = null;
        String[] aAttributeValues = null;
        Enumeration aAttributeEnumerator = null;
        LDAPAttribute aAttribute = null;
        int aIdx = 0;
        if (theDnSwitch) {
            aAttributeValue = theLdapEntry.getDN();
            aFormattedString = commEntry.formatLdifLine("dn", aAttributeValue);
            aReturnBuffer.append(aFormattedString).append("\n");
        }
        aAttributeEnumerator = theLdapEntry.getAttributeSet().getAttributes();
        while (aAttributeEnumerator.hasMoreElements()) {
            aAttribute = (LDAPAttribute)aAttributeEnumerator.nextElement();
            aAttributeName = aAttribute.getName();
            aAttributeValues = aAttribute.getStringValueArray();
            for (aIdx = 0; aIdx < aAttributeValues.length; ++aIdx) {
                aFormattedString = commEntry.formatLdifLine(aAttributeName, aAttributeValues[aIdx]);
                aReturnBuffer.append(aFormattedString).append("\n");
            }
        }
        return aReturnBuffer.toString();
    }

    public static String LdapEntryToDeleteLdif(LDAPEntry theLdapEntry) {
        String aReturnString = null;
        StringBuffer aBuffer = new StringBuffer(120);
        boolean aIdx = false;
        if (theLdapEntry == null) {
            return "";
        }
        aReturnString = aBuffer.append(commEntry.formatDn(theLdapEntry)).append("changetype: delete").append("\n").toString();
        return aReturnString;
    }

    public static String LdapModificationSetToLdif(LDAPModificationSet theModificationSet, String theDn) {
        LDAPModification aModification = null;
        LDAPAttribute aLdapAttribute = null;
        StringBuffer aStringBuffer = new StringBuffer(120);
        StringBuffer aOpBuffer = null;
        String aName = null;
        String aOpString = null;
        String[] aValueArray = null;
        int aModSize = 0;
        int aIdx = 0;
        int aInnerIdx = 0;
        if (theModificationSet == null) {
            return null;
        }
        aStringBuffer.append(commEntry.formatLdifLine("dn", theDn)).append("\n").append("changetype: modify").append("\n");
        aModSize = theModificationSet.size();
        for (aIdx = 0; aIdx < aModSize; ++aIdx) {
            if (aIdx > 0) {
                aStringBuffer.append("-").append("\n");
            }
            aModification = theModificationSet.elementAt(aIdx);
            aLdapAttribute = aModification.getAttribute();
            aName = aLdapAttribute.getName();
            aValueArray = aLdapAttribute.getStringValueArray();
            aOpBuffer = new StringBuffer(64);
            switch (aModification.getOp()) {
                case 0: {
                    aOpBuffer.append("add");
                    break;
                }
                case 1: {
                    aOpBuffer.append("delete");
                    break;
                }
                case 2: {
                    aOpBuffer.append("replace");
                    break;
                }
            }
            aOpString = aOpBuffer.append(": ").append(aName).append("\n").toString();
            for (aInnerIdx = 0; aInnerIdx < aValueArray.length; ++aInnerIdx) {
                if (aInnerIdx > 0) {
                    aStringBuffer.append("-").append("\n");
                }
                aStringBuffer.append(aOpString).append(commEntry.formatLdifLine(aName, aValueArray[aInnerIdx])).append("\n");
            }
        }
        return aStringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String LdapModificationSet_UndoToLdif(LDAPModificationSet theModificationSet, String theDn) {
        LDAPModification aModification = null;
        LDAPAttribute aLdapAttribute = null;
        StringBuffer aStringBuffer = new StringBuffer(120);
        StringBuffer aOpBuffer = null;
        String aName = null;
        String aOpString = null;
        String[] aValueArray = null;
        int aModSize = 0;
        int aIdx = 0;
        int aInnerIdx = 0;
        if (theModificationSet == null) {
            return null;
        }
        aStringBuffer.append(commEntry.formatLdifLine("dn", theDn)).append("\n").append("changetype: modify").append("\n");
        aModSize = theModificationSet.size();
        aIdx = 0;
        while (true) {
            block11: {
                if (aIdx >= aModSize) {
                    return aStringBuffer.toString();
                }
                if (aIdx > 0) {
                    aStringBuffer.append("-").append("\n");
                }
                aModification = theModificationSet.elementAt(aIdx);
                aLdapAttribute = aModification.getAttribute();
                aName = aLdapAttribute.getName();
                aValueArray = aLdapAttribute.getStringValueArray();
                aOpBuffer = new StringBuffer(64);
                switch (aModification.getOp()) {
                    case 0: {
                        aOpBuffer.append("delete");
                        break;
                    }
                    case 1: {
                        aOpBuffer.append("add");
                        break;
                    }
                    case 2: {
                        break block11;
                    }
                }
                aOpString = aOpBuffer.append(": ").append(aName).append("\n").toString();
                for (aInnerIdx = 0; aInnerIdx < aValueArray.length; ++aInnerIdx) {
                    if (aInnerIdx > 0) {
                        aStringBuffer.append("-").append("\n");
                    }
                    aStringBuffer.append(aOpString).append(commEntry.formatLdifLine(aName, aValueArray[aInnerIdx])).append("\n");
                }
            }
            ++aIdx;
        }
    }

    public static String formatLdifLine(String theAttributeName, String theAttributeValue) {
        StringBuffer aStringBuffer = new StringBuffer(theAttributeName.length() + theAttributeValue.length() + 32);
        int aFormattedLength = 0;
        int aMargin = 72;
        aStringBuffer.append(theAttributeName).append(": ").append(theAttributeValue);
        while (aStringBuffer.length() - aFormattedLength > aMargin) {
            aStringBuffer.insert(aFormattedLength + aMargin, "\n ");
            aFormattedLength += aMargin;
        }
        return aStringBuffer.toString();
    }

    public static String formatDn(LDAPEntry theLdapEntry) {
        StringBuffer aReturnBuffer = new StringBuffer(120);
        String aAttributeValue = null;
        String aFormattedString = null;
        aAttributeValue = theLdapEntry.getDN();
        aFormattedString = commEntry.formatLdifLine("dn", aAttributeValue);
        aReturnBuffer.append(aFormattedString).append("\n");
        return aReturnBuffer.toString();
    }

    public String getObjectType() {
        return this.objectType;
    }

    public LDAPEntry getLDAPEntry() {
        return this.myLDAPEntry;
    }

    public String getDn() {
        return this.myLDAPEntry.getDN();
    }
}

