/*
 * Decompiled with CFR 0.152.
 */
package sun.comm.dirmig;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Date;
import sun.comm.dirmig.commConfig;
import sun.comm.dirmig.commDirMig;
import sun.comm.dirmig.commDirMigException;

public class SmartWriter {
    private File sFileHandle = null;
    private PrintWriter sWriter = null;
    private String rootDir = "";

    public SmartWriter(String theFile) throws Exception {
        this.initData(theFile, true);
    }

    private void initData(String oldName, boolean firstTime) throws Exception {
        Date now = new Date();
        String newName = firstTime ? oldName : oldName.substring(0, oldName.lastIndexOf(46));
        newName = newName + "." + String.valueOf(now.getTime());
        if (firstTime && newName.indexOf("/") == -1) {
            this.rootDir = "/opt/SUNWcomm/data/log/";
        }
        this.sFileHandle = new File(this.rootDir + newName);
        this.sWriter = new PrintWriter(new FileOutputStream(this.sFileHandle), true);
    }

    public void printLine(String s) throws Exception {
        String unit;
        long curSize = this.sFileHandle.length();
        String logMax = (String)commDirMig.getOptionValue("m");
        if (logMax == null || logMax.length() == 0) {
            logMax = "500K";
        }
        if (!(unit = logMax.substring(logMax.length() - 1).toUpperCase()).equals("K") && !unit.equals("M")) {
            throw new commDirMigException(commConfig.getCodedString(6));
        }
        int magnitude = 0;
        try {
            magnitude = Integer.parseInt(logMax.substring(0, logMax.length() - 1));
        }
        catch (NumberFormatException e) {
            throw new commDirMigException(commConfig.getCodedString(6));
        }
        long mult = unit.equals("K") ? 1024L : 0x100000L;
        long limit = (long)magnitude * mult;
        if (curSize + (long)s.length() > limit) {
            this.initData(this.sFileHandle.getName(), false);
        }
        this.sWriter.println(s);
    }
}

