/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comm.jdapi;

import com.sun.comm.jdapi.DAAttribute;
import com.sun.comm.jdapi.DABusinessOrganization;
import com.sun.comm.jdapi.DAConnection;
import com.sun.comm.jdapi.DAConstants;
import com.sun.comm.jdapi.DAException;
import com.sun.comm.jdapi.DAGroup;
import com.sun.comm.jdapi.DAObject;
import com.sun.comm.jdapi.DAOrganization;
import com.sun.comm.jdapi.DAProviderOrganization;
import com.sun.comm.jdapi.DAResource;
import com.sun.comm.jdapi.DAResults;
import com.sun.comm.jdapi.DASearchResults;
import com.sun.comm.jdapi.DAServicePackage;
import com.sun.comm.jdapi.DAUser;
import com.sun.comm.jdapi.DAUtil;
import com.sun.comm.jdapi.DAValidOptions;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Vector;
import sun.comm.client.BadLoginException;
import sun.comm.client.CLIObject;
import sun.comm.client.CLIValidOptions;
import sun.comm.client.Debug;
import sun.comm.client.InvalidOptionException;
import sun.comm.client.ServletInfo;

class DATask {
    private String rcStat = "INIT";
    CLIObject cliObj = null;
    public static final String CREATE = "create";
    public static final String MODIFY = "modify";
    public static final String DELETE = "delete";
    public static final String SEARCH = "search";
    public static final String PURGE = "purge";
    public static final String GETROLE = "getrole";
    public static final String ADDROLE = "addrole";
    public static final String REMOVEROLE = "removerole";
    public static final String GET_SERVICEPACKAGE = "getservicepackage";
    public static final String OBJECT_USER = "user";
    public static final String OBJECT_GROUP = "group";
    public static final String OBJECT_RESOURCE = "resource";
    public static final String OBJECT_ORG = "org";
    public static final String OBJECT_BUSINESSORG = "businessorg";
    public static final String OBJECT_PROVIDERORG = "providerorg";
    public static final String OBJECT_SERVICEPACKAGE = "servicepackage";
    public static final String STATUSOK = "OK";
    public static final String STATUSFAIL = "FAIL";

    DATask(CLIObject cliObj) {
        this.cliObj = cliObj;
    }

    DAResults doTask(String action, DAObject obj, DAOrganization locationObj) throws DAException {
        int i;
        String objType = null;
        DAResults results = null;
        DASearchResults srchResults = null;
        Object tmpObj = null;
        boolean newObjRequired = true;
        if (obj instanceof DAUser) {
            objType = OBJECT_USER;
        } else if (obj instanceof DAGroup) {
            objType = OBJECT_GROUP;
        } else if (obj instanceof DAResource) {
            objType = OBJECT_RESOURCE;
        } else if (obj instanceof DAServicePackage) {
            objType = OBJECT_SERVICEPACKAGE;
        } else if (obj instanceof DAOrganization) {
            objType = obj instanceof DABusinessOrganization ? OBJECT_BUSINESSORG : (obj instanceof DAProviderOrganization ? OBJECT_PROVIDERORG : OBJECT_ORG);
        }
        ServletInfo[] servInfo = null;
        try {
            String tmpObjType = objType;
            if (objType.equals(OBJECT_PROVIDERORG) && action.equals(SEARCH)) {
                tmpObjType = OBJECT_BUSINESSORG;
            }
            servInfo = this.cliObj.getObjTaskArgs(tmpObjType, action);
            Debug.println((String)("DBG: doTask:got mapping info for objType=" + objType + ", action=" + action));
        }
        catch (BadLoginException e) {
            throw new DAException(e.getMessage());
        }
        catch (Exception e) {
            Debug.println((String)("DBG:doTask():exception: " + e.getMessage()));
            Debug.stackTrace((Exception)e);
            throw new DAException(e.getMessage());
        }
        DAValidOptions allValidOptions = new DAValidOptions();
        CLIValidOptions validObjTaskOptions = null;
        for (int i2 = 0; i2 < servInfo.length; ++i2) {
            validObjTaskOptions = servInfo[i2].getValidOptions();
            allValidOptions.addValidOptions(validObjTaskOptions);
        }
        Vector attrList = obj.getAttributes();
        String[] svcNames = obj.getMyServices();
        String[] mandatoryAttrNames = allValidOptions.getRequiredAttributeNames();
        for (i = 0; i < mandatoryAttrNames.length; ++i) {
            if (obj.isAttributePresent(mandatoryAttrNames[i])) continue;
            if (objType.equals(OBJECT_USER) && action.equals(CREATE) && mandatoryAttrNames[i].equalsIgnoreCase(DAConstants.UID)) {
                obj.setAttributeValues(DAConstants.UID, "tryautogeneratingmyuid");
                continue;
            }
            throw new DAException(DAConnection._resourceSet.getString("error", "missingMandatoryAttr") + mandatoryAttrNames[i]);
        }
        if (svcNames != null) {
            for (i = 0; i < svcNames.length; ++i) {
                String[] svcReqdAttrNames = allValidOptions.getRequiredServiceAttributeNames(svcNames[i]);
                for (int j = 0; j < svcReqdAttrNames.length; ++j) {
                    if (obj.isAttributePresent(svcReqdAttrNames[j])) continue;
                    throw new DAException(DAConnection._resourceSet.getString("error", "missingMandatoryServiceAttr") + svcReqdAttrNames[j] + ":" + svcNames[i]);
                }
            }
        }
        String prefix = "";
        Vector resp = null;
        for (int servNum = 0; servNum < servInfo.length; ++servNum) {
            int j;
            String value;
            String[] values;
            int i3;
            String[] servArg = servInfo[servNum].getservletArgs();
            String servCommand = servArg[0];
            String location = locationObj.getFirstValue("sunpreferreddomain");
            if (location == null || location.length() == 0 || action.equals(SEARCH) && obj instanceof DAServicePackage) {
                location = locationObj.getDN();
            }
            if (!action.equals(ADDROLE) && !action.equals(REMOVEROLE)) {
                servCommand = servCommand + "&domain=" + location;
            }
            String servlet = "/commcli/" + servInfo[servNum].getName();
            for (int argNum = 1; argNum < servArg.length; ++argNum) {
                servCommand = servCommand + "&" + servArg[argNum];
            }
            if (action.equals(CREATE)) {
                prefix = "add_";
                for (i3 = 0; i3 < attrList.size(); ++i3) {
                    int j2;
                    DAAttribute attr = (DAAttribute)attrList.elementAt(i3);
                    if (attr.getName().equals("dn")) continue;
                    values = attr.getValues();
                    if (objType.equals(OBJECT_RESOURCE) && attr.getName().equals("calendar")) {
                        for (j2 = 0; j2 < values.length; ++j2) {
                            servCommand = servCommand + "&" + attr.getName() + "=" + this.encode(values[j2]);
                        }
                        continue;
                    }
                    for (j2 = 0; j2 < values.length; ++j2) {
                        servCommand = servCommand + "&" + prefix + attr.getName() + "=" + this.encode(values[j2]);
                    }
                }
            } else if (action.equals(MODIFY)) {
                for (i3 = 0; i3 < attrList.size(); ++i3) {
                    DAAttribute attr = (DAAttribute)attrList.elementAt(i3);
                    value = attr.getFirstValue();
                    if (value != null) {
                        value = this.encode(value);
                    }
                    if (objType.equals(OBJECT_USER) && attr.getName().equals(DAConstants.UID)) {
                        servCommand = servCommand + "&" + attr.getName() + "=" + value;
                        continue;
                    }
                    if ((objType.equals(OBJECT_BUSINESSORG) || objType.equals(OBJECT_PROVIDERORG)) && attr.getName().equals("dn")) {
                        servCommand = servCommand + "&" + attr.getName() + "=" + value;
                        continue;
                    }
                    if (objType.equals(OBJECT_RESOURCE) && attr.getName().equals(DAConstants.UID)) {
                        servCommand = servCommand + "&" + attr.getName() + "=" + value;
                        continue;
                    }
                    if (!objType.equals(OBJECT_GROUP) || !attr.getName().equals(DAConstants.FULL_NAME)) continue;
                    servCommand = servCommand + "&" + attr.getName() + "=" + value;
                }
                attrList = obj.getChangedAttributes();
                for (i3 = 0; i3 < attrList.size(); ++i3) {
                    DAAttribute attr = (DAAttribute)attrList.elementAt(i3);
                    values = attr.getValues();
                    if (values != null) {
                        for (int j3 = 0; j3 < values.length; ++j3) {
                            switch (attr.getOperation()) {
                                case 2: {
                                    prefix = "add_";
                                    break;
                                }
                                case 4: {
                                    prefix = "replace_";
                                    break;
                                }
                                case 8: {
                                    prefix = "delete_";
                                    break;
                                }
                                case 1: {
                                    prefix = "";
                                    break;
                                }
                                default: {
                                    prefix = "";
                                }
                            }
                            servCommand = servCommand + "&" + prefix + attr.getName() + "=" + this.encode(values[j3]);
                        }
                        continue;
                    }
                    if (attr.getOperation() != 8) continue;
                    servCommand = servCommand + "&delete_" + attr.getName() + "=";
                }
            } else if (action.equals(DELETE)) {
                for (i3 = 0; i3 < attrList.size(); ++i3) {
                    DAAttribute attr = (DAAttribute)attrList.elementAt(i3);
                    value = attr.getFirstValue();
                    if (value != null) {
                        value = this.encode(value);
                    }
                    if (objType.equals(OBJECT_USER) && attr.getName().equals(DAConstants.UID)) {
                        servCommand = servCommand + "&" + attr.getName() + "=" + value;
                        continue;
                    }
                    if ((objType.equals(OBJECT_BUSINESSORG) || objType.equals(OBJECT_PROVIDERORG)) && attr.getName().equals("dn")) {
                        servCommand = servCommand + "&" + attr.getName() + "=" + value;
                        continue;
                    }
                    if (objType.equals(OBJECT_RESOURCE) && attr.getName().equals(DAConstants.UID)) {
                        servCommand = servCommand + "&" + attr.getName() + "=" + value;
                        continue;
                    }
                    if (!objType.equals(OBJECT_GROUP) || !attr.getName().equals(DAConstants.FULL_NAME)) continue;
                    servCommand = servCommand + "&" + attr.getName() + "=" + value;
                }
            } else if (action.equals(SEARCH)) {
                for (i3 = 0; i3 < attrList.size(); ++i3) {
                    DAAttribute attr = (DAAttribute)attrList.elementAt(i3);
                    String attrName = attr.getName();
                    String[] values2 = attr.getValues();
                    prefix = attrName.equals("filter") || attrName.equals("returnattributes") || attrName.equals("scope") || attrName.equals("borgdn") || attrName.equals("userdn") || attrName.equals("icsresourcedn") || attrName.equals("groupdn") ? "" : "srch_";
                    for (j = 0; j < values2.length; ++j) {
                        servCommand = servCommand + "&" + prefix + attr.getName() + "=" + this.encode(values2[j]);
                    }
                }
            } else if (action.equals(GETROLE) || action.equals(ADDROLE)) {
                for (i3 = 0; i3 < attrList.size(); ++i3) {
                    DAAttribute attr = (DAAttribute)attrList.elementAt(i3);
                    values = attr.getValues();
                    for (int j4 = 0; j4 < values.length; ++j4) {
                        servCommand = servCommand + "&" + attr.getName() + "=" + this.encode(values[j4]);
                    }
                }
            } else if (action.equals(REMOVEROLE)) {
                DAAttribute attr;
                Vector changedAttrList = obj.getChangedAttributes();
                for (int i4 = 0; i4 < attrList.size(); ++i4) {
                    attr = (DAAttribute)attrList.elementAt(i4);
                    String[] values3 = attr.getValues();
                    if (values3 == null) continue;
                    for (j = 0; j < values3.length; ++j) {
                        servCommand = servCommand + "&" + attr.getName() + "=" + this.encode(values3[j]);
                    }
                }
                for (int k = 0; k < changedAttrList.size(); ++k) {
                    attr = (DAAttribute)changedAttrList.elementAt(k);
                    String[] values4 = attr.getValues();
                    if (values4 == null) continue;
                    for (int l = 0; l < values4.length; ++l) {
                        servCommand = servCommand + "&" + attr.getName() + "=" + this.encode(values4[l]);
                    }
                }
            }
            try {
                System.out.println("DBG:doTask():servlet=" + servlet + "\ncmd = " + servCommand);
                resp = this.cliObj.sendservCommand(servlet, servCommand);
            }
            catch (IOException e) {
                throw new DAException(e.getMessage());
            }
            catch (InvalidOptionException ioe) {
                throw new DAException(ioe.getMessage());
            }
            catch (BadLoginException ble) {
                throw new DAException(ble.getMessage());
            }
            if (resp == null) continue;
            results = new DAResults();
            this.rcStat = (String)resp.elementAt(0);
            results.setStatus(this.rcStat);
            Debug.println((String)("DATask: status returned =" + this.rcStat));
            if (this.rcStat.equals(STATUSFAIL)) {
                String errorMsg = (String)resp.elementAt(1);
                String[] arr = errorMsg.split("\\^");
                errorMsg = arr[0];
                String isErr = null;
                String ldapErr = null;
                if (arr.length >= 3) {
                    if (!arr[1].equals("NONE")) {
                        isErr = arr[1];
                    }
                    if (!arr[2].equals("NONE")) {
                        ldapErr = arr[2];
                    }
                }
                for (int i5 = 2; i5 < resp.size(); ++i5) {
                    errorMsg = errorMsg + "\n" + (String)resp.elementAt(i5);
                }
                throw new DAException(errorMsg, isErr, ldapErr);
            }
            if (action.equals(GETROLE) && resp.size() >= 3) {
                resp.removeElementAt(0);
                resp.removeElementAt(0);
                results.setLoginUserRoles(resp);
            }
            if (!action.equals(SEARCH)) continue;
            srchResults = DAUtil.convertToSearchResults(resp, objType, this);
            srchResults.searchResultsFilledUp();
            results.setSearchResult(srchResults);
        }
        return results;
    }

    private String encode(String toEncode) throws DAException {
        String toReturn = "";
        try {
            toReturn = URLEncoder.encode(toEncode, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new DAException(e.toString() + e.getMessage());
        }
        return toReturn;
    }
}

