/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comm.jdapi;

import com.sun.comm.jdapi.DAAttribute;
import com.sun.comm.jdapi.DAException;
import com.sun.comm.jdapi.DAObject;
import com.sun.comm.jdapi.DAServiceName;
import com.sun.comm.jdapi.DAUtil;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class DAServicePackage
extends DAObject {
    private Vector _statusAttributes = new Vector();
    private Vector _requiredAttributes = new Vector();
    private Vector _optionalAttributes = new Vector();
    private Vector _cosAttributes = new Vector();
    private Vector _writeableAttributes = new Vector();
    private Vector _typeAndObject = new Vector();
    public static final String MAIL_SERVICE = "mail";
    public static final String CALENDAR_SERVICE = "calendar";
    private static Map sServiceMap = null;

    DAServicePackage() {
    }

    public String[] getServiceTypes() {
        String[] aServiceTypeArray = null;
        Object aStatusSplit = null;
        Object aStatusString = null;
        Vector<String> aServiceTypeVector = new Vector<String>();
        DAServiceName aDAServiceName = null;
        Iterator aIterator = null;
        if (this._typeAndObject == null || this._typeAndObject.size() == 0) {
            return null;
        }
        aIterator = this._typeAndObject.iterator();
        while (aIterator.hasNext()) {
            aDAServiceName = (DAServiceName)aIterator.next();
            aServiceTypeVector.add(aDAServiceName.getServiceName());
        }
        aServiceTypeArray = new String[1];
        return aServiceTypeVector.toArray(aServiceTypeArray);
    }

    public String getServiceStatusAttributeName(String theServiceName) throws DAException {
        Iterator aIterator = null;
        String[] aStatusSplit = null;
        String aStatusAttributeName = null;
        String aStatusString = null;
        if (theServiceName == null) {
            throw new DAException("Invalid argument for method");
        }
        aIterator = this._statusAttributes.iterator();
        while (aIterator.hasNext()) {
            aStatusString = (String)aIterator.next();
            aStatusSplit = aStatusString.split(":");
            if (!aStatusSplit[1].equalsIgnoreCase(theServiceName)) continue;
            aStatusAttributeName = aStatusSplit[0];
            break;
        }
        if (aStatusAttributeName == null) {
            throw new DAException(":getServiceStatus - no such service : " + theServiceName);
        }
        return aStatusAttributeName;
    }

    DAAttribute getServiceStatusAttribute(String theServiceName) throws Exception {
        String aStatusAttrName = this.getServiceStatusAttributeName(theServiceName);
        return this.getAttribute(aStatusAttrName);
    }

    public String getObjectTypeAsString() {
        DAServiceName aServiceDescriptor = null;
        String aObjectName = null;
        if (this._typeAndObject.size() > 0) {
            aServiceDescriptor = (DAServiceName)this._typeAndObject.get(0);
            aObjectName = aServiceDescriptor.getObject();
        }
        return aObjectName;
    }

    public Vector getCOSAttributes() {
        int aTypeInt = 0;
        Vector aReturnVector = null;
        aReturnVector = this.getAttributes(aTypeInt |= 0x80);
        return aReturnVector;
    }

    public Vector getCOSAttributes(String theServiceName) {
        int aTypeInt = 0;
        Vector aReturnVector = null;
        aTypeInt = this.serviceNameToInt(theServiceName);
        aReturnVector = this.getAttributes(aTypeInt |= 0x80);
        return aReturnVector;
    }

    public Vector getOverwriteableCOSAttributes() {
        int aTypeInt = 0;
        Vector aReturnVector = null;
        aTypeInt |= 0x1000000;
        aReturnVector = this.getAttributes(aTypeInt |= 0x80);
        return aReturnVector;
    }

    public Vector getOverwriteableCOSAttributes(String theServiceName) {
        int aTypeInt = 0;
        Vector aReturnVector = null;
        aTypeInt = this.serviceNameToInt(theServiceName);
        aTypeInt |= 0x1000000;
        aReturnVector = this.getAttributes(aTypeInt |= 0x80);
        return aReturnVector;
    }

    public Vector getRequiredAttributes() {
        int aTypeInt = 0;
        Vector aReturnVector = null;
        aReturnVector = this.getAttributes(aTypeInt |= 0x20);
        return aReturnVector;
    }

    public Vector getRequiredAttributes(String theServiceName) {
        int aTypeInt = 0;
        Vector aReturnVector = null;
        aTypeInt = this.serviceNameToInt(theServiceName);
        aReturnVector = this.getAttributes(aTypeInt |= 0x20);
        return aReturnVector;
    }

    public Vector getAllowedAttributes() {
        int aTypeInt = 0;
        Vector aReturnVector = null;
        aReturnVector = this.getAttributes(aTypeInt |= 0x10);
        return aReturnVector;
    }

    public Vector getAllowedAttributes(String theServiceName) {
        int aTypeInt = 0;
        Vector aReturnVector = null;
        aTypeInt = this.serviceNameToInt(theServiceName);
        aReturnVector = this.getAttributes(aTypeInt |= 0x10);
        return aReturnVector;
    }

    public Vector getAllAttributes() {
        return this.getAttributeVector();
    }

    public Vector getAllAttributes(String theServiceName) {
        int aTypeInt = 0;
        Vector aReturnVector = null;
        aTypeInt = this.serviceNameToInt(theServiceName);
        aReturnVector = this.getAttributes(aTypeInt);
        return aReturnVector;
    }

    public void collateAttributes() {
        Iterator aIterator = null;
        DAAttribute aAttribute = null;
        Vector aAttributes = this.getAttributes();
        String aAttributeName = null;
        String[] aAttributeValues = null;
        if (aAttributes == null || aAttributes.size() == 0) {
            return;
        }
        this._attributes = new Vector();
        aIterator = aAttributes.iterator();
        while (aIterator.hasNext()) {
            aAttribute = (DAAttribute)aIterator.next();
            aAttributeName = aAttribute.getName();
            aAttributeValues = aAttribute.getValues();
            if (aAttributeName.equalsIgnoreCase("dn")) {
                this.setDN(aAttributeValues[0]);
                this.setName(aAttributeValues[0]);
                continue;
            }
            this.addCosAttribute(aAttribute.getName(), aAttribute.getValues());
        }
    }

    public void addCosAttribute(String theAttributeName, String[] theValues) {
        int aIdx = 0;
        int aIntType = 16;
        String[] aTokens = null;
        String[] aValuesArray = null;
        String aValue = null;
        String aStringType = null;
        Vector<String> aValueList = new Vector<String>();
        DAAttribute aAttribute = null;
        if (theAttributeName == null || theValues == null) {
            return;
        }
        for (aIdx = 0; aIdx < theValues.length; ++aIdx) {
            aValue = theValues[aIdx];
            if (aValue.toLowerCase().indexOf("jdtype") >= 0) {
                aTokens = aValue.split("=");
                if (aTokens.length != 2) continue;
                aStringType = aTokens[1];
                aIntType = Integer.parseInt(aStringType.trim());
                continue;
            }
            aValueList.add(aValue);
        }
        if (aValueList.size() > 0) {
            aValuesArray = new String[1];
            aAttribute = new DAAttribute(theAttributeName, aValueList.toArray(aValuesArray));
        } else {
            aAttribute = new DAAttribute(theAttributeName);
        }
        aAttribute.setType(aIntType);
        this.addCosAttribute(aAttribute);
    }

    public void addCosAttribute(DAAttribute theAttribute) {
        String[] aValues = null;
        int aIdx = 0;
        if (theAttribute == null) {
            return;
        }
        if (theAttribute.hasType(16)) {
            DAUtil.addObjectToVector(this._optionalAttributes, theAttribute, 1003);
        }
        if (theAttribute.hasType(32)) {
            DAUtil.addObjectToVector(this._requiredAttributes, theAttribute, 1003);
        }
        if (theAttribute.hasType(64)) {
            DAUtil.addObjectToVector(this._writeableAttributes, theAttribute, 1003);
        }
        if (theAttribute.hasType(128)) {
            DAUtil.addObjectToVector(this._cosAttributes, theAttribute, 1003);
        }
        if (theAttribute.hasType(256)) {
            if (theAttribute.hasType(512)) {
                this._statusAttributes.add(theAttribute.getName() + ":" + MAIL_SERVICE);
            } else if (theAttribute.hasType(1024)) {
                this._statusAttributes.add(theAttribute.getName() + ":" + CALENDAR_SERVICE);
            }
        }
        if (theAttribute.hasType(4096) && (aValues = theAttribute.getValues()) != null) {
            for (aIdx = 0; aIdx < aValues.length; ++aIdx) {
                this._typeAndObject.add(new DAServiceName(aValues[aIdx]));
            }
        }
        DAUtil.addObjectToVector(this.getAttributeVector(), theAttribute, 1003);
    }

    protected int serviceNameToInt(String theServiceName) {
        int aReturnInt = 0;
        if (theServiceName.equalsIgnoreCase(MAIL_SERVICE)) {
            aReturnInt = 512;
        } else if (theServiceName.equalsIgnoreCase(CALENDAR_SERVICE)) {
            aReturnInt = 1024;
        }
        return aReturnInt;
    }

    private Vector getAttributes(int theTypeMask) {
        Vector aAllAttributes = this.getAttributeVector();
        Vector<DAAttribute> aReturnVector = new Vector<DAAttribute>();
        DAAttribute aAttribute = null;
        Iterator aIterator = null;
        if (aAllAttributes == null || aAllAttributes.size() == 0) {
            return aReturnVector;
        }
        aIterator = aAllAttributes.iterator();
        while (aIterator.hasNext()) {
            aAttribute = (DAAttribute)aIterator.next();
            if (!aAttribute.matchesType(theTypeMask)) continue;
            aReturnVector.add(aAttribute);
        }
        return aReturnVector;
    }

    DAServicePackage test(String theSPName) throws Exception {
        DAServicePackage aGoldServicePackage = new DAServicePackage();
        DAServicePackage aSilverServicePackage = new DAServicePackage();
        DAServicePackage aBronzeServicePackage = new DAServicePackage();
        Object aSP = null;
        String[][] aGoldValues = new String[][]{{"jdtype=192", "mailbox"}, {"jdtype=128", "100"}, {"jdType=128", "200"}};
        String[][] aSilverValues = new String[][]{{"jdtype=192", "mailbox"}, {"jdtype=128", "500"}, {"jdtype=128", "1000"}};
        String[][] aBronzeValues = new String[][]{{"jdtype=192", "mailbox"}, {"jdtype=128", "700"}, {"jdtype=128", "1200"}};
        String[] aMailServiceAttrNames = new String[]{"mailuserstatus", MAIL_SERVICE, "mailalternateaddress", "mailallowedserviceaccess", "mailautoreplymode", "mailautoreplysubject", "mailautoreplytext", "mailforwardingaddress", "vacationenddate", "vacationstartdate"};
        String[][] aMailAttributes = new String[][]{{"jdtype=800", "active"}, {"jdtype=32"}, {"jdtype=16"}, {"jdtype=16"}, {"jdtype=16", "echo"}, {"jdtype=16"}, {"jdtype=16"}, {"jdtype=16"}, {"jdtype=16"}, {"jdtype=16"}};
        aGoldServicePackage.setName("gold");
        aGoldServicePackage.addCosAttribute("maildeliveryoption", aGoldValues[0]);
        aGoldServicePackage.addCosAttribute("maildeliveryoption", aGoldValues[0]);
        aGoldServicePackage.addCosAttribute("mailquota", aGoldValues[1]);
        aGoldServicePackage.addCosAttribute("mailmsgquota", aGoldValues[2]);
        this.addMailServiceAttributes(aGoldServicePackage, aMailServiceAttrNames, aMailAttributes);
        aSilverServicePackage.setName("silver");
        aSilverServicePackage.addCosAttribute("maildeliveryoption", aSilverValues[0]);
        aSilverServicePackage.addCosAttribute("mailquota", aSilverValues[1]);
        aSilverServicePackage.addCosAttribute("mailmsgquota", aSilverValues[2]);
        this.addMailServiceAttributes(aSilverServicePackage, aMailServiceAttrNames, aMailAttributes);
        aBronzeServicePackage.setName("bronze");
        aBronzeServicePackage.addCosAttribute("maildeliveryoption", aBronzeValues[0]);
        aBronzeServicePackage.addCosAttribute("mailquota", aBronzeValues[1]);
        aBronzeServicePackage.addCosAttribute("mailmsgquota", aBronzeValues[2]);
        this.addMailServiceAttributes(aBronzeServicePackage, aMailServiceAttrNames, aMailAttributes);
        DAServicePackage.getInformation(aGoldServicePackage);
        DAServicePackage.getInformation(aSilverServicePackage);
        DAServicePackage.getInformation(aBronzeServicePackage);
        if (theSPName.equalsIgnoreCase("gold")) {
            return aGoldServicePackage;
        }
        if (theSPName.equalsIgnoreCase("silver")) {
            return aSilverServicePackage;
        }
        if (theSPName.equalsIgnoreCase("bronze")) {
            return aBronzeServicePackage;
        }
        return null;
    }

    private void addMailServiceAttributes(DAServicePackage theServicePackage, String[] theAttributeNames, String[][] theAttributeValues) {
        int aIdx = 0;
        boolean aIdx2 = false;
        for (aIdx = 0; aIdx < theAttributeNames.length; ++aIdx) {
            theServicePackage.addCosAttribute(theAttributeNames[aIdx], theAttributeValues[aIdx]);
        }
    }

    public static void getInformation(DAServicePackage theServicePackage) throws Exception {
        String aString = null;
        String[] aStrings = null;
        DAAttribute aAttribute = null;
        Vector aVector = null;
        boolean aBoolean = true;
        aString = theServicePackage.getName();
        aStrings = theServicePackage.getServiceTypes();
        aAttribute = theServicePackage.getServiceStatusAttribute(aStrings[0]);
        aString = theServicePackage.getServiceStatusAttributeName(aStrings[0]);
        aStrings = theServicePackage.getServiceTypes();
        aVector = theServicePackage.getCOSAttributes();
        aVector = theServicePackage.getOverwriteableCOSAttributes();
        aVector = theServicePackage.getRequiredAttributes();
        aVector = theServicePackage.getAllowedAttributes();
        aVector = theServicePackage.getAllAttributes();
        aString = theServicePackage.getFirstValue("maildeliveryoption");
        aStrings = theServicePackage.getAttributeValues("maildeliveryoption");
        aAttribute = theServicePackage.getAttribute("mailautoreplymode");
        if (aAttribute != null) {
            aBoolean = aAttribute.hasType(16);
        }
        if ((aAttribute = theServicePackage.getAttribute("mailuserstatus")) != null) {
            aBoolean = aAttribute.hasType(16);
            aBoolean = aAttribute.hasType(256);
            aBoolean = aAttribute.hasType(32);
            aBoolean = aAttribute.hasType(288);
        }
    }
}

