/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comm.jdapi;

import com.sun.comm.jdapi.DAConstants;

public class DARole {
    private String name = null;
    private String organizationDN = null;
    private String _dn = null;
    public static final String TOP_LEVEL_ADMIN = "cn=Top-level Admin Role";
    public static final String PROVIDER_ADMIN = "cn=Provider Admin Role";
    public static final String BUSINESSORG_ADMIN = "cn=Organization Admin Role";

    public DARole(String _name) {
        this.name = _name;
    }

    DARole() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String _name) {
        this.name = _name;
        if (this.name != null && this.organizationDN != null && this.organizationDN.length() > 0 && this.name.length() > 0) {
            this._dn = this.name + "," + this.organizationDN;
        }
    }

    public String getManagedOrganizationDN() {
        return this.organizationDN;
    }

    public void setManagedOrganizationDN(String orgDN) {
        this.organizationDN = orgDN;
        if (this.name != null && this.organizationDN != null && this.organizationDN.length() > 0 && this.name.length() > 0) {
            this._dn = this.name + "," + this.organizationDN;
        }
    }

    public String getRoleDN() {
        return this._dn;
    }

    public void setRoleDN(String theDn) {
        String[] aDnSplit = null;
        int aIdx = 0;
        this._dn = theDn;
        this.organizationDN = new String();
        aDnSplit = theDn.split(",");
        this.name = aDnSplit[0];
        for (aIdx = 1; aIdx < aDnSplit.length; ++aIdx) {
            this.organizationDN = aIdx == aDnSplit.length - 1 ? this.organizationDN.concat(aDnSplit[aIdx].trim()) : this.organizationDN.concat(aDnSplit[aIdx].trim() + ",");
        }
    }

    public boolean isOrgAdmin() {
        if (this.name == null || this.name.length() == 0) {
            return false;
        }
        return this.name.equals(DAConstants.BUSINESSORG_ADMIN);
    }

    public boolean isProviderAdmin() {
        if (this.name == null || this.name.length() == 0) {
            return false;
        }
        return this.name.equals(DAConstants.PROVIDER_ADMIN);
    }

    public boolean isTopLevelAdmin() {
        if (this.name == null || this.name.length() == 0) {
            return false;
        }
        return this.name.equals(DAConstants.TOP_LEVEL_ADMIN);
    }

    void print() {
        System.out.println("role dn = " + this._dn);
    }
}

