/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comm.jdapi;

import java.util.Hashtable;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

class DAResourceBundle {
    protected static final String separator = "-";
    protected static final char parameter = '%';
    protected static Hashtable cache = new Hashtable();
    protected PropertyResourceBundle prb;

    DAResourceBundle(String bundle, Locale locale) {
        Locale defaultLocale = new Locale("en", "US");
        Locale.setDefault(defaultLocale);
        this.prb = locale == null ? (PropertyResourceBundle)ResourceBundle.getBundle(bundle, Locale.getDefault()) : (PropertyResourceBundle)ResourceBundle.getBundle(bundle, locale);
    }

    DAResourceBundle(String bundle, String locale) {
        Locale defaultLocale = new Locale("en", "US");
        Locale.setDefault(defaultLocale);
        if (locale == null) {
            this.prb = (PropertyResourceBundle)ResourceBundle.getBundle(bundle, Locale.getDefault());
        } else {
            Locale myLocale = this.getLocale(locale);
            this.prb = (PropertyResourceBundle)ResourceBundle.getBundle(bundle, myLocale);
        }
    }

    DAResourceBundle(String bundle) {
        this(bundle, (String)null);
    }

    public String getString(String prefix, String name) {
        return this.getString(prefix, name, (String[])null);
    }

    public String getString(String thePrefixOne, String thePrefixTwo, String theStringName, String[] args) {
        return this.getString(thePrefixOne + separator + thePrefixTwo, theStringName, args);
    }

    public String getString(String prefix, String name, String arg) {
        String[] s = new String[]{arg};
        return this.getString(prefix, name, s);
    }

    public String getString(String prefix, String name, String[] args) {
        if (this.prb != null) {
            if (prefix != null) {
                try {
                    return this.substitute(this.prb.getString(prefix + separator + name), args);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                return this.substitute(this.prb.getString(name), args);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    protected Locale getLocale(String locale) {
        String country;
        String lang;
        int pos = locale.indexOf(45);
        if (pos == -1) {
            lang = locale;
            country = "";
        } else {
            lang = locale.substring(0, pos);
            country = locale.substring(pos + 1, locale.length());
        }
        return new Locale(lang, country);
    }

    protected String substitute(String s, String[] args) {
        if (args == null) {
            return s;
        }
        char[] val = s.toCharArray();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < val.length; ++i) {
            if (val[i] != '%') {
                sb.append(val[i]);
                continue;
            }
            if (++i == val.length) {
                sb.append(val[i]);
                break;
            }
            int num = Character.getNumericValue(val[i]);
            if (num < 0 || num >= args.length) {
                sb.append("<error>");
                continue;
            }
            if (args[num] == null) continue;
            sb.append(args[num]);
        }
        return sb.toString();
    }
}

