/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comm.jdapi;

import com.sun.comm.jdapi.DAAttribute;
import com.sun.comm.jdapi.DABusinessOrganization;
import com.sun.comm.jdapi.DAConstants;
import com.sun.comm.jdapi.DAException;
import com.sun.comm.jdapi.DAGroup;
import com.sun.comm.jdapi.DAObject;
import com.sun.comm.jdapi.DAOrganization;
import com.sun.comm.jdapi.DAProviderOrganization;
import com.sun.comm.jdapi.DAResource;
import com.sun.comm.jdapi.DAResourceBundle;
import com.sun.comm.jdapi.DAResults;
import com.sun.comm.jdapi.DARole;
import com.sun.comm.jdapi.DASearchConstraint;
import com.sun.comm.jdapi.DASearchResults;
import com.sun.comm.jdapi.DAServicePackage;
import com.sun.comm.jdapi.DAServicePackageManager;
import com.sun.comm.jdapi.DASpSearch;
import com.sun.comm.jdapi.DATask;
import com.sun.comm.jdapi.DAUser;
import com.sun.comm.jdapi.DAUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import sun.comm.client.CLIObject;
import sun.comm.client.Debug;

public class DAConnection {
    private CLIObject cliObj = null;
    private DATask myTask = null;
    private static String loggedInUID = null;
    private static String loginDomainName = null;
    private static DAServicePackageManager _servicePackageManager = new DAServicePackageManager();
    static DAResourceBundle _resourceSet = null;
    static final int NUM_CANNEDUSERS = 10;
    static Vector _businessOrgCache = new Vector();
    static Vector _providerOrgCache = new Vector();
    static Vector _userCache = new Vector();
    private static int _mode = 103;
    private DAUser _loggedInUser = null;

    private static DAConnection cannedAuth(String username, String pwd) throws DAException {
        _resourceSet = new DAResourceBundle("com.sun.comm.jdapi.resource", "en");
        Iterator aIterator = _userCache.iterator();
        while (aIterator.hasNext()) {
            DAUser userObj = (DAUser)aIterator.next();
            String uname = userObj.getFirstValue(DAConstants.UID);
            String password = userObj.getFirstValue(DAConstants.PASSWORD);
            if (!uname.equals(username) || !password.equals(pwd)) continue;
            DAConnection conn = new DAConnection();
            conn._loggedInUser = userObj;
            return conn;
        }
        throw new DAException("DAConnection.authenticate: " + _resourceSet.getString("error", "invalidUserPassword") + username);
    }

    private static DAConnection liveAuth(CLIObject cli, boolean domainAuth, String userOrLogin, String password, String loginOrDomain) throws DAException {
        Vector resp = null;
        _resourceSet = new DAResourceBundle("com.sun.comm.jdapi.resource", "en");
        try {
            if (domainAuth) {
                cli.authenticate(userOrLogin, password, loginOrDomain);
            } else {
                cli.loginOnlyAuthenticate(userOrLogin, password, loginOrDomain);
            }
        }
        catch (Exception e) {
            Debug.println((String)"DBG:DAConnection:authenticate:exception: ");
            Debug.stackTrace((Exception)e);
            resp = cli.getCurrentResponse();
            if (resp != null) {
                String status = (String)resp.elementAt(0);
                if (status.equals("FAIL")) {
                    String msg = (String)resp.elementAt(1);
                    throw new DAException(msg);
                }
            }
            throw new DAException(e.getMessage());
        }
        resp = cli.getCurrentResponse();
        String status = (String)resp.elementAt(0);
        if (status.equals("FAIL")) {
            String msg = (String)resp.elementAt(1);
            throw new DAException(msg);
        }
        DAConnection conn = new DAConnection(cli);
        Vector results = DAUtil.convertToSearchResults(resp, "user", conn.myTask).getResultVector();
        DAUser loggedUser = null;
        if (results != null && results.size() > 0) {
            loggedUser = (DAUser)results.elementAt(0);
        }
        if (loggedUser != null) {
            Debug.println((String)("DAConnection.liveAuth:auth user Dn=" + loggedUser.getDN()));
        }
        conn._loggedInUser = loggedUser;
        return conn;
    }

    public static DAConnection authenticate(String daServerHost, int daServerPort, String loginname, String password, boolean useSSL) throws DAException {
        if (DAConnection.getMode() == 102) {
            return DAConnection.cannedAuth(loginname, password);
        }
        CLIObject cli = new CLIObject(daServerHost, daServerPort, useSSL);
        return DAConnection.liveAuth(cli, false, loginname, password, "loginid");
    }

    public static DAConnection authenticate(String daServerHost, int daServerPort, String username, String password, String domain, boolean useSSL) throws DAException {
        loggedInUID = username;
        loginDomainName = domain;
        if (DAConnection.getMode() == 102) {
            return DAConnection.cannedAuth(username, password);
        }
        CLIObject cli = new CLIObject(daServerHost, daServerPort, useSSL);
        return DAConnection.liveAuth(cli, true, username, password, domain);
    }

    DAConnection(CLIObject cliObj) {
        this.cliObj = cliObj;
        this.myTask = new DATask(cliObj);
    }

    DAConnection() {
    }

    DATask getTask() {
        return this.myTask;
    }

    public DARole[] getRoles() {
        DARole[] roles = null;
        if (this._loggedInUser != null) {
            roles = this._loggedInUser.getRoles();
        }
        return roles;
    }

    public DAUser getUser(String userDN) throws DAException {
        if (userDN == null || userDN.length() == 0) {
            throw new DAException("getUser(): " + _resourceSet.getString("error", "missingUserDn"));
        }
        userDN = userDN.trim();
        DAUser toReturn = null;
        DAUser tmpU = new DAUser();
        tmpU.addAttribute("userdn", new String[]{userDN});
        DAResults results = null;
        DAOrganization tmpLoc = new DAOrganization();
        try {
            results = this.myTask.doTask("search", tmpU, tmpLoc);
        }
        catch (DAException de) {
            Debug.println((String)("getUser():exception while searching B.Org " + userDN));
            throw de;
        }
        Vector Users = results.getSearchResult().getResultVector();
        if (Users.size() > 1) {
            Debug.println((String)"Internal error: getUser(): more than 1 user entry matching!");
            return null;
        }
        toReturn = (DAUser)Users.elementAt(0);
        DAAttribute objClasses = toReturn.getAttribute("objectClass");
        String[] objClassNames = objClasses.getValues();
        boolean validUser = false;
        for (int i = 0; i < objClassNames.length; ++i) {
            if (!objClassNames[i].equalsIgnoreCase("person")) continue;
            validUser = true;
            break;
        }
        if (!validUser) {
            throw new DAException(_resourceSet.getString("error", "invalidUser"));
        }
        return toReturn;
    }

    public DAGroup getGroup(String groupDN) throws DAException {
        if (groupDN == null || groupDN.length() == 0) {
            throw new DAException("getGroup(): " + _resourceSet.getString("error", "missingGroupDn"));
        }
        groupDN = groupDN.trim();
        DAGroup toReturn = null;
        DAGroup tmpG = new DAGroup();
        tmpG.addAttribute("groupdn", new String[]{groupDN});
        DAResults results = null;
        DAOrganization tmpLoc = new DAOrganization();
        try {
            results = this.myTask.doTask("search", tmpG, tmpLoc);
        }
        catch (DAException de) {
            Debug.println((String)("getGroup():exception while searching B.Org " + groupDN));
            throw de;
        }
        Vector Groups = results.getSearchResult().getResultVector();
        toReturn = (DAGroup)Groups.elementAt(0);
        return toReturn;
    }

    public DAResource getResource(String rsrcDN) throws DAException {
        if (rsrcDN == null || rsrcDN.length() == 0) {
            throw new DAException("getResource(): " + _resourceSet.getString("error", "missingResourceDn"));
        }
        rsrcDN = rsrcDN.trim();
        DAResource toReturn = null;
        DAResource tmp = new DAResource();
        tmp.addAttribute("icsresourcedn", new String[]{rsrcDN});
        DAResults results = null;
        DAOrganization tmpLoc = new DAOrganization();
        try {
            results = this.myTask.doTask("search", tmp, tmpLoc);
        }
        catch (DAException de) {
            Debug.println((String)("getResource():exception while searching B.Org " + rsrcDN));
            throw de;
        }
        Vector Resources = results.getSearchResult().getResultVector();
        if (Resources.size() > 1) {
            Debug.println((String)"Internal error: getResource(): more than 1 user entry matching!");
            return null;
        }
        toReturn = (DAResource)Resources.elementAt(0);
        DAAttribute objClasses = toReturn.getAttribute("objectClass");
        String[] objClassNames = objClasses.getValues();
        boolean validResource = false;
        for (int i = 0; i < objClassNames.length; ++i) {
            if (!objClassNames[i].equalsIgnoreCase("icsCalendarResource")) continue;
            validResource = true;
            break;
        }
        if (!validResource) {
            throw new DAException(_resourceSet.getString("error", "invalidResource"));
        }
        return toReturn;
    }

    public DAServicePackage[] getAllServicePackages() throws DAException {
        Vector aSpVector = null;
        DAServicePackage[] aSpArray = new DAServicePackage[1];
        DARole aRole = null;
        DARole[] aRoleArray = null;
        boolean aTopLevelAdmin = false;
        int aIdx = 0;
        if (this._loggedInUser == null) {
            throw new DAException("User not logged in");
        }
        aRoleArray = this._loggedInUser.getRoles();
        for (aIdx = 0; aIdx < aRoleArray.length; ++aIdx) {
            aRole = aRoleArray[aIdx];
            if (!aRole.isTopLevelAdmin()) continue;
            aTopLevelAdmin = true;
            break;
        }
        if (!aTopLevelAdmin) {
            throw new DAException("Not a top level admin");
        }
        aSpVector = _servicePackageManager.getServicePackages((Vector)null, (Vector)null, this.getMyTask());
        if (aSpVector.size() == 0) {
            return null;
        }
        aSpArray = aSpVector.toArray(aSpArray);
        return aSpArray;
    }

    public DAServicePackage[] getAllServicePackages(DASpSearch theSearchInfo) throws DAException {
        DASearchResults aSearchResults = null;
        DAServicePackage[] aSpArray = this.getAllServicePackages();
        Vector aSpVector = null;
        if (aSpArray != null) {
            aSpVector = DAUtil.convertToVector(aSpArray);
            aSearchResults = DAUtil.searchObjects(aSpVector, theSearchInfo);
            if ((aSpVector = aSearchResults.getResultVector()).size() > 0) {
                aSpArray = new DAServicePackage[1];
                aSpArray = aSpVector.toArray(aSpArray);
            } else {
                aSpArray = null;
            }
        }
        return aSpArray;
    }

    public DAUser getLoggedInUser() {
        return this._loggedInUser;
    }

    public DAOrganization getLoginOrganization() {
        if (this._loggedInUser == null) {
            Debug.println((String)"logged in user object is null");
            return null;
        }
        DARole[] roles = this._loggedInUser.getRoles();
        String aOrgDn = this._loggedInUser.getOrganizationDn();
        DAOrganization toReturn = null;
        if (roles == null) {
            return null;
        }
        if (DAConnection.getMode() == 102) {
            Vector orgVc = null;
            orgVc = DAConnection.getCacheBusinessOrgs(aOrgDn);
            if (orgVc != null && orgVc.size() == 1) {
                toReturn = (DABusinessOrganization)orgVc.elementAt(0);
            }
            return toReturn;
        }
        String userDn = this._loggedInUser.getDN();
        int firstComma = userDn.indexOf(",");
        int secondComma = userDn.substring(firstComma + 1).indexOf(",");
        String borgDn = userDn.substring(firstComma + secondComma + 2);
        borgDn = borgDn.trim();
        DABusinessOrganization tmpBO = new DABusinessOrganization();
        tmpBO.addAttribute("borgdn", new String[]{borgDn});
        DAResults results = null;
        DAOrganization tmpLoc = new DAOrganization(borgDn);
        try {
            results = this.myTask.doTask("search", tmpBO, tmpLoc);
        }
        catch (DAException de) {
            Debug.println((String)("getLoginOrganization():exception while searching B.Org " + borgDn));
            return null;
        }
        Vector BOrgs = results.getSearchResult().getResultVector();
        if (BOrgs.size() > 1) {
            Debug.println((String)"Internal error: more than 1 org matching!");
            return null;
        }
        toReturn = (DAOrganization)BOrgs.elementAt(0);
        return toReturn;
    }

    public DABusinessOrganization[] getBusinessOrganization() throws UnsupportedOperationException, DAException {
        String role;
        int i;
        DARole aRole = null;
        Object aProviderRole = null;
        DARole[] aRoleArray = null;
        String aRoleBaseDn = null;
        Vector aReturnVector = null;
        Vector aTmpVector = null;
        Iterator aIterator = null;
        DABusinessOrganization[] aReturnArray = null;
        DABusinessOrganization aBusinessOrg = null;
        int aIdx = 0;
        if (DAConnection.getMode() == 102) {
            if (this._loggedInUser == null) {
                return null;
            }
            aRoleArray = this._loggedInUser.getRoles();
            aReturnVector = new Vector();
            for (aIdx = 0; aIdx < aRoleArray.length; ++aIdx) {
                aRole = aRoleArray[aIdx];
                aRoleBaseDn = aRole.getManagedOrganizationDN();
                aTmpVector = DAConnection.getCacheBusinessOrgs(aRoleBaseDn);
                aIterator = aTmpVector.iterator();
                while (aIterator.hasNext()) {
                    aBusinessOrg = (DABusinessOrganization)aIterator.next();
                    DAUtil.addObjectToVector(aReturnVector, aBusinessOrg, 1003);
                }
            }
            if (aReturnVector.size() > 0) {
                aReturnArray = new DABusinessOrganization[1];
                aReturnArray = aReturnVector.toArray(aReturnArray);
            }
            return aReturnArray;
        }
        if (this.myTask == null) {
            return null;
        }
        Object result = null;
        DAResults result1 = null;
        DAUser loginUser = new DAUser();
        Vector managedOrgs = new Vector();
        DABusinessOrganization tmpBO = null;
        DABusinessOrganization[] toReturn = null;
        Vector orgsToReturn = new Vector();
        Vector returnedBOrgs = null;
        String[] roles = null;
        boolean isOUA = false;
        boolean isSPA = false;
        boolean isTLA = false;
        roles = this._loggedInUser.getAttributeValues("nsroledn");
        if (roles == null) {
            throw new UnsupportedOperationException("DAConnection.getBusinessOrganization():" + _resourceSet.getString("error", "userInvalidRole"));
        }
        for (i = 0; i < roles.length; ++i) {
            role = roles[i];
            if (role != null) {
                role = role.trim().toLowerCase();
            }
            if (role.indexOf("cn=organization admin role") != -1) {
                isOUA = true;
                continue;
            }
            if (role.indexOf("cn=provider admin role") != -1) {
                isSPA = true;
                continue;
            }
            if (role.indexOf("cn=top-level admin role") == -1) continue;
            isTLA = true;
        }
        tmpBO = new DABusinessOrganization();
        for (i = 0; i < roles.length; ++i) {
            DASearchConstraint cons;
            DAProviderOrganization pOrg;
            String[] newArray;
            Vector rOrgs;
            DASearchResults result2;
            HashMap<String, String> attrMap;
            String providerOrgDN;
            role = roles[i];
            if (role != null) {
                role = role.trim().toLowerCase();
            }
            System.out.println("Role[" + i + "] = " + role);
            if (role.indexOf("cn=organization admin role") != -1) {
                if (isSPA || isTLA) continue;
                isOUA = true;
                String[] myArray = role.split("cn=organization admin role,");
                System.out.println("myArray.length =" + myArray.length);
                if (myArray.length < 2) continue;
                tmpBO.addAttribute("borgdn", new String[]{myArray[1]});
                continue;
            }
            if (role.indexOf("cn=provider admin role") != -1) {
                if (isTLA) continue;
                providerOrgDN = null;
                attrMap = new HashMap<String, String>();
                result2 = null;
                rOrgs = null;
                attrMap.put("o", "*");
                attrMap.put("objectclass", "sunDelegatedOrganization");
                newArray = role.split("cn=provider admin role,");
                if (newArray.length == 2) {
                    providerOrgDN = newArray[1];
                }
                pOrg = new DAProviderOrganization();
                pOrg.setDN(providerOrgDN);
                pOrg.setMyTask(this.myTask);
                cons = new DASearchConstraint("", DASearchConstraint.SUBTREE_SCOPE, attrMap);
                result2 = pOrg.searchOrganization(cons);
                if (result2 == null || (rOrgs = result2.getResultVector()) == null) continue;
                orgsToReturn.addAll(rOrgs);
                continue;
            }
            if (role.indexOf("cn=top-level admin role") == -1) continue;
            providerOrgDN = null;
            attrMap = new HashMap();
            result2 = null;
            rOrgs = null;
            attrMap.put("o", "*");
            attrMap.put("objectclass", "sunDelegatedOrganization");
            newArray = role.split("cn=top-level admin role,");
            if (newArray.length == 2) {
                providerOrgDN = newArray[1];
            }
            pOrg = new DAProviderOrganization();
            pOrg.setDN(providerOrgDN);
            pOrg.setMyTask(this.myTask);
            cons = new DASearchConstraint("", DASearchConstraint.SUBTREE_SCOPE, attrMap);
            result2 = pOrg.searchOrganization(cons);
            if (result2 == null || (rOrgs = result2.getResultVector()) == null) continue;
            orgsToReturn.addAll(rOrgs);
        }
        if (isOUA && !isSPA && !isTLA) {
            DAOrganization loginOrg = new DAOrganization();
            if (loginDomainName != null && loginDomainName.length() != 0) {
                loginOrg.setAttributeValues("sunpreferreddomain", loginDomainName);
            }
            if ((result1 = this.myTask.doTask("search", tmpBO, loginOrg)) != null) {
                DASearchResults srchRes = result1.getSearchResult();
                if (srchRes != null) {
                    returnedBOrgs = srchRes.getResultVector();
                }
                if (returnedBOrgs != null) {
                    orgsToReturn.addAll(returnedBOrgs);
                }
            }
        }
        if (orgsToReturn.size() > 0) {
            if (toReturn == null) {
                toReturn = new DABusinessOrganization[orgsToReturn.size()];
            }
            toReturn = (DABusinessOrganization[])orgsToReturn.toArray(toReturn);
        }
        return toReturn;
    }

    public DABusinessOrganization[] getBusinessOrganization(DASearchConstraint theConstraints) throws UnsupportedOperationException, DAException {
        Vector<DABusinessOrganization> aVector = new Vector<DABusinessOrganization>();
        Vector aReturnVector = null;
        DABusinessOrganization[] aOrganizationArray = null;
        DABusinessOrganization[] aReturnArray = null;
        DASearchResults aSearchResults = null;
        String aWildCardFilter = null;
        int aIdx = 0;
        if (DAConnection.getMode() == 102) {
            aOrganizationArray = this.getBusinessOrganization();
            for (aIdx = 0; aIdx < aOrganizationArray.length; ++aIdx) {
                aVector.add(aOrganizationArray[aIdx]);
            }
            aWildCardFilter = theConstraints.getFilter();
            if (aWildCardFilter == null) {
                aWildCardFilter = "*";
            }
            if ((aReturnVector = (aSearchResults = DAUtil.searchObjects(aVector, aWildCardFilter, theConstraints)).getResultVector()).size() > 0) {
                aReturnArray = new DABusinessOrganization[1];
                aReturnArray = aReturnVector.toArray(aReturnArray);
            }
            return aReturnArray;
        }
        return null;
    }

    public DABusinessOrganization getBusinessOrganization(String borgDn) throws DAException {
        if (borgDn == null) {
            borgDn = "";
        }
        borgDn = borgDn.trim();
        DABusinessOrganization toReturn = null;
        DABusinessOrganization tmpBO = new DABusinessOrganization();
        tmpBO.addAttribute("borgdn", new String[]{borgDn});
        DAResults results = null;
        DAOrganization tmpLoc = new DAOrganization(borgDn);
        try {
            results = this.myTask.doTask("search", tmpBO, tmpLoc);
        }
        catch (DAException de) {
            Debug.println((String)("getBusinessOrganization():exception while searching B.Org " + borgDn));
            throw de;
        }
        Vector BOrgs = results.getSearchResult().getResultVector();
        if (BOrgs.size() > 1) {
            Debug.println((String)"Internal error: more than 1 bus.org matching!");
            return null;
        }
        toReturn = (DABusinessOrganization)BOrgs.elementAt(0);
        DAAttribute objClasses = toReturn.getAttribute("objectClass");
        String[] objClassNames = objClasses.getValues();
        boolean validBOrg = false;
        for (int i = 0; i < objClassNames.length; ++i) {
            if (!objClassNames[i].equalsIgnoreCase("sunDelegatedOrganization")) continue;
            validBOrg = true;
            break;
        }
        if (borgDn.length() > 0 && !validBOrg) {
            throw new DAException(_resourceSet.getString("error", "invalidBOrg"));
        }
        return toReturn;
    }

    public DAProviderOrganization[] getProviderOrganization() throws UnsupportedOperationException, DAException {
        Object aProviderRole = null;
        DARole aRole = null;
        DARole[] aRoleArray = null;
        Vector aReturnVector = null;
        Vector aTmpVector = null;
        int aIdx = 0;
        String aRoleBaseDn = null;
        Iterator aIterator = null;
        DAProviderOrganization aProviderOrg = null;
        DAProviderOrganization[] aReturnArray = null;
        if (DAConnection.getMode() == 102) {
            if (this._loggedInUser == null) {
                return null;
            }
            aRoleArray = this._loggedInUser.getRoles();
            aReturnVector = new Vector();
            for (aIdx = 0; aIdx < aRoleArray.length; ++aIdx) {
                aRole = aRoleArray[aIdx];
                aRoleBaseDn = aRole.getManagedOrganizationDN();
                aTmpVector = DAConnection.getCacheProviderOrgs(aRoleBaseDn);
                aIterator = aTmpVector.iterator();
                while (aIterator.hasNext()) {
                    aProviderOrg = (DAProviderOrganization)aIterator.next();
                    DAUtil.addObjectToVector(aReturnVector, aProviderOrg, 1003);
                }
            }
            if (aReturnVector.size() > 0) {
                aReturnArray = new DAProviderOrganization[1];
                aReturnArray = aReturnVector.toArray(aReturnArray);
            }
            return aReturnArray;
        }
        String[] roles = this._loggedInUser.getAttributeValues("nsroledn");
        if (roles == null) {
            throw new UnsupportedOperationException("DAConnection.getProviderOrganization():" + _resourceSet.getString("error", "userInvalidRole"));
        }
        String providerOrgDn = null;
        for (int i = 0; i < roles.length; ++i) {
            int comma = roles[i].indexOf(",");
            String role_rdn = roles[i].substring(0, comma);
            if (!role_rdn.equalsIgnoreCase(DAConstants.PROVIDER_ADMIN)) continue;
            providerOrgDn = roles[i].substring(comma + 1);
            break;
        }
        if (providerOrgDn == null) {
            throw new UnsupportedOperationException("DAConnection.getProviderOrganization():" + _resourceSet.getString("error", "userInvalidRole"));
        }
        DAProviderOrganization tmpPO = new DAProviderOrganization();
        DAOrganization loc = new DAOrganization();
        loc.setDN(providerOrgDn);
        DAResults result = null;
        tmpPO.addAttribute("borgdn", new String[]{providerOrgDn});
        result = this.myTask.doTask("search", tmpPO, loc);
        if (result == null || result.getStatus().equals("FAIL")) {
            throw new DAException("DAConnection.getProviderOrganization():" + _resourceSet.getString("error", "providerOrgSearchFail"));
        }
        Vector returnedPOrgs = result.getSearchResult().getResultVector();
        DAProviderOrganization[] pOrgArr = new DAProviderOrganization[returnedPOrgs.size()];
        pOrgArr = returnedPOrgs.toArray(pOrgArr);
        return pOrgArr;
    }

    public DAProviderOrganization getProviderOrganization(String porgDn) throws DAException {
        if (porgDn == null || porgDn.length() == 0) {
            throw new DAException("getProviderOrganization(): " + _resourceSet.getString("error", "missingPOrgDn"));
        }
        porgDn = porgDn.trim();
        DAProviderOrganization toReturn = null;
        DAProviderOrganization tmpPO = new DAProviderOrganization();
        tmpPO.addAttribute("borgdn", new String[]{porgDn});
        DAResults results = null;
        DAOrganization tmpLoc = new DAOrganization(porgDn);
        try {
            results = this.myTask.doTask("search", tmpPO, tmpLoc);
        }
        catch (DAException de) {
            Debug.println((String)("getProvidersOrganization():exception while searching P.Org " + porgDn));
            throw de;
        }
        Vector POrgs = results.getSearchResult().getResultVector();
        if (POrgs.size() > 1) {
            Debug.println((String)"Internal error: more than 1 provider org matching!");
            return null;
        }
        toReturn = (DAProviderOrganization)POrgs.elementAt(0);
        DAAttribute objClasses = toReturn.getAttribute("objectClass");
        String[] objClassNames = objClasses.getValues();
        boolean validPOrg = false;
        for (int i = 0; i < objClassNames.length; ++i) {
            if (!objClassNames[i].equalsIgnoreCase("sunManagedProvider")) continue;
            validPOrg = true;
            break;
        }
        if (!validPOrg) {
            throw new DAException(_resourceSet.getString("error", "invalidPOrg"));
        }
        return toReturn;
    }

    public DAProviderOrganization[] getProviderOrganization(DASearchConstraint theConstraints) throws UnsupportedOperationException, DAException {
        if (DAConnection.getMode() == 102) {
            return null;
        }
        DAProviderOrganization aOrg = new DAProviderOrganization();
        DAResults result = new DAResults();
        String searchBase = theConstraints.getSearchBase();
        DAOrganization locationObj = null;
        Map avPairs = null;
        Set attrNames = null;
        String attrName = null;
        if (searchBase != null && searchBase.length() != 0) {
            locationObj = new DAOrganization();
            locationObj.setDN(searchBase);
        } else {
            locationObj = this.getBusinessOrganization("");
        }
        avPairs = theConstraints.getFilterAVPairs();
        avPairs.put("objectclass", "sunManagedProvider");
        if (avPairs != null) {
            attrNames = avPairs.keySet();
            Iterator itr = attrNames.iterator();
            while (itr.hasNext()) {
                attrName = (String)itr.next();
                aOrg.addAttribute(new DAAttribute(attrName, 2048, (String)avPairs.get(attrName)));
            }
        }
        aOrg.addAttributeList(theConstraints.getConstraintsAsAttributes());
        result = this.getMyTask().doTask("search", aOrg, locationObj);
        if (result == null || result.getStatus().equals("FAIL")) {
            throw new DAException("DAConnection.getProviderOrganization():" + _resourceSet.getString("error", "providerOrgSearchFail"));
        }
        Vector returnedPOrgs = result.getSearchResult().getResultVector();
        DAProviderOrganization[] pOrgArr = new DAProviderOrganization[returnedPOrgs.size()];
        pOrgArr = returnedPOrgs.toArray(pOrgArr);
        return pOrgArr;
    }

    public void modifyProviderOrganization(DAProviderOrganization theProviderOrganization) throws DAException {
        if (DAConnection.getMode() != 102) {
            this.getMyTask().doTask("modify", theProviderOrganization, theProviderOrganization);
        }
    }

    public void modifyBusinessOrganization(DABusinessOrganization theBusinessOrganization) throws DAException {
        if (DAConnection.getMode() != 102) {
            this.getMyTask().doTask("modify", theBusinessOrganization, theBusinessOrganization);
        }
    }

    public void close() throws DAException {
        try {
            this.cliObj.logout();
        }
        catch (Exception e) {
            Debug.println((String)"DBG:DAConnection:logout:exception: ");
            Debug.stackTrace((Exception)e);
            throw new DAException(e.getMessage());
        }
    }

    DATask getMyTask() {
        return this.myTask;
    }

    static DAServicePackageManager getServicePackageManager() {
        return _servicePackageManager;
    }

    static Vector getServicePackages(Vector theServicePackageNames) throws DAException {
        if (theServicePackageNames == null) {
            return null;
        }
        Iterator aIterator = theServicePackageNames.iterator();
        Vector<DAServicePackage> aSpVector = new Vector<DAServicePackage>();
        while (aIterator.hasNext()) {
            String aSpName = (String)aIterator.next();
            String aLowerCaseName = aSpName.toLowerCase();
            DAServicePackage aServicePackage = null;
            aServicePackage = _servicePackageManager.getServicePackage(aSpName);
            if (aServicePackage == null) continue;
            aSpVector.add(aServicePackage);
        }
        return aSpVector;
    }

    static DAServicePackage getServicePackage(String theServicePackageName) throws DAException {
        if (theServicePackageName == null) {
            return null;
        }
        return _servicePackageManager.getServicePackage(theServicePackageName);
    }

    public static void setMode(int theMode) throws Exception {
        Object aIterator = null;
        Vector aOrgNames = new Vector();
        String[] aStringArray = new String[1];
        Object aServices = null;
        Object aBusinessOrg = null;
        boolean aIdx = false;
        Object aServiceNames = null;
        Object aBorgServices = null;
        _mode = theMode;
        if (_mode == 102) {
            _providerOrgCache.add(DAConnection.createCannedProviderOrganization("ESG"));
            _businessOrgCache = DAConnection.createCannedBusinessOrgs(null, "o=ESG,o=managedmail.com,o=SharedDomainsRoot,o=Business,o=smi");
            DAConnection.createUsersForBusinessOrgs(_businessOrgCache);
            _providerOrgCache.add(DAConnection.createCannedProviderOrganization("VIS"));
            String[] defOrgArr = new String[]{"DEF"};
            _businessOrgCache.addAll(DAConnection.createCannedBusinessOrgs(defOrgArr, "o=VIS,o=managedmail.com,o=SharedDomainsRoot,o=Business,o=smi"));
            DAConnection.createCannedDEFUserList();
            _servicePackageManager.initCannedData();
        }
    }

    static int getMode() {
        return _mode;
    }

    public static void printCannedData() throws Exception {
        DAConnection aConnection = null;
        DAObject[] aBusinessOrgArray = null;
        DAObject[] aProviderOrgArray = null;
        DAObject aProviderOrg = null;
        DASearchResults aSearchResults = null;
        DAObject[] aServicePackageArray = null;
        int aIdx = 0;
        Vector aObjectsVector = null;
        Object aIterator = null;
        DASearchConstraint aConstraint = null;
        DAObject[] aObjectsArray = null;
        aConnection = DAConnection.authenticate("blink", 3891, "user1RST", "password", "RST", false);
        aProviderOrgArray = aConnection.getProviderOrganization();
        DAConnection.printArrayOfObjects("Provider Organizations", aProviderOrgArray);
        aBusinessOrgArray = aConnection.getBusinessOrganization();
        DAConnection.printArrayOfObjects("Business Organizations", aBusinessOrgArray);
        aConstraint = new DASearchConstraint("base", DASearchConstraint.SUBTREE_SCOPE, null);
        aConstraint.setFilter("*");
        for (aIdx = 0; aIdx < aProviderOrgArray.length; ++aIdx) {
            aProviderOrg = aProviderOrgArray[aIdx];
            aSearchResults = ((DAOrganization)aProviderOrg).searchUsers(aConstraint);
            aObjectsVector = aSearchResults.getResultVector();
            aObjectsArray = new DAObject[1];
            aObjectsArray = aObjectsVector.toArray(aObjectsArray);
            DAConnection.printArrayOfObjects("Users", aObjectsArray);
        }
        aProviderOrg = aProviderOrgArray[0];
        aServicePackageArray = ((DAOrganization)aProviderOrg).getServicePackages();
        DAConnection.printArrayOfObjects("Service Packages", aServicePackageArray);
    }

    static void printArrayOfObjects(String theName, DAObject[] theObjectArray) {
        int aIdx = 0;
        System.out.println("\n#" + theName + "\n");
        for (aIdx = 0; aIdx < theObjectArray.length; ++aIdx) {
            System.out.println("\n");
            theObjectArray[aIdx].print();
        }
    }

    static Vector getUserCache() {
        return _userCache;
    }

    static Vector getBusinessOrgCache() {
        return _businessOrgCache;
    }

    static Vector getProviderOrgCache() {
        return _providerOrgCache;
    }

    static Vector getCacheUsers(String thePartialDn) {
        if (thePartialDn == null) {
            return null;
        }
        return DAUtil.matchPartialDn(_userCache, DAUtil.normalizeDn(thePartialDn));
    }

    static Vector getCacheBusinessOrgs(String thePartialDn) {
        if (thePartialDn == null) {
            return null;
        }
        return DAUtil.matchPartialDn(_businessOrgCache, DAUtil.normalizeDn(thePartialDn));
    }

    static Vector getCacheProviderOrgs(String thePartialDn) {
        if (thePartialDn == null) {
            return null;
        }
        return DAUtil.matchPartialDn(_providerOrgCache, DAUtil.normalizeDn(thePartialDn));
    }

    static void createCannedDEFUserList() {
        for (int i = 1; i < 4; ++i) {
            String uid = "user" + i;
            DAUser aUser = new DAUser();
            aUser.setDN("uid=" + uid + ",ou=People,o=DEF," + "o=VIS,o=managedmail.com,o=SharedDomainsRoot,o=Business,o=smi");
            aUser.setAttributeValues(DAConstants.UID, uid);
            aUser.setFirstName(uid);
            aUser.setLastName("testor");
            aUser.setAttributeValues(DAConstants.PASSWORD, "password");
            aUser.setAttributeValues("inetUserStatus", "active");
            aUser.setAttributeValues("cn", uid + " " + "testor");
            if (i == 1) {
                aUser.setAttributeValues("nsroledn", "cn=Organization Admin Role,o=VIS,o=managedmail.com,o=SharedDomainsRoot,o=Business,o=smi");
            }
            _userCache.add(aUser);
        }
    }

    static void createUsersForBusinessOrgs(Vector theBusinessOrgs) {
        int aBusinessOrgCount = theBusinessOrgs.size();
        int aIdx = 0;
        boolean aInnerIdx = false;
        DABusinessOrganization aBusinessOrg = null;
        Object aServices = null;
        String[] aBorgNamesArray = null;
        String[] aBorgServicesArray = null;
        aBusinessOrgCount = theBusinessOrgs.size();
        aBorgNamesArray = new String[aBusinessOrgCount];
        aBorgServicesArray = new String[aBusinessOrgCount];
        for (aIdx = 0; aIdx < aBusinessOrgCount; ++aIdx) {
            aBusinessOrg = (DABusinessOrganization)theBusinessOrgs.elementAt(aIdx);
            aBorgNamesArray[aIdx] = aBusinessOrg.getName();
            if (aBorgNamesArray[aIdx].equalsIgnoreCase("RST")) {
                aBorgServicesArray[aIdx] = "gold";
            }
            if (aBorgNamesArray[aIdx].equalsIgnoreCase("UVW")) {
                aBorgServicesArray[aIdx] = "silver";
            }
            if (!aBorgNamesArray[aIdx].equalsIgnoreCase("XYZ")) continue;
            aBorgServicesArray[aIdx] = "bronze";
        }
        DAConnection.createCannedUserList(aBorgNamesArray, "o=ESG,o=managedmail.com,o=SharedDomainsRoot,o=Business,o=smi", null);
    }

    static void createCannedUserList(String[] bOrgNames, String containerDn, String[] theServices) {
        for (int i = 0; i < bOrgNames.length; ++i) {
            for (int j = 0; j < 10; ++j) {
                String uid = "user" + (j + 1) + bOrgNames[i];
                String userDn = "uid=" + uid + ",ou=People," + "o=" + bOrgNames[i] + "," + containerDn;
                DAUser aUser = new DAUser();
                aUser.setDN(userDn);
                aUser.setAttributeValues(DAConstants.UID, uid);
                aUser.setFirstName("Test");
                aUser.setLastName(uid);
                aUser.setAttributeValues("inetUserStatus", "active");
                aUser.setAttributeValues("cn", "Test" + uid);
                aUser.setAttributeValues(DAConstants.PASSWORD, "secret");
                if (theServices != null) {
                    aUser.setAttributeValues("inetcos", theServices[i]);
                    DAConnection.setMailServices(aUser, theServices[i]);
                }
                if (j == 0) {
                    String bOrgDn = "o=" + bOrgNames[i] + "," + containerDn;
                    aUser.setAttributeValues("nsroledn", "cn=organization admin role," + bOrgDn);
                    if (bOrgNames[i].equalsIgnoreCase("RST")) {
                        aUser.addAttributeValue("nsroledn", "cn=provider admin role,o=ESG,o=managedmail.com,o=SharedDomainsRoot,o=Business,o=smi");
                    }
                }
                _userCache.add(aUser);
            }
        }
    }

    static void setMailServices(DAUser theUser, String theServiceName) {
    }

    static DAProviderOrganization createCannedProviderOrganization(String name) {
        DAProviderOrganization cannedProviderOrgNode = new DAProviderOrganization();
        cannedProviderOrgNode.setAttributeValues("o", name);
        cannedProviderOrgNode.setName(name);
        cannedProviderOrgNode.setDN("o=" + name + ",o=managedmail.com,o=SharedDomainsRoot,o=Business,o=smi");
        String[] allowedTypes = new String[]{"full", "shared"};
        cannedProviderOrgNode.setAttributeValues("sunallowbusinessorgtype", allowedTypes);
        cannedProviderOrgNode.setAttributeValues("sunbusinessorgbase", "o=" + name + "DomainsRoot,o=Business,o=smi");
        String[] svcs = new String[]{"gold", "silver", "bronze"};
        cannedProviderOrgNode.setAttributeValues("sunincludeservices", svcs);
        String[] aDomains = new String[]{"managedmail.com", "verizonmail.net"};
        cannedProviderOrgNode.setAttributeValues("sunassignabledomains", aDomains);
        cannedProviderOrgNode.setAttributeValues("sunallowmultipledomains", "true");
        cannedProviderOrgNode.setAttributeValues("sunallowoutsideadmins", "false");
        cannedProviderOrgNode.setAttributeValues("inetDomainStatus", "Active");
        return cannedProviderOrgNode;
    }

    static Vector createCannedBusinessOrgs(String[] theBusinessOrgNames, String providerOrgDN) {
        int aIdx = 0;
        String[][] aSharedDomains = new String[][]{{"managedmail.com", "verizon.net"}, {"managedmail.com", "verizon.org"}, {"managedmail.com", "verizon.com"}};
        String[][] aAvailableServices = new String[][]{{"gold:20", "silver:30", "bronze:40"}, {"silver:50", "bronze:60"}, {"gold:70", "bronze:80"}};
        String[] aBusinessOrgNames = new String[]{"RST", "UVW", "XYZ"};
        DABusinessOrganization aBusinessOrg = null;
        Vector<DABusinessOrganization> aBorgVector = new Vector<DABusinessOrganization>();
        if (theBusinessOrgNames != null) {
            aBusinessOrgNames = theBusinessOrgNames;
        }
        for (aIdx = 0; aIdx < aBusinessOrgNames.length; ++aIdx) {
            aBusinessOrg = DAConnection.createACannedBusinessOrg(aBusinessOrgNames[aIdx], aSharedDomains[aIdx], aAvailableServices[aIdx], providerOrgDN);
            aBorgVector.add(aBusinessOrg);
        }
        return aBorgVector;
    }

    static DABusinessOrganization createACannedBusinessOrg(String theName, String[] theSharedDomains, String[] theServices, String theProviderOrgDn) {
        DABusinessOrganization aBusinessOrg = new DABusinessOrganization();
        aBusinessOrg.setName(theName);
        aBusinessOrg.setDn("o=" + theName + "," + theProviderOrgDn);
        aBusinessOrg.setAttributeValues("dn", "o=" + theName + "," + theProviderOrgDn);
        aBusinessOrg.setAttributeValues(DAConstants.AVAILABLE_DOMAIN_NAMES, theSharedDomains);
        aBusinessOrg.setAttributeValues(DAConstants.AVAILABLE_SERVICES, theServices);
        aBusinessOrg.setAttributeValues(DAConstants.BUSINESS_ORG_TYPE, "shared");
        aBusinessOrg.setAttributeValues(DAConstants.MAX_USERS, "15");
        aBusinessOrg.setAttributeValues(DAConstants.NUMBER_OF_USERS, "10");
        aBusinessOrg.setAttributeValues(DAConstants.MAX_GROUPS, "0");
        aBusinessOrg.setAttributeValues(DAConstants.NUMBER_OF_GROUPS, "0");
        aBusinessOrg.setAttributeValues(DAConstants.ENABLE_GAB, "false");
        aBusinessOrg.setAttributeValues(DAConstants.ALLOW_MULTIPLE_SERVICES, "true");
        aBusinessOrg.setAttributeValues("inetDomainStatus", "Active");
        return aBusinessOrg;
    }
}

