/*
 * Decompiled with CFR 0.152.
 */
package sun.comm.client;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import sun.comm.client.BadLoginException;
import sun.comm.client.CLIInteractive;
import sun.comm.client.CLIObject;
import sun.comm.client.CLIValidOptions;
import sun.comm.client.CommAdmin;
import sun.comm.client.Debug;
import sun.comm.client.InvalidOptionException;
import sun.comm.client.MissingOptionException;
import sun.comm.client.NoMoreOptionsException;
import sun.comm.client.ServletInfo;

public class CLITask
extends CLIObject {
    static final String sccs_id = "%W% %G% SMI";
    private String[][] validConnOptionsArray = new String[][]{{"D", "true", "", "true", "true", "ObjectOptDesc_binddn", ""}, {"n", "true", "", "true", "true", "ObjectOptDesc_domain", ""}, {"p", "true", "", "true", "true", "ObjectOptDesc_ldapport", ""}, {"w", "true", "", "true", "false", "ObjectOptDesc_bindpw", ""}, {"X", "true", "", "true", "true", "ObjectOptDesc_ldaphost", ""}};
    private CLIValidOptions connValidOptions = null;
    private CLIValidOptions perIterValidOptions = null;
    private ServletInfo[] servInfo = null;
    private static final String APPKEY = "appName";
    private static final String DEFAULTAPPNAME = "commcli";
    private static final String ARGSEPARATOR = "+";
    private static final String CLIMODIFYARG = "CLIModifyArg";
    private String usageObject = null;
    private String usageTask = null;
    private String bindUser;
    private String bindPw;
    private String bindDomain;

    public String getClassVersion() {
        return sccs_id;
    }

    public CLITask() {
    }

    public CLITask(boolean secure) {
        super(secure);
    }

    public String getUsageObject() {
        return this.usageObject;
    }

    public String getUsageTask() {
        return this.usageTask;
    }

    public int doStuff(String[] argv) throws InvalidOptionException, MissingOptionException {
        String[] taskObjArgsArray = null;
        String[] allArgs = null;
        Hashtable optionArgs = new Hashtable();
        Hashtable commandOnlyTable = null;
        for (int g = 0; g < argv.length; ++g) {
            String usrPw;
            String bindPw;
            String optionName = argv[g].trim();
            if (optionName.equalsIgnoreCase("-w") && new File(bindPw = argv[g + 1]).exists()) {
                argv[g + 1] = bindPw = this.readPasswordFile(bindPw);
            }
            if (!optionName.equalsIgnoreCase("-W") || !new File(usrPw = argv[g + 1]).exists()) continue;
            this.bindPw = this.readPasswordFile(usrPw);
            argv[g + 1] = usrPw;
        }
        int iterationNum = 0;
        if (argv == null || argv.length < 2) {
            Debug.println("Not Implemented connxn yet !");
            return -1;
        }
        String object = argv[0];
        String task = argv[1];
        Debug.println("DBG:Object = " + object + " ; " + "task = " + task);
        taskObjArgsArray = new String[argv.length - 2];
        for (int i = 0; i < argv.length - 2; ++i) {
            taskObjArgsArray[i] = argv[i + 2];
        }
        this.connValidOptions = new CLIValidOptions(this.validConnOptionsArray);
        this.setDefaultProperties(this.connValidOptions);
        this.parseOptionValues(optionArgs, this.connValidOptions, taskObjArgsArray);
        allArgs = taskObjArgsArray;
        int returnCode = 6;
        iterationNum = 0;
        while (true) {
            block37: {
                block38: {
                    block36: {
                        block35: {
                            if (iterationNum == 0) {
                                this.allValidOptions = this.connValidOptions.getCopy();
                            }
                            try {
                                this.promptMissingValues(optionArgs, this.allValidOptions);
                            }
                            catch (MissingOptionException e) {
                                if (!CommAdmin.getNonInteractive()) {
                                    throw e;
                                }
                                if (iterationNum <= 0) break block35;
                                CLIInteractive.printMissing(e.getMessage());
                            }
                        }
                        this.bindUser = this.getOptionArg(optionArgs, "D");
                        this.bindPw = this.getOptionArg(optionArgs, "w");
                        this.bindDomain = this.getOptionArg(optionArgs, "n");
                        String ndaHost = this.getOptionArg(optionArgs, "X");
                        int ndaPort = 0;
                        try {
                            ndaPort = Integer.valueOf(this.getOptionArg(optionArgs, "p"));
                        }
                        catch (NumberFormatException e) {
                            this.invalidValue(optionArgs, this.allValidOptions, "p");
                        }
                        this.setCurrentHostPort(ndaHost, ndaPort);
                        int status = 0;
                        try {
                            this.authenticate(this.bindUser, this.bindPw, this.bindDomain);
                        }
                        catch (MalformedURLException e) {
                            CLIInteractive.printError(e.getMessage());
                            e.printStackTrace();
                        }
                        catch (IOException e) {
                            CLIInteractive.printError(e.getMessage());
                            this.invalidValue(optionArgs, this.allValidOptions, "X");
                            this.invalidValue(optionArgs, this.allValidOptions, "p");
                            status = 3;
                            if (CommAdmin.getNonInteractive()) break block36;
                            break block37;
                        }
                        catch (BadLoginException e) {
                            this.invalidValue(optionArgs, this.allValidOptions, "D");
                            this.invalidValue(optionArgs, this.allValidOptions, "w");
                            this.invalidValue(optionArgs, this.allValidOptions, "n");
                            if (!CommAdmin.getNonInteractive()) break block37;
                        }
                    }
                    Debug.println("DBG: before getobjtaskargs");
                    try {
                        if (this.servInfo == null) {
                            this.servInfo = this.getObjTaskArgs(object, task);
                            if (this.servInfo != null && this.servInfo.length > 0 && this.servInfo[0].isJDAPIOnly()) {
                                Debug.println("CLITask: illegal command in CLI context:object=" + object + ",task=" + task);
                                CLIInteractive.printError(this.res.getString("IllegalCommand"));
                                return 101;
                            }
                            Debug.println("DBG: getObjTaskArgs done");
                        }
                    }
                    catch (BadLoginException e) {
                    }
                    catch (Exception e) {
                        Debug.println("doStuff, Excptn: " + e.getMessage());
                        Debug.stackTrace(e);
                        CLIInteractive.printError(e.getMessage());
                    }
                    CLIValidOptions validObjTaskOptions = null;
                    for (int i = 0; this.servInfo != null && i < this.servInfo.length; ++i) {
                        validObjTaskOptions = this.servInfo[i].getValidOptions();
                        this.allValidOptions.addValidOptions(validObjTaskOptions);
                    }
                    if (this.servInfo != null) {
                        this.usageObject = object;
                        this.usageTask = task;
                    } else {
                        Debug.println("servinfo == null");
                    }
                    if (CommAdmin.getPrintUsage() || CommAdmin.getPrintVersion()) break;
                    this.perIterValidOptions = this.allValidOptions.getCopy();
                    try {
                        String key;
                        Enumeration keys;
                        boolean inputFilePresent = CommAdmin.getInputFile() != null;
                        String[] argsLeft = null;
                        if (iterationNum > 0 && inputFilePresent) {
                            optionArgs = new Hashtable();
                            keys = commandOnlyTable.keys();
                            while (keys.hasMoreElements()) {
                                key = (String)keys.nextElement();
                                optionArgs.put(key, commandOnlyTable.get(key));
                            }
                        } else {
                            argsLeft = this.parseOptionValues(optionArgs, this.perIterValidOptions, allArgs, true);
                            commandOnlyTable = new Hashtable();
                            keys = optionArgs.keys();
                            while (keys.hasMoreElements()) {
                                key = (String)keys.nextElement();
                                commandOnlyTable.put(key, optionArgs.get(key));
                            }
                        }
                        if (inputFilePresent) {
                            allArgs = this.parseNextOptionValues(optionArgs, this.perIterValidOptions);
                        }
                        if (argsLeft != null && argsLeft.length > 0) {
                            throw new InvalidOptionException("Unknown options/additional data entered.");
                        }
                        returnCode = this.doOne(object, task, optionArgs);
                        Debug.println("DBG: doOne returned code=" + returnCode);
                    }
                    catch (InvalidOptionException e) {
                        returnCode = 2;
                        CLIInteractive.printUnknown(e.getMessage());
                        if (CommAdmin.getNonInteractive()) break block38;
                        CommAdmin.setPrintUsage(true);
                    }
                    catch (MissingOptionException e) {
                        returnCode = 3;
                        if (iterationNum <= 0) break block38;
                        CLIInteractive.printMissing(e.getMessage());
                    }
                    catch (NoMoreOptionsException e) {
                        break;
                    }
                }
                if (CommAdmin.getInputFile() == null) break;
            }
            ++iterationNum;
        }
        try {
            this.logout();
        }
        catch (Exception e) {
            Debug.println("logout exception: " + e.getMessage());
        }
        this.dsMesg = null;
        this.successMesg = null;
        return returnCode;
    }

    /*
     * Unable to fully structure code
     */
    public int doOne(String object, String task, Hashtable args) throws MissingOptionException {
        validObjTaskOptions = null;
        ObjTaskoptionMultiValues = null;
        resp = null;
        if (this.servInfo == null) {
            return 0;
        }
        Debug.println("servInfo len = " + this.servInfo.length);
        for (servNum = 0; servNum < this.servInfo.length; ++servNum) {
            promptAll = false;
            missingRequired = true;
            while (missingRequired) {
                missingRequired = false;
                validObjTaskOptions = this.servInfo[servNum].getValidOptions();
                appName = this.cliRes.getString("appName");
                if (appName == null || appName.length() == 0) {
                    appName = "commcli";
                }
                servlet = "/" + appName + "/" + this.servInfo[servNum].getName();
                servArg = this.servInfo[servNum].getservletArgs();
                this.promptMissingValues(args, this.perIterValidOptions, promptAll);
                servCommand = null;
                for (argNum = 0; argNum < servArg.length; ++argNum) {
                    servCommand = servCommand == null ? servArg[argNum] : servCommand + "&" + servArg[argNum];
                }
                for (optNum = 0; !missingRequired && optNum < this.perIterValidOptions.size(); ++optNum) {
                    currentOption = this.perIterValidOptions.getName(optNum);
                    servArgDesc = this.perIterValidOptions.getArgPrefix(optNum);
                    ObjTaskoptionMultiValues = this.getOptionArgs(args, currentOption);
                    block10: for (j = 0; ObjTaskoptionMultiValues != null && !missingRequired && j < ObjTaskoptionMultiValues.length; ++j) {
                        argVal = ObjTaskoptionMultiValues[j];
                        st = new StringTokenizer(servArgDesc, "+");
                        if (argVal == null || argVal.equals("")) continue;
                        if (argVal.startsWith("\\")) {
                            argVal = argVal.substring(1);
                        }
                        while (st.hasMoreTokens()) {
                            block50: {
                                block51: {
                                    block49: {
                                        prefix = st.nextToken();
                                        if (this.perIterValidOptions.getTakesArg(optNum)) break block49;
                                        servCommand = servCommand + "&" + prefix;
                                        break block50;
                                    }
                                    if (!object.equalsIgnoreCase("group") || !currentOption.equals("m") && !currentOption.equals("M") && !currentOption.equals("f")) break block51;
                                    if (!task.equalsIgnoreCase("modify")) ** GOTO lbl52
                                    if (argVal.startsWith("+")) {
                                        prefix = "add_";
                                        argVal = argVal.substring(1);
                                    } else if (argVal.startsWith("-")) {
                                        prefix = "delete_";
                                        argVal = argVal.substring(1);
                                    } else {
                                        this.invalidValue(args, this.perIterValidOptions, currentOption, this.res.getString("MissingAction"));
                                        missingRequired = true;
                                        continue block10;
lbl52:
                                        // 1 sources

                                        if (task.equalsIgnoreCase("create")) {
                                            if (argVal.startsWith("+")) {
                                                prefix = "add_";
                                                argVal = argVal.substring(1);
                                            } else {
                                                if (argVal.startsWith("-")) {
                                                    this.invalidValue(args, this.perIterValidOptions, currentOption, this.res.getString("ActionNotAllowed"));
                                                    missingRequired = true;
                                                    continue block10;
                                                }
                                                prefix = "add_";
                                            }
                                        }
                                    }
                                    attrName = currentOption.equals("m") != false ? "uniquemember" : (currentOption.equals("M") != false ? "mgrprfc822mailmember" : "memberurl");
                                    servCommand = servCommand + "&" + prefix + attrName + "=" + this.MyURLEncoder(argVal);
                                    break block50;
                                }
                                if (currentOption.equals("R")) {
                                    if (prefix.equalsIgnoreCase("CLIModifyArg")) {
                                        Debug.println("With 'R' received for modify command: " + prefix);
                                        if (argVal.startsWith("+")) {
                                            prefix = "add_";
                                            argVal = argVal.substring(1);
                                        } else if (argVal.startsWith("-")) {
                                            prefix = "delete_";
                                            argVal = argVal.substring(1);
                                        } else {
                                            prefix = "replace_";
                                        }
                                        attrName = "icsallowrights";
                                        servCommand = servCommand + "&" + prefix + attrName + "=" + this.MyURLEncoder(argVal);
                                    } else if (task.equalsIgnoreCase("create")) {
                                        if (argVal.startsWith("+")) {
                                            prefix = "add_";
                                            argVal = argVal.substring(1);
                                        } else {
                                            if (argVal.startsWith("-")) {
                                                this.invalidValue(args, this.perIterValidOptions, currentOption, this.res.getString("ActionNotAllowed"));
                                                missingRequired = true;
                                                continue block10;
                                            }
                                            prefix = "add_";
                                        }
                                        attrName = "icsallowrights";
                                        servCommand = servCommand + "&" + prefix + attrName + "=" + this.MyURLEncoder(argVal);
                                    }
                                } else if (currentOption.equals("A")) {
                                    if (task.equalsIgnoreCase("create")) {
                                        Debug.println("Option 'A' recvd for create command: " + prefix);
                                        if (argVal.startsWith("+")) {
                                            argVal = argVal.substring(1);
                                        } else if (argVal.startsWith("-")) {
                                            this.invalidValue(args, this.perIterValidOptions, currentOption, this.res.getString("ActionNotAllowed"));
                                            missingRequired = true;
                                            continue block10;
                                        }
                                    } else if (prefix.equalsIgnoreCase("CLIModifyArg")) {
                                        Debug.println("With 'A' recvd for modify command: " + prefix);
                                        if (argVal.startsWith("+")) {
                                            prefix = "add_";
                                            argVal = argVal.substring(1);
                                        } else if (argVal.startsWith("-")) {
                                            prefix = "delete_";
                                            argVal = argVal.substring(1);
                                        } else {
                                            prefix = "replace_";
                                        }
                                    }
                                    index = argVal.indexOf(":");
                                    if (index <= 0) {
                                        this.invalidMultiValue(args, this.perIterValidOptions, "A", j + 1);
                                        missingRequired = true;
                                        continue block10;
                                    }
                                    Debug.println("argVal.substring(index+1) =" + argVal.substring(index + 1));
                                    servCommand = servCommand + "&" + prefix + argVal.substring(0, index).toLowerCase() + "=" + this.MyURLEncoder(argVal.substring(index + 1));
                                } else {
                                    Debug.println("argVal =" + argVal);
                                    servCommand = servCommand + "&" + prefix + "=" + this.MyURLEncoder(argVal);
                                }
                            }
                            Debug.println("servCommand =" + servCommand);
                        }
                    }
                }
                if (servCommand != null && servCommand.startsWith("&")) {
                    servCommand = servCommand.substring(1);
                }
                if (missingRequired) continue;
                try {
                    if (missingRequired) continue;
                    resp = this.sendservCommand(servlet, servCommand);
                }
                catch (IOException e) {
                    CLIInteractive.printError(e.getMessage());
                    return 4;
                }
                catch (InvalidOptionException e) {
                    missingRequired = true;
                    promptAll = true;
                }
                catch (BadLoginException e) {
                    try {
                        this.authenticate(this.bindUser, this.bindPw, this.bindDomain);
                    }
                    catch (Exception e1) {
                        CLIInteractive.printError(e1.getMessage());
                    }
                }
            }
            if (resp == null) continue;
            this.rcStat = (String)resp.elementAt(0);
            Debug.println("CLITask: status returned =" + this.rcStat);
            if (this.rcStat.equals("FAIL")) break;
        }
        return this.printStatus(resp);
    }

    public String MyURLEncoder(String data) {
        try {
            return URLEncoder.encode(data, "UTF-8");
        }
        catch (Exception e) {
            Debug.println("exception =" + e.toString());
            return data;
        }
    }

    private String readPasswordFile(String fileName) throws InvalidOptionException {
        BufferedReader reader = null;
        String toReturn = null;
        try {
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(fileName)));
            toReturn = reader.readLine();
        }
        catch (Exception e) {
            throw new InvalidOptionException(this.res.getString("COULDNOTREADPASSWORDFILE"));
        }
        if (toReturn == null) {
            throw new InvalidOptionException(this.res.getString("PASSWORDFILEEMPTY"));
        }
        return toReturn;
    }
}

