/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comm.jdapi;

import com.sun.comm.jdapi.DAAttribute;
import com.sun.comm.jdapi.DABusinessOrganization;
import com.sun.comm.jdapi.DAGroup;
import com.sun.comm.jdapi.DAObject;
import com.sun.comm.jdapi.DAOrganization;
import com.sun.comm.jdapi.DAProviderOrganization;
import com.sun.comm.jdapi.DAResource;
import com.sun.comm.jdapi.DASearchConstraint;
import com.sun.comm.jdapi.DASearchResults;
import com.sun.comm.jdapi.DAServicePackage;
import com.sun.comm.jdapi.DASpNameCount;
import com.sun.comm.jdapi.DASpSearch;
import com.sun.comm.jdapi.DASpSearchItem;
import com.sun.comm.jdapi.DATask;
import com.sun.comm.jdapi.DAUser;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DAUtil {
    public static void addAStringToVector(Vector theVector, String theString, int theDuplicateSwitch, int theCaseSwitch) {
        int aIndex = 0;
        if (theVector == null || theString == null) {
            return;
        }
        if (theDuplicateSwitch == 1002) {
            theVector.add(theString);
        } else {
            aIndex = DAUtil.findStringInVector(theVector, theString, theCaseSwitch);
            if (aIndex < 0) {
                theVector.add(theString);
            }
        }
    }

    public static void removeAStringFromVector(Vector theVector, String theString, int theCaseSwitch) {
        int aIndex = 0;
        if (theVector == null || theString == null) {
            return;
        }
        while ((aIndex = DAUtil.findStringInVector(theVector, theString, theCaseSwitch)) >= 0) {
            theVector.removeElementAt(aIndex);
        }
    }

    public static void removeStringsFromVector(Vector theVector, String[] theStrings, int theCaseSwitch) {
        int aIdx = 0;
        if (theVector == null || theStrings == null) {
            return;
        }
        for (aIdx = 0; aIdx < theStrings.length; ++aIdx) {
            DAUtil.removeAStringFromVector(theVector, theStrings[aIdx], theCaseSwitch);
        }
    }

    public static void addStringsToVector(Vector theVector, String[] theStrings, int theDuplicateSwitch, int theCaseSwitch) {
        Object aValue = null;
        int aIdx = 0;
        if (theStrings == null) {
            return;
        }
        for (aIdx = 0; aIdx < theStrings.length; ++aIdx) {
            DAUtil.addAStringToVector(theVector, theStrings[aIdx], theDuplicateSwitch, theCaseSwitch);
        }
    }

    public static int findStringInVector(Vector theVector, String theString, int theCaseSwitch) {
        int aIndex = -1;
        int aIdx = 0;
        Object aStrings = null;
        String aStringValue = null;
        Iterator aIterator = null;
        if (theVector == null || theString == null) {
            return 0;
        }
        aIterator = theVector.iterator();
        aIdx = 0;
        while (aIterator.hasNext()) {
            aStringValue = (String)aIterator.next();
            if (theCaseSwitch == 1001) {
                if (aStringValue.equals(theString)) {
                    aIndex = aIdx;
                    break;
                }
            } else if (aStringValue.equalsIgnoreCase(theString)) {
                aIndex = aIdx;
                break;
            }
            ++aIdx;
        }
        return aIndex;
    }

    public static void addObjectToVector(Vector theVector, Object theObject, int theDuplicateSwitch) {
        int aIndex = 0;
        if (theVector == null || theObject == null) {
            return;
        }
        if (theDuplicateSwitch == 1002) {
            theVector.add(theObject);
        } else {
            aIndex = DAUtil.findObjectInVector(theVector, theObject);
            if (aIndex < 0) {
                theVector.add(theObject);
            } else {
                theVector.removeElementAt(aIndex);
                theVector.add(theObject);
            }
        }
    }

    static Object getObjectInVector(Vector theVector, Object theObject) {
        int aIndex = 0;
        if (theObject == null || theVector == null) {
            return null;
        }
        aIndex = DAUtil.findObjectInVector(theVector, theObject);
        if (aIndex > -1) {
            return theVector.elementAt(aIndex);
        }
        return null;
    }

    static void removeObjectFromVector(Vector theVector, String theObjectName) {
        DAObject aObject = null;
        if (theObjectName == null) {
            return;
        }
        aObject = new DAObject();
        aObject.setName(theObjectName);
        DAUtil.removeObjectFromVector(theVector, aObject);
    }

    static void removeObjectFromVector(Vector theVector, Object theObject) {
        int aIndex = 0;
        if (theObject == null || theVector == null) {
            return;
        }
        aIndex = DAUtil.findObjectInVector(theVector, theObject);
        if (aIndex > -1) {
            theVector.removeElementAt(aIndex);
        }
    }

    static int findObjectInVector(Vector theVector, Object theObject) {
        int aIndex = -1;
        boolean aIdx = false;
        Object aObject = null;
        Object aIterator = null;
        if (theVector == null || theObject == null) {
            return 0;
        }
        return theVector.indexOf(theObject);
    }

    static Vector matchPartialDn(Vector theVector, String thePartialDn) {
        Vector<DAObject> aReturnVector = new Vector<DAObject>();
        DAObject aObject = null;
        Iterator aIterator = null;
        if (theVector == null || thePartialDn == null) {
            return aReturnVector;
        }
        aIterator = theVector.iterator();
        while (aIterator.hasNext()) {
            aObject = (DAObject)aIterator.next();
            if (!aObject.matchPartialDn(thePartialDn)) continue;
            aReturnVector.add(aObject);
        }
        return aReturnVector;
    }

    public static String[] addStringToArray(String[] theStringArray, String theStringToAdd, int theDuplicatesSwitch, int theCaseSwitch) {
        String[] aReturnArray = null;
        int aIdx = 0;
        if (theStringToAdd == null) {
            return null;
        }
        if (theStringArray == null) {
            aReturnArray = new String[]{theStringToAdd};
        } else if (theDuplicatesSwitch == 1003 && DAUtil.isPresentInArray(theStringArray, theStringToAdd, theCaseSwitch) >= 0) {
            aReturnArray = theStringArray;
        }
        if (aReturnArray == null && (aReturnArray = new String[theStringArray.length + 1]) != null) {
            for (aIdx = 0; aIdx < theStringArray.length; ++aIdx) {
                aReturnArray[aIdx] = theStringArray[aIdx];
            }
            aReturnArray[aIdx] = theStringToAdd;
        }
        return aReturnArray;
    }

    public static String[] removeStringFromArray(String[] theStringArray, String theStringToRemove, int theCaseSwitch) {
        String[] aReturnArray = null;
        boolean aStringFound = false;
        int aIdx = 0;
        int aNewIdx = 0;
        int aMatchCount = 0;
        if (theStringArray == null || theStringToRemove == null) {
            return null;
        }
        aMatchCount = DAUtil.isPresentInArray(theStringArray, theStringToRemove, theCaseSwitch);
        if (aMatchCount == 0) {
            return theStringArray;
        }
        aReturnArray = new String[theStringArray.length - aMatchCount];
        if (aReturnArray == null) {
            return null;
        }
        aNewIdx = 0;
        for (aIdx = 0; aIdx < theStringArray.length - 1; ++aIdx) {
            aStringFound = theCaseSwitch == 1001 ? theStringToRemove.equalsIgnoreCase(theStringArray[aIdx]) : theStringToRemove.equals(theStringArray[aIdx]);
            if (aStringFound) continue;
            aReturnArray[aNewIdx] = theStringArray[aIdx];
            ++aNewIdx;
        }
        return aReturnArray;
    }

    public static int isPresentInArray(String[] theStringArray, String theTargetString, int theCaseSwitch) {
        int aIdx = 0;
        int aMatchCount = 0;
        if (theStringArray == null || theTargetString == null) {
            return 0;
        }
        for (aIdx = 0; aIdx < theStringArray.length; ++aIdx) {
            if (theCaseSwitch == 1001) {
                if (!theTargetString.equalsIgnoreCase(theStringArray[aIdx])) continue;
                ++aMatchCount;
                continue;
            }
            if (!theTargetString.equals(theStringArray[aIdx])) continue;
            ++aMatchCount;
        }
        return aMatchCount;
    }

    static String normalizeDn(String theDn) {
        String aReturnDn = new String();
        String[] aSplitDn = null;
        int aIdx = 0;
        if (theDn == null) {
            return null;
        }
        aSplitDn = theDn.split(",");
        for (aIdx = 0; aIdx < aSplitDn.length; ++aIdx) {
            aReturnDn = aIdx == aSplitDn.length - 1 ? aReturnDn.concat(aSplitDn[aIdx].trim()) : aReturnDn.concat(aSplitDn[aIdx].trim() + ",");
        }
        return aReturnDn;
    }

    static Vector convertToVector(DAServicePackage[] theSpArray) {
        int aIdx = 0;
        Vector<DAServicePackage> aReturnVector = new Vector<DAServicePackage>();
        if (theSpArray == null) {
            return aReturnVector;
        }
        for (aIdx = 0; aIdx < theSpArray.length; ++aIdx) {
            aReturnVector.add(theSpArray[aIdx]);
        }
        return aReturnVector;
    }

    static Vector convertToVector(String[] theStringArray) {
        int aIdx = 0;
        Vector<String> aReturnVector = new Vector<String>();
        if (theStringArray == null) {
            return aReturnVector;
        }
        for (aIdx = 0; aIdx < theStringArray.length; ++aIdx) {
            aReturnVector.add(theStringArray[aIdx]);
        }
        return aReturnVector;
    }

    static Vector convertToVector(Object[] theArray) {
        Vector<Object> aReturnVector = new Vector<Object>();
        int aIdx = 0;
        if (theArray == null) {
            return aReturnVector;
        }
        for (aIdx = 0; aIdx < theArray.length; ++aIdx) {
            aReturnVector.add(theArray[aIdx]);
        }
        return aReturnVector;
    }

    static Vector convertToVector(Map theMap) {
        Object aKeySet = null;
        Iterator aIterator = null;
        Vector aReturnVector = new Vector();
        if (theMap == null || theMap.size() == 0) {
            return aReturnVector;
        }
        aIterator = theMap.keySet().iterator();
        while (aIterator.hasNext()) {
            aReturnVector.add(theMap.get(aIterator.next()));
        }
        return aReturnVector;
    }

    static Vector convertToVector(Set theSet) {
        Iterator aIterator = null;
        Vector aReturnVector = new Vector();
        if (theSet == null || theSet.size() == 0) {
            return aReturnVector;
        }
        aIterator = theSet.iterator();
        while (aIterator.hasNext()) {
            aReturnVector.add(aIterator.next());
        }
        return aReturnVector;
    }

    public static Vector convertToDaSpNameVector(String[] theServiceStrings) {
        DASpNameCount aSpNameCount = null;
        Vector<DASpNameCount> aReturnVector = new Vector<DASpNameCount>();
        int aIdx = 0;
        if (theServiceStrings == null) {
            return aReturnVector;
        }
        for (aIdx = 0; aIdx < theServiceStrings.length; ++aIdx) {
            aSpNameCount = new DASpNameCount(theServiceStrings[aIdx]);
            aReturnVector.add(aSpNameCount);
        }
        return aReturnVector;
    }

    public static Vector convertToDaSpNameVector(Map theServiceMap) {
        DASpNameCount aNewService = null;
        Vector<DASpNameCount> aReturnVector = new Vector<DASpNameCount>();
        Iterator aIterator = null;
        String aServiceName = null;
        String aServiceStringCount = null;
        int aServiceCount = 0;
        if (theServiceMap == null) {
            return aReturnVector;
        }
        aIterator = theServiceMap.keySet().iterator();
        while (aIterator.hasNext()) {
            aServiceName = (String)aIterator.next();
            aServiceStringCount = ((Integer)theServiceMap.get(aServiceName)).toString();
            aServiceCount = aServiceStringCount == null ? -1 : Integer.parseInt(aServiceStringCount);
            aNewService = new DASpNameCount(aServiceName, aServiceCount);
            aReturnVector.add(aNewService);
        }
        return aReturnVector;
    }

    static DASearchResults searchObjects(Vector theObjects, DASpSearch theSearchInfo) {
        Iterator aIterator = null;
        DAObject aObject = null;
        DASearchResults aSearchResults = new DASearchResults();
        Object aConvertedWildcard = null;
        String aName = null;
        String aObjectName = null;
        Pattern aPattern = null;
        Matcher aMatcher = null;
        aName = theSearchInfo.getName();
        aIterator = theObjects.iterator();
        while (aIterator.hasNext()) {
            aObject = (DAObject)aIterator.next();
            aObjectName = aObject.getName();
            aPattern = Pattern.compile(aName, 66);
            aMatcher = aPattern.matcher(aObjectName);
            if (!aMatcher.matches() || !DAUtil.compare(aObject, theSearchInfo.getSearchItems())) continue;
            aSearchResults.addObject(aObject);
        }
        return aSearchResults;
    }

    public static boolean compare(DAObject theObject, Vector theSearchItems) {
        Iterator aIterator = theSearchItems.iterator();
        DASpSearchItem aSearchItem = null;
        boolean aBoolReturn = true;
        String aAttributeName = null;
        DAAttribute aAttribute = null;
        while (aIterator.hasNext() && aBoolReturn) {
            aSearchItem = (DASpSearchItem)aIterator.next();
            aAttributeName = aSearchItem.getName();
            aAttribute = theObject.getAttribute(aAttributeName);
            if (aAttribute == null) {
                aBoolReturn = false;
                continue;
            }
            aBoolReturn = aSearchItem.compare(aAttribute);
        }
        return aBoolReturn;
    }

    static DASearchResults searchObjects(Vector theObjects, String theWildcard, DASearchConstraint theSearchConstraints) {
        DASearchResults aSearchResults = null;
        Map aAvPairs = null;
        if (theObjects == null) {
            return aSearchResults;
        }
        if (theSearchConstraints != null) {
            aAvPairs = theSearchConstraints.getFilterAVPairs();
        }
        aSearchResults = DAUtil.searchObjects(theObjects, theWildcard, aAvPairs);
        return aSearchResults;
    }

    static DASearchResults searchObjects(Vector theObjects, String theWildcard, Map theAvPairs) {
        Iterator aIterator = null;
        DAObject aObject = null;
        DASearchResults aSearchResults = new DASearchResults();
        String aConvertedWildcard = null;
        aConvertedWildcard = theWildcard != null ? theWildcard.replaceAll("\\*", ".*") : ".*";
        aIterator = theObjects.iterator();
        while (aIterator.hasNext()) {
            aObject = (DAObject)aIterator.next();
            if (!aObject.getName().matches(aConvertedWildcard) || !aObject.match(theAvPairs)) continue;
            aSearchResults.addObject(aObject);
        }
        return aSearchResults;
    }

    static DASearchResults convertToSearchResults(Vector response, String objType, DATask myTask) {
        DASearchResults srchResults = new DASearchResults();
        DAObject tmpObj = null;
        boolean newObjRequired = true;
        for (int i = 0; i < response.size(); ++i) {
            String line;
            String[] strArray;
            String oneLine = ((String)response.elementAt(i)).trim();
            if (oneLine.equals("OK")) continue;
            if (oneLine.equals("") && tmpObj != null) {
                if (tmpObj instanceof DAServicePackage) {
                    ((DAServicePackage)tmpObj).collateAttributes();
                }
                if (tmpObj instanceof DAUser) {
                    tmpObj.fillReadServices();
                }
                if (tmpObj instanceof DABusinessOrganization) {
                    tmpObj.fillReadServices();
                }
                tmpObj.setMyTask(myTask);
                srchResults.addObject(tmpObj);
                newObjRequired = true;
                continue;
            }
            if (newObjRequired) {
                if (objType.equals("businessorg")) {
                    tmpObj = new DABusinessOrganization();
                } else if (objType.equals("providerorg")) {
                    tmpObj = new DAProviderOrganization();
                } else if (objType.equals("org")) {
                    tmpObj = new DAOrganization();
                } else if (objType.equals("user")) {
                    tmpObj = new DAUser();
                } else if (objType.equals("group")) {
                    tmpObj = new DAGroup();
                } else if (objType.equals("resource")) {
                    tmpObj = new DAResource();
                } else if (objType.equals("servicepackage")) {
                    tmpObj = new DAServicePackage();
                }
                newObjRequired = false;
            }
            if ((strArray = oneLine.split(": ")).length != 2 || tmpObj == null) continue;
            if (strArray[0].equalsIgnoreCase("dn")) {
                tmpObj.setDN(strArray[1]);
            }
            String val = strArray[1];
            int j = i + 1;
            while ((line = (String)response.elementAt(j)).startsWith(" ")) {
                val = val + "\n" + line.trim();
                ++j;
            }
            tmpObj.addAttributeValue(strArray[0], val);
            i = j - 1;
        }
        return srchResults;
    }

    public static String formatToOneString(String[] theStrings) {
        String aReturnString = new String();
        int aIdx = 0;
        if (theStrings == null || theStrings.length == 0) {
            return aReturnString;
        }
        for (aIdx = 0; aIdx < theStrings.length; ++aIdx) {
            aReturnString = aReturnString + theStrings[aIdx] + " ";
        }
        return aReturnString;
    }

    public static Vector sortStrings(Vector theStrings) {
        Iterator aIterator = null;
        String aString = null;
        String aSortString = null;
        Vector<String> aReturnVector = new Vector<String>();
        int aIdx = 0;
        int aReturnSize = 0;
        aIterator = theStrings.iterator();
        while (aIterator.hasNext()) {
            aString = (String)aIterator.next();
            aReturnSize = aReturnVector.size();
            for (aIdx = 0; aIdx < aReturnSize && aString.compareToIgnoreCase(aSortString = (String)aReturnVector.elementAt(aIdx)) > 0; ++aIdx) {
            }
            aReturnVector.add(aIdx, aString);
        }
        return aReturnVector;
    }

    public static DAServicePackage[] sortServicePackages(DAServicePackage[] theServicePackages) {
        DAServicePackage aSp = null;
        DAServicePackage aSpSort = null;
        DAServicePackage[] aSpArray = new DAServicePackage[]{};
        String aSpName = null;
        String aSortString = null;
        Vector<DAServicePackage> aReturnVector = new Vector<DAServicePackage>();
        int aIdx = 0;
        int aSpIdx = 0;
        int aReturnSize = 0;
        for (aSpIdx = 0; aSpIdx < theServicePackages.length; ++aSpIdx) {
            aSp = theServicePackages[aSpIdx];
            aSpName = aSp.getName();
            aReturnSize = aReturnVector.size();
            for (aIdx = 0; aIdx < aReturnSize && aSpName.compareToIgnoreCase(aSortString = (aSpSort = (DAServicePackage)aReturnVector.elementAt(aIdx)).getName()) > 0; ++aIdx) {
            }
            aReturnVector.add(aIdx, aSp);
        }
        return aReturnVector.toArray(aSpArray);
    }
}

