/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comm.jdapi;

import com.sun.comm.jdapi.DAAttribute;
import com.sun.comm.jdapi.DAException;
import com.sun.comm.jdapi.DASpSearchItem;
import java.util.Iterator;

public class DASpSearchStringItem
extends DASpSearchItem {
    public DASpSearchStringItem(String theName, int theOperation, String theValue) throws DAException {
        if (!this.validStringOperation(theOperation)) {
            throw new DAException("invalid operation for string comparison");
        }
        this.setName(theName);
        this.setOperation(theOperation);
        this.setValues(theValue);
    }

    public DASpSearchStringItem(String theName, int theOperation, String[] theValues) throws DAException {
        if (!this.validStringOperation(theOperation)) {
            throw new DAException("invalid operation for string comparison");
        }
        this.setName(theName);
        this.setOperation(theOperation);
        this.setValues(theValues);
    }

    public boolean compare(DAAttribute theAttribute) {
        if (theAttribute == null) {
            return false;
        }
        return this.compare(theAttribute.getValues());
    }

    public boolean compare(String[] theValues) {
        String aSearchValue = null;
        String aAttributeValue = null;
        Iterator aIterator = this._values.iterator();
        int aIdx = 0;
        boolean aBoolReturn = true;
        if (theValues == null) {
            return false;
        }
        while (aIterator.hasNext() && aBoolReturn) {
            aSearchValue = (String)aIterator.next();
            aBoolReturn = false;
            for (aIdx = 0; aIdx < theValues.length && !aBoolReturn; ++aIdx) {
                aAttributeValue = theValues[aIdx];
                aBoolReturn = this.compareStrings(aSearchValue, aAttributeValue);
            }
        }
        return aBoolReturn;
    }

    protected boolean compareStrings(String theSearchString, String theTargetString) {
        boolean aBoolReturn = false;
        switch (this._operation) {
            case 32: {
                aBoolReturn = theTargetString.equals(theSearchString);
                break;
            }
            case 64: {
                aBoolReturn = theTargetString.equalsIgnoreCase(theSearchString);
                break;
            }
            default: {
                aBoolReturn = theTargetString.matches(theSearchString);
            }
        }
        return aBoolReturn;
    }

    public boolean validStringOperation(int theOperation) {
        boolean aBoolReturn = false;
        switch (theOperation) {
            case 32: 
            case 64: 
            case 128: {
                aBoolReturn = true;
                break;
            }
            default: {
                aBoolReturn = false;
            }
        }
        return aBoolReturn;
    }
}

