/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comm.jdapi;

import com.sun.comm.jdapi.DAAttribute;
import com.sun.comm.jdapi.DAConnection;
import com.sun.comm.jdapi.DAConstants;
import com.sun.comm.jdapi.DAException;
import com.sun.comm.jdapi.DAOrganization;
import com.sun.comm.jdapi.DAServicePackage;
import com.sun.comm.jdapi.DAServicePackageManager;
import com.sun.comm.jdapi.DASpNameCount;
import com.sun.comm.jdapi.DATask;
import com.sun.comm.jdapi.DAUser;
import com.sun.comm.jdapi.DAUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class DAObject {
    private DATask myTask = null;
    private Vector myServices = new Vector();
    protected Vector _readServices = null;
    protected Vector _attributes = new Vector();
    protected Vector _changedAttributes = new Vector();
    private String _dn = null;
    private String _name = null;

    public String getDN() {
        if (this._dn == null) {
            this._dn = this.getFirstValue("dn");
        }
        return this._dn;
    }

    DAObject() {
    }

    DAObject(DAConnection con) {
        this.myTask = con.getMyTask();
    }

    public void setDN(String DN) {
        this._dn = DN;
        this.addAttributeValue("dn", DN);
    }

    public DAAttribute getAttribute(String theName) {
        int aIndex = 0;
        DAAttribute aAttribute = new DAAttribute(theName);
        aIndex = DAUtil.findObjectInVector(this._attributes, aAttribute);
        if (aIndex >= 0) {
            return (DAAttribute)this._attributes.elementAt(aIndex);
        }
        return null;
    }

    public Vector getAttributes() {
        return this._attributes;
    }

    Vector getChangedAttributes() {
        return this._changedAttributes;
    }

    public String[] getAttributeValues(String theName) {
        DAAttribute aAttribute = this.getAttribute(theName);
        if (aAttribute != null) {
            return aAttribute.getValues();
        }
        return null;
    }

    public String getFirstValue(String theAttributeName) {
        String[] aValues = null;
        aValues = this.getAttributeValues(theAttributeName);
        if (aValues != null) {
            return aValues[0];
        }
        return null;
    }

    public void addAttribute(DAAttribute theAttribute) {
        boolean aIndex = false;
        int aOperation = 2;
        if (theAttribute == null) {
            return;
        }
        if (DAUtil.findObjectInVector(this._attributes, theAttribute) >= 0) {
            this.addValuesToAttribute(theAttribute.getName(), theAttribute.getValues());
        } else {
            DAUtil.addObjectToVector(this._attributes, theAttribute, 1003);
        }
        theAttribute.setOperation(2);
        this._changedAttributes.add(theAttribute);
    }

    public void addAttributeList(Vector theAttributes) {
        Iterator aIterator = null;
        if (theAttributes == null) {
            return;
        }
        aIterator = theAttributes.iterator();
        while (aIterator.hasNext()) {
            this.addAttribute((DAAttribute)aIterator.next());
        }
    }

    public void addAttribute(String name, String[] values) {
        DAAttribute aAttribute = new DAAttribute(name, 2, values);
        this.addAttribute(aAttribute);
    }

    public void addAttributeValue(String name, String value) {
        DAAttribute existingAttr = null;
        String[] valArray = new String[]{value};
        DAAttribute aAttribute = new DAAttribute(name, 1, valArray);
        int index = DAUtil.findObjectInVector(this._attributes, aAttribute);
        if (index != -1) {
            existingAttr = (DAAttribute)this._attributes.elementAt(index);
            existingAttr.addValue(value);
        } else {
            DAUtil.addObjectToVector(this._attributes, aAttribute, 1003);
        }
    }

    public void addAttribute(String name, int op, String[] values) {
        DAAttribute aAttribute = new DAAttribute(name, op, values);
        this.addAttribute(aAttribute);
    }

    public void removeAttribute(DAAttribute theAttribute) {
        int aIndex = 0;
        if (theAttribute != null) {
            aIndex = DAUtil.findObjectInVector(this._attributes, theAttribute);
            if (aIndex > 0) {
                this._attributes.removeElementAt(aIndex);
            }
            theAttribute.setOperation(8);
            this._changedAttributes.add(theAttribute);
        }
    }

    public void removeAttribute(String theAttributeName) {
        DAAttribute aAttribute = new DAAttribute(theAttributeName);
        this.removeAttribute(aAttribute);
    }

    public void removeAttributeList(Vector theAttributes) {
        Iterator aIterator = null;
        if (theAttributes == null) {
            return;
        }
        aIterator = theAttributes.iterator();
        while (aIterator.hasNext()) {
            this.removeAttribute((DAAttribute)aIterator.next());
        }
    }

    public void removeAttributeList(String[] theAttributes) {
        int aIdx = 0;
        if (theAttributes == null) {
            return;
        }
        for (aIdx = 0; aIdx < theAttributes.length; ++aIdx) {
            this.removeAttribute(theAttributes[aIdx]);
        }
    }

    void removeAttribute_noChangeMode(DAAttribute theAttribute) {
        int aIndex = 0;
        if (theAttribute != null && (aIndex = DAUtil.findObjectInVector(this._attributes, theAttribute)) > 0) {
            this._attributes.removeElementAt(aIndex);
        }
    }

    public void addValuesToAttribute(String theAttributeName, String[] theValues) {
        DAAttribute aAttribute = null;
        DAAttribute aNewAttribute = null;
        if (theAttributeName == null || theValues == null) {
            return;
        }
        aNewAttribute = new DAAttribute(theAttributeName, 2, theValues);
        aAttribute = this.getAttribute(theAttributeName);
        if (aAttribute != null) {
            aAttribute.addValues(theValues);
        } else {
            DAUtil.addObjectToVector(this._attributes, aNewAttribute, 1003);
        }
        this._changedAttributes.add(aNewAttribute);
    }

    public void removeValuesFromAttribute(String theAttributeName, String[] theValues) {
        DAAttribute aAttribute = null;
        if (theAttributeName == null || theValues == null) {
            return;
        }
        aAttribute = this.getAttribute(theAttributeName);
        if (aAttribute != null) {
            aAttribute.removeValues(theValues);
            String[] newValues = aAttribute.getValues();
            if (newValues == null || newValues.length == 0) {
                int aIndex = 0;
                aIndex = DAUtil.findObjectInVector(this._attributes, aAttribute);
                if (aIndex > 0) {
                    this._attributes.removeElementAt(aIndex);
                }
            }
        }
        this._changedAttributes.add(new DAAttribute(theAttributeName, 8, theValues));
    }

    public void setAttributeValues(String theAttributeName, String[] theValues) {
        DAAttribute aExistingAttribute = null;
        DAAttribute aNewAttribute = null;
        Object aValues = null;
        if (theAttributeName == null || theValues == null) {
            return;
        }
        aExistingAttribute = this.getAttribute(theAttributeName);
        aNewAttribute = new DAAttribute(theAttributeName, 4, theValues);
        if (aExistingAttribute != null) {
            aExistingAttribute.setValues(theValues);
        } else if (aNewAttribute != null) {
            DAUtil.addObjectToVector(this._attributes, aNewAttribute, 1003);
        }
        this._changedAttributes.add(aNewAttribute);
    }

    public void setAttributeValues(String theAttributeName, String theValue) {
        Object aNewAttribute = null;
        Object aExistingAttribute = null;
        String[] aValues = new String[1];
        if (theAttributeName == null || theValue == null) {
            return;
        }
        aValues[0] = theValue;
        this.setAttributeValues(theAttributeName, aValues);
    }

    void setMyTask(DATask taskObj) {
        this.myTask = taskObj;
    }

    DATask getMyTask() {
        return this.myTask;
    }

    public void setDn(String theDn) {
        this.setDN(theDn);
    }

    void storeAttribute(String theAttributeName, String theValue) {
        DAAttribute aExistingAttr = null;
        DAAttribute aNewAttribute = null;
        String[] aValueArray = new String[1];
        int aIndex = 0;
        aValueArray[0] = theValue;
        aNewAttribute = new DAAttribute(theAttributeName, 1, aValueArray);
        aIndex = DAUtil.findObjectInVector(this._attributes, aNewAttribute);
        if (aIndex != -1) {
            aExistingAttr = (DAAttribute)this._attributes.elementAt(aIndex);
            aExistingAttr.addValue(theValue);
        } else {
            this.addAttribute(aNewAttribute);
        }
    }

    String[] getMyServices() {
        String[] aStringArray = new String[1];
        if (this.myServices.size() == 0) {
            return null;
        }
        aStringArray = this.myServices.toArray(aStringArray);
        return aStringArray;
    }

    void removeAllServices() {
        this.myServices.removeAllElements();
    }

    void setServices(String[] theServiceNames) {
        this.myServices.removeAllElements();
        DAUtil.addStringsToVector(this.myServices, theServiceNames, 1003, 1001);
    }

    void addServices(String[] theServiceNames) {
        if (theServiceNames == null) {
            return;
        }
        DAUtil.addStringsToVector(this.myServices, theServiceNames, 1003, 1001);
    }

    void addAService(String theServiceName) {
        if (theServiceName == null) {
            return;
        }
        DAUtil.addAStringToVector(this.myServices, theServiceName, 1003, 1001);
    }

    void removeAService(String theServiceName) {
        if (theServiceName == null) {
            return;
        }
        DAUtil.removeAStringFromVector(this.myServices, theServiceName, 1001);
    }

    boolean isAttributePresent(String theName) {
        DAAttribute aAttribute = this.getAttribute(theName);
        String[] aValues = null;
        boolean aMatchCount = false;
        if (aAttribute == null) {
            return false;
        }
        aValues = aAttribute.getValues();
        return aValues != null && aValues.length != 0;
    }

    Vector getAttributeVector() {
        return this._attributes;
    }

    Vector getReadServicesVector() {
        return this._readServices;
    }

    public void setStatus(String value) {
    }

    public String getStatus() {
        return null;
    }

    void setName(String theName) {
        this._name = theName;
    }

    public String getName() {
        if (this._name != null && this._name.length() != 0) {
            return this._name;
        }
        if (this instanceof DAUser) {
            return this.getFirstValue(DAConstants.UID);
        }
        if (this instanceof DAOrganization) {
            return this.getFirstValue("o");
        }
        return this._name;
    }

    boolean equals(DAObject theDAObject) {
        String aThatName = null;
        String aThisName = null;
        if (theDAObject == null || (aThatName = theDAObject.getDN()) == null) {
            return false;
        }
        aThisName = this.getDN();
        return aThisName.equalsIgnoreCase(aThatName);
    }

    public boolean equals(Object theObject) {
        DAObject aDAObject = (DAObject)theObject;
        String aThatName = null;
        String aThisName = null;
        if (aDAObject == null || (aThatName = aDAObject.getDN()) == null) {
            return false;
        }
        aThisName = this.getDN();
        return aThisName.equalsIgnoreCase(aThatName);
    }

    boolean equalsDn(String theDn) {
        return theDn.equalsIgnoreCase(this._dn);
    }

    boolean match(Map theAvPairs) {
        Object aKeySet = null;
        Iterator aKeySetIterator = null;
        boolean aMatchResult = true;
        DAAttribute aAttribute = null;
        String aAttributeName = null;
        String aAttributeValue = null;
        if (theAvPairs == null) {
            return true;
        }
        aKeySetIterator = theAvPairs.keySet().iterator();
        while (aKeySetIterator.hasNext() && aMatchResult) {
            aAttributeName = (String)aKeySetIterator.next();
            aAttributeValue = (String)theAvPairs.get(aAttributeName);
            if (aAttributeName.equalsIgnoreCase("dn")) {
                aMatchResult = this.equalsDn(aAttributeValue);
            }
            if ((aAttribute = this.getAttribute(aAttributeName)) == null) {
                aMatchResult = false;
                continue;
            }
            aMatchResult = aAttribute.matchesValue(aAttributeValue);
        }
        return aMatchResult;
    }

    boolean matchPartialDn(String thePartialDn) {
        String aDn = this._dn;
        return aDn.endsWith(thePartialDn);
    }

    boolean hasRequiredAttributes(DATask theTask) throws DAException {
        Object aServiceNamesToAddVector = null;
        boolean aBoolReturn = true;
        return true;
    }

    DAAttribute getCosAttribute() {
        return new DAAttribute("inetcos");
    }

    Vector resolveServiceModifications() {
        Object aCurrentServices = null;
        String[] aServiceNames = null;
        String aServiceName = null;
        DAAttribute aCosAttribute = null;
        DAAttribute aChangeAttribute = null;
        DASpNameCount aService = null;
        Vector<String> aCurrentServicesVector = null;
        Object aServiceNamesVector = null;
        int aIndex = -1;
        int aStartIndex = 0;
        int aAddIndex = 0;
        int aDeleteIndex = 0;
        int aOperation = 0;
        int aIdx = 0;
        aCosAttribute = this.getCosAttribute();
        aCurrentServicesVector = this.getReadServicesVector();
        if (aCurrentServicesVector == null) {
            aCurrentServicesVector = new Vector<String>();
        }
        if (this._changedAttributes == null || this._changedAttributes.size() == 0) {
            return aCurrentServicesVector;
        }
        block5: while ((aIndex = this._changedAttributes.indexOf(aCosAttribute, aStartIndex)) != -1) {
            aChangeAttribute = (DAAttribute)this._changedAttributes.elementAt(aIndex);
            aOperation = aChangeAttribute.getOperation();
            aServiceNames = aChangeAttribute.getValues();
            aStartIndex = aIndex + 1;
            if (aServiceNames == null || aServiceNames.length == 0) continue;
            switch (aChangeAttribute.getOperation()) {
                case 2: {
                    for (aIdx = 0; aIdx < aServiceNames.length; ++aIdx) {
                        aService = new DASpNameCount(aServiceNames[aIdx]);
                        aServiceName = aService.getName();
                        aAddIndex = aCurrentServicesVector.indexOf(aServiceName);
                        if (aAddIndex != -1) continue;
                        aCurrentServicesVector.add(aServiceName);
                    }
                    continue block5;
                }
                case 8: {
                    for (aIdx = 0; aIdx < aServiceNames.length; ++aIdx) {
                        aService = new DASpNameCount(aServiceNames[aIdx]);
                        aServiceName = aService.getName();
                        aDeleteIndex = aCurrentServicesVector.indexOf(aServiceName);
                        if (aDeleteIndex == -1) continue;
                        aCurrentServicesVector.removeElementAt(aDeleteIndex);
                    }
                    continue block5;
                }
                case 4: {
                    aCurrentServicesVector = new Vector();
                    for (aIdx = 0; aIdx < aServiceNames.length; ++aIdx) {
                        aService = new DASpNameCount(aServiceNames[aIdx]);
                        aServiceName = aService.getName();
                        aCurrentServicesVector.add(aServiceName);
                    }
                    continue block5;
                }
            }
        }
        return aCurrentServicesVector;
    }

    void addServiceChangeAttributes(DATask theTask, String theOperation) throws DAException {
        Vector aIsAddServices = new Vector();
        Vector aIsDeleteServices = new Vector();
        String[] aServiceValues = null;
        this.getIsServicesModifications(aIsAddServices, aIsDeleteServices, theTask);
        if (aIsAddServices.size() > 0) {
            aServiceValues = new String[1];
            aServiceValues = aIsAddServices.toArray(aServiceValues);
            if (theOperation.equalsIgnoreCase("create")) {
                this._attributes.add(new DAAttribute("services", 2, aServiceValues));
            } else {
                this._changedAttributes.add(new DAAttribute("services", 2, aServiceValues));
            }
        }
        if (aIsDeleteServices.size() > 0) {
            aServiceValues = new String[1];
            aServiceValues = aIsAddServices.toArray(aServiceValues);
            this._changedAttributes.add(new DAAttribute("services", 8, aServiceValues));
        }
    }

    void getIsServicesModifications(Vector theIsServicesToAdd, Vector theIsServicesToDelete, DATask theTask) throws DAException {
        Object aCurrentSpNames = null;
        String aIsName = null;
        Vector aCurrentSpNamesVector = null;
        Vector aResolvedSpNamesVector = null;
        Vector aCurrentIsNamesVector = null;
        Vector aResolvedIsNamesVector = null;
        Iterator aIterator = null;
        if (theIsServicesToAdd == null || theIsServicesToDelete == null) {
            return;
        }
        aResolvedSpNamesVector = this.resolveServiceModifications();
        aCurrentSpNamesVector = this.getReadServicesVector();
        aCurrentIsNamesVector = this.getIsServiceNames(aCurrentSpNamesVector, theTask);
        aResolvedIsNamesVector = this.getIsServiceNames(aResolvedSpNamesVector, theTask);
        aIterator = aResolvedIsNamesVector.iterator();
        while (aIterator.hasNext()) {
            aIsName = (String)aIterator.next();
            if (aCurrentIsNamesVector.indexOf(aIsName) != -1) continue;
            theIsServicesToAdd.add(aIsName);
        }
        aIterator = aCurrentIsNamesVector.iterator();
        while (aIterator.hasNext()) {
            aIsName = (String)aIterator.next();
            if (aResolvedIsNamesVector.indexOf(aIsName) != -1) continue;
            theIsServicesToDelete.add(aIsName);
        }
    }

    Vector getIsServiceNames(Vector theSpNames, DATask theTask) throws DAException {
        Iterator aIterator = null;
        HashSet aIsReturnNames = new HashSet();
        Set aIsNames = null;
        String aSpName = null;
        Vector aReturnVector = null;
        if (theSpNames == null || theSpNames.size() == 0) {
            return new Vector();
        }
        aIterator = theSpNames.iterator();
        while (aIterator.hasNext()) {
            aSpName = (String)aIterator.next();
            aIsNames = this.getIsServicesForSp(aSpName, theTask);
            if (aIsNames == null) continue;
            aIsReturnNames.addAll(aIsNames);
        }
        aReturnVector = DAUtil.convertToVector(aIsReturnNames);
        return aReturnVector;
    }

    Set getIsServicesForSp(String theSpName, DATask theTask) throws DAException {
        DAServicePackageManager aSpManager = DAConnection.getServicePackageManager();
        DAServicePackage aSp = null;
        HashSet<String> aReturnSet = null;
        int aIdx = 0;
        String[] aServiceTypes = null;
        String aServiceType = null;
        if (theSpName == null || theTask == null) {
            return null;
        }
        aSp = aSpManager.getServicePackage(theSpName, theTask);
        if (aSp == null) {
            return null;
        }
        aServiceTypes = aSp.getServiceTypes();
        if (aServiceTypes == null || aServiceTypes.length == 0) {
            return null;
        }
        aReturnSet = new HashSet<String>();
        for (aIdx = 0; aIdx < aServiceTypes.length; ++aIdx) {
            aServiceType = aServiceTypes[aIdx];
            aReturnSet.add(aServiceType);
        }
        return aReturnSet;
    }

    String[] convertIsNamesToServiceSchemaNames(String[] aServiceValues) {
        String aObjectTypeString = null;
        String aServiceTypeString = null;
        String aServiceName = null;
        String[] aReturnArray = null;
        Vector<String> aReturnVector = null;
        int aIdx = 0;
        if (aServiceValues == null || aServiceValues.length == 0) {
            return aServiceValues;
        }
        aObjectTypeString = this instanceof DAUser ? "User" : (this instanceof DAOrganization ? "Domain" : "UnknownObject");
        aReturnVector = new Vector<String>();
        for (aIdx = 0; aIdx < aServiceValues.length; ++aIdx) {
            aServiceName = aServiceValues[aIdx];
            aServiceTypeString = aServiceName.equalsIgnoreCase("Mail") ? "Mail" : (aServiceName.equalsIgnoreCase("Calendar") ? "Calendar" : "unknownService");
            aReturnVector.add(aObjectTypeString + aServiceTypeString + "Service");
        }
        aReturnArray = new String[1];
        aReturnArray = aReturnVector.toArray(aReturnArray);
        return aReturnArray;
    }

    void fillReadServices() {
        String[] aCurrentServices = this.getAttributeValues("inetcos");
        if (aCurrentServices != null) {
            this._readServices = DAUtil.convertToVector(aCurrentServices);
        }
    }

    void print() {
        for (int i = 0; i < this._attributes.size(); ++i) {
            DAAttribute attr = (DAAttribute)this._attributes.elementAt(i);
            attr.print();
        }
    }
}

