/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comm.jdapi;

import com.sun.comm.jdapi.DAAttribute;
import com.sun.comm.jdapi.DAConnection;
import com.sun.comm.jdapi.DAConstants;
import com.sun.comm.jdapi.DAObject;
import com.sun.comm.jdapi.DAServicePackage;
import com.sun.comm.jdapi.DAServicePackageManager;
import com.sun.comm.jdapi.DAUtil;
import java.util.Iterator;
import java.util.Vector;

public class DAGroup
extends DAObject {
    String _organizationDn;

    public void addStaticMembers(String[] memberDns) {
        this.addValuesToAttribute("uniquemember", memberDns);
    }

    public void addExternalMembers(String[] memberEmailAddresses) {
        this.addValuesToAttribute("mgrprfc822mailmember", memberEmailAddresses);
    }

    public void addDynamicMembers(String[] memberURLs) {
        this.addValuesToAttribute("memberurl", memberURLs);
    }

    public void addServicePackages(String[] services) throws Exception {
        int aIdx = 0;
        boolean aIIdx = false;
        Vector aSpNamesVector = null;
        Vector aSpVector = null;
        Vector aCosAttributes = null;
        DAAttribute aAttribute = null;
        Object aStatusAttribute = null;
        DAServicePackage aServicePackage = null;
        Object aDefaultValue = null;
        Object aServiceTypes = null;
        Iterator aIterator = null;
        if (DAConnection.getMode() == 102) {
            this.addValuesToAttribute(DAConstants.COS_ATTR, services);
            aSpNamesVector = DAUtil.convertToVector(services);
            aSpVector = DAConnection.getServicePackages(aSpNamesVector);
            for (aIdx = 0; aIdx < services.length; ++aIdx) {
                aServicePackage = new DAServicePackage();
                aServicePackage.setName(services[aIdx]);
                aServicePackage = (DAServicePackage)DAUtil.getObjectInVector(aSpVector, aServicePackage);
                if (aServicePackage == null || (aCosAttributes = aServicePackage.getCOSAttributes()) == null) continue;
                aIterator = aCosAttributes.iterator();
                while (aIterator.hasNext()) {
                    aAttribute = (DAAttribute)aIterator.next();
                    this.addAttribute(aAttribute);
                }
            }
        } else {
            this.addValuesToAttribute(DAConstants.COS_ATTR, services);
        }
    }

    public void assignServicePackages(String[] services) throws Exception {
        String[] aServiceNames = null;
        if (DAConnection.getMode() == 102) {
            aServiceNames = this.getServicePackageNames();
            this.removeServicePackages(aServiceNames);
            this.setAttributeValues(DAConstants.COS_ATTR, services);
            aServiceNames = this.getServicePackageNames();
            this.addServicePackages(aServiceNames);
        } else {
            this.setAttributeValues(DAConstants.COS_ATTR, services);
        }
    }

    public String[] getStaticMembers() {
        return this.getAttributeValues("uniquemember");
    }

    public String[] getExternalMembers() {
        return this.getAttributeValues("mgrprfc822mailmember");
    }

    public String[] getDynamicMembers() {
        return this.getAttributeValues("memberurl");
    }

    public String[] getCurrentServicePackageNames() {
        DAAttribute cosAttr = this.getAttribute(DAConstants.COS_ATTR);
        if (cosAttr == null) {
            return null;
        }
        return cosAttr.getValues();
    }

    public String getStatus() {
        return this.getFirstValue("inetgroupstatus");
    }

    public String getServiceStatus(String theServiceName) {
        String aStatusAttributeName = null;
        aStatusAttributeName = this.getStatusAttributeName(theServiceName);
        if (aStatusAttributeName == null) {
            return null;
        }
        return this.getFirstValue(aStatusAttributeName);
    }

    public String getName() {
        return this.getFirstValue(DAConstants.FULL_NAME);
    }

    public String[] getServicePackageNames() {
        return this.getAttributeValues(DAConstants.COS_ATTR);
    }

    public DAServicePackage[] getServicePackages() throws Exception {
        DAServicePackage[] aSpArray = null;
        Vector aSpVector = null;
        String[] aSpNamesArray = null;
        DAServicePackageManager aSpManager = null;
        aSpNamesArray = this.getServicePackageNames();
        if (aSpNamesArray == null || aSpNamesArray.length == 0) {
            return null;
        }
        aSpManager = DAConnection.getServicePackageManager();
        aSpVector = aSpManager.getServicePackages(aSpNamesArray, null, this.getMyTask());
        aSpArray = new DAServicePackage[]{};
        if (aSpVector.size() == 0) {
            return aSpArray;
        }
        return aSpVector.toArray(aSpArray);
    }

    public void removeStaticMembers(String[] memberDns) {
        this.removeValuesFromAttribute("uniquemember", memberDns);
    }

    public void removeExternalMembers(String[] memberEmailAddresses) {
        this.removeValuesFromAttribute("mgrprfc822mailmember", memberEmailAddresses);
    }

    public void removeDynamicMembers(String[] memberURLs) {
        this.removeValuesFromAttribute("memberurl", memberURLs);
    }

    public void removeServicePackages(String[] services) throws Exception {
        int aIdx = 0;
        Vector aSpNamesVector = null;
        Vector aSpVector = null;
        Vector aCosAttributes = null;
        DAAttribute aAttribute = null;
        DAServicePackage aServicePackage = null;
        Iterator aIterator = null;
        if (DAConnection.getMode() == 102) {
            this.removeValuesFromAttribute(DAConstants.COS_ATTR, services);
            aSpNamesVector = DAUtil.convertToVector(services);
            aSpVector = DAConnection.getServicePackages(aSpNamesVector);
            for (aIdx = 0; aIdx < services.length; ++aIdx) {
                aServicePackage = new DAServicePackage();
                aServicePackage.setName(services[aIdx]);
                aServicePackage = (DAServicePackage)DAUtil.getObjectInVector(aSpVector, aServicePackage);
                if (aServicePackage == null || (aCosAttributes = aServicePackage.getCOSAttributes()) == null) continue;
                aIterator = aCosAttributes.iterator();
                while (aIterator.hasNext()) {
                    aAttribute = (DAAttribute)aIterator.next();
                    this.removeAttribute(aAttribute);
                }
            }
        } else {
            this.removeValuesFromAttribute(DAConstants.COS_ATTR, services);
        }
    }

    public void setServiceStatus(String theService, String theStatus) {
        String aStatusAttributeName = null;
        aStatusAttributeName = this.getStatusAttributeName(theService);
        if (aStatusAttributeName == null) {
            return;
        }
        this.setAttributeValues(aStatusAttributeName, theStatus);
    }

    public void setDN(String theDn) {
        String aPartialDn = null;
        super.setDN(theDn);
        aPartialDn = theDn.substring(theDn.indexOf(",") + 1);
        this._organizationDn = aPartialDn.substring(aPartialDn.indexOf(",") + 1);
    }

    String getOrganizationDn() {
        return this._organizationDn;
    }

    String getStatusAttributeName(String theServiceName) {
        DAServicePackage[] aSpArray = null;
        DAServicePackage aServicePackage = null;
        String aServiceTypeStatusAttributeName = null;
        int aIdx = 0;
        try {
            aSpArray = this.getServicePackages();
            if (aSpArray == null) {
                return null;
            }
        }
        catch (Exception theException) {
            return null;
        }
        for (aIdx = 0; aIdx < aSpArray.length; ++aIdx) {
            aServicePackage = aSpArray[aIdx];
            try {
                aServiceTypeStatusAttributeName = aServicePackage.getServiceStatusAttributeName(theServiceName);
            }
            catch (Exception theException) {
                // empty catch block
            }
            if (aServiceTypeStatusAttributeName != null) break;
        }
        return aServiceTypeStatusAttributeName;
    }
}

