
if {![info exists print_debug]} {
    set print_debug 0
}

if {![info exists ignore_V2_0R3_check]} {
    set ignore_V2_0R3_check 0
}

namespace eval nauticusZipApp {
    proc dbgPrint { args } {
        global print_debug
        if {$print_debug} {
            puts stderr "$args"
            tclflush stderr
        }
    }

    proc ask { msg {defaultVal ""}} {
        puts -nonewline stdout "$msg: \[$defaultVal\]? "
        tclflush stdout
        gets stdin answer
        if {$answer == ""} {
            set answer $defaultVal
        }
        set answer [string trimleft $answer]
        set answer [string trimright $answer]
        return $answer
    }

    # using disk10 as the asfname 'coz disk2 and disk3 are taken
    # priority of 1100 'coz 900 and 1000 are taken. And 2000 tftp asf
    proc configureAsf { dirname  {asfname disk10} {priority 1100} } {
        dbgPrint "asdisc $asfname"
        nos asdisc $asfname
        dbgPrint "asconn -p $priority $asfname"
        nos asconn -p $priority $asfname
        dbgPrint "asconf $asfname $dirname"
        nos asconf $asfname $dirname
        return $asfname
    }

    proc disconnectAsf { {asfname disk10} } {
        dbgPrint "asdisc $asfname"
        nos asdisc $asfname
    }

    proc updateAsfs { {asflist "disk2 disk3"} } {
        foreach asf $asflist {
            dbgPrint "asupdate $asf"
            nos asupdate $asf
        }
    }
}

if {![file exists "/ftl0/dist/V2_0R3.toc"] || \
    [catch {glob "/ftl0/V2_0R/bin/*,3"}]} {
    if {!$ignore_V2_0R3_check} {
        puts stdout "You must install patch \"V2_0R3\" before running the compression utility"
        return
    }
}

set lmfile "lmzip.elf"
while { 1 } {
    set lmpath [nauticusZipApp::ask "Enter the absolute path to $lmfile" \
                    "/ftl0/dist/$lmfile"]
    if {[string length $lmpath] == 0 || [string first "/" $lmpath] != 0} {
        puts stderr "\"$lmpath\" is not an absolute path"
    } elseif {![file exists $lmpath]} {
        puts stderr "\"$lmpath\" doesn't exist"
    } elseif {[file isdirectory $lmpath]} {
        if {[string index $lmpath [expr [string length $lmpath]-1]] != "/"} {
            set lmpath "${lmpath}/"
        }
        set fpath "${lmpath}${lmfile}"
        if {![file exists $fpath]} {
            puts stderr "\"$fpath\" doesn't exist"
        } else {
            set lmdir $lmpath
            break
        }
    } elseif {[string range $lmpath [string length [file dirname $lmpath]] \
                   end] != "/$lmfile"} {
        puts stderr "Path to $lmfile must end in $lmfile"
    } else {
        set lmdir "[file dirname $lmpath]/"
        break
    }
}

enable
configure
dbg on
if { 0 } {
    # Eric Balkan (ENEA/OSE) says I can't do this without a process already
    # running that is the new asf. All I can do is change the directory of
    # an existing asf
    nauticusZipApp::configureAsf $lmdir
    nos pgexec $lmfile
    nauticusZipApp::disconnectAsf
} else {
    puts stdout "\nLoading lmzip.elf"; tclflush stdout
    set copied 0
    if {![string match $lmdir "/ftl0/"]} {
        nauticusZipApp::dbgPrint "copying ${lmdir}${lmfile} to /ftl0/${lmfile}"
        cp "${lmdir}${lmfile}" "/ftl0/${lmfile}"
        set copied 1
    }
    nauticusZipApp::updateAsfs
    nos pgexec $lmfile
    if { $copied } {
        nauticusZipApp::dbgPrint "removing /ftl0/${lmfile}"
        rm "/ftl0/${lmfile}"
    }
}
