/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.daemon.transport;

import com.sun.apoc.daemon.config.DaemonConfig;
import com.sun.apoc.daemon.misc.APOCLogger;
import com.sun.apoc.daemon.transport.ChannelManager;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class ClientChannel {
    private SocketChannel mChannel;
    private ChannelManager mManager = null;
    private static int sSoTimeout = DaemonConfig.getIntProperty("ConnectionReadTimeout");

    public ClientChannel(SocketChannel socketChannel, ChannelManager channelManager) throws IOException {
        this(socketChannel);
        this.mManager = channelManager;
    }

    public ClientChannel(SocketChannel socketChannel) throws IOException {
        this.initChannel(socketChannel);
    }

    public SocketChannel getSocketChannel() {
        return this.mChannel;
    }

    public void registerForSelection(boolean bl) {
        this.mManager.registerForSelection(this, bl);
    }

    public long read(ByteBuffer byteBuffer) throws IOException {
        long l = 0L;
        while (l == 0L) {
            try {
                l = this.mChannel.read(byteBuffer);
                if (l != 0L) continue;
                Thread.currentThread();
                Thread.yield();
            }
            catch (IOException iOException) {
                l = -1L;
                break;
            }
        }
        if (l == -1L) {
            APOCLogger.finest("Clch002");
            if (this.mManager != null) {
                this.mManager.closeClientChannel(this);
            }
            throw new IOException();
        }
        return l;
    }

    public void write(ByteBuffer byteBuffer) {
        block3: {
            try {
                while (byteBuffer.hasRemaining()) {
                    this.mChannel.write(byteBuffer);
                }
            }
            catch (IOException iOException) {
                APOCLogger.throwing("ClientChannel", "write", iOException);
                if (this.mManager == null) break block3;
                this.mManager.closeClientChannel(this);
            }
        }
    }

    public void close() {
        try {
            if (this.mChannel != null) {
                this.mChannel.close();
                this.mChannel = null;
            }
        }
        catch (Exception exception) {
            APOCLogger.throwing("ClientChannel", "close", exception);
        }
    }

    private void initChannel(SocketChannel socketChannel) throws IOException {
        this.mChannel = socketChannel;
        Socket socket = this.mChannel.socket();
        socket.setSoLinger(false, 0);
        socket.setSoTimeout(sSoTimeout);
    }
}

