/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.daemon.transport;

import com.sun.apoc.daemon.config.ConfigEventListener;
import com.sun.apoc.daemon.config.DaemonConfig;
import com.sun.apoc.daemon.misc.APOCException;
import com.sun.apoc.daemon.misc.APOCLogger;
import com.sun.apoc.daemon.transport.ClientChannel;
import com.sun.apoc.daemon.transport.ClientChannelEventListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ChannelManager
extends Thread
implements ConfigEventListener {
    private Selector mSelector;
    private ServerSocketChannel mChannel;
    private final HashSet mRegisteringChannels = new HashSet();
    private final HashSet mDeRegisteringChannels = new HashSet();
    private final Object mLock = new Object();
    private int mMaxClientChannels = DaemonConfig.getIntProperty("MaxClientConnections");
    private final HashSet mClientChannelEventListeners = new HashSet();
    private int mChannelCount = 0;
    private boolean mTerminate = false;
    private static final byte sReject = 0;
    private static final byte[] sAcceptByte = new byte[]{1};
    private static final ByteBuffer sAccept = ByteBuffer.wrap(sAcceptByte);

    public ChannelManager() throws APOCException {
        try {
            this.initThread();
            this.initChannel();
            DaemonConfig.addConfigEventListener(this);
        }
        catch (IOException iOException) {
            throw new APOCException(62, (Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClientChannelEventListener(ClientChannelEventListener clientChannelEventListener) {
        if (clientChannelEventListener != null) {
            HashSet hashSet = this.mClientChannelEventListeners;
            synchronized (hashSet) {
                this.mClientChannelEventListeners.add(clientChannelEventListener);
            }
        }
    }

    public void closeClientChannels() {
        Set<SelectionKey> set = this.mSelector.keys();
        if (set != null) {
            Iterator<SelectionKey> iterator = set.iterator();
            while (iterator.hasNext()) {
                SelectionKey selectionKey = iterator.next();
                if (!selectionKey.isValid()) continue;
                try {
                    selectionKey.channel().close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void closeChannels() {
        this.closeClientChannels();
        this.closeServerChannel();
    }

    public void onConfigEvent() {
        this.setMaxClientChannels();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClientChannelEventListener(ClientChannelEventListener clientChannelEventListener) {
        if (clientChannelEventListener != null) {
            HashSet hashSet = this.mClientChannelEventListeners;
            synchronized (hashSet) {
                this.mClientChannelEventListeners.remove(clientChannelEventListener);
            }
        }
    }

    public void run() {
        APOCLogger.fine("Chmr001");
        while (!this.shouldTerminate()) {
            try {
                this.selectChannels();
                this.registerChannels();
            }
            catch (Exception exception) {
                APOCLogger.throwing("ChannelManager", "run", exception);
                break;
            }
        }
        APOCLogger.fine("Chmr003");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        Object object = this.mLock;
        synchronized (object) {
            this.mTerminate = true;
        }
        this.mSelector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeClientChannel(ClientChannel clientChannel) {
        clientChannel.close();
        this.notifyClosed(clientChannel);
        Object object = this.mLock;
        synchronized (object) {
            --this.mChannelCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerForSelection(ClientChannel clientChannel, boolean bl) {
        HashSet hashSet;
        HashSet hashSet2 = hashSet = bl ? this.mRegisteringChannels : this.mDeRegisteringChannels;
        synchronized (hashSet2) {
            hashSet.add(clientChannel.getSocketChannel().keyFor(this.mSelector));
            this.mSelector.wakeup();
            try {
                hashSet.wait();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acceptableKey(SelectionKey selectionKey) {
        block11: {
            SocketChannel socketChannel = null;
            try {
                socketChannel = ((ServerSocketChannel)selectionKey.channel()).accept();
                if (!this.testMaxChannels() && socketChannel != null) {
                    try {
                        socketChannel.socket().getOutputStream().write(0);
                        socketChannel.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
                if (!socketChannel.socket().getInetAddress().isLoopbackAddress()) break block11;
                socketChannel.configureBlocking(false);
                SelectionKey selectionKey2 = socketChannel.register(this.mSelector, 1);
                ClientChannel clientChannel = new ClientChannel(socketChannel, this);
                selectionKey2.attach(clientChannel);
                Object object = this.mLock;
                synchronized (object) {
                    ++this.mChannelCount;
                }
                clientChannel.write(sAccept);
                sAccept.flip();
            }
            catch (IOException iOException) {
                if (socketChannel != null) {
                    try {
                        socketChannel.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                APOCLogger.throwing("ChannelManager", "acceptableKey", iOException);
            }
        }
    }

    private void closeServerChannel() {
        try {
            this.mSelector.close();
            this.mChannel.close();
        }
        catch (IOException iOException) {
            APOCLogger.throwing("ClientManager", "close", iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getMaxClientChannels() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mMaxClientChannels;
        }
    }

    private void initChannel() throws IOException {
        this.mSelector = Selector.open();
        this.mChannel = ServerSocketChannel.open();
        this.mChannel.configureBlocking(false);
        this.mChannel.socket().bind(new InetSocketAddress(DaemonConfig.getIntProperty("DaemonPort")));
        this.mChannel.register(this.mSelector, 16);
    }

    private void initThread() {
        this.setName("ChannelManager");
        this.setDaemon(true);
    }

    private void notifyClosed(ClientChannel clientChannel) {
        Iterator iterator = this.mClientChannelEventListeners.iterator();
        while (iterator.hasNext()) {
            ((ClientChannelEventListener)iterator.next()).onClosed(clientChannel);
        }
    }

    private void notifyPending(ClientChannel clientChannel) {
        Iterator iterator = this.mClientChannelEventListeners.iterator();
        while (iterator.hasNext()) {
            ((ClientChannelEventListener)iterator.next()).onPending(clientChannel);
        }
    }

    private void readableKey(SelectionKey selectionKey) {
        selectionKey.interestOps(selectionKey.interestOps() & 0xFFFFFFFE);
        this.notifyPending((ClientChannel)selectionKey.attachment());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerChannels() {
        SelectionKey selectionKey;
        Iterator iterator;
        HashSet hashSet = this.mRegisteringChannels;
        synchronized (hashSet) {
            if (this.mRegisteringChannels.size() > 0) {
                iterator = this.mRegisteringChannels.iterator();
                while (iterator.hasNext()) {
                    selectionKey = (SelectionKey)iterator.next();
                    selectionKey.interestOps(selectionKey.interestOps() | 1);
                }
                this.mRegisteringChannels.clear();
                this.mRegisteringChannels.notifyAll();
            }
        }
        hashSet = this.mDeRegisteringChannels;
        synchronized (hashSet) {
            if (this.mDeRegisteringChannels.size() > 0) {
                iterator = this.mDeRegisteringChannels.iterator();
                while (iterator.hasNext()) {
                    selectionKey = (SelectionKey)iterator.next();
                    selectionKey.interestOps(selectionKey.interestOps() & 0xFFFFFFFE);
                }
            }
            this.mDeRegisteringChannels.clear();
            this.mDeRegisteringChannels.notifyAll();
        }
    }

    private void selectChannels() throws IOException {
        if (this.mSelector.select() > 0) {
            Iterator<SelectionKey> iterator = this.mSelector.selectedKeys().iterator();
            while (iterator.hasNext()) {
                SelectionKey selectionKey = iterator.next();
                iterator.remove();
                if (selectionKey.isAcceptable()) {
                    this.acceptableKey(selectionKey);
                }
                if (!selectionKey.isReadable()) continue;
                this.readableKey(selectionKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMaxClientChannels() {
        Object object = this.mLock;
        synchronized (object) {
            this.mMaxClientChannels = DaemonConfig.getIntProperty("MaxClientConnections");
        }
        this.mSelector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldTerminate() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mTerminate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean testMaxChannels() {
        boolean bl = false;
        int n = this.getMaxClientChannels();
        if (n > 0) {
            Object object = this.mLock;
            synchronized (object) {
                bl = n > this.mChannelCount;
            }
        }
        if (!bl) {
            APOCLogger.warning("Chmr002", String.valueOf(n));
        }
        return bl;
    }
}

