/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.daemon.transaction;

import com.sun.apoc.daemon.apocd.Cache;
import com.sun.apoc.daemon.apocd.Client;
import com.sun.apoc.daemon.apocd.ClientManager;
import com.sun.apoc.daemon.localdatabase.Database;
import com.sun.apoc.daemon.messaging.Message;
import com.sun.apoc.daemon.misc.DaemonTimerTask;
import com.sun.apoc.daemon.transaction.AddListenerTransaction;
import com.sun.apoc.daemon.transaction.ChangeDetectTransaction;
import com.sun.apoc.daemon.transaction.CreateSessionTransaction;
import com.sun.apoc.daemon.transaction.DestroySessionTransaction;
import com.sun.apoc.daemon.transaction.GarbageCollectTransaction;
import com.sun.apoc.daemon.transaction.ListTransaction;
import com.sun.apoc.daemon.transaction.ReadTransaction;
import com.sun.apoc.daemon.transaction.RemoveListenerTransaction;
import com.sun.apoc.daemon.transaction.Transaction;
import java.util.HashSet;

public class TransactionFactory {
    private static TransactionFactory sInstance;
    private static final Transaction[] sTransactionModel;
    private static long sTransactionTimeout;
    private final HashSet mTransactions = new HashSet();
    private final DaemonTimerTask mTransactionInterrupter = new DaemonTimerTask(new TransactionInterrupter());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransaction(Transaction transaction) {
        HashSet hashSet = this.mTransactions;
        synchronized (hashSet) {
            if (this.mTransactions.size() == 0) {
                this.mTransactionInterrupter.setPeriod(sTransactionTimeout);
            }
            this.mTransactions.add(transaction);
        }
    }

    public ChangeDetectTransaction createChangeDetectTransaction(ClientManager clientManager, Cache cache) {
        return new ChangeDetectTransaction(clientManager, cache);
    }

    public GarbageCollectTransaction createGarbageCollectTransaction(Database database) {
        return new GarbageCollectTransaction(database);
    }

    public Transaction createTransaction(Client client, Message message) {
        Transaction transaction = null;
        switch (message.getName()) {
            case 15: {
                transaction = new ReadTransaction(client, message);
                break;
            }
            case 11: {
                transaction = new AddListenerTransaction(client, message);
                break;
            }
            case 12: {
                transaction = new CreateSessionTransaction(client, message);
                break;
            }
            case 13: {
                transaction = new DestroySessionTransaction(client, message);
                break;
            }
            case 16: {
                transaction = new RemoveListenerTransaction(client, message);
                break;
            }
            case 14: {
                transaction = new ListTransaction(client, message);
                break;
            }
        }
        return transaction;
    }

    public static TransactionFactory getInstance() {
        if (sInstance == null) {
            sInstance = new TransactionFactory();
        }
        return sInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransaction(Transaction transaction) {
        HashSet hashSet = this.mTransactions;
        synchronized (hashSet) {
            if (this.mTransactions.size() == 1) {
                this.mTransactionInterrupter.cancel();
            }
            this.mTransactions.remove(transaction);
        }
    }

    private TransactionFactory() {
    }

    static {
        sTransactionModel = new Transaction[0];
        sTransactionTimeout = 10000L;
    }

    class TransactionInterrupter
    implements Runnable {
        TransactionInterrupter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            HashSet hashSet = TransactionFactory.this.mTransactions;
            synchronized (hashSet) {
                Transaction[] transactionArray = null;
                if (TransactionFactory.this.mTransactions.size() > 0) {
                    transactionArray = TransactionFactory.this.mTransactions.toArray(sTransactionModel);
                }
                if (transactionArray != null && transactionArray.length > 0) {
                    for (int i = 0; i < transactionArray.length; ++i) {
                        if (transactionArray[i].getDuration() <= sTransactionTimeout) continue;
                        transactionArray[i].interrupt();
                        TransactionFactory.this.removeTransaction(transactionArray[i]);
                    }
                }
            }
        }
    }
}

