/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.daemon.transaction;

import com.sun.apoc.daemon.apocd.Client;
import com.sun.apoc.daemon.apocd.Session;
import com.sun.apoc.daemon.messaging.Message;
import com.sun.apoc.daemon.messaging.MessageFactory;
import com.sun.apoc.daemon.misc.APOCLogger;
import com.sun.apoc.daemon.transaction.TransactionFactory;

public abstract class Transaction {
    protected final Client mClient;
    protected Session mSession;
    protected final Message mRequest;
    protected Message mResponse;
    private Thread mThread;
    private Object mThreadLock = new Object();
    private long mStartTime;

    public Transaction(Client client, Message message) {
        this.mClient = client;
        this.mRequest = message;
        if (client != null && message != null) {
            this.mSession = client.getSession(this.mRequest.getSessionId());
        }
    }

    public Message execute() {
        if (!this.needSession() || this.mSession != null) {
            try {
                this.beginTransaction();
                this.executeTransaction();
                this.endTransaction();
            }
            catch (Exception exception) {
                APOCLogger.throwing("Transaction", "execute", exception);
                this.setResponse(26);
            }
        } else {
            this.setResponse(24);
        }
        return this.mResponse;
    }

    public long getDuration() {
        return System.currentTimeMillis() - this.mStartTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        Object object = this.mThreadLock;
        synchronized (object) {
            if (this.mThread != null) {
                this.mThread.interrupt();
                this.mThread = null;
            }
        }
    }

    protected boolean needSession() {
        return true;
    }

    protected void beginTransaction() {
        this.mStartTime = System.currentTimeMillis();
        this.setThread(Thread.currentThread());
        TransactionFactory.getInstance().addTransaction(this);
    }

    protected abstract void executeTransaction();

    protected void endTransaction() {
        this.setThread(null);
        TransactionFactory.getInstance().removeTransaction(this);
    }

    protected void setResponse(int n) {
        this.setResponse(n, this.mRequest.getSessionId(), null);
    }

    protected void setResponse(int n, String string) {
        this.setResponse(n, string, null);
    }

    protected void setResponse(int n, String string, String string2) {
        this.mResponse = MessageFactory.createResponse(n, string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setThread(Thread thread) {
        Object object = this.mThreadLock;
        synchronized (object) {
            this.mThread = thread;
        }
    }
}

