/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.daemon.transaction;

import com.sun.apoc.daemon.config.DaemonConfig;
import com.sun.apoc.daemon.localdatabase.Database;
import com.sun.apoc.daemon.localdatabase.LocalDatabaseFactory;
import com.sun.apoc.daemon.localdatabase.Timestamp;
import com.sun.apoc.daemon.misc.APOCLogger;
import com.sun.apoc.daemon.transaction.Transaction;

public class GarbageCollectTransaction
extends Transaction {
    private final Database mDatabase;

    public GarbageCollectTransaction(Database database) {
        super(null, null);
        this.mDatabase = database;
    }

    protected void executeTransaction() {
        try {
            APOCLogger.finer("Gctn001");
            this.mDatabase.beginTransaction();
            boolean bl = Timestamp.getMillis(this.mDatabase.getLastRead()) <= Timestamp.getMillis(Timestamp.getTimestamp()) - (long)(DaemonConfig.getIntProperty("TimeToLive") * 60000);
            this.mDatabase.endTransaction();
            this.mDatabase.close(0);
            if (bl) {
                LocalDatabaseFactory.getInstance().deleteDatabase(this.mDatabase);
            }
            APOCLogger.finer("Gctn002");
        }
        catch (Exception exception) {
            APOCLogger.throwing("GarbageCollectTransaction", "execute", exception);
        }
    }

    protected boolean needSession() {
        return false;
    }
}

