/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.daemon.transaction;

import com.sun.apoc.daemon.apocd.Cache;
import com.sun.apoc.daemon.apocd.ClientManager;
import com.sun.apoc.daemon.apocd.Session;
import com.sun.apoc.daemon.localdatabase.UpdateItem;
import com.sun.apoc.daemon.messaging.Message;
import com.sun.apoc.daemon.messaging.MessageFactory;
import com.sun.apoc.daemon.messaging.Notification;
import com.sun.apoc.daemon.misc.APOCLogger;
import com.sun.apoc.daemon.transaction.Transaction;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class ChangeDetectTransaction
extends Transaction {
    private ClientManager mClientManager;
    private Cache mCache;
    private static final String[] sStringModel = new String[0];
    private static final byte[] sBindingHeader = "CONTENT-LENGTH:".getBytes();
    private static final int sBindingHeaderLen = sBindingHeader.length;

    public ChangeDetectTransaction(ClientManager clientManager, Cache cache) {
        super(null, null);
        this.mClientManager = clientManager;
        this.mCache = cache;
    }

    protected void executeTransaction() {
        Session session = null;
        try {
            ArrayList arrayList;
            APOCLogger.finer("Cdtn001");
            session = this.getLockedSession();
            if (session != null && (arrayList = this.mCache.changeDetect()).size() > 0) {
                this.sendNotifications(arrayList);
            }
            APOCLogger.finer("Cdtn002");
        }
        catch (Exception exception) {
            APOCLogger.throwing("ChangeDetectTransaction", "execute", exception);
        }
        if (session != null) {
            session.unlock();
        }
    }

    protected boolean needSession() {
        return false;
    }

    private Notification createNotification(Session session, String string, String string2, int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer().append(" sessionId      = ").append(session.getSessionId()).append("\n").append(" component name = ").append(string).append("\n").append(" type           = ");
        switch (n) {
            case 1: {
                n2 = 30;
                stringBuffer.append("Add");
                break;
            }
            case 2: {
                n2 = 31;
                stringBuffer.append("Remove");
                break;
            }
            case 3: {
                n2 = 32;
                stringBuffer.append("Modify");
                break;
            }
            default: {
                n2 = -1;
                stringBuffer.append("Unknown");
            }
        }
        APOCLogger.finer("Cdtn003", stringBuffer.toString());
        Notification notification = (Notification)MessageFactory.createNotification(session.getSessionId(), n2);
        notification.setComponentName(string);
        notification.setClientData(session.getListenerClientData(string2));
        return notification;
    }

    private Session getLockedSession() {
        Session session = null;
        Session[] sessionArray = this.mClientManager.getSessions(this.mCache);
        if (sessionArray != null) {
            for (int i = 0; i < sessionArray.length; ++i) {
                if (!sessionArray[i].lock()) continue;
                session = sessionArray[i];
                break;
            }
        }
        return session;
    }

    private void sendNotifications(ArrayList arrayList) {
        Session[] sessionArray = this.mClientManager.getSessions(this.mCache);
        for (int i = 0; i < sessionArray.length; ++i) {
            this.sendNotifications(arrayList, sessionArray[i]);
        }
    }

    private void sendNotifications(ArrayList arrayList, Session session) {
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            UpdateItem updateItem = (UpdateItem)arrayList.get(i);
            String string = updateItem.getComponentName();
            String string2 = session.getListenerComponentName(string);
            if (string2 == null) continue;
            this.sendNotification(this.createNotification(session, string, string2, updateItem.getUpdateType()), session);
        }
    }

    private void sendNotification(Notification notification, Session session) {
        session.getClient().getClientChannel().write(this.serialise(notification));
    }

    private ByteBuffer serialise(Message message) {
        byte[] byArray = message.toString().getBytes();
        byte[] byArray2 = String.valueOf(byArray.length).getBytes();
        return (ByteBuffer)ByteBuffer.allocate(sBindingHeaderLen + byArray2.length + 2 + byArray.length).put(sBindingHeader).put(byArray2).put((byte)13).put((byte)10).put(byArray).flip();
    }
}

