/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.daemon.misc;

public class Name {
    private static int sLocationLocal = 0;
    private static int sLocationGlobal = 1;
    private static int sApplicabilityHost = 2;
    private static int sApplicabilityUser = 3;
    private static int sEntityLocalHost = 4;
    private static int sEntityLocalUser = 5;
    private static int sUndefined = 6;
    private static final String sLocationLocalStr = "local";
    private static final String sLocationGlobalStr = "global";
    private static final String sApplicabilityHostStr = "host";
    private static final String sApplicabilityUserStr = "user";
    public static final String sEntityLocalHostStr = "localHost";
    public static final String sEntityLocalUserStr = "localUser";
    public static final String sSep = "/";
    public static final String[] sNames = new String[]{"local", "global", "host", "user", "localHost", "localUser"};
    private String mName;
    private String mUserName;
    private String mEntityName;
    private boolean mIsLocal;
    private boolean mIsHost;

    public Name(String string, String string2, boolean bl, boolean bl2) {
        this.mUserName = string;
        this.mEntityName = string2;
        this.mIsLocal = bl;
        this.mIsHost = bl2;
    }

    public Name(String string) {
        String[] stringArray = string.split(sSep);
        this.mUserName = stringArray[0];
        this.mEntityName = stringArray[1];
        this.mIsLocal = stringArray[2].compareTo(sLocationLocalStr) == 0;
        this.mIsHost = stringArray[3].compareTo(sApplicabilityHostStr) == 0;
    }

    public String getUserName() {
        return this.mUserName;
    }

    public String getEntityName() {
        return this.mEntityName;
    }

    public String getLocation() {
        return sNames[this.getLocationAsInt()];
    }

    public int getLocationAsInt() {
        return this.mIsLocal ? sLocationLocal : sLocationGlobal;
    }

    public String getApplicability() {
        return sNames[this.getApplicabilityAsInt()];
    }

    public int getApplicabilityAsInt() {
        return this.mIsHost ? sApplicabilityHost : sApplicabilityUser;
    }

    public String toString() {
        return this.mUserName + sSep + this.mEntityName + sSep + this.getLocation() + sSep + this.getApplicability();
    }

    public boolean isLocal() {
        return this.mIsLocal;
    }

    public boolean isGlobal() {
        return !this.isLocal();
    }

    public boolean isHost() {
        return this.mIsHost;
    }

    public boolean isUser() {
        return !this.isHost();
    }

    public boolean isLocalHost() {
        return this.isLocal() && this.isHost();
    }

    public boolean isGlobalHost() {
        return this.isGlobal() && this.isHost();
    }

    public boolean isLocalUser() {
        return this.isLocal() && this.isUser();
    }

    public boolean isGlobalUser() {
        return this.isGlobal() && this.isUser();
    }
}

