/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.daemon.misc;

import java.util.Timer;
import java.util.TimerTask;

public class DaemonTimerTask {
    private Runnable mRunnable;
    private long mPeriod = 0L;
    private TimerTask mTimerTask = null;
    private boolean mIsOneTime = false;
    private static final Timer sTimer = new Timer(true);

    public DaemonTimerTask(Runnable runnable) {
        this.mRunnable = runnable;
    }

    public DaemonTimerTask(Runnable runnable, boolean bl) {
        this(runnable);
        this.mIsOneTime = bl;
    }

    public void cancel() {
        this.setPeriod(-1L);
    }

    public long getPeriod() {
        return this.mPeriod;
    }

    public boolean setPeriod(long l) {
        boolean bl = false;
        if (l != this.mPeriod) {
            this.mPeriod = l;
            this.schedule();
            bl = true;
        }
        return bl;
    }

    private void schedule() {
        if (this.mPeriod > 0L) {
            if (this.mTimerTask != null) {
                this.mTimerTask.cancel();
            }
            this.mTimerTask = new Task();
            sTimer.schedule(this.mTimerTask, this.mPeriod, this.mPeriod);
        } else if (this.mTimerTask != null) {
            this.mTimerTask.cancel();
            this.mTimerTask = null;
        }
    }

    class Task
    extends TimerTask {
        Task() {
        }

        public void run() {
            DaemonTimerTask.this.mRunnable.run();
            if (DaemonTimerTask.this.mIsOneTime) {
                this.cancel();
            }
        }
    }
}

