/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.daemon.misc;

import com.sun.apoc.daemon.config.DaemonConfig;
import com.sun.apoc.daemon.misc.ConfigurableLogger;
import java.io.File;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;

public class APOCLogger {
    private static final String sLoggerName = "com.sun.apoc.daemon";
    private static final String sLogDir = "/Logs";
    private static final String sLogFile = "/apocd.log";
    private static final Logger sLogger = ConfigurableLogger.getLogger("com.sun.apoc.daemon", "com.sun.apoc.daemon");
    private static final int sLimit = 1000000;
    private static final int sCount = 5;

    public static void config(String string) {
        sLogger.log(Level.CONFIG, string);
    }

    public static void config(String string, Object object) {
        sLogger.log(Level.CONFIG, string, object);
    }

    public static void fine(String string) {
        sLogger.log(Level.FINE, string);
    }

    public static void fine(String string, Object object) {
        sLogger.log(Level.FINE, string, object);
    }

    public static void finer(String string) {
        sLogger.log(Level.FINER, string);
    }

    public static void finer(String string, Object object) {
        sLogger.log(Level.FINER, string, object);
    }

    public static void finest(String string) {
        sLogger.log(Level.FINEST, string);
    }

    public static void finest(String string, Object object) {
        sLogger.log(Level.FINEST, string, object);
    }

    public static boolean isLoggable(Level level) {
        return sLogger.isLoggable(level);
    }

    public static void info(String string) {
        sLogger.log(Level.INFO, string);
    }

    public static void info(String string, Object object) {
        sLogger.log(Level.INFO, string, object);
    }

    public static void severe(String string) {
        sLogger.log(Level.SEVERE, string);
    }

    public static void severe(String string, Object object) {
        sLogger.log(Level.SEVERE, string, object);
    }

    public static void throwing(String string, String string2, Throwable throwable) {
        sLogger.throwing(string, string2, throwable);
    }

    public static void warning(String string) {
        sLogger.log(Level.WARNING, string);
    }

    public static void warning(String string, Object object) {
        sLogger.log(Level.WARNING, string, object);
    }

    public static void warning(String string, Object[] objectArray) {
        sLogger.log(Level.WARNING, string, objectArray);
    }

    private static Handler createHandler(String string) {
        StreamHandler streamHandler;
        if (APOCLogger.needFileHandler() && string != null) {
            String string2 = string + sLogDir;
            APOCLogger.createLogDir(string2);
            try {
                streamHandler = new FileHandler(string2 + sLogFile, 1000000, 5, true);
            }
            catch (Exception exception) {
                System.err.println("Warning:Failed to create log file handler");
                streamHandler = new ConsoleHandler();
            }
        } else {
            streamHandler = new ConsoleHandler();
        }
        return streamHandler;
    }

    private static void createLogDir(String string) {
        File file = new File(string);
        if (!file.exists()) {
            if (!file.mkdirs()) {
                System.err.println("Warning: Cannot create Log directory '" + string + "'");
            }
        } else if (!file.isDirectory()) {
            System.err.println("Warning: Log directory '" + string + "' is actually a file");
        }
    }

    private static boolean needFileHandler() {
        boolean bl = false;
        String string = DaemonConfig.getStringProperty("handlers");
        if (string == null || string.compareTo("java.util.logging.FileHandler") == 0) {
            bl = true;
        }
        return bl;
    }

    static {
        try {
            Handler handler = APOCLogger.createHandler(DaemonConfig.getStringProperty("DataDir"));
            Level level = Level.parse(DaemonConfig.getStringProperty("LogLevel"));
            handler.setLevel(level);
            handler.setFormatter(new SimpleFormatter());
            sLogger.addHandler(handler);
            sLogger.setLevel(level);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

