/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.daemon.misc;

import com.sun.apoc.daemon.config.DaemonConfig;
import com.sun.apoc.daemon.misc.APOCException;
import com.sun.apoc.daemon.misc.APOCLogger;
import com.sun.apoc.daemon.misc.FileAccess;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Random;

public class APOCAuthenticator {
    public static final File sAuthDir = new File(DaemonConfig.getStringProperty("DataDir") + File.separatorChar + ".auth");
    private File mFile;
    private String mFileName;
    private byte[] mResponse;
    private static final Random sRandom = new Random();
    private static int sAuthBufferSize = 20;

    public APOCAuthenticator(String string) throws APOCException {
        String string2 = string != null ? string : "<Daemon administrator>";
        APOCLogger.finest("Auth001", string2);
        try {
            this.createAuthFile(string);
            this.createAuthToken();
        }
        catch (Exception exception) {
            this.cleanup();
            APOCLogger.finest("Auth003");
            throw new APOCException(exception);
        }
    }

    public void cleanup() {
        try {
            if (this.mFile != null) {
                this.mFile.delete();
                this.mFile = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int getAuthBufferSize() {
        return sAuthBufferSize;
    }

    public byte[] getChallenge() {
        return this.mFileName.getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processResponse(byte[] byArray) throws APOCException {
        try {
            if (byArray == null || byArray.length != sAuthBufferSize) {
                APOCLogger.finest("Auth003");
                throw new APOCException();
            }
            for (int i = 0; i < sAuthBufferSize; ++i) {
                if (this.mResponse[i] == byArray[i]) continue;
                APOCLogger.finest("Auth003");
                throw new APOCException();
            }
            APOCLogger.finest("Auth002");
        }
        finally {
            this.cleanup();
        }
    }

    private void createAuthFile(String string) throws Exception {
        long l = sRandom.nextLong();
        l = l < 0L ? -l : l;
        this.mFile = File.createTempFile(String.valueOf(l), null, sAuthDir);
        this.mFile.deleteOnExit();
        this.mFileName = this.mFile.getAbsolutePath();
        if (string != null) {
            FileAccess.chown(this.mFileName, string);
        }
        FileAccess.chmod(this.mFileName, 384);
    }

    private void createAuthToken() throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(this.mFileName);
        long l = sRandom.nextLong();
        l = l < 0L ? -l : l;
        StringBuffer stringBuffer = new StringBuffer().append(l);
        int n = stringBuffer.length();
        if (n > sAuthBufferSize) {
            stringBuffer.delete(sAuthBufferSize + 1, n);
        } else if (n < sAuthBufferSize) {
            int n2 = sAuthBufferSize - n;
            for (int i = 0; i < n2; ++i) {
                stringBuffer.append(0);
            }
        }
        this.mResponse = stringBuffer.toString().getBytes();
        fileOutputStream.write(this.mResponse);
        fileOutputStream.close();
    }
}

