/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.daemon.messaging;

import com.sun.apoc.daemon.messaging.Message;
import com.sun.apoc.daemon.messaging.ProtocolDeserialiser;
import com.sun.apoc.daemon.messaging.ProtocolUnbinder;
import com.sun.apoc.daemon.misc.APOCException;
import com.sun.apoc.daemon.misc.APOCLogger;
import com.sun.apoc.daemon.transport.ClientChannel;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

class RequestReceiver {
    private ProtocolUnbinder mUnbinder;
    private ProtocolDeserialiser mDeserialiser;

    public RequestReceiver() throws APOCException {
        try {
            this.mUnbinder = new ProtocolUnbinder();
            this.mDeserialiser = new ProtocolDeserialiser();
        }
        catch (SAXException sAXException) {
            throw new APOCException(sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new APOCException(parserConfigurationException);
        }
    }

    public Message receiveRequest(ClientChannel clientChannel) throws APOCException {
        Message message;
        try {
            this.mUnbinder.setClientChannel(clientChannel);
            this.mDeserialiser.setInputStream(this.mUnbinder.unbind());
            message = this.mDeserialiser.deserialise();
            if (!message.isValid()) {
                throw new APOCException(21);
            }
        }
        catch (SAXException sAXException) {
            APOCLogger.throwing("RequestReceiver", "receiveRequest", sAXException);
            throw new APOCException(sAXException);
        }
        catch (IOException iOException) {
            throw new APOCException(iOException);
        }
        return message;
    }
}

