/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.daemon.messaging;

import com.sun.apoc.daemon.config.ConfigEventListener;
import com.sun.apoc.daemon.config.DaemonConfig;
import com.sun.apoc.daemon.misc.APOCException;
import com.sun.apoc.daemon.misc.APOCLogger;
import com.sun.apoc.daemon.transport.ClientChannel;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

class ProtocolUnbinder
extends InputStream
implements ConfigEventListener {
    private ClientChannel mClientChannel;
    private final ByteBuffer mInputBuffer = ByteBuffer.allocate(1024);
    private int mContentLength;
    private final StringBuffer mContentLengthBuffer = new StringBuffer(5);
    private long mAvailableByteCount;
    private static int sMaxRequestLengthMinimum = 4096;
    private static Integer sMaxRequestLength = new Integer(sMaxRequestLengthMinimum);
    private static final byte[] sContentLengthHeader = "CONTENT-LENGTH:".getBytes();
    private static final int sContentLengthValueSize = 5;

    public ProtocolUnbinder() {
        DaemonConfig.addConfigEventListener(this);
    }

    public void setClientChannel(ClientChannel clientChannel) {
        this.mClientChannel = clientChannel;
        this.mAvailableByteCount = 0L;
    }

    public void onConfigEvent() {
        ProtocolUnbinder.setMaxRequestLength();
    }

    public int read() throws IOException {
        int n = -1;
        if (this.mContentLength-- > 0) {
            n = this.getByte();
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (this.mContentLength > 0 && n3 < n2) {
            byArray[n + n3++] = this.getByte();
            --this.mContentLength;
        }
        return n3 > 0 ? n3 : -1;
    }

    public InputStream unbind() throws APOCException, IOException {
        this.mContentLength = this.getContentLength();
        if (this.mContentLength == 0 || this.mContentLength > this.getMaxRequestLength()) {
            throw new APOCException(21);
        }
        return this;
    }

    private byte getByte() throws IOException {
        if (this.mAvailableByteCount == 0L) {
            this.mInputBuffer.clear();
            this.mAvailableByteCount = this.mClientChannel.read(this.mInputBuffer);
            this.mInputBuffer.flip();
        }
        --this.mAvailableByteCount;
        return this.mInputBuffer.get();
    }

    private int getContentLength() throws IOException {
        return this.hasContentHeader() ? this.readContentLength() : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getMaxRequestLength() {
        Integer n = sMaxRequestLength;
        synchronized (n) {
            return sMaxRequestLength;
        }
    }

    private boolean hasContentHeader() throws IOException {
        boolean bl = true;
        for (int i = 0; i < sContentLengthHeader.length; ++i) {
            if (this.getByte() == sContentLengthHeader[i]) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private int readContentLength() throws IOException {
        this.mContentLengthBuffer.delete(0, 5);
        int n = 0;
        for (int i = 0; i < 5; ++i) {
            byte by = this.getByte();
            n = by;
            if (by == 13) break;
            this.mContentLengthBuffer.append((char)n);
        }
        if (n != 13) {
            this.getByte();
        }
        this.getByte();
        return Integer.parseInt(this.mContentLengthBuffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setMaxRequestLength() {
        Integer n = sMaxRequestLength;
        synchronized (n) {
            int n2 = DaemonConfig.getIntProperty("MaxRequestSize");
            if (n2 < sMaxRequestLengthMinimum) {
                Object[] objectArray = new String[]{String.valueOf(n2), String.valueOf(sMaxRequestLengthMinimum), String.valueOf(sMaxRequestLengthMinimum)};
                APOCLogger.warning("Punb001", objectArray);
                n2 = sMaxRequestLengthMinimum;
            }
            sMaxRequestLength = new Integer(n2);
        }
    }

    static {
        ProtocolUnbinder.setMaxRequestLength();
    }
}

