/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.daemon.messaging;

import com.sun.apoc.daemon.messaging.Message;
import com.sun.apoc.daemon.messaging.RequestReceiver;
import com.sun.apoc.daemon.misc.APOCException;
import com.sun.apoc.daemon.misc.APOCLogger;
import com.sun.apoc.daemon.transport.ClientChannel;
import java.nio.ByteBuffer;

public class Messenger {
    private ClientChannel mClientChannel;
    private RequestReceiver mRequestReceiver = new RequestReceiver();
    private static final byte[] sBindingHeader = "CONTENT-LENGTH:".getBytes();
    private static final int sBindingHeaderLen = sBindingHeader.length;

    public void setClientChannel(ClientChannel clientChannel) {
        this.mClientChannel = clientChannel;
    }

    public Message receiveRequest() throws APOCException {
        return this.receiveRequest(true);
    }

    public Message receiveRequest(boolean bl) throws APOCException {
        return this.mRequestReceiver.receiveRequest(this.mClientChannel);
    }

    public void sendResponse(Message message) {
        this.sendResponse(message, true);
    }

    public void sendResponse(Message message, boolean bl) {
        try {
            if (bl) {
                this.mClientChannel.registerForSelection(true);
            }
            this.mClientChannel.write(this.serialise(message));
        }
        catch (Exception exception) {
            APOCLogger.finest("Msgr001");
            APOCLogger.throwing("Messenger", "sendResponse", exception);
        }
    }

    private ByteBuffer serialise(Message message) {
        byte[] byArray = message.toString().getBytes();
        byte[] byArray2 = String.valueOf(byArray.length).getBytes();
        return (ByteBuffer)ByteBuffer.allocate(sBindingHeaderLen + byArray2.length + 2 + byArray.length).put(sBindingHeader).put(byArray2).put((byte)13).put((byte)10).put(byArray).flip();
    }
}

