/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.daemon.messaging;

import com.sun.apoc.daemon.messaging.AddListenerMessage;
import com.sun.apoc.daemon.messaging.CreateSessionMessage;
import com.sun.apoc.daemon.messaging.DestroySessionMessage;
import com.sun.apoc.daemon.messaging.ListMessage;
import com.sun.apoc.daemon.messaging.Message;
import com.sun.apoc.daemon.messaging.Notification;
import com.sun.apoc.daemon.messaging.ReadMessage;
import com.sun.apoc.daemon.messaging.RemoveListenerMessage;
import com.sun.apoc.daemon.messaging.Response;
import com.sun.apoc.daemon.misc.APOCException;
import com.sun.apoc.daemon.misc.APOCSymbols;

public class MessageFactory {
    public static Message createRequest(String string) throws APOCException {
        Message message;
        switch (APOCSymbols.getProtocolSymbol(string)) {
            case 15: {
                message = new ReadMessage();
                break;
            }
            case 14: {
                message = new ListMessage();
                break;
            }
            case 11: {
                message = new AddListenerMessage();
                break;
            }
            case 12: {
                message = new CreateSessionMessage();
                break;
            }
            case 13: {
                message = new DestroySessionMessage();
                break;
            }
            case 16: {
                message = new RemoveListenerMessage();
                break;
            }
            default: {
                throw new APOCException();
            }
        }
        return message;
    }

    public static Message createResponse(int n, String string, String string2) {
        Response response = null;
        switch (n) {
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                response = new Response(n, string, string2);
                break;
            }
        }
        return response;
    }

    public static Message createNotification(String string, int n) {
        return new Notification(string, n);
    }
}

