/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.daemon.messaging;

import com.sun.apoc.daemon.messaging.Message;
import com.sun.apoc.daemon.misc.APOCException;
import com.sun.apoc.daemon.misc.APOCSymbols;

public class CreateSessionMessage
extends Message {
    private String mUserId;
    private String mEntityId;
    private String mCredentials;
    private int[] mExpectedSymbols = new int[]{40, 0};
    private boolean mIsValid = false;

    public CreateSessionMessage() {
        super(12);
    }

    public boolean isValid() {
        return this.mIsValid;
    }

    public String getUserId() {
        return this.mUserId;
    }

    public String getEntityId() {
        return this.mEntityId;
    }

    public String getCredentials() {
        return this.mCredentials;
    }

    protected void addParameter(String string, String string2) throws APOCException {
        switch (APOCSymbols.getProtocolSymbol(string)) {
            case 40: {
                this.addUserId(string2);
                break;
            }
            case 41: {
                this.addEntityId(string2);
                break;
            }
            case 42: {
                this.addCredentials(string2);
                break;
            }
            default: {
                throw new APOCException();
            }
        }
    }

    private void addUserId(String string) throws APOCException {
        this.checkSymbol(40);
        this.mUserId = string;
        this.setCheckSymbols(41, 42);
        this.mIsValid = true;
    }

    private void addEntityId(String string) throws APOCException {
        this.checkSymbol(41);
        this.mEntityId = string;
        this.setCheckSymbols(42);
    }

    private void addCredentials(String string) throws APOCException {
        this.checkSymbol(42);
        this.mCredentials = string;
        this.setCheckSymbols(0);
    }

    private void checkSymbol(int n) throws APOCException {
        if (this.mExpectedSymbols[0] == 0 || this.mExpectedSymbols[0] != n && this.mExpectedSymbols[1] != n) {
            throw new APOCException();
        }
    }

    private void setCheckSymbols(int n) {
        this.setCheckSymbols(n, 0);
    }

    private void setCheckSymbols(int n, int n2) {
        this.mExpectedSymbols[0] = n;
        this.mExpectedSymbols[1] = n2;
    }
}

