/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.daemon.localdatabase;

import com.sleepycat.db.Db;
import com.sleepycat.db.DbEnv;
import com.sleepycat.db.DbException;
import com.sun.apoc.daemon.config.DaemonConfig;
import com.sun.apoc.daemon.localdatabase.Database;
import com.sun.apoc.daemon.localdatabase.LocalDatabase;
import com.sun.apoc.daemon.misc.APOCException;
import com.sun.apoc.daemon.misc.APOCLogger;
import com.sun.apoc.daemon.misc.FileAccess;
import com.sun.apoc.daemon.misc.Name;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class LocalDatabaseFactory
extends DbEnv {
    private static LocalDatabaseFactory sInstance;
    private static final HashMap sDatabases;
    private static final String sLDBHome;
    private static final String sDbListDbName = "DbList";
    private static final int sDbEnvFlags;
    private static final int sDbEnvMode = 384;
    private static final String s__dbPrefix = "__db.";

    private LocalDatabaseFactory() throws APOCException, DbException {
        super(0);
        this.createDBHome();
        this.openEnv();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDatabase(Database database) {
        Name name = database.getName();
        HashMap hashMap = sDatabases;
        synchronized (hashMap) {
            if (!sDatabases.containsKey(this.createDatabaseKey(name))) {
                try {
                    HashSet hashSet = this.removeDbFromDbList(name);
                    if (hashSet == null || hashSet.size() == 0) {
                        new File(sLDBHome + File.separatorChar + database.getName().getUserName()).delete();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void finalize() {
        try {
            this.close(0);
        }
        catch (DbException dbException) {
            // empty catch block
        }
    }

    public static LocalDatabaseFactory getInstance() throws APOCException {
        if (sInstance == null) {
            try {
                sInstance = new LocalDatabaseFactory();
            }
            catch (DbException dbException) {
                throw new APOCException(dbException);
            }
        }
        return sInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getDatabases() {
        Object[] objectArray = null;
        String[] stringArray = new File(sLDBHome).list();
        if (stringArray != null) {
            ArrayList<Database> arrayList = new ArrayList<Database>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2;
                if (stringArray[i].startsWith(s__dbPrefix) || (stringArray2 = this.getDatabaseNames(stringArray[i])) == null) continue;
                for (int j = 0; j < stringArray2.length; ++j) {
                    HashMap hashMap = sDatabases;
                    synchronized (hashMap) {
                        Database database = (Database)((Object)sDatabases.get(stringArray2[j]));
                        if (database == null) {
                            try {
                                database = new Database(new Name(stringArray2[j]));
                                arrayList.add(database);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        continue;
                    }
                }
            }
            objectArray = arrayList.toArray();
        }
        return objectArray;
    }

    public String[] getDatabaseNames(String string) {
        String[] stringArray = null;
        try {
            HashSet hashSet = this.getDBList(string);
            if (hashSet != null && hashSet.size() > 0) {
                stringArray = hashSet.toArray(new String[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringArray;
    }

    public Object[] openLocalDatabases() {
        Object[] objectArray = null;
        if (!sDatabases.isEmpty()) {
            objectArray = sDatabases.values().toArray();
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalDatabase openLocalDatabase(Name name) throws APOCException {
        String string = this.createDatabaseKey(name);
        LocalDatabase localDatabase = null;
        HashMap hashMap = sDatabases;
        synchronized (hashMap) {
            localDatabase = (LocalDatabase)((Object)sDatabases.get(string));
            if (localDatabase == null) {
                localDatabase = this.createNewLocalDatabase(name);
            }
            if (localDatabase != null) {
                localDatabase.acquire();
            }
        }
        return localDatabase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeLocalDatabase(LocalDatabase localDatabase) {
        HashMap hashMap = sDatabases;
        synchronized (hashMap) {
            if (localDatabase.release() == 0) {
                sDatabases.remove(this.createDatabaseKey(localDatabase.getName()));
            }
        }
    }

    private void addDbToDbList(Name name) throws APOCException, DbException, FileNotFoundException {
        Database database = new Database(new Name(name.getUserName(), sDbListDbName, true, true));
        HashSet<String> hashSet = database.getDBList();
        if (hashSet == null) {
            hashSet = new HashSet<String>(1);
        }
        hashSet.add(name.toString());
        database.beginTransaction();
        database.putDBList(hashSet);
        database.endTransaction();
        database.close(0);
    }

    private String createDatabaseKey(Name name) {
        return name.toString();
    }

    private void createDBHome() throws APOCException {
        File file = new File(sLDBHome);
        if (!file.exists() ? !file.mkdirs() : !file.isDirectory()) {
            throw new APOCException(61);
        }
        FileAccess.chmod(sLDBHome, 448);
        FileAccess.chmod(file.getParent(), 493);
    }

    private LocalDatabase createNewLocalDatabase(Name name) throws APOCException {
        return this.createNewLocalDatabase(name, true);
    }

    private LocalDatabase createNewLocalDatabase(Name name, boolean bl) throws APOCException {
        this.ensureNonZeroLengthDBFile(name.getUserName());
        try {
            LocalDatabase localDatabase = new LocalDatabase(name);
            this.addDbToDbList(name);
            sDatabases.put(this.createDatabaseKey(name), localDatabase);
            return localDatabase;
        }
        catch (Exception exception) {
            if (bl) {
                new File(this.getLocalDatabaseFileName(name.getUserName())).delete();
                return this.createNewLocalDatabase(name, false);
            }
            throw new APOCException(exception);
        }
    }

    private void ensureNonZeroLengthDBFile(String string) throws APOCException {
        File file = new File(this.getLocalDatabaseTmpFileName(string));
        try {
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception exception) {
            throw new APOCException(exception);
        }
        file = new File(this.getLocalDatabaseFileName(string));
        try {
            if (file.exists() && file.length() == 0L) {
                file.delete();
            }
        }
        catch (Exception exception) {
            throw new APOCException(exception);
        }
    }

    private void openEnv() throws APOCException {
        try {
            new DbEnv(0).remove(sLDBHome, Db.DB_FORCE);
            this.open(sLDBHome, sDbEnvFlags, 384);
        }
        catch (DbException dbException) {
            APOCLogger.throwing("LocalDatabaseFactory", "openEnv", dbException);
            throw new APOCException(dbException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            APOCLogger.throwing("LocalDatabaseFactory", "openEnv", fileNotFoundException);
            throw new APOCException(fileNotFoundException);
        }
    }

    private HashSet getDBList(String string) throws APOCException, DbException, FileNotFoundException {
        Database database = new Database(new Name(string, sDbListDbName, true, true));
        HashSet hashSet = database.getDBList();
        database.close(0);
        return hashSet;
    }

    private String getLocalDatabaseFileName(String string) {
        return sLDBHome + File.separatorChar + string;
    }

    private String getLocalDatabaseTmpFileName(String string) {
        return sLDBHome + File.separatorChar + s__dbPrefix + string;
    }

    private HashSet removeDbFromDbList(Name name) throws APOCException, DbException, FileNotFoundException {
        Database database = new Database(new Name(name.getUserName(), sDbListDbName, true, true));
        HashSet hashSet = database.getDBList();
        if (hashSet != null) {
            hashSet.remove(name.toString());
            database.beginTransaction();
            database.putDBList(hashSet);
            database.endTransaction();
        }
        return hashSet;
    }

    static {
        sDatabases = new HashMap(DaemonConfig.getIntProperty("MaxClientConnections"));
        sLDBHome = DaemonConfig.getStringProperty("DataDir") + File.separatorChar + "LocalDB";
        sDbEnvFlags = Db.DB_CREATE | Db.DB_INIT_CDB | Db.DB_INIT_MPOOL | Db.DB_PRIVATE;
    }
}

