/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.daemon.localdatabase;

import com.sleepycat.db.DbException;
import com.sleepycat.db.Dbt;
import com.sun.apoc.daemon.localdatabase.Database;
import com.sun.apoc.daemon.localdatabase.StringDbt;
import com.sun.apoc.daemon.localdatabase.Timestamp;
import com.sun.apoc.daemon.localdatabase.UpdateItem;
import com.sun.apoc.daemon.misc.APOCException;
import com.sun.apoc.daemon.misc.Name;
import com.sun.apoc.spi.policies.Policy;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Vector;

public class LocalDatabase
extends Database {
    private HashSet mLocalComponentList;
    private int mRefCount = 0;

    public LocalDatabase(Name name) throws APOCException, DbException, FileNotFoundException {
        super(name);
        this.initLocalComponentList();
    }

    public synchronized int acquire() {
        return ++this.mRefCount;
    }

    public synchronized int release() {
        if (--this.mRefCount == 0) {
            try {
                this.beginTransaction();
                this.putLastRead();
                this.endTransaction();
                this.close(0);
            }
            catch (DbException dbException) {
            }
            catch (APOCException aPOCException) {
                // empty catch block
            }
        }
        return this.mRefCount;
    }

    public boolean hasComponent(String string) {
        return this.mLocalComponentList.contains(string);
    }

    public void putLocalComponentList(HashSet hashSet) throws APOCException {
        this.mLocalComponentList = hashSet;
        super.putLocalComponentList(this.mLocalComponentList);
    }

    public void update(UpdateItem updateItem, String string) throws APOCException {
        if (updateItem != null) {
            this.updateItem(updateItem, new StringDbt(string));
        }
    }

    public void update(ArrayList arrayList, String string) throws APOCException {
        int n;
        if (arrayList != null && (n = arrayList.size()) > 0) {
            StringDbt stringDbt = new StringDbt(string);
            for (int i = 0; i < n; ++i) {
                this.updateItem((UpdateItem)arrayList.get(i), stringDbt);
            }
        }
    }

    private void addLocalComponent(String string) throws APOCException {
        this.mLocalComponentList.add(string);
        super.putLocalComponentList(this.mLocalComponentList);
    }

    private void initLocalComponentList() throws APOCException {
        this.mLocalComponentList = super.getLocalComponentList();
        if (this.mLocalComponentList == null) {
            this.mLocalComponentList = new HashSet();
        }
    }

    private void putComponent(String string, Policy[] policyArray) throws APOCException {
        if (policyArray != null && policyArray.length > 0) {
            Vector<String> vector = new Vector<String>(policyArray.length);
            for (int i = 0; i < policyArray.length; ++i) {
                String string2 = String.valueOf(policyArray[i].getProfileId().hashCode());
                String string3 = string2 + "/" + string;
                this.put(string3, policyArray[i].getData());
                vector.add(string2);
                this.putLastModified(string2, string, Timestamp.getTimestamp(policyArray[i].getLastModified()));
            }
            this.putLayerIds(string, vector);
        }
    }

    private void removeLocalComponent(String string) throws APOCException {
        this.mLocalComponentList.remove(string);
        super.putLocalComponentList(this.mLocalComponentList);
    }

    private void updateItem(UpdateItem updateItem) throws APOCException {
        this.updateItem(updateItem, new StringDbt(Timestamp.getTimestamp()));
    }

    private void updateItem(UpdateItem updateItem, Dbt dbt) throws APOCException {
        String string = updateItem.getComponentName();
        Policy[] policyArray = updateItem.getPolicies();
        switch (updateItem.getUpdateType()) {
            case 1: {
                this.putComponent(string, policyArray);
                this.addLocalComponent(string);
                break;
            }
            case 3: {
                this.putComponent(string, policyArray);
                break;
            }
            case 2: {
                this.removeLocalComponent(string);
                break;
            }
        }
    }
}

