/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.daemon.localdatabase;

import com.sleepycat.db.Db;
import com.sleepycat.db.DbEnv;
import com.sleepycat.db.DbException;
import com.sleepycat.db.Dbc;
import com.sleepycat.db.Dbt;
import com.sun.apoc.daemon.localdatabase.LocalDatabaseFactory;
import com.sun.apoc.daemon.localdatabase.SetDbt;
import com.sun.apoc.daemon.localdatabase.StringDbt;
import com.sun.apoc.daemon.localdatabase.Timestamp;
import com.sun.apoc.daemon.localdatabase.VectorStringDbt;
import com.sun.apoc.daemon.misc.APOCException;
import com.sun.apoc.daemon.misc.Name;
import java.io.FileNotFoundException;
import java.util.HashSet;
import java.util.Vector;

public class Database
extends Db {
    protected final Name mName;
    private Dbc mDbc;
    private static final int sDbType = 1;
    private static final int sDbFlags = Db.DB_CREATE;
    private static final int sDbMode = 384;
    private static final String sValueEpoch = "19700101000000Z";
    public static final String sKeyLastChangeDetect = "lastChangeDetect";
    public static final String sKeyLastModified = "lastModified/";
    public static final String sKeyLastRead = "lastRead";
    public static final String sKeyLayerIds = "layerIds/";
    public static final String sKeyDBs = "dbs";
    public static final String sKeyRemoteComponentList = "remoteComponentList";
    public static final String sKeyLocalComponentList = "localComponentList";

    public Database(Name name) throws APOCException, DbException, FileNotFoundException {
        super((DbEnv)LocalDatabaseFactory.getInstance(), 0);
        this.mName = name;
        this.open(null, name.getUserName(), this.mName.toString(), 1, sDbFlags, 384);
    }

    public Name getName() {
        return this.mName;
    }

    public void beginTransaction() throws APOCException {
        try {
            Dbc dbc;
            this.mDbc = dbc = this.cursor(null, Db.DB_WRITECURSOR);
        }
        catch (DbException dbException) {
            throw new APOCException(dbException);
        }
    }

    public void endTransaction() throws APOCException {
        if (this.mDbc != null) {
            try {
                Dbc dbc = this.mDbc;
                this.mDbc = null;
                dbc.close();
            }
            catch (DbException dbException) {
                throw new APOCException(dbException);
            }
        }
    }

    public int get(String string, Dbt dbt) throws APOCException {
        return this.get(new StringDbt(string), dbt);
    }

    public int get(Dbt dbt, Dbt dbt2) throws APOCException {
        try {
            return this.get(null, dbt, dbt2, 0);
        }
        catch (DbException dbException) {
            throw new APOCException(dbException);
        }
    }

    public HashSet getDBList() throws APOCException {
        SetDbt setDbt = new SetDbt();
        this.get(sKeyDBs, (Dbt)setDbt);
        return setDbt.getApocData();
    }

    public String getLastChangeDetect() throws APOCException {
        StringDbt stringDbt = new StringDbt();
        this.get(sKeyLastChangeDetect, (Dbt)stringDbt);
        if (stringDbt.get_size() > 0) {
            return stringDbt.getApocData();
        }
        return sValueEpoch;
    }

    public String getLastModified(String string, String string2) throws APOCException {
        StringDbt stringDbt = new StringDbt();
        this.get(sKeyLastModified + string + "/" + string2, (Dbt)stringDbt);
        if (stringDbt.get_size() > 0) {
            return stringDbt.getApocData();
        }
        return sValueEpoch;
    }

    public String getLastRead() throws APOCException {
        StringDbt stringDbt = new StringDbt();
        this.get(sKeyLastRead, (Dbt)stringDbt);
        if (stringDbt.get_size() > 0) {
            return stringDbt.getApocData();
        }
        return sValueEpoch;
    }

    public String getLayer(String string, String string2) throws APOCException {
        String string3 = string2 + "/" + string;
        StringDbt stringDbt = new StringDbt();
        this.get(string3, (Dbt)stringDbt);
        return stringDbt.getApocData();
    }

    public Vector getLayerIds(String string) throws APOCException {
        VectorStringDbt vectorStringDbt = new VectorStringDbt();
        this.get(sKeyLayerIds + string, (Dbt)vectorStringDbt);
        return vectorStringDbt.retrieveData();
    }

    public HashSet getLocalComponentList() throws APOCException {
        SetDbt setDbt = new SetDbt();
        this.get(sKeyLocalComponentList, (Dbt)setDbt);
        return setDbt.getApocData();
    }

    public HashSet getRemoteComponentList() throws APOCException {
        SetDbt setDbt = new SetDbt();
        this.get(sKeyRemoteComponentList, (Dbt)setDbt);
        return setDbt.getApocData();
    }

    public int put(Dbt dbt, String string) throws APOCException {
        return this.put(dbt, (Dbt)new StringDbt(string));
    }

    public int put(String string, HashSet hashSet) throws APOCException {
        return this.put((Dbt)new StringDbt(string), (Dbt)new SetDbt(hashSet));
    }

    public int put(Dbt dbt, HashSet hashSet) throws APOCException {
        return this.put(dbt, (Dbt)new SetDbt(hashSet));
    }

    public int put(String string, Vector vector) throws APOCException {
        return this.put((Dbt)new StringDbt(string), (Dbt)new VectorStringDbt(vector));
    }

    public int put(String string, String string2) throws APOCException {
        return this.put((Dbt)new StringDbt(string), (Dbt)new StringDbt(string2));
    }

    public int put(String string, Dbt dbt) throws APOCException {
        return this.put((Dbt)new StringDbt(string), dbt);
    }

    public int put(Dbt dbt, Dbt dbt2) throws APOCException {
        try {
            return this.mDbc.put(dbt, dbt2, Db.DB_KEYFIRST);
        }
        catch (DbException dbException) {
            throw new APOCException(dbException);
        }
    }

    public void putDBList(HashSet hashSet) throws APOCException {
        this.put(sKeyDBs, hashSet);
    }

    public void putLastChangeDetect(String string) throws APOCException {
        this.put(sKeyLastChangeDetect, string);
    }

    public void putLastModified(String string, String string2, String string3) throws APOCException {
        this.put(sKeyLastModified + string + "/" + string2, string3);
    }

    public void putLayerIds(String string, Vector vector) throws APOCException {
        this.put(sKeyLayerIds + string, vector);
    }

    public void putRemoteComponentList(HashSet hashSet) throws APOCException {
        this.put(sKeyRemoteComponentList, hashSet);
    }

    public void putLocalComponentList(HashSet hashSet) throws APOCException {
        this.put(sKeyLocalComponentList, hashSet);
    }

    protected void putLastRead() throws APOCException {
        this.put(sKeyLastRead, Timestamp.getTimestamp());
    }
}

