/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.daemon.config;

import com.sun.apoc.daemon.config.ConfigEventListener;
import com.sun.apoc.daemon.config.LocalConfig;
import com.sun.apoc.daemon.config.RemoteConfig;
import com.sun.apoc.daemon.misc.APOCException;
import com.sun.apoc.daemon.misc.APOCLogger;
import com.sun.apoc.daemon.misc.DaemonTimerTask;
import com.sun.apoc.spi.PolicyMgrFactory;
import com.sun.apoc.spi.PolicyMgrFactoryImpl;
import com.sun.apoc.spi.SPIException;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.zip.ZipFile;

public class DaemonConfig
implements ConfigEventListener {
    public static final String sDaemonPort = "DaemonPort";
    public static final String sDaemonAdminPort = "DaemonAdminPort";
    public static final String sDataDir = "DataDir";
    public static final String sMaxClientThreads = "MaxClientThreads";
    public static final String sMaxClientConnections = "MaxClientConnections";
    public static final String sMaxRequestSize = "MaxRequestSize";
    public static final String sConfigCDInterval = "DaemonChangeDetectionInterval";
    public static final String sChangeDetectionInterval = "ChangeDetectionInterval";
    public static final String sGarbageCollectionInterval = "GarbageCollectionInterval";
    public static final String sTimeToLive = "TimeToLive";
    public static final String sLogLevel = "LogLevel";
    public static final String sIdleThreadDetectionInterval = "IdleThreadDetectionInterval";
    public static final String sThreadTimeToLive = "ThreadTimeToLive";
    public static final String sConnectionReadTimeout = "ConnectionReadTimeout";
    public static final String sInitialChangeDetectionDelay = "InitialChangeDetectionDelay";
    public static final String sApplyLocalPolicy = "ApplyLocalPolicy";
    private static DaemonConfig sInstance;
    private static final String sAPOCJarFile = "apocd.jar";
    private static final String sDefaultsPropertiesFile = "defaults.properties";
    private static final String sOSPropertiesFile = "os.properties";
    private static final String sApocPropertiesFile = "apocd.properties";
    private static final String sJProxyPropertiesFile = "policymgr.properties";
    private static final String[] sLocalPropertiesFiles;
    private static String sDaemonInstallDir;
    private static String sDaemonPropertiesDir;
    private Properties mDefaultProperties;
    private RemoteConfig mRemoteConfig;
    private LocalConfig mLocalConfig;
    private final HashSet mConfigEventListeners = new HashSet();
    private String mHostIdentifier;
    private final DaemonTimerTask mConfigLoader = new DaemonTimerTask(new ConfigLoader());
    private PolicyMgrFactory mFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addConfigEventListener(ConfigEventListener configEventListener) {
        HashSet hashSet = DaemonConfig.sInstance.mConfigEventListeners;
        synchronized (hashSet) {
            DaemonConfig.sInstance.mConfigEventListeners.add(configEventListener);
        }
    }

    public static String getHostIdentifier() {
        return DaemonConfig.sInstance.mHostIdentifier;
    }

    public static DaemonConfig getInstance() {
        return sInstance;
    }

    public static PolicyMgrFactory getPolicyMgrFactory() throws SPIException {
        if (sInstance != null && DaemonConfig.sInstance.mFactory == null) {
            DaemonConfig.sInstance.mFactory = new PolicyMgrFactoryImpl();
        }
        return DaemonConfig.sInstance.mFactory;
    }

    public static boolean getBooleanProperty(String string) {
        return DaemonConfig.getBooleanProperty(string, null);
    }

    public static boolean getBooleanProperty(String string, String string2) {
        return Boolean.valueOf(DaemonConfig.getStringProperty(string, string2).trim());
    }

    public static float getFloatProperty(String string) {
        return DaemonConfig.getFloatProperty(string, null);
    }

    public static float getFloatProperty(String string, String string2) {
        return Float.parseFloat(DaemonConfig.getStringProperty(string, string2).trim());
    }

    public static int getIntProperty(String string) {
        return DaemonConfig.getIntProperty(string, null);
    }

    public static int getIntProperty(String string, String string2) {
        return Integer.parseInt(DaemonConfig.getStringProperty(string, string2).trim());
    }

    public static LocalConfig getLocalConfig() {
        return DaemonConfig.sInstance.mLocalConfig;
    }

    public static String getStringProperty(String string) {
        return DaemonConfig.getStringProperty(string, null);
    }

    public static String getStringProperty(String string, String string2) {
        return DaemonConfig.sInstance.mLocalConfig.getProperty(string, string2);
    }

    public static void init(String[] stringArray) throws IOException, APOCException {
        sInstance = new DaemonConfig(stringArray);
        DaemonConfig.reload();
        DaemonConfig.addConfigEventListener(sInstance);
        sInstance.pollForChanges();
    }

    public static void log() {
        if (APOCLogger.isLoggable(Level.CONFIG) && sInstance != null && DaemonConfig.sInstance.mLocalConfig != null) {
            StringBuffer stringBuffer = new StringBuffer("");
            Enumeration<?> enumeration = DaemonConfig.sInstance.mLocalConfig.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                stringBuffer.append(" ").append(string).append(" = ").append(string.compareTo("Password") == 0 ? DaemonConfig.obscure(DaemonConfig.getStringProperty(string)) : DaemonConfig.getStringProperty(string)).append("\n");
            }
            APOCLogger.config("Dcfg001", stringBuffer.toString());
        }
    }

    public void onConfigEvent() {
        this.pollForChanges();
    }

    public static void reload() throws IOException {
        DaemonConfig.reload(false);
    }

    public static void reload(boolean bl) throws IOException {
        Set set = sInstance.getAllValues();
        if (!bl) {
            DaemonConfig.sInstance.mLocalConfig.load(sLocalPropertiesFiles);
            sInstance.setHostIdentifier();
        }
        DaemonConfig.sInstance.mRemoteConfig.load();
        if (!((Object)sInstance.getAllValues()).equals(set)) {
            sInstance.configLoaded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeConfigEventListener(ConfigEventListener configEventListener) {
        HashSet hashSet = DaemonConfig.sInstance.mConfigEventListeners;
        synchronized (hashSet) {
            DaemonConfig.sInstance.mConfigEventListeners.remove(configEventListener);
        }
    }

    private DaemonConfig(String[] stringArray) throws IOException {
        sDaemonInstallDir = stringArray[0];
        sDaemonPropertiesDir = stringArray[1];
        this.createDefaults();
        this.mLocalConfig = new LocalConfig(sDaemonPropertiesDir);
        this.mRemoteConfig = new RemoteConfig();
        this.mLocalConfig.setDefaults(this.mRemoteConfig);
        this.mRemoteConfig.setDefaults(this.mDefaultProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configLoaded() {
        Object[] objectArray;
        HashSet hashSet = this.mConfigEventListeners;
        synchronized (hashSet) {
            objectArray = this.mConfigEventListeners.toArray();
        }
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                ((ConfigEventListener)objectArray[i]).onConfigEvent();
            }
        }
    }

    private void createDefaults() throws IOException {
        ZipFile zipFile = new ZipFile(sDaemonInstallDir + File.separatorChar + sAPOCJarFile);
        String string = new String("com/sun/apoc/daemon/");
        this.mDefaultProperties = new Properties();
        this.mDefaultProperties.load(zipFile.getInputStream(zipFile.getEntry(string + sDefaultsPropertiesFile)));
        this.mDefaultProperties.load(zipFile.getInputStream(zipFile.getEntry(string + sOSPropertiesFile)));
    }

    private Set getAllValues() {
        HashSet<String> hashSet = new HashSet<String>();
        if (this.mLocalConfig != null) {
            Enumeration<?> enumeration = this.mLocalConfig.propertyNames();
            while (enumeration.hasMoreElements()) {
                hashSet.add(this.mLocalConfig.getProperty((String)enumeration.nextElement()));
            }
        }
        return hashSet;
    }

    private static boolean isAcceptableAddress(InetAddress inetAddress) {
        return !inetAddress.isLoopbackAddress();
    }

    private String guessHostIdentifer() {
        String string = null;
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            if (enumeration != null) {
                block2: while (enumeration.hasMoreElements()) {
                    NetworkInterface networkInterface = enumeration.nextElement();
                    Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                    if (enumeration2 == null) continue;
                    while (enumeration2.hasMoreElements()) {
                        InetAddress inetAddress = enumeration2.nextElement();
                        if (!DaemonConfig.isAcceptableAddress(inetAddress)) continue;
                        string = inetAddress.getHostAddress();
                        continue block2;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    private static String obscure(String string) {
        String string2 = null;
        if (string != null) {
            string2 = string.replaceAll("\\p{Alnum}", "*");
        }
        return string2;
    }

    private void pollForChanges() {
        this.mConfigLoader.setPeriod(60000 * DaemonConfig.getIntProperty(sConfigCDInterval));
    }

    private void setHostIdentifier() {
        try {
            InetAddress inetAddress;
            this.mHostIdentifier = this.mLocalConfig.getProperty("HostIdentifierType", "Hostname").compareTo("IPAddress") == 0 ? (DaemonConfig.isAcceptableAddress(inetAddress = InetAddress.getLocalHost()) ? inetAddress.getHostAddress() : this.guessHostIdentifer()) : InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            this.mHostIdentifier = null;
        }
    }

    static {
        sLocalPropertiesFiles = new String[]{sOSPropertiesFile, sApocPropertiesFile, sJProxyPropertiesFile};
    }

    class ConfigLoader
    implements Runnable {
        ConfigLoader() {
        }

        public void run() {
            try {
                sInstance;
                DaemonConfig.reload(true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

