/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.daemon.apocd;

import com.sun.apoc.daemon.apocd.Cache;
import com.sun.apoc.daemon.apocd.CacheFactory;
import com.sun.apoc.daemon.apocd.Client;
import com.sun.apoc.daemon.apocd.SaslAuthCallbackHandler;
import com.sun.apoc.daemon.messaging.CreateSessionMessage;
import com.sun.apoc.daemon.messaging.MessageFactory;
import com.sun.apoc.daemon.messaging.Messenger;
import com.sun.apoc.daemon.misc.APOCAuthenticator;
import com.sun.apoc.daemon.misc.APOCException;
import com.sun.apoc.daemon.misc.APOCLogger;
import java.util.HashMap;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;

public class Session {
    private Client mClient;
    private String mSessionId;
    private HashMap mListeners = new HashMap();
    private Cache mCache;
    private Object mLock = new Object();
    private static final String sSep = ".";
    private static final Random sRandom = new Random();
    private static int sAuthBufferSize = 20;
    private static int sCantLock = 0;
    private static int sUnlocked = 1;
    private static int sLocked = 2;
    private int mState = sUnlocked;

    Session() {
    }

    public Session(Client client, String string, String string2) throws APOCException {
        APOCLogger.finer("Sess001");
        try {
            this.authenticate(client, string);
            this.mClient = client;
            this.mSessionId = String.valueOf(sRandom.nextLong());
            this.mCache = CacheFactory.getInstance().openCache(string, string2, new SaslAuthCallbackHandler(this.mClient));
        }
        catch (APOCException aPOCException) {
            this.close();
            throw aPOCException;
        }
        APOCLogger.finer("Sess002", this.toString(string));
    }

    public Cache getCache() {
        return this.mCache;
    }

    public Client getClient() {
        return this.mClient;
    }

    public String getSessionId() {
        return this.mSessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListeners(Vector vector, String string) {
        HashMap hashMap = this.mListeners;
        synchronized (hashMap) {
            for (int i = 0; i < vector.size(); ++i) {
                this.mListeners.put(vector.elementAt(i), string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListeners(Vector vector) {
        HashMap hashMap = this.mListeners;
        synchronized (hashMap) {
            for (int i = 0; i < vector.size(); ++i) {
                this.mListeners.remove(vector.elementAt(i));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mState == sLocked) {
                try {
                    this.mLock.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.mState = sCantLock;
            this.mLock.notify();
        }
        if (this.mCache != null) {
            CacheFactory.getInstance().closeCache(this.mCache);
            this.mCache = null;
        }
        if (this.mSessionId != null) {
            APOCLogger.finer("Sess003", this.mSessionId);
        }
    }

    public String getListenerClientData(String string) {
        return (String)this.mListeners.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getListenerComponentName(String string) {
        HashMap hashMap = this.mListeners;
        synchronized (hashMap) {
            String string2;
            String string3 = string2 = this.mListeners.containsKey(string) ? string : null;
            if (string2 == null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, sSep);
                StringBuffer stringBuffer = new StringBuffer();
                int n = stringTokenizer.countTokens();
                for (int i = 0; i < n - 1; ++i) {
                    String string4 = stringBuffer.append(stringTokenizer.nextToken()).append(sSep).toString();
                    if (!this.mListeners.containsKey(string4)) continue;
                    string2 = string4;
                    break;
                }
            }
            return string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lock() {
        boolean bl = false;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mState == sUnlocked) {
                this.mState = sLocked;
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() {
        Object object = this.mLock;
        synchronized (object) {
            this.mState = sUnlocked;
            this.mLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void authenticate(Client client, String string) throws APOCException {
        APOCAuthenticator aPOCAuthenticator = null;
        try {
            aPOCAuthenticator = new APOCAuthenticator(string);
            Messenger messenger = new Messenger();
            messenger.setClientChannel(client.getClientChannel());
            messenger.sendResponse(MessageFactory.createResponse(27, null, new String(aPOCAuthenticator.getChallenge())), false);
            CreateSessionMessage createSessionMessage = (CreateSessionMessage)messenger.receiveRequest();
            aPOCAuthenticator.processResponse(createSessionMessage.getCredentials().getBytes());
        }
        finally {
            if (aPOCAuthenticator != null) {
                aPOCAuthenticator.cleanup();
            }
        }
    }

    private String toString(String string) {
        return " userId       = " + string + "\n" + " sessionId    = " + this.mSessionId + "\n" + this.mCache.toString() + "\n ";
    }
}

