/*
 * Decompiled with CFR 0.152.
 */
package com.sun.apoc.daemon.apocd;

import com.sun.apoc.daemon.apocd.Client;
import com.sun.apoc.daemon.messaging.CreateSessionMessage;
import com.sun.apoc.daemon.messaging.MessageFactory;
import com.sun.apoc.daemon.messaging.Messenger;
import com.sun.apoc.daemon.misc.APOCException;
import com.sun.apoc.daemon.misc.APOCLogger;
import com.sun.apoc.daemon.transport.ClientChannel;
import com.sun.apoc.spi.ldap.authentication.LdapSaslGSSAPICallback;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;

class SaslAuthCallbackHandler
implements CallbackHandler {
    private Messenger mMessenger = new Messenger();
    private ClientChannel mChannel;
    private ByteBuffer mBuffer;
    private boolean mReconnectMode = false;
    private static final byte[] base64ToInt = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};

    SaslAuthCallbackHandler(Client client) throws APOCException {
        this.mChannel = client.getClientChannel();
        this.mMessenger.setClientChannel(this.mChannel);
    }

    public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        LdapSaslGSSAPICallback ldapSaslGSSAPICallback = (LdapSaslGSSAPICallback)callbackArray[0];
        if (this.mBuffer == null) {
            this.createTokens(ldapSaslGSSAPICallback);
        }
        ldapSaslGSSAPICallback.setResponse(this.getToken());
    }

    public void setReconnectMode() {
        this.mReconnectMode = true;
    }

    private void createTokens(LdapSaslGSSAPICallback ldapSaslGSSAPICallback) {
        try {
            String string;
            if (this.mReconnectMode) {
                this.mChannel.registerForSelection(false);
            }
            this.mMessenger.sendResponse(MessageFactory.createResponse(28, null, ldapSaslGSSAPICallback.getServiceName() + "/" + ldapSaslGSSAPICallback.getHostname()), false);
            CreateSessionMessage createSessionMessage = (CreateSessionMessage)this.mMessenger.receiveRequest(!this.mReconnectMode);
            if (createSessionMessage != null && (string = createSessionMessage.getCredentials()) != null) {
                this.mBuffer = ByteBuffer.wrap(this.base64ToByteArray(string.toCharArray()));
            }
            if (this.mReconnectMode) {
                this.mMessenger.sendResponse(MessageFactory.createResponse(20, null, null), true);
            }
        }
        catch (Exception exception) {
            APOCLogger.throwing("SaslAuthCallbackHandler", "createTokens", exception);
        }
    }

    private byte[] getToken() {
        byte[] byArray = null;
        if (this.mBuffer != null && this.mBuffer.hasRemaining()) {
            int n = this.nextTokenSize();
            if (n > 0) {
                byArray = new byte[n];
                this.mBuffer = this.mBuffer.get(byArray);
            }
            if (!this.mBuffer.hasRemaining()) {
                this.mBuffer = null;
            }
        }
        return byArray;
    }

    private int nextTokenSize() {
        int n = 0;
        try {
            if (this.mBuffer.hasRemaining()) {
                byte[] byArray = new byte[5];
                this.mBuffer = this.mBuffer.get(byArray);
                n = Integer.parseInt(new String(byArray));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    private byte[] base64ToByteArray(char[] cArray) {
        int n;
        int n2;
        int n3;
        byte[] byArray = base64ToInt;
        int n4 = cArray.length;
        int n5 = n4 / 4;
        if (4 * n5 != n4) {
            throw new IllegalArgumentException("String length must be a multiple of four.");
        }
        int n6 = 0;
        int n7 = n5;
        if (n4 != 0) {
            if (cArray[n4 - 1] == '=') {
                ++n6;
                --n7;
            }
            if (cArray[n4 - 2] == '=') {
                ++n6;
            }
        }
        byte[] byArray2 = new byte[3 * n5 - n6];
        int n8 = 0;
        int n9 = 0;
        for (n3 = 0; n3 < n7; ++n3) {
            n2 = this.base64toInt(cArray[n8++], byArray);
            n = this.base64toInt(cArray[n8++], byArray);
            int n10 = this.base64toInt(cArray[n8++], byArray);
            int n11 = this.base64toInt(cArray[n8++], byArray);
            byArray2[n9++] = (byte)(n2 << 2 | n >> 4);
            byArray2[n9++] = (byte)(n << 4 | n10 >> 2);
            byArray2[n9++] = (byte)(n10 << 6 | n11);
        }
        if (n6 != 0) {
            n3 = this.base64toInt(cArray[n8++], byArray);
            n2 = this.base64toInt(cArray[n8++], byArray);
            byArray2[n9++] = (byte)(n3 << 2 | n2 >> 4);
            if (n6 == 1) {
                n = this.base64toInt(cArray[n8++], byArray);
                byArray2[n9++] = (byte)(n2 << 4 | n >> 2);
            }
        }
        return byArray2;
    }

    private int base64toInt(char c, byte[] byArray) {
        byte by = byArray[c];
        if (by < 0) {
            throw new IllegalArgumentException("Illegal character " + c);
        }
        return by;
    }
}

